/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

/*
 * $Id$
 */

#pragma ident	"@(#)iiimpAuth.c 1.1	99/11/12 SMI"


#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <fcntl.h>
#include <errno.h>
#include <ctype.h>
#include <time.h>
#include <unistd.h>
#if defined(AUTH_STANDALONE)
#include <stdio.h>
#include <locale.h>
#endif /* AUTH_STANDALONE */

#include "iiimpAuth.h"


#define PASSWORD_DIR_0		".iiim"
#define PASSWORD_DIR_1		".iiim/auth"
#define PASSWORD_FILE		".iiim/auth/passwd"
#define PASSWORD_FILE_LEN	(17)

#define HOME_ENV	"HOME"

char *
auth_password_get(char * home_dir)
{
	char *		password;
	char *		password_file;
	char *		home_env;
	int		home_dir_len;
	int		fd;
	int		len;
	struct stat	st;
	int		i;
	char		pwd_buf[AUTH_PASSWORD_LEN + 1];
	unsigned int	seed;
	int		c;

	password = NULL;
	password_file = NULL;
	fd = -1;

	do {
		home_env = getenv("HOME");
		if (NULL != home_env) {
			home_dir = home_env;
		}
		if (NULL == home_dir) {
			break;
		}
		home_dir_len = strlen(home_dir);
		len = (home_dir_len + 1 + PASSWORD_FILE_LEN);

		password_file = malloc(len + 1);
		if (NULL == password_file) {
			break;
		}

		strcpy(password_file, home_dir);
		*(password_file + home_dir_len) = '/';
		home_dir_len += 1;
		strcpy(password_file + home_dir_len, PASSWORD_FILE);

		if (0 != stat(password_file, &st)) {
			if ((ENOENT != errno) && (EACCES != errno)) {
				break;
			}

			/* create "${HOME}/.iiim" */
			strcpy(password_file + home_dir_len, PASSWORD_DIR_0);
			if (0 != stat(password_file, &st)) {
				if ((ENOENT != errno) && (EACCES != errno)) {
					break;
				}
				if (0 != mkdir(password_file, 0777)) break;
			}

			/* create "${HOME}/.iiim/auth" */
			strcpy(password_file + home_dir_len, PASSWORD_DIR_1);
			if (0 != stat(password_file, &st)) {
				if ((ENOENT != errno) && (EACCES != errno)) {
					break;
				}
				if (0 != mkdir(password_file, 0700)) break;
			}

			/* create "${HOME}/.iiim/auth/password" */
			strcpy(password_file + home_dir_len, PASSWORD_FILE);
			fd = open(password_file, O_CREAT | O_WRONLY, 0600);
			if (-1 == fd) break;

			seed = (time(NULL) + getpid());
			srand(seed);
			for (i = 0; i < AUTH_PASSWORD_LEN; i++) {
				c = rand();
				c %= 62;
				if (c < 10) {
					c = ('0' + c);
				} else if (c < 36) {
					c = ('A' + (c - 10));
				} else {
					c = ('a' + (c - 36));
				}
				pwd_buf[i] = c;
			}
			pwd_buf[AUTH_PASSWORD_LEN] = '\n';

			len = write(fd, pwd_buf, AUTH_PASSWORD_LEN + 1);
			if ((AUTH_PASSWORD_LEN + 1) != len) {
				break;
			}

		} else {
			fd = open(password_file, O_RDONLY, 0);
			if (-1 == fd) break;
			len = read(fd, pwd_buf, AUTH_PASSWORD_LEN);
			if (AUTH_PASSWORD_LEN != len) break;
			for (i = 0; i < AUTH_PASSWORD_LEN; i++) {
				if (0 == isalnum(pwd_buf[i])) {
					break;
				}
			}
			if (AUTH_PASSWORD_LEN != i) {
				break;
			}
		}

		password = malloc(AUTH_PASSWORD_LEN);
		if (NULL == password) break;
		memcpy(password, pwd_buf, AUTH_PASSWORD_LEN);

	} while(0);

	if (-1 != fd) {
		close(fd);
	}
	free(password_file);

	return password;
}

#if defined(AUTH_STANDALONE)
main(int argc, char ** argv)
{
	char *		password;
	int 		i;
	int		c;

	extern char *	optarg;
	extern int	optind;
	extern int	opterr;
	extern int	optopt;

	setlocale(LC_MESSAGES, "");

	while (EOF != (c = getopt(argc, argv, "p"))) {
		switch (c) {
		case 'p':
			password = auth_password_get(NULL);
			printf("%s\n",
			       (NULL == password) ? "(NULL)" : password);
			free(password);
			break;
		default:
			break;
		}
	}

	return 0;
}
#endif /* AUTH_STANDALONE */
