/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef _guiIM_PRE_h
#define _guiIM_PRE_h

#include "guiIM.h"

typedef struct _PreeditCharsRec {
  int		caret_pos;
  int		wchar_len;
  int		alloc_len;
  XIMFeedback	*feedback;
  IMFeedbackList *feedback_list;
  wchar_t	*wchar;
  unsigned short *wchar_width;
} PreeditCharsRec, *PreeditChars;

typedef struct _PreeditLineRec {
  int	x;
  int	y;
  int	char_offset;
  int	char_len;
} PreeditLineRec, *PreeditLine;

typedef struct _PreeditAreaRec {
  Window 	window;
  int		x;
  int		y;
  int		char_offset;
  int		char_len;
  int		char_offset_backup;
  int		char_len_backup;
  int		alloc_lines;
  int		active_lines;
  PreeditLine	lines;
  Bool		mapped;
  Bool		configured;
  struct {
	  int	x;
	  int	y;
	  int	width;
	  int	height;
  }		win_config;
} PreeditAreaRec, *PreeditArea;

typedef struct _PreeditWinRec {
  int		alloc_areas;
  int		active_areas;
  PreeditArea	preedit_areas;
  PreeditCharsRec preedit_chars;
  PreeditCharsRec preedit_chars_backup;
  GC		gc;
  GC		rgc;
  XFontSet	fontset;
  XFontSetExtents *fse;
  Bool		need_free_fontset;
  Window	parent;
  int		client_window_width;
  int		client_window_height;
  Bool		discard_expose_event;
  CacheRec preedit_cache;
} PreeditWinRec;

typedef void (*PreeditCB)(XicCommon, XPointer);

extern Bool FilterConfigureNotify(Display *, Window, XEvent *, XPointer);
extern void UnmapPreeditWindow(XicCommon, PreeditArea);
extern Bool SetupPreeditExt(XicCommon);
extern Bool NewPreeditWindow(XicCommon);
extern Bool SetupPreeditWindow(XicCommon, Window);
extern void SetPreeditForeground(XicCommon, XPointer);
extern void SetPreeditBackground(XicCommon, XPointer);
extern void SetPreeditFont(XicCommon, XPointer);
extern void PreeditStart(XicCommon, XPointer);
extern void PreeditCaret(XicCommon, XPointer);
extern void PreeditDrawText(XicCommon, XPointer);
extern void PreeditDone(XicCommon, XPointer);
extern void DestroyPreedit(XicCommon, XPointer);
extern void PreeditCaretAdjustLookupPlacement(XicCommon, XPoint *);
extern void PreeditCaretPlacement(XicCommon, XPoint *);
extern void PreeditCaretPlacementRelative(XicCommon, XPoint *);

#endif
