/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "commonIM.h"
#include "guiIM.h"
#include "iiimpDL.h"
#include "popupIM.h"
#include "XimpIm.h"
#include "ximp40.h"
#include "trace_message.h"

Status
CommonOpenIM(XIM xim, XLCd lcd, Display *dpy, XrmDatabase rdb,
	     char *res_name, char *res_class) {
  XimCommon im = (XimCommon)xim;

  TRACE_MESSAGE_INIT(NULL);

  /* Open mbs->wcs and wcs->mbs converters */
  if (!(im->wtom_conv = _XlcOpenConverter(lcd, XlcNWideChar,
					  lcd, XlcNMultiByte))) {
    goto Set_Error;
  }
  if (!(im->mtow_conv = _XlcOpenConverter(lcd, XlcNMultiByte,
					  lcd, XlcNWideChar))) {
    goto Set_Error;
  }
  im->core.lcd       = lcd;
  im->core.ic_chain  = (XIC)NULL;
  im->core.display   = dpy;
  im->core.rdb       = rdb;
  im->core.res_name  = NULL;
  im->core.res_class = NULL;
  im->core.im_name   = NULL;

  if ((res_name != NULL) && (*res_name != '\0')){
    im->core.res_name  = (char *)Xmalloc(strlen(res_name)+1);
    strcpy(im->core.res_name,res_name);
  }
  if ((res_class != NULL) && (*res_class != '\0')){
    im->core.res_class = (char *)Xmalloc(strlen(res_class)+1);
    strcpy(im->core.res_class,res_class);
  }

  /* set XIMP-dependent data */
  im->ximp_impart = (XIMXimp)Ximp_OpenIM(lcd);

  /* set dynamic loadble object data */
  im->dl_impart = OpenDynamicObject(lcd);

  return True;
 Set_Error:
  if (im) CommonCloseIM((XIM)im);
  return False;
}

extern Status
CommonCloseIM(XIM xim) {
  XIC ic;
  XimCommon im = (XimCommon)xim;

  for (ic = xim->core.ic_chain; ic; ic = ic->core.next)
    XDestroyIC(ic);

  if (im->mtow_conv)
    _XlcCloseConverter(im->mtow_conv);

  if (im->wtom_conv)
    _XlcCloseConverter(im->wtom_conv);

  if (im->ximp_impart) {
    Ximp_CloseIM(im->ximp_impart);
  }

  if (im->popup_impart) ClosePopupIM(im);

  if (im->dl_impart) {
    CloseDynamicObject(im->dl_impart);
  }
  if (im->core.res_name) Xfree(im->core.res_name);
  if (im->core.res_class) Xfree(im->core.res_class);

  return True;
}

Status
CommonCreateIC(XIC xic, XIMArg *arg) {
  XicCommon ic = (XicCommon)xic;

  /* ximp icpart */
  if (!ic->ximp_icpart) {
    ic->ximp_icpart = (XICXimp)Xmalloc(sizeof(XICXimpRec));
    if (!ic->ximp_icpart) goto Error;;
    memset(ic->ximp_icpart, 0, sizeof(XICXimpRec));
  }
  if (!ic->gui_icpart) {
    if (!(ic->gui_icpart = CreateGUI(ic, arg))) goto Error;
  }
  return True;
 Error:
  CommonDestroyIC((XIC)ic);
  return False;
}

Status
CommonDestroyIC(XIC xic) {
  XicCommon ic = (XicCommon)xic;
  if (ic->ximp_icpart) Xfree(ic->ximp_icpart);
  ic->ximp_icpart = 0;
  if (ic->gui_icpart) DestroyGUI(ic); /* destroy gui */
  ic->gui_icpart = 0;
  return True;
}
