/*
 * @(#)Protocol.java	1.8 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.net.*;
import java.io.*;

class Protocol implements IIIMProtocol {
    ProtocolHeader header = null;
    ProtocolData data;
    
    Protocol() {
	 data = new ProtocolData();
    }

    Protocol(int protocol, ProtocolData data) {
        try {
	    if (data != null) {
		data.pad();
	    }
        } catch(IOException e) {
        }
        this.data = data;
	if (data != null) {
	    calculateHeader(protocol);
	}
    }
    
    void calculateHeader(int protocol) {
	int pad = ProtocolData.paddings(data.count);
	int total = data.count + pad;

        int size = 0;
	if(total < (int)Math.pow((double)2, (double)24)) 
            size = IIIMProtocol.FOURBYTES_PACKET;
	else size = IIIMProtocol.EIGHTBYTES_PACKET;
	
	header = new ProtocolHeader(size, protocol, total);
    }
    
    public void read(IIIMPInputStream in) {
        header = new ProtocolHeader();
        synchronized(in) {
            header.read(in);
        
            data.read(in, header.packetLength);
        }
    }
    
    public void write(IIIMPOutputStream out) {
        if (header == null) {
	    debug("error");
	} else {
	    header.write(out);
	}
        data.write(out);
    }
    
    int getOpCode() {
        return header.getOpCode();
    }

    ProtocolHeader getHeader() {
        return header;
    }

    ProtocolData getData() {
        return data;
    }

    static String toString(int opcode) {
	switch(opcode) {
	  case IM_NO_PROTOCOL:
	    return "IM_NO_PROTOCOL";
	  case IM_CONNECT:
	    return "IM_CONNECT";
	  case IM_CONNECT_REPLY:
	    return "IM_CONNECT_REPLY";
	  case IM_DISCONNECT:
	    return "IM_DISCONNECT";
	  case IM_DISCONNECT_REPLY:
	    return "IM_DISCONNECT_REPLY";
	  case IM_REGISTER_TRIGGER_KEYS:
	    return "IM_REGISTER_TRIGGER_KEYS";
	  case IM_TRIGGER_NOTIFY:
	    return "IM_TRIGGER_NOTIFY";
	  case IM_TRIGGER_NOTIFY_REPLY:
	    return "IM_TRIGGER_NOTIFY_REPLY";
	  case IM_SETIMVALUES:
	    return "IM_SETIMVALUES";
	  case IM_SETIMVALUES_REPLY:
	    return "IM_SETIMVALUES_REPLY";
	  case IM_GETIMVALUES:
	    return "IM_GETIMVALUES";
	  case IM_GETIMVALUES_REPLY:
	    return "IM_GETIMVALUES_REPLY";
	  case IM_FORWARD_EVENT:
	    return "IM_FORWARD_EVENT";
	  case IM_FORWARD_EVENT_REPLY:
	    return "IM_FORWARD_EVENT_REPLY";
	  case IM_COMMIT_STRING:
	    return "IM_COMMIT_STRING";
	  case IM_FORWARD_EVENT_WITH_OPERATIONS:
	    return "IM_FORWARD_EVENT_WITH_OPERATIONS";
	  case IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY:
	    return "IM_FORWARD_EVENT_WITH_OPERATIONS_REPLY";
	  case IM_CREATEIC:
	    return "IM_CREATEIC";
	  case IM_CREATEIC_REPLY:
	    return "IM_CREATEIC_REPLY";
	  case IM_DESTROYIC:
	    return "IM_DESTROYIC";
	  case IM_DESTROYIC_REPLY:
	    return "IM_DESTROYIC_REPLY";
	  case IM_SETICVALUES:
	    return "IM_SETICVALUES";
	  case IM_SETICVALUES_REPLY:
	    return "IM_SETICVALUES_REPLY";
	  case IM_GETICVALUES:
	    return "IM_GETICVALUES";
	  case IM_GETICVALUES_REPLY:
	    return "IM_GETICVALUES_REPLY";
	  case IM_SETICFOCUS:
	    return "IM_SETICFOCUS";
	  case IM_SETICFOCUS_REPLY:
	    return "IM_SETICFOCUS_REPLY";
	  case IM_UNSETICFOCUS:
	    return "IM_UNSETICFOCUS";
	  case IM_UNSETICFOCUS_REPLY:
	    return "IM_UNSETICFOCUS_REPLY";
	  case IM_RESETIC:
	    return "IM_RESETIC";
	  case IM_RESETIC_REPLY:
	    return "IM_RESETIC_REPLY";
	  case IM_PREEDIT_START:
	    return "IM_PREEDIT_START";
	  case IM_PREEDIT_START_REPLY:
	    return "IM_PREEDIT_START_REPLY";
	  case IM_PREEDIT_DRAW:
	    return "IM_PREEDIT_DRAW";
	  case IM_PREEDIT_DRAW_REPLY:
	    return "IM_PREEDIT_DRAW_REPLY";
	  case IM_PREEDIT_DONE:
	    return "IM_PREEDIT_DONE";
	  case IM_PREEDIT_DONE_REPLY:
	    return "IM_PREEDIT_DONE_REPLY";
	  case IM_STATUS_START:
	    return "IM_STATUS_START";
	  case IM_STATUS_START_REPLY:
	    return "IM_STATUS_START_REPLY";
	  case IM_STATUS_DRAW:
	    return "IM_STATUS_DRAW";
	  case IM_STATUS_DRAW_REPLY:
	    return "IM_STATUS_DRAW_REPLY";
	  case IM_STATUS_DONE:
	    return "IM_STATUS_DONE";
	  case IM_STATUS_DONE_REPLY:
	    return "IM_STATUS_DONE_REPLY";
	  case IM_LOOKUP_CHOICE_START:
	    return "IM_LOOKUP_CHOICE_START";
	  case IM_LOOKUP_CHOICE_START_REPLY:
	    return "IM_LOOKUP_CHOICE_START_REPLY";
	  case IM_LOOKUP_CHOICE_DRAW:
	    return "IM_LOOKUP_CHOICE_DRAW";
	  case IM_LOOKUP_CHOICE_DRAW_REPLY:
	    return "IM_LOOKUP_CHOICE_DRAW_REPLY";
	  case IM_LOOKUP_CHOICE_DONE:
	    return "IM_LOOKUP_CHOICE_DONE";
	  case IM_LOOKUP_CHOICE_DONE_REPLY:
	    return "IM_LOOKUP_CHOICE_DONE_REPLY";
	  case IM_LOOKUP_CHOICE_PROCESS:
	    return "IM_LOOKUP_CHOICE_PROCESS";
	  case IM_LOOKUP_CHOICE_PROCESS_REPLY:
	    return "IM_LOOKUP_CHOICE_PROCESS_REPLY";
	  case IM_AUX_START:
	    return "IM_AUX_START";
	  case IM_AUX_START_REPLY:
	    return "IM_AUX_START_REPLY";
	  case IM_AUX_DRAW:
	    return "IM_AUX_DRAW";
	  case IM_AUX_DRAW_REPLY:
	    return "IM_AUX_DRAW_REPLY";
	  case IM_AUX_DONE:
	    return "IM_AUX_DONE";
	  case IM_AUX_DONE_REPLY:
	    return "IM_AUX_DONE_REPLY";
	  case IM_AUX_SETVALUES:
	    return "IM_AUX_SETVALUES";
	  case IM_AUX_SETVALUES_REPLY:
	    return "IM_AUX_SETVALUES_REPLY";
	  default:
	    return "Unknown Protocol";
	}
    }

    public String toString() {
	int opcode = getOpCode();
	return toString(opcode);
    }

    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}

class ProtocolHeader {
    int packet_size;
    int opCode;
    int packetLength;
    
    ProtocolHeader() {
        packet_size = 0;
        opCode = 0;
        packetLength = 0;
    }
    
    ProtocolHeader(int packet_size, int opCode, int packetLength) {
        this.packet_size = packet_size;
        this.opCode = opCode;
        this.packetLength = packetLength;
    }
    
    void setPacketSize(int size) {
        packet_size = size;
    }
    
    int getPacketSize() {
        return packet_size;
    }
    
    void setOpCode(int opCode) {
        this.opCode = opCode;
    }
    
    int getOpCode() {
        return opCode;
    }
    
    void setPacketLength(int length) {
        packetLength = length;
    }
    
    int getPacketLength() {
        return packetLength;
    }
    
    public void read(IIIMPInputStream in) {
        try {
            int c = in.read();

            int ret = ((c >>> 7) & 0xFF);
            if(ret == 0) {
                packet_size = IIIMProtocol.FOURBYTES_PACKET;
            } else if (ret == 1) {
                packet_size = IIIMProtocol.EIGHTBYTES_PACKET;
            }
            opCode = (c & 0x7f);
            
            int count = 0;
            if(packet_size == IIIMProtocol.FOURBYTES_PACKET) count = 4;
            else if(packet_size == IIIMProtocol.EIGHTBYTES_PACKET) count = 8;
            
            int ch[] = new int[count];
            // Because the first byte is packet_size and opcode,
            // this byte con't calculate for totoal length of protocol
            ch[0] = 0x00;
            
            ch[1] = in.read();
            // O byte protocol
            if(ch[1] == -1) {
                packetLength = 0;
                return;
            }
            
            for(int i=2;i<count;i++) {
                ch[i] = in.read();
            }
            
            
            for(int i = 0 ;i < count; i++) {
                packetLength += (ch[i] << ((count - i - 1) * 8));
            }
            packetLength = (packetLength << 2);
            
        } catch(IOException e) {
            debug("e = " + e);
        }
    }
    
    void write(IIIMPOutputStream out) {
        try {
            int length = ((packetLength / 4) & 0x00FFFFFF);   
            out.write(opCode & 0x7f);
            out.write((length >>> 16) & 0xFF);
            out.write((length >>> 8)  & 0xFF);
            out.write((length >>> 0)  & 0xFF);
                     
        } catch(IOException e) {
            debug("e = " + e);
        }
    }

    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}

