/*
 * @(#)PreeditWindow.java	1.8 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.font.*;
//For testing
import java.text.*;
import com.sun.iiim.*;

class PreeditWindow extends IIIMWindow implements IIIMPreeditListener {
    String style;
    
    PreeditPane pane;
    
    int columWidth, columHeight;
    
    // Below-spot offset value
    int offset = 20;
    
    // Default, no arg constructor
    public PreeditWindow() {
        style = Manager.getProperty("iiimf.preedit.style");
        if(style == null) style = "ROOTWINDOW";
    }
    
    void init() {
        window = new Dialog(new Frame(""));
        ((Dialog)window).setResizable(true);
        
        ((Dialog)window).setTitle("Preedit Window");
        
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
        FontMetrics fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        window.setFont(font);

        pane = new PreeditPane();
        pane.setFont(font);
        window.add(pane);

	window.pack();                
    }
    
    // IIIMPreeditListener method
    public void preeditStart(IIIMPreeditEvent e) {
    }
    public void preeditDone(IIIMPreeditEvent e) {
    }
    public void preeditDraw(IIIMPreeditEvent e) {
    }

    public void dispatchEvent(IIIMPreeditEvent e) {
        if(pane == null) init();
        
        pane.handleEvent(e);
        
        Insets inset = window.getInsets();
        
        int width = inset.left + inset.right + pane.width();
        int height = inset.top + inset.bottom + pane.height();
        
        window.setSize(width, height);
        calculatePosition();

        window.show();
    }
    
    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getStyle() {
        return style;
    }
    
    void calculatePosition() {
        Component component = getClientComponent();
        
        Component frame = component;
        while(!(frame instanceof Frame)) frame = component.getParent();        

        if(style.equals("BELOWSPOT") && 
            component instanceof InputMethodRequests) {
                Rectangle rect = 
                    ((InputMethodRequests)component).getTextLocation(TextHitInfo.leading(0));
                Point point = new Point();
                point.x = rect.x;
                point.y = rect.y + (int)rect.getHeight() + offset;
                
                window.setLocation(point);
        } else {
            // for ROOTWINDOW style and client not InputMethodRequests
            // Place the window on the left-corner of client component
            Point point = frame.getLocation();
            Dimension size = frame.getSize();     
        
            double x = point.getX();
            double y = point.getY() + size.getHeight();
            window.setLocation((int)x, (int)y);
        }
        
        // If window is out of screen, adjust it
        Point location = window.getLocation();
        double xl = location.getX();
        double yl = location.getY();
        Dimension dm = window.getSize();
        if((xl + dm.getWidth()) > screenWidth) 
            xl = screenWidth - dm.getWidth();
        if((yl + dm.getHeight()) > screenHeight) 
            yl = screenHeight - dm.getHeight();
        window.setLocation((int)xl, (int)yl);
    }
}
