/*
 * @(#)Manager.java	1.43 99/10/08
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.security.AccessController;
import java.security.PrivilegedAction;

import java.lang.Character.Subset;
import java.awt.im.InputContext;
import sun.awt.im.InputMethodAdapter;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.sun.iiim.*;

/**
 * This is package private class.
 */
public class Manager {

    // private variables
    private ManageRule rule;
    private IIIMPreeditListener preeditListener;
    private IIIMCommittedListener committedListener;
    private IIIMLookupListener lookupListener;
    private IIIMStatusListener statusListener;
    private IIIMActionListener actionListener;
    private IIIMAuxListener auxListeners;
    private IIIMFAdapter adapter;

    static void setPD(ProtocolDriver pd) {
	protocolDriver = pd;
	String[] ims = pd.getEngineScript();

	if (ims != null) {
	    for (int i = 0; i < ims.length; i++) {
		ruleTable.add(new ManageRule(ims[i]));
	    }
	}
    }

    private static ProtocolDriver protocolDriver = null;

    private final static String PCE_CLASSNAME =
	"sun.awt.im.iiimp.PCE";

    private final static String DEFAULT_RULE = 
	" sun.awt.im.iiimp.ProtocolDriver";

    private final static String TEST_RULE =
	"sun.awt.im.iiimp.LWE1 " +
	"sun.awt.im.iiimp.LWE2";

    private final static String PCE_TEST_RULE =
	PCE_CLASSNAME +
	" sun.awt.im.iiimp.PseudoPD";

    private static String defaultRuleString;
    private static String currentRuleString;

    public static boolean DEBUG = false;
    public static boolean COLOR_SUPPORT = false;
    public static boolean NO_STATUS = false;

    // for engine switching
    private static IIIMKeyEvent toggleKey = new IIIMKeyEvent("Alt+Shift");
    private static IIIMKeyEvent editHotKey = new IIIMKeyEvent("F12");
    private static HashSet ruleTable = new HashSet();

    private static void collectRules() {
	// local rules
	String localRules = getProperty("iiimf.manager.rules",
					defaultRuleString);
	StringTokenizer st = new StringTokenizer(localRules, ",");
	while (st.hasMoreTokens()) {
	    String token = st.nextToken();
	    ruleTable.add(new ManageRule(token));
	}
	// remote rules is added when setPD is called.
    }

    private Manager() {
	initProps();

	DEBUG =
	    getProperty("iiimf.manager.debug", "false").equals("true") ?
	    true : false;

	COLOR_SUPPORT =
	    getProperty("iiimf.gui.color", "false").equals("true") ?
	    true : false;

	NO_STATUS =
	    getProperty("iiimf.status.none", "false").equals("true") ?
	    true : false;

	defaultRuleString =
	    getProperty("iiimf.manager.rule", DEFAULT_RULE);
	currentRuleString =
	    getProperty("iiimf.manager.rule.userpref", defaultRuleString);
    }

    void setManageRule(ManageRule rule) {
	this.rule = rule;
    }

    void setCCDEF(String ccdef) {
	rule.setCCDEF(ccdef);
    }

    /*
     * Only one Manager exist per one VM.
     */
    static private Manager manager;
    static public Manager getInstance() {
	if (manager == null) {
	    manager = new Manager();
	    manager.setManageRule(new ManageRule(currentRuleString));
	    collectRules();
	}
	return manager;
    }

    static private ODClassLoader loader;
    static void setLoader(ODClassLoader ld) {
	loader = ld;
    }

    static public ODClassLoader getLoader() {
	return loader;
    }

    void setIIIMFAdapter(IIIMFAdapter adapter) {
	this.adapter = adapter;
    }

    void setIIIMActionListener(IIIMActionListener l) {
	// override previous one
	actionListener = l;	
    }

    void setIIIMPreeditListener(IIIMPreeditListener l) {
	// override previous one
	preeditListener = l;
    }

    IIIMPreeditListener getIIIMPreeditListener() {
	return preeditListener;
    }

    void setIIIMCommittedListener(IIIMCommittedListener l) {
	// override previous one
	committedListener = l;
    }

    IIIMCommittedListener getIIIMCommittedListener() {
	return committedListener;
    }

    void setIIIMLookupListener(IIIMLookupListener l) {
	// override previous one
	lookupListener = l;
    }

    void setIIIMStatusListener(IIIMStatusListener l) {
	// override previous one
	statusListener = l;
    }

    void setIIIMAuxListener(IIIMAuxListener l) {
	// add existing auxes
	auxListeners = IIIMAuxListeners.add(auxListeners, l);
    }

    /*
     * called from IIIMFAdapter
     */
    void dispatchEvent(IIIMEvent ev) {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener iiimListener = rule.get(i);
	    if (!ev.isProcessedBy(iiimListener) && !ev.isConsumed()) {
		iiimListener.dispatchEvent(ev);
		ev.processedBy(iiimListener);
	    }
	}
    }

    public void dispatchActionEvent(IIIMActionEvent e) {
	switch(e.getType()) {
	  case IIIMActionEvent.LOOKUP_PROCESSED:
	    Component c = getClientComponent();
	    int ch = ((String)e.getArg()).charAt(0);
	    KeyEvent kev = new KeyEvent(c, KeyEvent.KEY_PRESSED,
					0, 0, ch, (char)ch);
	    adapter.dispatchEvent(kev);
	    break;
	  default:
	    for (int i = 0; i < rule.size(); i++) {
		IIIMListener iiimListener = rule.get(i);
		if (iiimListener instanceof IIIMActionListener &&
		    !e.isProcessedBy(iiimListener) && !e.isConsumed()) {
		    ((IIIMActionListener)iiimListener).actionPerformed(e);
		    e.processedBy(iiimListener);
		}
	    }
	    break;
	}
    }

    public void dispatchAuxEvent(IIIMAuxEvent e) {
	if (e.getType() == IIIMAuxEvent.SETVALUES) {
	    // client -> server
	    if (protocolDriver != null) {
		try {
		    protocolDriver.sendAuxData(e);
		} catch(Exception ex) {
		    if (Manager.DEBUG) {
			ex.printStackTrace();
		    }
		}
	    }
	} else if (auxListeners != null) {
	    // server -> client
	    switch(e.getType()) {
	      case IIIMAuxEvent.START:
		auxListeners.auxStart(e);
		break;
	      case IIIMAuxEvent.DONE:
		auxListeners.auxDone(e);
		break;
	      case IIIMAuxEvent.DRAW:
		auxListeners.auxDraw(e);
		break;
	      default:
		System.out.println("Unknown aux event");
		break;
	    }
	}
    }

    public void dispatchPreeditEvent(IIIMPreeditEvent e) {
	if (preeditListener == null) {
	    return;
	}
	switch(e.getType()) {
	  case IIIMPreeditEvent.START:
	    preeditListener.preeditStart(e);
	    break;
	  case IIIMPreeditEvent.DONE:
	    preeditListener.preeditDone(e);
	    break;
	  case IIIMPreeditEvent.DRAW:
	    preeditListener.preeditDraw(e);
	    break;
	  default:
	    System.out.println(" Unknown preedit event");
	}
    }

    public void dispatchCommittedEvent(IIIMCommittedEvent e) {
	if (committedListener == null) {
	    return;
	}
	committedListener.committedPerformed(e);
    }

    public void dispatchStatusEvent(IIIMStatusEvent e) {
	if (NO_STATUS) {
	    return;
	}

	if (statusListener == null) {
	    return;
	}
	switch(e.getType()) {
	  case IIIMStatusEvent.START:
	    statusListener.statusStart(e);
	    break;
	  case IIIMStatusEvent.DONE:
	    statusListener.statusDone(e);
	    break;
	  case IIIMStatusEvent.DRAW:
	    statusListener.statusDraw(e);
	    break;
	  default:
	    System.out.println(" Unknown status event");
	}
    }

    public void dispatchLookupEvent(IIIMLookupEvent e) {
	if (lookupListener == null) {
	    return;
	}
	switch(e.getType()) {
	  case IIIMLookupEvent.START:
	    lookupListener.lookupStart(e);
	    break;
	  case IIIMLookupEvent.DONE:
	    lookupListener.lookupDone(e);
	    break;
	  case IIIMLookupEvent.DRAW:
	    lookupListener.lookupDraw(e);
	    break;
	  case IIIMLookupEvent.PROCESS:
	    lookupListener.lookupProcess(e);
	    break;
	  default:
	    System.out.println("Unknown lookup event");
	}
    }

    public void markProcessedUpperListener(IIIMEvent e, IIIMListener l) {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener iiimListener = rule.get(i);
	    e.processedBy(iiimListener);
	    if (iiimListener.equals(rule.get(i))) {
		break;
	    }
	}
    }

    public Component getClientComponent() {
	if (adapter == null)
	    return null;
	
	return adapter.getClientComponent();
    }
	

    private static Properties iiimProps = null;

    private static String userPropsFile;

    static void initProps() {
	iiimProps = new Properties();
	AccessController.doPrivileged(new PrivilegedAction() {
	    public Object run() {
		String javaHome = System.getProperty("java.home");
		String userHome = System.getProperty("user.home");
		File f;
		InputStream in;

		try {
		    // $JAVA_HOME/lib/iiimp.properties
		    f = new File(javaHome + File.separator +
				 "lib" + File.separator + "iiimp.properties");
		    if (f != null && f.canRead()) {
			in = new BufferedInputStream
			    (new FileInputStream(f.getPath()));
			iiimProps.load(in);
			in.close();
		    }

		    // $HOME/.iiimp
		    userPropsFile = userHome + File.separator + ".iiimp";
		    f = new File(userPropsFile);
		    if (f != null && f.canRead()) {
			in = new BufferedInputStream
			    (new FileInputStream(f.getPath()));
			iiimProps.load(in);
			in.close();
		    }
		} catch(Exception e) {
		    if (Manager.DEBUG) {
			e.printStackTrace();
		    }
		}
		return null;
	    }
	});
    }
	
    /*
     * set Property, return previous value if exist
     */
    static String setProperty(String key, String value) {
	String ret = (String)iiimProps.setProperty(key, value);
	
	AccessController.doPrivileged(new PrivilegedAction() {
	    public Object run() {
		File f;
		OutputStream out;

		try {
		    f = new File(userPropsFile);
		    if (f != null && f.canWrite()) {
			out = new BufferedOutputStream
			    (new FileOutputStream(f.getPath()));
			iiimProps.store(out, "iiimf property file");
			out.close();
		    }
		} catch(Exception e) {
		    if (Manager.DEBUG) {
			e.printStackTrace();
		    }
		}
		return null;
	    }
	});
		    
	return ret;
    }

    /*
     * get Property, return null if the key does not exist
     */
    static String getProperty(String key) {
	return iiimProps.getProperty(key);
    }

    /*
     * get Property, return def if the  key does not exist
     */
    static String getProperty(String key, String def) {
	return iiimProps.getProperty(key, def);
    }

    Locale currentLocale = null;

    Locale getCurrentLocale() {
	if (currentLocale != null) {
	    return currentLocale;
	}
	return Locale.getDefault();
    }

    ///////// JDK12 sun.awt.im.InputMethodAdapter's method ///////
    boolean setLocale(Locale locale) {
	currentLocale = locale;
	return true;
    }

    void setCharacterSubsets(Subset[] subsets) {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		((InputMethodAdapter)l).setCharacterSubsets(subsets);
	    }
	}
    }

    void activate() {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		((InputMethodAdapter)l).activate();
	    }
	}
	if (statusListener instanceof InputMethodAdapter) {
	    ((InputMethodAdapter)statusListener).activate();
	}
	if (lookupListener instanceof InputMethodAdapter) {
	    ((InputMethodAdapter)lookupListener).activate();
	}
    }

    void deactivate(boolean isTemporary) {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		((InputMethodAdapter)l).deactivate(isTemporary);
	    }
	}
	if (statusListener instanceof InputMethodAdapter) {
	    ((InputMethodAdapter)statusListener).deactivate(isTemporary);
	}
	if (lookupListener instanceof InputMethodAdapter) {
	    ((InputMethodAdapter)lookupListener).deactivate(isTemporary);
	}
    }

    void removeNotify() {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		((InputMethodAdapter)l).removeNotify();
	    }
	}
    }

    void endComposition() {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		((InputMethodAdapter)l).endComposition();
	    }
	}
    }

    void dispose() {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		((InputMethodAdapter)l).dispose();
	    }
	}
	if (statusListener instanceof InputMethodAdapter) {
	    ((InputMethodAdapter)statusListener).dispose();
	}
	if (lookupListener instanceof InputMethodAdapter) {
	    ((InputMethodAdapter)lookupListener).dispose();
	}
    }

    Object getControlObject() {
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof InputMethodAdapter) {
		Object o = ((InputMethodAdapter)l).getControlObject();
		if (o != null)
		    return o;
	    }
	}
	return null;
    }

    public Locale[] getAvailableLocales() {
	// use Set to prevent duplicate entry
	HashSet hs = new HashSet();
	for (int i = 0; i < rule.size(); i++) {
	    IIIMListener l = rule.get(i);
	    if (l instanceof IMProvider) {
		IMProvider imp = (IMProvider)l;
		Locale[] la = imp.getSupportLocales();
		if (la != null) {
		    for (int j = 0; j < la.length; j++) {
			hs.add(la[j]);
		    }
		}
	    }
	}
	Locale[] locales = new Locale[hs.size()];
	Iterator iterator = hs.iterator();
	int k = 0;
	for (; iterator.hasNext();) {
	    locales[k++] = (Locale)iterator.next();
	}
	return locales;
    }
}
	    
/*
 * Holder class for multiple AuxListener
 */
class IIIMAuxListeners implements IIIMAuxListener {

    IIIMAuxListener a, b;	
    IIIMAuxListeners(IIIMAuxListener a, IIIMAuxListener b) {
	this.a = a; this.b = b;
    }

    static IIIMAuxListener add(IIIMAuxListener a, IIIMAuxListener b) {
	if (a == null) return b;
	if (b == null) return a; 
	return new IIIMAuxListeners(a, b);
    }

    public void dispatchEvent(IIIMEvent e) {
    }

    public void auxStart(IIIMAuxEvent e) {
	if (a != null) a.dispatchEvent(e);
	if (b != null) b.dispatchEvent(e);
    }
    public void auxDone(IIIMAuxEvent e) {
	if (a != null) a.dispatchEvent(e);
	if (b != null) b.dispatchEvent(e);
    }
    public void auxDraw(IIIMAuxEvent e) {
	if (a != null) a.dispatchEvent(e);
	if (b != null) b.dispatchEvent(e);
    }

}

