/*
 * @(#)IIIMFDescriptor.java	1.3 00/08/23
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.Image;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodDescriptor;
import java.util.Locale;

public class IIIMFDescriptor implements InputMethodDescriptor {

    private Manager manager;

    public IIIMFDescriptor() {
    }

    public Locale[] getAvailableLocales() {
	if (manager == null) {
	    manager = Manager.getInstance();
	}
	return manager.getAvailableLocales();
    }

    public boolean hasDynamicLocaleList() {
	return false;
    }

    public synchronized String getInputMethodDisplayName(Locale inputLocale,
							 Locale displayLanguage) {
	return "Sun Internet/Intranet Input Method Federation";
    }

    public Image getInputMethodIcon(Locale inputLocale) {
	return null;
    }

    public String getInputMethodClassName() {
	return "sun.awt.im.iiimp.IIIMFAdapter";
    }

    public InputMethod createInputMethod() {
	return new IIIMFAdapter();
    }
}

    
