/*
 * @(#)IMProvider.java	1.8 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

import java.util.Locale;

public interface IMProvider {
    /**
     * name of this im
     */
    public String getName();

    /**
     * list of supported Script in human readable string
     */
    public String[] getEngineScript();

    /**
     * list of trigger on event for this im
     */
    public IIIMEvent[] getTriggerEvent();

    /**
     * set trigger event
     * if getTriggerConfigureLevel() returns CONF_NOKEY, then this
     * method will have no effect.
     */
    public void setTriggerEvent();

    /**
     * list of trigger off event
     */
    public IIIMEvent[] getTriggerOffEvent();

    /**
     * set trigger off event
     * if getTriggerConfiguraeLevel() returns other than CONF_ONOFFKEY,
     * then this method will have no effect.
     */
    public void setTriggerOffEvent();

    /**
     * returns supported Locales
     */
    public Locale[] getSupportLocales();
}
