/*
 * @(#)IIIMPreeditEvent.java	1.10 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

import java.text.AttributedString;
import java.text.AttributedCharacterIterator;

/**
 * This class represents InputMethod's preedit event.
 */
public class IIIMPreeditEvent extends IIIMEvent {

    private AttributedCharacterIterator iterator;
    private String string;
    private int caret;

    public static final int START = 0;
    public static final int DRAW  = 1;
    public static final int DONE  = 2;

    /**
     * Constructor for START/DONE event
     *
     * @param type IIIMPreeditEvent.START or IIIMPreeditEvent.DRAW
     */
    public IIIMPreeditEvent(int type) {
	super(PREEDIT);
	if (type != START && type != DONE) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
    }

    /** 
     * Constructor for DRAW event
     *
     * @param type IIIMPreeditEvent.DRAW
     * @param iterator AttributedCharacterIterator which represents preedit string
     * @param caret caret position
     */
    public IIIMPreeditEvent(int type, AttributedCharacterIterator iterator,
			    int caret) {
	super(PREEDIT);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.iterator = iterator;
	this.caret = caret;
    }

    /** 
     * Constructor for DRAW event
     *
     * @param type IIIMPreeditEvent.DRAW
     * @param string String which represents preedity string
     * @param caret caret position
     */
    public IIIMPreeditEvent(int type, String string, int caret) {
	super(PREEDIT);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.string = string;
	this.caret = caret;
    }

    /**
     * Get preedit string
     *
     * @return 	preedit string AttributedCharacterIterator
     */
    public AttributedCharacterIterator getIterator() {
	if (iterator == null) {
	    iterator = new AttributedString(string).getIterator();
	}
	return iterator;
    }

    /**
     *
     * @return preedit string String
     */
    public String getString() {
	if (string == null) {
	    string = iteratorToString(iterator);
	}
	return string;
    }

    /**
     * Get caret position
     *
     * @return 	caret position
     */
    public int getCaret() {
	return caret;
    }
}
