/*
 * @(#)IIIMAuxEvent.java	1.11 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

import sun.awt.im.iiimp.*;

/**
 * This class represents Aux event.
 */
public class IIIMAuxEvent extends IIIMEvent {

    public static final int START    = 0;
    public static final int DRAW     = 1;
    public static final int DONE     = 2;
    public static final int SETVALUES = 3;

    private int index;
    private String name;
    private int[] intValues;
    private String[] stringValues;

    /**
     * Constructor for START/DONE event
     */
    public IIIMAuxEvent(int type, int index, String name) {
	// classIndex is for backward compatibility
	super(AUX);
	if (type != START && type != DONE) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
	this.index = index;
	this.name = name;
    }

    /**
     * Constructor for DRAW/SETVALUES event
     */
    public IIIMAuxEvent(int type, int index, String name,
			int[] intValues, String[] stringValues) {
	super(AUX);
	if (type != DRAW && type != SETVALUES) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
	this.index = index;
	this.name = name;
	this.intValues = intValues;
	this.stringValues = stringValues;
    }

    public int getIndex() {
	return index;
    }

    public String getName() {
	return name;
    }

    public int[] getIntValues() {
	return intValues;
    }

    public String[] getStringValues() {
	return stringValues;
    }
}
