/*
 * @(#)IIIMActionEvent.java	1.7 99/09/01
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package com.sun.iiim;

public class IIIMActionEvent extends IIIMEvent {

    public static final int FORWARD_STRING = 1;
    public static final int LOOKUP_PROCESSED = 2;
    public static final int CUSTOM = 10;

    private String action;
    private Object arg;

    public IIIMActionEvent(int type, Object arg) {
	super(ACTION);
	this.type = type;
	this.action = null;
	this.arg = arg;
    }

    public IIIMActionEvent(String action, Object arg) {
	super(ACTION);
	this.action = action;
	this.arg = arg;
	this.type = CUSTOM;
    }

    public IIIMActionEvent(String action) {
	this(action, null);
    }

    public String getAction() {
	return action;
    }

    public Object getArg() {
	return arg;
    }
}
