/*
 * @(#)SamplePanel.java	1.12 99/06/17
 * Copyright 1998, 1999 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

package com.sun.iiim.sample.sampleja;

import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.text.*;

import com.sun.iiim.*;

public class SamplePanel extends IIIMComponent implements MouseMotionListener,  MouseListener, IIIMAuxListener {

    JWindow mainWindow = null;
    JButton b1, b2, b3, b4,  b5;
    int index;
    String name;

    public void auxStart(IIIMAuxEvent e) {

	index = e.getIndex();
	name = e.getName();

	mainWindow = new JWindow();
	JRootPane pane = mainWindow.getRootPane();
	pane.addMouseMotionListener(this);
	pane.addMouseListener(this);

	b1 = new JButton("mode", getImageIcon("images/b1.gif"));
	b2 = new JButton("dict", getImageIcon("images/b2.gif"));
	b3 = new JButton("hide", getImageIcon("images/b3.gif"));
	b4 = new JButton("flip", getImageIcon("images/b4.gif"));
	b5 = new JButton("help", getImageIcon("images/b5.gif"));

	b1.addActionListener(new modeListener());
	b2.addActionListener(new dictListener());
	b3.addActionListener(new hideListener());
	b4.addActionListener(new flipListener());
	b5.addActionListener(new helpListener());
	
	pane.setLayout(new FlowLayout());

	pane.add(b1);
	pane.add(b2);
	pane.add(b3);
	pane.add(b4);
	pane.add(b5);

	pane.setBorder(BorderFactory.createBevelBorder
		       (BevelBorder.RAISED, Color.lightGray, Color.darkGray));

	mainWindow.pack();
	Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
	Dimension wd = mainWindow.getSize();
	mainWindow.setLocation(sd.width - wd.width, sd.height - wd.height);
	mainWindow.setVisible(true);
    }


    public void auxDone(IIIMAuxEvent e) {
    }

    public void auxDraw(IIIMAuxEvent e) {
	int[] ia = e.getIntValues();
	if (ia != null && ia.length > 0) {
	    if (ia[0] == 2) {
		mainWindow.setVisible(true);
	    } else if (ia[0] == 3) {
		mainWindow.setVisible(false);
	    } else {
		System.out.println(" AUX protocol error");
	    }
	}
    }

    private int startX = 0;
    private int startY = 0;

    // MouseMotionListener implementation

    public void mouseDragged(MouseEvent e) {
	int x = e.getX();
	int y = e.getY();
	Point cp = mainWindow.getLocation();
	mainWindow.setLocation(cp.x + (x - startX), cp.y + (y - startY)); 
	mainWindow.getContentPane().repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    // MouseListener implementation

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
	startX = e.getX();
	startY = e.getY();
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    void sendEvent(String[] strs, int[] ints) {
	dispatchAuxEvent(new IIIMAuxEvent(IIIMAuxEvent.SETVALUES,
					  index, name, ints, strs));
    }

    class modeListener implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    try {
		// If SecurityManager is set, this must not be
		// allowed to Aux.
		String home = System.getProperty("user.home");
		String sep = System.getProperty("file.separator");
		FileWriter fow = new FileWriter(home + sep + "sampleJA");
		fow.write(" This should not be happned... ");
		fow.flush();
		fow.close();
	    } catch(Exception ex) {
		System.out.println("ex = " + ex);
	    }
	    System.out.println("mode");
	}
    }

    class dictListener implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    int[] ints = new int[] {1};
	    String[] strs = new String[] {"DICT"};
	    sendEvent(strs, ints);
	}
    }

    class hideListener implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    mainWindow.setVisible(false);
	}
    }

    class flipListener implements ActionListener {
	public void actionPerformed(ActionEvent e) {
	    System.out.println("flip");
	}
    }

    class helpListener implements ActionListener, HyperlinkListener {
	JDialog helpDialog = null;
	JEditorPane editorPane = null;

	public void actionPerformed(ActionEvent e) {
	    if (helpDialog != null) {
		helpDialog.setVisible(true);
		return;
	    }

	    helpDialog = new JDialog((Frame)null, "Help Window");
	    final JDialog dialog = helpDialog;
	    Container pane = helpDialog.getContentPane();
	    JPanel panel = new JPanel(new BorderLayout());

	    editorPane = new JEditorPane();
	    editorPane.setEditable(false);
	    editorPane.enableInputMethods(false);

	    try {
		URL html = getURL("html/sample.html");
		editorPane.setPage(html);
	    } catch(Exception ex) {
		ex.printStackTrace();
	    }

	    editorPane.addHyperlinkListener(this);
	    JScrollPane editorScrollPane = new JScrollPane(editorPane);
	    editorScrollPane.setVerticalScrollBarPolicy
		(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
	    editorScrollPane.setPreferredSize(new Dimension(400, 300));

	    JPanel buttonPanel = new JPanel();
	    JButton closeButton = new JButton("Close");
	    closeButton.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    dialog.setVisible(false);
		}
	    });
	    buttonPanel.add(closeButton);

	    panel.add(editorScrollPane, BorderLayout.CENTER);
	    panel.add(buttonPanel, BorderLayout.SOUTH);
	    pane.add(panel);

	    helpDialog.pack();
	    helpDialog.setVisible(true);
	}

	public void hyperlinkUpdate(HyperlinkEvent e) {
	    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
		linkActivated(e.getURL());
	    }
	}

	void linkActivated(URL url) {
	    Cursor c = editorPane.getCursor();
	    Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
	    editorPane.setCursor(waitCursor);
	    SwingUtilities.invokeLater(new PageLoader(url, c));
	}

	class PageLoader implements Runnable {
	    URL url;
	    Cursor c;

	    PageLoader(URL url, Cursor c) {
		this.url = url;
		this.c = c;
	    }

	    public void run() {
		if (url == null) {
		    editorPane.setCursor(c);
		    Container parent = editorPane.getParent();
		    parent.repaint();
		} else {
		    Document doc = editorPane.getDocument();
		    try {
			editorPane.setPage(url);
		    } catch(IOException ex) {
			editorPane.setDocument(doc);
		    } finally {
			url = null;
			SwingUtilities.invokeLater(this);
		    }
		}
	    }
	}
    }

}
			 

    
