/*
 * @(#)SampleLookup.java	1.5 99/04/19
 * Copyright 1998, 1999 by Sun Microsystems, Inc., 901 San Antonio Road,
 * Palo Alto, California, 94303, U.S.A. All rights reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered
 * into with Sun.
 */

package com.sun.iiim.sample.sampleja;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import com.sun.iiim.*;

public class SampleLookup extends IIIMComponent implements IIIMLookupListener {

    JDialog mainWindow;
    CandidatePanel panel;
    int row;
    int column;
    ImageIcon ii;

    public SampleLookup() {
	mainWindow = new JDialog();
	panel = new CandidatePanel();
	mainWindow.getContentPane().add(panel);
	ii = getImageIcon("images/button.gif");
    }

    public void lookupStart(IIIMLookupEvent e) {
	Dimension d = e.getRowColum(); 
	row = d.width;
	column = d.height;
	GridLayout gl = new GridLayout(row, column);
	gl.setHgap(4);
	panel.setLayout(gl);
	mainWindow.setVisible(true);
    }

    public void lookupDone(IIIMLookupEvent e) {
	mainWindow.setVisible(false);
    }

    public void lookupDraw(IIIMLookupEvent e) {
	panel.setCandidates(e.getCandidates(), e.getLabelList());
	mainWindow.setTitle(e.getTitle());
	Dimension d = mainWindow.getPreferredSize();
	mainWindow.setSize(d);
    }

    public void lookupProcess(IIIMLookupEvent e) {
    }

    class CandidatePanel extends JPanel {

	int cacheSize = 26;
	JLabel[] labels;

	CandidatePanel() {
	    labels = new JLabel[cacheSize];
	    for (int i = 0; i < cacheSize; i++) {
		labels[i] = new JLabel();
	    }
	}

	void setCandidates(String[] list, String[] label) {
	    if (list.length > cacheSize) {
		JLabel[] newLabels = new JLabel[list.length];
		for (int i = cacheSize; i < list.length; i++) {
		    newLabels[i] = new JLabel();
		}
		System.arraycopy(labels, 0, newLabels, 0, labels.length);
		labels = newLabels;
	    }
	    for (int i = 0; i < list.length; i++) {
		labels[i].setIcon(ii);
		labels[i].setText(label[i] + ":" + list[i]);
		add(labels[i]);
	    }
	}

    }
}
    
