/*
 * @(#)LWE1.java	1.13 99/05/31
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim.sample.lwe;

import java.util.Hashtable;
import java.util.Locale;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.text.AttributedString;
import java.text.AttributedCharacterIterator;
import com.sun.iiim.*;

class LWE1 extends LWE {

    private Hashtable firstTable;

    private static final String ISO8859_1 =
	"x!\u00a1" +
	"/c\u00a2" +
	"l-\u00a3" +
	"ox\u00a4" +
	"y=\u00a5" +
	"|-\u00a6" +
	"ss\u00a7" +
	"co\u00a9" +
	"ro\u00ae" +
	"x?\u00bf" +
	"34\u00be";

    private String[] sampleCandidate = {
	"\u00a1",
	"\u00a2",
	"\u00a3",
	"\u00a4",
	"\u00a5",
	"\u00a6",
	"\u00a7",
	"\u00a8",
	"\u00a9",
	"\u00aa",
	"\u00ab",
	"\u00ac",
	"\u00ad",
	"\u00ae",
	"\u00af",
    };
    
    public LWE1() {

	firstTable = new Hashtable();
	
	for (int i = 0; i < ISO8859_1.length(); i += 3) {
	    Character c1 = new Character(ISO8859_1.charAt(i));
	    Hashtable secondTable;
	    if (firstTable.containsKey(c1)) {
		secondTable = (Hashtable)firstTable.get(c1);
	    } else {
		secondTable = new Hashtable();
		firstTable.put(c1, secondTable);
	    }
	    Character c2 = new Character(ISO8859_1.charAt(i + 1));
	    Character c3 = new Character(ISO8859_1.charAt(i + 2));
	    secondTable.put(c2, c3);
	}
    }

    public void dispatchEvent(IIIMEvent e) {

	AWTEvent aev = e.getAWTEvent();
	if (aev == null)
	    return;

	if (aev instanceof KeyEvent) {
	    processKeyEvent(e);
	}
    }

    public String getName() {
	return "Sample LWE1";
    }

    private boolean beingProcess = false;
    private Character first, second, result;
    private boolean haveFirst = false;

    private void processKeyEvent(IIIMEvent e) {

	KeyEvent kev = (KeyEvent)e.getAWTEvent();
	int id = kev.getID();

	if (!beingProcess && id == KeyEvent.KEY_PRESSED &&
	    kev.getKeyCode() == KeyEvent.VK_COMPOSE) {
	    e.consume();
	    beingProcess = true;
	    // fire IIIMStatuEvent
	    AttributedString aString = new AttributedString("COMPOSE");
	    AttributedCharacterIterator iterator = aString.getIterator();
	    dispatchStatusEvent(new IIIMStatusEvent(IIIMStatusEvent.DRAW, iterator));
	    return;
	}

	//
	// Normal mode
	//
	if (!beingProcess) {
	    return;
	}

	//
	// Being process 
	//
	e.consume();

	//
	// only KEY_TYPED event will produce something
	// during processing
	//
	if (id == KeyEvent.KEY_RELEASED || id == KeyEvent.KEY_PRESSED) {
	    return;
	}

	if (haveFirst) {
	    Hashtable secondTable = (Hashtable)firstTable.get(first);

	    beingProcess = false;
	    haveFirst = false;

	    if (secondTable == null) {
		// reset compose
		return;
	    }
	    
	    second = new Character(kev.getKeyChar());
	    result = (Character)secondTable.get(second);

	    if (result == null) {
		// do nothing
		return;
	    }

	    // fire IIIMCommittedString
	    dispatchCommittedEvent
		(new IIIMCommittedEvent(String.valueOf(result.charValue())));
	    return;
	}

	first = new Character(kev.getKeyChar());
	haveFirst = true;
    }

    public Locale[] getSupportLocales() {
	return new Locale[] {Locale.JAPAN};
    }
}

class LWE2 extends LWE {

    private Hashtable firstTable1, firstTable2;

    private static final String HIRAGANA1 =
	"a\u3042" +
	"i\u3044" +
	"u\u3046" +
	"e\u3048" +
	"o\u304a";

    private static final String HIRAGANA2 =
	"ka\u304b" + "ki\u304d" + "ku\u304f" + "ke\u3051" + "ko\u3053" +
	"sa\u3055" + "si\u3057" + "su\u3059" + "se\u305b" + "so\u305d" +
	"ta\u305f" + "ti\u3061" + "tu\u3064" + "te\u3066" + "to\u3068" +
	"na\u306a" + "ni\u306b" + "nu\u306c" + "ne\u306d" + "no\u306e" +
	"ma\u307e" + "mi\u307f" + "mu\u3080" + "me\u3081" + "mo\u3082" +
	"ha\u306f" + "hi\u3072" + "fu\u3075" + "he\u3078" + "ho\u307b" +
	"ya\u3084" + "yu\u3086" + "yo\u3088" + "wa\u308f";

    public LWE2() {

	firstTable1 = new Hashtable();
	firstTable2 = new Hashtable();

	for (int i = 0; i < HIRAGANA1.length(); i += 2) {
	    Character c1 = new Character(HIRAGANA1.charAt(i));
	    Character c2 = new Character(HIRAGANA1.charAt(i + 1));
	    firstTable1.put(c1, c2);
	}

	for (int i = 0; i < HIRAGANA2.length(); i += 3) {
	    Character c1 = new Character(HIRAGANA2.charAt(i));
	    Hashtable secondTable;
	    if (firstTable2.containsKey(c1)) {
		secondTable = (Hashtable)firstTable2.get(c1);
	    } else {
		secondTable = new Hashtable();
		firstTable2.put(c1, secondTable);
	    }
	    Character c2 = new Character(HIRAGANA2.charAt(i + 1));
	    Character c3 = new Character(HIRAGANA2.charAt(i + 2));
	    secondTable.put(c2, c3);
	}
    }

    public void dispatchEvent(IIIMEvent e) {

	AWTEvent aev = e.getAWTEvent();
	if (aev == null)
	    return;

	if (aev instanceof KeyEvent) {
	    processKeyEvent(e);
	}
    }

    public String getName() {
	return "Sanple LWE2";
    }

    private boolean beingProcess = false;
    private Character first, second, result;
    private boolean haveFirst = false;

    private boolean triggerConsume = false;

    private void processKeyEvent(IIIMEvent e) {

	KeyEvent kev = (KeyEvent)e.getAWTEvent();
	int id = kev.getID();

	if (!beingProcess && id == KeyEvent.KEY_PRESSED &&
	    kev.getKeyCode() == KeyEvent.VK_SPACE &&
	    kev.isControlDown()) {
	    e.consume();
	    triggerConsume = true;
	    beingProcess = true;
	    // fire IIIMStatusEvent
	    return;
	}

	if (triggerConsume && id == KeyEvent.KEY_TYPED) {
	    triggerConsume = false;
	    e.consume();
	    return;
	}

	//
	// Conversion off
	//
	if (!beingProcess) {
	    return;
	}
	
	//
	// Being process
	//
	e.consume();

	//
	// Check Conversion off
	//
	if (id == KeyEvent.KEY_PRESSED &&
	    kev.getKeyCode() == KeyEvent.VK_SPACE &&
	    kev.isControlDown()) {
	    beingProcess = false;
	    e.consume();
	    triggerConsume = true;
	    // fire IIIMStatusEvent / IIIMPreeditEvetn / IIIMCommittedEvent
	    return;
	}
	
	//
	// only KEY_TYPED event will produce something
	// during processing.
	//
	if (id == KeyEvent.KEY_RELEASED || id == KeyEvent.KEY_PRESSED) {
	    return;
	}

	if (haveFirst) {
	    Hashtable secondTable = (Hashtable)firstTable2.get(first);

	    haveFirst = false;

	    if (secondTable == null) {
		// reset preedit
		return;
	    }

	    second = new Character(kev.getKeyChar());
	    result = (Character)secondTable.get(second);

	    if (result == null) {
		// reset preedit
		return;
	    }

	    // fire IIIMPreeditString
	    dispatchCommittedEvent(new IIIMCommittedEvent(String.valueOf
							  (result.charValue())));
	    return;
	}
	
	//
	// check firstTabel1
	//
	first = new Character(kev.getKeyChar());
	result = (Character)firstTable1.get(first);

	if (result != null) {
	    // fire IIIPreeditEvent
	    dispatchCommittedEvent(new IIIMCommittedEvent(String.valueOf
							  (result.charValue())));
	    return;
	}

	haveFirst = true;
    }

    public Locale[] getSupportLocales() {
	return new Locale[] {Locale.JAPAN};
    }
}
