/*
 * @(#)PCE.java	1.13 99/05/31
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.Locale;
import java.util.StringTokenizer;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.im.InputContext;
import com.sun.iiim.*;

/**
 * Primary Composition Editor -
 * configurable Light Weight Engine which accept
 * LWESyntax as it's composition rule.
 */

public class PCE extends LWE {

    private Stack syntaxStack;
    private Hashtable icTable;
    private LWESyntax syntax;
    
    public void dispatchEvent(IIIMEvent e) {

	SyntaxOnOff syntaxOnOff = null;

	InputContext ic = getInputContext();
	if (ic == null) {
	    return;
	}
	
	if (icTable.size() == 0) {
	    syntax = (LWESyntax)syntaxStack.peek();
	    if (syntax == null) {
		return;
	    }
	    syntaxOnOff = new SyntaxOnOff(syntax);
	    icTable.put(ic, syntaxOnOff);
	} else {
	    if (icTable.containsKey(ic)) {
		syntaxOnOff = (SyntaxOnOff)icTable.get(ic);
	    } else {
		syntax = syntax.getCopy();
		syntaxOnOff = new SyntaxOnOff(syntax);
		icTable.put(ic, syntaxOnOff);
	    }
	}

	if (!syntaxOnOff.willProcess(e)) {
	    // Conversion Off Mode
	    return;
	}
	if (e.isConsumed()) {
	    // This e is trigger key
	    return;
	}

	IIIMEvent[] events = null;
	try {
	    events = syntax.getEventList(e);
	} catch(InvalidSyntaxException ex) {
	    if (Manager.DEBUG) {
		ex.printStackTrace();
	    }
	}

	e.consume();
	
	if (events != null) {
	    for (int i = 0; i < events.length; i++) {
		markProcessedUpperListener(events[i], this);
		int id = events[i].getID();
		switch(id) {
		  case IIIMEvent.ACTION:
		    debug(" action = " + ((IIIMActionEvent)events[i]).getAction());
		    dispatchActionEvent((IIIMActionEvent)events[i]);
		    break;
		  case IIIMEvent.COMMITTED:
		    dispatchCommittedEvent((IIIMCommittedEvent)events[i]);
		    break;
		  case IIIMEvent.PREEDIT:
		    dispatchPreeditEvent((IIIMPreeditEvent)events[i]);
		    break;
		  default:
		    debug(" LWESyntax procudes unknown event...");
		}
	    }
	}
    }

    public String getName() {
	return "PCE";
    }

    public IIIMEvent[] getTriggerEvent() {
	return triggerOns;
    }

    public IIIMEvent[] getTriggerOffEvent() {
	return triggerOffs;
    }

    public String[] getEngineSctipt() {
	return new String[] {"Japanese", "Chinese"};
    }

    /**
     * Manager will create the instance of this class
     * with default LWESyntax.
     */
    public PCE() {
	syntaxStack = new Stack();
	icTable = new Hashtable();
	if (!initTrigger) {
	    setupTriggerEvents();
	}
    }

    public void pushSyntax(LWESyntax syntax) {
	syntaxStack.push(syntax);
	icTable.clear();
    }

    public LWESyntax popSyntax() {
	LWESyntax syntax = (LWESyntax)syntaxStack.pop();

	return syntax;
    }

    private static final String defaultTrigger = "key<Control+P>";
    private static IIIMEvent[] triggerOns, triggerOffs;
    private static boolean initTrigger = false;

    /*
     * Trigger string representation is
     * key<modifier+..+keyname> or action<actioname>.
     * More than one trigger can be represented with delimiter ',' or ':'.
     * For example in ~/.iiimp propery file
     *     iiimf.pce.trigger.on = key<Control+Space>,action<PCETriggerOn>
     */
    private static void setupTriggerEvents() {
	initTrigger = true;

	String trigger =
	    Manager.getProperty("iiimf.pce.trigger", defaultTrigger);
	String triggerOn =
	    Manager.getProperty("iiimf.pce.trigger.on", defaultTrigger);
	String triggerOff
	    = Manager.getProperty("iiimf.pce.trigger.off", defaultTrigger);
	
	String onString = trigger.equals(triggerOn) ?
	    trigger : trigger + "," + triggerOn;
	triggerOns = makeIIIMEvents(onString);

	if (triggerOn.equals(triggerOff)) {
	    triggerOffs = triggerOns;
	} else {
	    String offString = trigger.equals(triggerOff) ?
		trigger : trigger + "," + triggerOff;
	    triggerOffs = makeIIIMEvents(offString);
	}
    }

    private static IIIMEvent[] makeIIIMEvents(String triggers) {
	StringTokenizer ston = new StringTokenizer(triggers, ",:");
	Vector vector = new Vector();
	while(ston.hasMoreTokens()) {
	    String trigger = ston.nextToken();
	    int lastIndex = trigger.lastIndexOf('>');
	    if (lastIndex < 4)
		// ignore wrong representation
		continue;
	    if (trigger.startsWith("key<")) {
		String key = trigger.substring(4, lastIndex);
		vector.add(new IIIMKeyEvent(key));
	    } else if (trigger.startsWith("action<")) {
		if (lastIndex <= 7)
		    continue;
		String action = trigger.substring(7, lastIndex);
		vector.add(new IIIMActionEvent(action));
	    }
	}
	IIIMEvent[] iea = new IIIMEvent[vector.size()];
	for (int i = 0; i < iea.length; i++) {
	    iea[i] = (IIIMEvent)vector.elementAt(i);
	}
	return iea;
    }

    class SyntaxOnOff {

	private LWESyntax syntax;
	private boolean on = false;


	// KEY_TYPED event does not hold modifier information
	// so this variable is needed...
	private boolean controlDown = false;

	SyntaxOnOff(LWESyntax syntax) {
	    this.syntax = syntax;
	    on = false;
	}

	LWESyntax getSyntax() {
	    return syntax;
	}

	boolean willProcess(IIIMEvent e) {
	    if (on) {
		return checkTrigger(e, triggerOffs);
	    } else {
		return checkTrigger(e, triggerOns);
	    }
	}

	boolean checkTrigger(IIIMEvent e, IIIMEvent[] triggers) {
	    AWTEvent ae = e.getAWTEvent();
	    if (ae != null && ae instanceof KeyEvent) {
		KeyEvent ke = (KeyEvent)ae;
		int id = ke.getID();
		for (int i = 0; i < triggers.length; i++) {
		    if (triggers[i] instanceof IIIMKeyEvent) {
			if (((IIIMKeyEvent)triggers[i]).match(ke)) {
			    e.consume();
			    if (id == KeyEvent.KEY_RELEASED) {
				on = !on;
			    }
			    break;
			}
		    }
		}
	    }
	    return on;
	}
    }

    public Locale[] getSupportLocales() {
	return null;
    }
    
    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}
