/*
 * @(#)ODClassLoader.java	1.6 99/10/21
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.io.*;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.*;
import java.security.*;
import javax.swing.ImageIcon;

public class ODClassLoader extends SecureClassLoader {


    private HashMap byteTable = new HashMap();

    ODClassLoader() {
	super(ClassLoader.getSystemClassLoader());
    }

    void addJar(JarInputStream jis) {
	JarEntry je;
	boolean defc;
	
	for (;;) {
	    try {
		je = jis.getNextJarEntry();
	    } catch(Exception e) {
		continue;
	    }
	    
	    if (je == null) {
		break;
	    }

	    String name = je.getName();
	    //
	    // should use ByteArrayOutputStream and getByteArray()!!!
	    //
	    byte[] buf = new byte[1024];
	    int bufLen = 2048;
	    byte[] buffer = new byte[bufLen];
	    int total = 0, len;
	    try {
		for (;(len = jis.read(buf, 0, buf.length)) != -1;) {
		    if (bufLen < total + len) {
			byte[] tmp = new byte[bufLen * 2];
			System.arraycopy(buffer, 0, tmp, 0, total);
			buffer = tmp;
			bufLen *= 2;
		    }
		    System.arraycopy(buf, 0, buffer, total, len);
		    total += len;
		}
	    } catch(Exception e) {
		if (Manager.DEBUG) {
		    e.printStackTrace();
		}
		continue;
	    }
	    //
	    // store byte array for findClass() of ODClassLoader
	    //
	    byte[] realBuf = new byte[total];
	    System.arraycopy(buffer, 0, realBuf, 0, total);
	    byteTable.put(name, realBuf);
	}
    }

    /**
     * findClass from class byte array strage made from JarInputStream.
     */
    public Class findClass(String name) {
	
	byte[] ba = (byte[])byteTable.get(name.replace('.', '/') + ".class");

	if (ba == null) {
	    debug(" ODClassLoader: Unknown class " + name);
	    return null;
	}
	Class cls = null;
	try {
	    // CodeSource object will be added later.
	    //
	    cls = defineClass(name, ba, 0, ba.length, (CodeSource)null);
	} catch(Throwable e) {
	    debug(" E = " + e);
	    return null;
	}

	return cls;
    }

    public ImageIcon getImageIcon(String name) {

	byte[] ba = (byte[])byteTable.get(name);
	if (ba == null) {
	    debug(" ODClassLoader: " + name + " not found.");
	    return null;
	}

	return new ImageIcon(ba);
    }

    public String getString(String name) {

	byte[] ba = (byte[])byteTable.get(name);
	if (ba == null) {
	    debug(" ODClassLoader: " + name + " not found.");
	    return null;
	}
	String ret = null;
	try {
	    ret = new String(ba, "UTF-8");
	} catch(Exception e) {
	    if (Manager.DEBUG) {
		e.printStackTrace();
	    }
	}

	return ret;
    }

    

    public URL getURL(String name) {

	byte[] ba = (byte[])byteTable.get(name);

	if (ba == null) {
	    debug(" ODClassLoader: " + name + " not found.");
	}
	URL url = null;
	String anchor = null;
	try {
	    File f = File.createTempFile("iiim", "iiim");
	    String tempName = f.getAbsolutePath();
	    f.delete();
	    f = new File(tempName);
	    f.mkdir();

	    int anchorID = name.indexOf('#');
	    if (anchorID > 0) {
		anchor = name.substring(anchorID);
		name = name.substring(0, anchorID);
	    }

	    int fileid = name.lastIndexOf("/");
	    String dirname = name.substring(0, fileid);
	    Object[] writeList = getWriteList(dirname);

	    for (int i = 0; i < writeList.length; i++) { 
		String filename = ((String)writeList[i]).substring
		    (fileid, ((String)writeList[i]).length());
		if (filename.equals("") || filename.equals("/")) {
		    continue;
		}
		File f2 = new File(f, filename);
		byte[] ba2 = (byte[])byteTable.get((String)writeList[i]);
		if (ba2 == null) {
		    continue;
		}
		FileOutputStream fos = new FileOutputStream(f2);
		BufferedOutputStream bos = new BufferedOutputStream(fos);
		bos.write(ba2);
		bos.close();
		if (name.equals((String)writeList[i])) {
		    url = f2.toURL();
		    if (anchor != null) {
			String s = url.toExternalForm();
			url = new URL(s + anchor);
		    }
		}
	    }
	} catch(Exception e) {
	    debug(" getURL faied");
	}

	return url;
    }

    private Object[] getWriteList(String dirname) {
	HashSet strSet = new HashSet();
	Iterator iterator = byteTable.keySet().iterator();
	for (; iterator.hasNext();) {
	    String key = (String)iterator.next();
	    if (key.startsWith(dirname)) {
		strSet.add(key);
	    }
	}

	return strSet.toArray();
    }
	
    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}
