/*
 * %W% %E%
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.event.*;
import java.awt.font.TextHitInfo;
import com.sun.iiim.*;

class LookupWindow extends IIIMWindow implements IIIMLookupListener {

    // Window's default position in root window style
    private static final int LocateX;
    private static final int LocateY;
    // Create separated or composite window flexibility
    private LookupPane pane;
    // Input style
    private String style;
    // offset value
    private int offset = 24;
   
    int columHeight, columWidth;
    FontMetrics fm;

    static {
	Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        LocateX = (d.width*8/9);
        LocateY = (d.height*8/9); 
    }
    
    // No argument constructor, it is necessary for downloading
    public LookupWindow() {
        style = Manager.getProperty("iiimf.preedit.style");
        if(style == null) style = "ROOTWINDOW";      
        
        init();
    }
    
    void init() {
        window = new EventWindow(this);
                
	Font font = new Font("Monospaced", Font.PLAIN, 12);
	
        fm = window.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        int fontWidth = fm.getMaxAdvance();
        int fontAscent = fm.getAscent();
        columWidth = fontWidth ;
        columHeight = fontHeight + 2;
        	
        window.setFont(font);
	
        pane = new LookupPane();
        pane.setFont(font);
        window.add(pane);

	window.pack();
    }
    
    protected void dispatchActionEvent(IIIMActionEvent e) {
	super.dispatchActionEvent(e);
    }

    // Listener method
    public void lookupStart(IIIMLookupEvent e) {
	if (pane == null) {
	    init();
	}
	pane.setTarget(getClientComponent());
	pane.setLookupWindow(this);
        pane.handleEvent(e);
    }

    public void lookupDone(IIIMLookupEvent e) {
        pane.handleEvent(e);
	window.setVisible(false);
    }

    public void lookupDraw(IIIMLookupEvent e) {
        pane.handleEvent(e);
	setTitle(e.getTitle());
	window.setSize(window.getPreferredSize());
	calculatePosition();  
	window.setVisible(true);
    }

    public void lookupProcess(IIIMLookupEvent e) {
        pane.handleEvent(e);
    }
    
    public void setStyle(String style) {
        this.style = style;
    }
    
    public String getStyle() {
        return style;
    }
    
    void setLocation(int x, int y) {
        window.setLocation(x,y);
    }
    
    void calculatePosition() {
        Component component = getClientComponent();
        
        Component frame = component;
        Insets inset = window.getInsets();
        
        while(!(frame instanceof Frame) && !(frame instanceof Dialog)) {
	    frame = frame.getParent();
	}
        
        if(style.equals("BELOWSPOT") 
            && component instanceof InputMethodRequests) {
                Rectangle rect = 
                    ((InputMethodRequests)component).getTextLocation(TextHitInfo.leading(0));
                Point point = new Point();
                point.x = rect.x;
                point.y = rect.y + (int)rect.getHeight() + offset;
                // Leave space for Preedit window
                point.y += (inset.top + inset.bottom + fm.getHeight());
                window.setLocation(point);            
        /*
         * ONSPOT style can used as root window
        else if(style.equals("ONSPOT") 
            && component instanceof InputMethodRequests) {
        */
        } else  {
            // For "ROOTWINDOW" style and component isn't InputMethodRequests
            // Place the window on the left-corner of client component
            
            Point point = frame.getLocation();
            Dimension size = frame.getSize();     

            double x = point.getX();
            // It must leave the position for PreeditWindow
            double y = point.getY() + size.getHeight() 
                + inset.top + inset.bottom + fm.getHeight();
            
            window.setLocation((int)x, (int)y);
            
  
        }
        
            // If window is out of screen, adjust it
            Point location = window.getLocation();
            double xl = location.getX();
            double yl = location.getY();
            Dimension dm = window.getSize();
            if((xl + dm.getWidth()) > screenWidth) 
                xl = screenWidth - dm.getWidth();
            if((yl + dm.getHeight()) > screenHeight) 
                yl = screenHeight - dm.getHeight();
            window.setLocation((int)xl, (int)yl);                  
    }
    
    synchronized void show() {
        if(window == null) init();
        window.setVisible(true);
    }
    
    private void setTitle(String str) {
        ((Dialog)window).setTitle(str);
    }
}
