/*
 * @(#)IIIMPInputStream.java	1.9 99/04/23
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.io.EOFException;
import java.io.InputStream;
import java.io.DataInputStream;
import java.io.IOException;

class IIIMPInputStream extends DataInputStream implements IIIMProtocol {
    ProtocolDriver pd;
    
    IIIMPInputStream(ProtocolDriver pd, InputStream in) {
        super(in);
	this.pd = pd;
    }

    IIIMPInputStream(InputStream in) {
	this(null, in);
    }

    public int read() throws IOException {
	try {
	    int c = in.read();
	    if (c == -1) {
	        debug("IIIMPInputStream Get -1 !!");
		if (pd != null) 
		    pd.lostConnect();
	    }
	    return c;
	} catch (Exception e) {
            debug("IIIMPInputStream exception = " + e);
	    if (pd != null) 
		pd.lostConnect();
	    throw new IOException("Connection lost");
	}
    }

    private void debug(String str) {
	if (Manager.DEBUG) {
	    System.err.println(str);
	}
    }
}


    
