/*
 * @(#)IIIMPClientDescripter.java	1.1 99/03/31
 *
 * Copyright 1998, 1999 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.io.IOException;

class IIIMPClientDescripter implements IIIMProtocol {

    /* LISTofIMATTRIBUTE
     *
     *  IMATTRIBUTE
     *  2 : ATTRIBID - CLIENTDESCRIPTOR(0x1011)
     *  2 : length of CLIENTDESCRIPTER
     *  n : LISTofSTRING (applicationName, osName, osArck, osVersion)  
     */
    
    static final String version = System.getProperty("java.version");
    static final String osName = System.getProperty("os.name");
    static final String osArch = System.getProperty("os.arch");
    static final String osVersion = System.getProperty("os.version");

    private String applicationName;

    ProtocolData cData;

    IIIMPClientDescripter() throws IOException {

	applicationName = "JDK" + version;

	// make CLIENTDESCRIPTER
	ProtocolData value = new ProtocolData();
	value.writeString(applicationName);
	value.writeString(osName);
	value.writeString(osArch);
	value.writeString(osVersion);

	cData = new ProtocolData();
	cData.write2(CLIENT_DESCRIPTER);
	cData.write2(0);
	cData.write4(value.count);
	cData.writeBytes(value.buf, value.count);
    }

    ProtocolData getData() {
	return cData;
    }
}
