/*
 * @(#)EventWindow.java	1.7 99/04/09
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package sun.awt.im.iiimp;

import java.awt.*;
import java.awt.im.*;
import java.awt.event.*;
import com.sun.iiim.*;

class EventWindow extends Dialog implements KeyListener, MouseListener, FocusListener {
    LookupWindow window;
    
    public EventWindow(LookupWindow window) {
        super(new Frame(""));
        
        this.window = window;
        
        setResizable(true);
        setTitle("Lookup Choice Window");
        
        addKeyListener(this);
        addMouseListener(this);
        addFocusListener(this);
    }
    
    public void keyPressed(KeyEvent e) {
        Component target = window.getClientComponent();
        
        if (target != null)
            target.dispatchEvent(e);    
    }
    
    public void keyReleased(KeyEvent e) {
        Component target = window.getClientComponent();
        
        if (target != null)
            target.dispatchEvent(e);        
    }
    
    public void keyTyped(KeyEvent e) {
        Component target = window.getClientComponent();
        
        if (target != null)
            target.dispatchEvent(e);    
    }
    
    public void mouseClicked(MouseEvent e) {
    }
    
    public void mouseEntered(MouseEvent e) {
    }
    
    public void mouseExited(MouseEvent e) {
    }
    
    public void mousePressed(MouseEvent e) {
    }
    
    public void mouseReleased(MouseEvent e) {
        if(!(e.getSource() instanceof Label)) return;
        Label label = (Label)e.getSource();

        IIIMActionEvent event = 
            new IIIMActionEvent("lookupProcessed", label.getText().substring(3));   

        window.dispatchActionEvent(event);
        window.hide();
    }
    
    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

}    
