/*
 * @(#)IIIMStatusEvent.java	1.9 99/08/02
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

import java.text.AttributedString;
import java.text.AttributedCharacterIterator;

/**
 * This class represents InputMethod's status event.
 */
public class IIIMStatusEvent extends IIIMEvent {

    private AttributedCharacterIterator iterator;
    private String statusString;

    public static final int START = 0;
    public static final int DRAW  = 1;
    public static final int DONE  = 2;

    /**
     * Constructor for START/DONE event
     *
     * @param	IIIMStatusEvent.START or IIIMStatusEvent.DONE
     */
    public IIIMStatusEvent(int type) {
	super(STATUS);
	if (type != START && type != DONE) {
	    throw new IllegalArgumentException();
	}
	this.type = type;
    }

    /**
     * Constructor for DRAW event
     *
     * @param 	IIIMStatusEvent.DRAW
     * @param	character iterator which represents status string
     */
    public IIIMStatusEvent(int type, AttributedCharacterIterator iterator) {
	super(STATUS);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.iterator = iterator;
    }

    /**
     * Constructor for DRAW event
     */
    public IIIMStatusEvent(int type, String statusString) {
	super(STATUS);
	if (type != DRAW) {
	    throw new IllegalArgumentException();
	}
	this.type = DRAW;
	this.statusString = statusString;
    }

    public AttributedCharacterIterator getIterator() {
	if (iterator == null) {
	    iterator = new AttributedString(statusString).getIterator();
	}
	return iterator;
    }

    public String getString() {
	if (statusString == null) {
	    statusString = iteratorToString(iterator);
	}
	return statusString;
    }
}
