/*
 * @(#)IIIMEvent.java	1.11 99/08/02
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.sun.iiim;

import java.util.Vector;
import java.awt.AWTEvent;
import java.awt.event.InputEvent;
import java.text.CharacterIterator;

public class IIIMEvent {

    protected boolean consumed = false;
	
    protected int id = AWT;

    public int getID() {
	return id;
    }

    /*
     * The type is unique only in one kind of IIIMEvent.
     */
    protected int type;

    public int getType() {
	return type;
    }

    // IIIMEvent id need to be unique only in IIIMEvent, because
    // EventQueue which is used to post/dispatch only handle
    // the subclass of IIIMEvent.
    //
    public final static int AWT			= 0;
    public final static int ACTION 		= 1;
    public final static int PREEDIT 		= 2;
    public final static int COMMITTED 		= 3;
    public final static int LOOKUP		= 4;
    public final static int STATUS		= 5;
    public final static int AUX			= 6;
    public final static int KEY			= 7;

    private AWTEvent awtEvent;
    private Vector listeners;

    public IIIMEvent(int id) {
	this.id = id;
	listeners = new Vector();
    }

    public IIIMEvent(AWTEvent e) {
	this(AWT);
	
	awtEvent = e;
    }

    public AWTEvent getAWTEvent() {
	return awtEvent;
    }

    public void processedBy(IIIMListener listener) {
	listeners.add(listener);
    }

    public boolean isProcessedBy(IIIMListener listener) {
	return listeners.contains(listener);
    }

    public void consume() {
	consumed = true;
	if (awtEvent != null && awtEvent instanceof InputEvent) {
	    ((InputEvent)awtEvent).consume();
	}
    } 

    public boolean isConsumed() {
	return consumed;
    }

    /**
     * convinience method
     */
    public static String iteratorToString(CharacterIterator iterator) {
	StringBuffer sb = new StringBuffer();
	for (char c = iterator.first(); c != CharacterIterator.DONE;
	     c = iterator.next()) {
	    sb.append(c);
	}
	return sb.toString();
    }
}
