/*
 * @(#)IIIMComponent.java	1.11 99/05/07
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package com.sun.iiim;

import java.lang.Character.Subset;
import java.util.Locale;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.im.InputContext;
import java.net.URL;
import javax.swing.ImageIcon;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.iiimp.*;

/**
 * The class <code>IIIMComponent</code> is an abstract class.
 * IIIM component like ProtocolDriver/GUI/LWE object procude
 * IM information, they will use this classes's method to deliver it
 * to appropriate component.
 */
public abstract class IIIMComponent extends InputMethodAdapter
	implements IIIMListener {

    private Manager manager;

    protected void dispatchActionEvent(IIIMActionEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchActionEvent(e);
    }

    /**
     * When iiim component delivers Aux event,
     * then this method is used. ProtocolDriver or Aux object 
     * use when they deliver Aux information.
     *
     * @param	<code>IIIMAuxEvent</code>
     */ 
    protected void dispatchAuxEvent(IIIMAuxEvent e) {
	if (auxProxy != null) {
	    auxProxy.dispatchAuxEvent(e);
	    return;
	} 

	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchAuxEvent(e);
    }

    /**
     * When iiim component delivers Preedit event, 
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver preedit information.
     *
     * @param	<code>IIIMPreeditEvent</code>
     */
    protected void dispatchPreeditEvent(IIIMPreeditEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchPreeditEvent(e);
    }

    /**
     * When iiim component delivers committed string,
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver committed information.
     *
     * @param	<code>IIIMCommittedEvent</code>
     */
    protected void dispatchCommittedEvent(IIIMCommittedEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchCommittedEvent(e);
    }

    /**
     * When iiim component delivers lookup information
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver lookup information.
     *
     * @param 	<code>IIIMLookupEvent</code>
     */
    protected void dispatchLookupEvent(IIIMLookupEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchLookupEvent(e);
    }

    /**
     * When iiim component delivers status information
     * then this method is used. ProtocolDriver or LWE
     * use when they deliver status information.
     *
     * @param <code>IIIMStatusEvent</code>
     */
    protected void dispatchStatusEvent(IIIMStatusEvent e) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.dispatchStatusEvent(e);
    }

    //
    
    protected void markProcessedUpperListener(IIIMEvent e, IIIMListener l) {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	manager.markProcessedUpperListener(e, l);
    }

    protected InputContext getInputContext() {
	if (manager == null) {
	    manager = Manager.getInstance();
	}

	Component c = getClientComponent();
	if (c != null)
	    return c.getInputContext();

	return null;
    }

    /**
     * Get current active InputMethod client Component.
     *
     * @return	active <code>java.awt.Component</code>
     */
    public Component getClientComponent() {
	if (manager == null) {
	    manager = Manager.getInstance();
	}
	
	return manager.getClientComponent();
    }

    public ImageIcon getImageIcon(String name) {
	if (auxProxy != null) {
	    return AuxProxy.getLoader().getImageIcon(name);
	}
	return Manager.getLoader().getImageIcon(name);
    }

    public String getString(String name) {
	if (auxProxy != null) {
	    return AuxProxy.getLoader().getString(name);
	}
	return Manager.getLoader().getString(name);
    }

    public URL getURL(String name) {
	if (auxProxy != null) {
	    return AuxProxy.getLoader().getURL(name);
	}
	return Manager.getLoader().getURL(name);
    }

    // IIIMEventListener
    public void dispatchEvent(IIIMEvent e) {
    }

    public boolean setLocale(Locale locale) {
	return true;
    }

    public void setCharacterSubsets(Subset[] subsets) {
    }

    public void dispatchEvent(AWTEvent event) {
    }

    public void activate() {
    }

    public void deactivate(boolean isTemporary) {
    }

    public void removeNotify() {
    }

    public void endComposition() {
    }

    public void dispose() {
    }

    public Object getControlObject() {
	return null;
    }

    protected AuxProxy auxProxy;

    public void setProxy(AuxProxy proxy) {
	auxProxy = proxy;
    }

}
