/*
 * Decompiled with CFR 0.152.
 */
package com.sun.iiim.sample.sampleja;

import com.sun.iiim.IIIMAuxEvent;
import com.sun.iiim.IIIMAuxListener;
import com.sun.iiim.IIIMComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class SamplePanel
extends IIIMComponent
implements MouseMotionListener,
MouseListener,
IIIMAuxListener {
    JWindow mainWindow = null;
    JButton b1;
    JButton b2;
    JButton b3;
    JButton b4;
    JButton b5;
    int index;
    String name;
    private int startX = 0;
    private int startY = 0;

    public void auxDone(IIIMAuxEvent iIIMAuxEvent) {
    }

    public void auxDraw(IIIMAuxEvent iIIMAuxEvent) {
        int[] nArray = iIIMAuxEvent.getIntValues();
        if (nArray != null && nArray.length > 0) {
            if (nArray[0] == 2) {
                ((Component)this.mainWindow).setVisible(true);
            } else if (nArray[0] == 3) {
                ((Component)this.mainWindow).setVisible(false);
            } else {
                System.out.println(" AUX protocol error");
            }
        }
    }

    public void auxStart(IIIMAuxEvent iIIMAuxEvent) {
        this.index = iIIMAuxEvent.getIndex();
        this.name = iIIMAuxEvent.getName();
        this.mainWindow = new JWindow();
        JRootPane jRootPane = this.mainWindow.getRootPane();
        jRootPane.addMouseMotionListener(this);
        jRootPane.addMouseListener(this);
        this.b1 = new JButton("mode", this.getImageIcon("images/b1.gif"));
        this.b2 = new JButton("dict", this.getImageIcon("images/b2.gif"));
        this.b3 = new JButton("hide", this.getImageIcon("images/b3.gif"));
        this.b4 = new JButton("flip", this.getImageIcon("images/b4.gif"));
        this.b5 = new JButton("help", this.getImageIcon("images/b5.gif"));
        this.b1.addActionListener(new modeListener());
        this.b2.addActionListener(new dictListener());
        this.b3.addActionListener(new hideListener());
        this.b4.addActionListener(new flipListener());
        this.b5.addActionListener(new helpListener());
        jRootPane.setLayout(new FlowLayout());
        jRootPane.add(this.b1);
        jRootPane.add(this.b2);
        jRootPane.add(this.b3);
        jRootPane.add(this.b4);
        jRootPane.add(this.b5);
        jRootPane.setBorder(BorderFactory.createBevelBorder(0, Color.lightGray, Color.darkGray));
        this.mainWindow.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.mainWindow.getSize();
        ((Component)this.mainWindow).setLocation(dimension.width - dimension2.width, dimension.height - dimension2.height);
        ((Component)this.mainWindow).setVisible(true);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.mainWindow.getLocation();
        ((Component)this.mainWindow).setLocation(point.x + (n - this.startX), point.y + (n2 - this.startY));
        this.mainWindow.getContentPane().repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.startX = mouseEvent.getX();
        this.startY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void sendEvent(String[] stringArray, int[] nArray) {
        this.dispatchAuxEvent(new IIIMAuxEvent(3, this.index, this.name, nArray, stringArray));
    }

    class modeListener
    implements ActionListener {
        modeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("mode");
        }
    }

    class dictListener
    implements ActionListener {
        dictListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = new int[]{1};
            String[] stringArray = new String[]{"DICT"};
            SamplePanel.this.sendEvent(stringArray, nArray);
        }
    }

    class hideListener
    implements ActionListener {
        hideListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)SamplePanel.this.mainWindow).setVisible(false);
        }
    }

    class flipListener
    implements ActionListener {
        flipListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("flip");
        }
    }

    class helpListener
    implements ActionListener,
    HyperlinkListener {
        JDialog helpDialog = null;
        JEditorPane editorPane = null;

        helpListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (this.helpDialog != null) {
                ((Component)this.helpDialog).setVisible(true);
                return;
            }
            JDialog jDialog = this.helpDialog = new JDialog(null, "Help Window");
            Container container = this.helpDialog.getContentPane();
            JPanel jPanel = new JPanel(new BorderLayout());
            this.editorPane = new JEditorPane();
            this.editorPane.setEditable(false);
            this.editorPane.enableInputMethods(false);
            try {
                serializable = SamplePanel.this.getURL("html/sample.html");
                this.editorPane.setPage((URL)serializable);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.editorPane.addHyperlinkListener(this);
            serializable = new JScrollPane(this.editorPane);
            ((JScrollPane)serializable).setVerticalScrollBarPolicy(22);
            ((JComponent)serializable).setPreferredSize(new Dimension(400, 300));
            JPanel jPanel2 = new JPanel();
            JButton jButton = new JButton("Close");
            jButton.addActionListener(new ActionListener(jDialog){
                private final /* synthetic */ JDialog val$dialog;
                {
                    this.val$dialog = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)this.val$dialog).setVisible(false);
                }
            });
            jPanel2.add(jButton);
            jPanel.add((Component)serializable, "Center");
            jPanel.add((Component)jPanel2, "South");
            container.add(jPanel);
            this.helpDialog.pack();
            ((Component)this.helpDialog).setVisible(true);
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.linkActivated(hyperlinkEvent.getURL());
            }
        }

        void linkActivated(URL uRL) {
            Cursor cursor = this.editorPane.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.editorPane.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(uRL, cursor));
        }

        class PageLoader
        implements Runnable {
            URL url;
            Cursor c;

            PageLoader(URL uRL, Cursor cursor) {
                this.url = uRL;
                this.c = cursor;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (this.url == null) {
                    helpListener.this.editorPane.setCursor(this.c);
                    Container container = helpListener.this.editorPane.getParent();
                    container.repaint();
                    return;
                }
                Document document = helpListener.this.editorPane.getDocument();
                try {
                    try {
                        helpListener.this.editorPane.setPage(this.url);
                    }
                    catch (IOException iOException) {
                        helpListener.this.editorPane.setDocument(document);
                    }
                    Object var3_3 = null;
                    this.url = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                    throw throwable;
                }
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

