/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
#ifdef	sccs
static char     sccsid[] = "@(#)phrase2.c	1.2 00/08/19";
#endif
#endif

/* 	Copyright (c) 1989 by Sun Microsystems, Inc.	 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <string.h>
#ifndef __STDC__ 
#include <strings.h>
#endif
#include "cm_prc.h"

extern char    *malloc();
extern int      compare3();
extern int      process_delete();
void            ci3456_search();
void            cim_search();
void            Init();
extern struct CM_screen *cmscreen[];
extern int      error;
extern int      exter_code_count;
extern int      c_c;
extern int      ci2_b;		/* ci2	 exter code table */
extern int      ci2_file;	/* ci2	 phrase code table */
extern caddr_t  ci2_buf;
struct ci_external_entery {
	char            c1;
	char            c2;
	char            c3;
	char            c4;
};
struct ci2_entery {		/* 8 bytes */
	u_char          first11;
	u_char          first12;
	u_char          sec21;
	u_char          sec22;
	u_int           pointer;/* Not used in the release */
};

static struct ci2_entery *p2_ci2_entry;

static e_char  *ci2_b_buf;
static int      ci2_b_len;

#define	IS_DELETE(c)		( (c == 0x8) || (c == 0x7f) )
#define	LEGAL_INPUT_KEY(c)	( (c >= 'a') && (c <= 'z') )
#define	MAX_RC		26

/*
 * phrase2_init:
 *		Initialing double Chinese character phrase data file.
 * Common varaible:
 *		ci2_b is a double Chinese character phrase's cache data file fd.
 */
phrase2_init()
{
	struct stat     ci2_b_stat;
	int             state_tmp;
	extern int      fstat();
	extern off_t    lseek();
	extern int      read();

	state_tmp = fstat(ci2_b, &ci2_b_stat);
	if (state_tmp)
		exit(1);
	ci2_b_len = ci2_b_stat.st_size;
	ci2_b_buf = (e_char *) malloc((unsigned) ci2_b_len);
	state_tmp = (int) lseek(ci2_b, 0, 0);
	if (state_tmp == -1)
		exit(1);
	state_tmp = read(ci2_b, ci2_b_buf, ci2_b_len);
	if (state_tmp == -1)
		exit(1);
}

/*
 *	looking up double Chinese character phrase data file.
 */
phrase2(flag, str, c_string, selections, cms)
	u_int           flag;
	e_char          str;
	e_char          c_string[];
	e_char         *selections[];
	Cm_session	cms;
{
	register int    p_i;
	register int    null_input, offset, array_count;
	struct ci_external_entery *ci2_external_entery;
	int             array[26];
	char            c2_c1, c2_c2, c2_c3, c2_c4;
	e_char         *e_tmp;

	r_cc = 0;
	c_c = 0;
	null_input = 1;
	if (IS_DELETE(str) && flag) {
		if (exter_code_count) {
			exter_code_count--;
			DISP_BUF[exter_code_count] = 0;
			null_input = 0;
		};
	}
	if (LEGAL_INPUT_KEY(str) && flag) {
		null_input = 0;
		if (exter_code_count == 4)
			exter_code_count = 0;
		DISP_BUF[exter_code_count] = str;
		DISP_BUF[exter_code_count++] = ATTR_REVERSE;
		DISP_BUF[exter_code_count] = 0;
	}
	if (null_input && flag) {
		c_string[c_c++] = str;
		Init(cms);
		return;
	}
	if (exter_code_count == 4) {
		p_i = 0;
		array_count = 0;
		while (p_i != ci2_b_len) {
			ci2_external_entery = (struct ci_external_entery *)
				& ci2_b_buf[p_i];
			c2_c1 = ci2_external_entery->c1;
			c2_c2 = ci2_external_entery->c2;
			c2_c3 = ci2_external_entery->c3;
			c2_c4 = ci2_external_entery->c4;
			if (compare3(c2_c1, c2_c2, c2_c3, c2_c4, cms)) {
				offset = (p_i / 4) * 8;
				array[array_count++] = offset;
				/* Store offset in array */
				if (array_count == MAX_RC)
					break;
			}
			p_i += 4;
		};
		if (array_count == 0)
			return;
		offset = 0;
		p_i = 0;
		while (offset != array_count) {
			e_tmp = (e_char *) malloc(5);
			p_i = array[offset++];
			p2_ci2_entry = (struct ci2_entery *) & ci2_buf[p_i];
			e_tmp[0] = p2_ci2_entry->first11;
			e_tmp[1] = p2_ci2_entry->first12;
			e_tmp[2] = p2_ci2_entry->sec21;
			e_tmp[3] = p2_ci2_entry->sec22;
			e_tmp[4] = 0;
			selections[r_cc++] = e_tmp;
			if (r_cc == MAX_RC)
				return;
		};
		;
	}			/* End of if(exter_code_count==4) */
	return;
}
