/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
#ifdef	sccs
static char     sccsid[] = "@(#)full_code.c	1.3 00/09/13";
#endif
#endif

/*	Copyright (c) 1989 Sun Microsystems, Inc.	*/

#include	<stdio.h>
#include	<fcntl.h>
#include	<sys/types.h>
#include	<sys/time.h>
#include	<sys/stat.h>
#include	<string.h>
#ifndef __STDC__ 
#include	<strings.h>
#endif
#include	"cm_prc.h"

/* The below extern functions are defined  in the DIC function file */
extern u_int    dict_find_new();
extern u_int    dict_find_next();
extern u_int    dict_find_prev();
extern e_char **dict_find_all();
extern u_int    dict_match_longest();
extern u_int    dict_get_cookie();

/* The below extern structures are defined in the cm_prc.c */
extern struct cm_to_env *alloc_env();

extern int      exter_code_count;
extern int      Maximum_Cans;
extern int	root_window;		/* new luc */
extern int	luc_label_type;

/* The below external functions are defined in here */
extern struct cm_to_env *full_code_pinyin();
extern int	create_dic_list();
extern int	create_tail_list();
extern void     send_interm();
extern void     send_interm_reset_select();
extern void     send_interm_select();
extern void     send_NOP();
extern struct cm_to_env *send_commit();
extern void     reset_interm_select();
extern struct cm_to_env *commit_inbuf();
extern int      process_S_state();
extern int      is_select_rang();
extern struct 	dic_to_cm *alloc_dic();
extern void     free_dic();
extern int      copy_select();

extern struct CM_screen *cmscreen[];

struct cm_to_env *fullcode_switch_out();

#define	CONVERT_MODE	1	/* First bit */
#define	SELECT_MODE	2	/* Second bit */
#define	full_code_on	cmscreen[cms]->cm_conv_on

#define	MAX_EUC_LEN	12	/* max euc len for a phrase */
#define	MAX_KEY_LEN	36	/* max key len for a phrase */

/* Full pinyin code data structures and pointers     */

struct dic_to_cm {		/* every converted segment's struct */
	u_char		*py_string;
	u_char		key_code[MAX_KEY_LEN +1];
	int		buf_flag;	/* 0 : key_code[], !0 : malloc() */
	int		py_strlen;
	u_char		EUC_code[MAX_EUC_LEN +1];
	int             conversion_on;	/* CONVERT_MODE and SELECT_MODE */
					/* not used in the release */
	u_int           cookie;		/* only used by DIC,
					 * -1 : invalid pinyin, no EUC code */
					/* -2 : invalid, but EUC code be used
					 * by CM in the release */
	struct dic_to_cm *dtoc_prev;	/* link prev pointer */
	struct dic_to_cm *dtoc_next;	/* link next pointer */
};

/*
 * DTOC_HEAD		: pointer to head of all dic_to_cm structures
 * CURRENT_FOCUS_PTR	: pointer to current focus position.
 */

#define DTOC_HEAD		(struct dic_to_cm *)cmscreen[cms]->dic_head
#define CURRENT_FOCUS_PTR	(struct dic_to_cm *)cmscreen[cms]->focus_ptr

static e_char   commit_string[MAX_INTERM_TEXT];
static e_char	second_commit[2] = {0, 0};

extern struct input_method *conversion_off;

#define CONV_OFF_CTL	conversion_off->ctl_key
#define CMOFF_STRING	conversion_off->message

extern struct input_method *full_code_kb;

#define	FULL_CTL_N	full_code_kb->next_choice
#define	FULL_CTL_P	full_code_kb->prev_choice
#define	FULL_CTL_K	full_code_kb->commit_key
#define	FULL_CTL_W	full_code_kb->disp_sel_key
#define	FULL_CTL_F	full_code_kb->focus_right
#define	FULL_CTL_B	full_code_kb->focus_left
#define	FULL_CTL_I	full_code_kb->focus_longer
#define	FULL_CTL_U	full_code_kb->focus_shorter
#define	FULL_CTL_H	'H' - 0x40		/* temporary */

#define	FOCUS_SELECT	(CURRENT_FOCUS_PTR)->conversion_on&SELECT_MODE
#define	FOCUS_CONVERT	(CURRENT_FOCUS_PTR)->conversion_on&CONVERT_MODE

/*
 * full_code_pinyin:
 *		This is the main function for Sun Microsystems inc.'s 
 *	Intelligent pinyin input method. It be called by process_simple_event
 *      in cm_prc.c file. The full_code_pinyin provides a similar User
 *	interface as the Japanese Language Environment's KKC.
 *	in_c is the key stroke.
 */
struct cm_to_env *
full_code_pinyin(in_c, to_env_ptr, cms)
	int             in_c;
	struct cm_to_env *to_env_ptr;
	Cm_session	cms;
{
	static int      length_collision = 0;
	static e_char **select_array, **head_array;
	static e_char  *euc_collision[26];
	u_int           cookie_tmp;
	int             euc_length, select_count;
	struct cm_to_env *tp;
	struct cm_to_env *fullcode_CM_RESET();

	if (in_c == CONV_OFF_CTL) {
		/*
		 * do auto-commit when conv is being turned off 
		 */
		fullcode_CM_RESET(to_env_ptr, cms);
	} else if (in_c == FULL_CTL_N) {		 /* NEXT_CHOICE key */
		if (!exter_code_count) {
			send_NOP(to_env_ptr);
			return;
		}
		if (full_code_on == 0) {
			full_code_on = 1;
			if(create_dic_list(cms) == -1) {
				fullcode_switch_out(to_env_ptr, cms);
				return;
			}
		} else if (S_state) {		/* adjust array pointer */
		    /* new luc */
		    euc_length = strlen((char *)(CURRENT_FOCUS_PTR)->EUC_code);

		    if ( root_window && euc_length > 2 ) {
			int	phr_max_cans = (Maximum_Cans * 2)/euc_length;

			if ( length_collision > phr_max_cans ) {
				length_collision -= phr_max_cans;
				select_array +=phr_max_cans;
			}
		    } else {
			if (length_collision > Maximum_Cans) {
				length_collision -= Maximum_Cans;
				select_array += Maximum_Cans;
			}
		    }
		} else if (FOCUS_CONVERT) {
			if ((CURRENT_FOCUS_PTR)->cookie != -1) {
				cookie_tmp = dict_find_next(
					       (CURRENT_FOCUS_PTR)->py_string,
						  (CURRENT_FOCUS_PTR)->cookie,
					       (CURRENT_FOCUS_PTR)->EUC_code);
				(CURRENT_FOCUS_PTR)->cookie = cookie_tmp;
			}
		}
		if (S_state && head_array) {
			euc_length = strlen((char *)(CURRENT_FOCUS_PTR)->EUC_code);
			select_count = copy_select(select_array,
						   euc_collision,
						   euc_length,
						   length_collision);
			send_interm_select(euc_collision,
					   select_count,
					   to_env_ptr, cms);
		} else {
			send_interm(to_env_ptr, cms);
		}
	} else if (in_c == FULL_CTL_P) {		/* PREV_CHOICE key */
		if (exter_code_count == 0) {
			send_NOP(to_env_ptr);
			return;
		}
		if (full_code_on == 0) {
			full_code_on = 1;
			if(create_dic_list(cms) == -1) {
				fullcode_switch_out(to_env_ptr, cms);
				return;
			}
		} else if (S_state) {
			if (select_array != head_array) {
			    /* new luc */
			    euc_length =
				strlen((char *)(CURRENT_FOCUS_PTR)->EUC_code);

			    if ( root_window && euc_length > 2 ) {
				int	phr_max_cans =
						(Maximum_Cans * 2)/euc_length;

				length_collision += phr_max_cans;
				select_array -= phr_max_cans;
			    } else {
				length_collision += Maximum_Cans;
				select_array -= Maximum_Cans;
			    }
			}
		} else if (FOCUS_CONVERT) {
			if ((CURRENT_FOCUS_PTR)->cookie != -1) {
				cookie_tmp = dict_find_prev(
					       (CURRENT_FOCUS_PTR)->py_string,
						  (CURRENT_FOCUS_PTR)->cookie,
					       (CURRENT_FOCUS_PTR)->EUC_code);
				(CURRENT_FOCUS_PTR)->cookie = cookie_tmp;
			};
		}
		if (S_state && head_array) {
			euc_length = strlen((char *)(CURRENT_FOCUS_PTR)->EUC_code);
			select_count = copy_select(select_array,
						   euc_collision,
						   euc_length,
						   length_collision);
			send_interm_select(euc_collision,
					   select_count,
					   to_env_ptr, cms);
		} else {
			send_interm(to_env_ptr, cms);
		}
	} else if (in_c == FULL_CTL_K) {
		if (exter_code_count == 0) {
			send_NOP(to_env_ptr);
			return;
		}
		if (full_code_on) {
			full_code_on = 0;
			send_commit(to_env_ptr, 0, cms);
			free_dic(DTOC_HEAD);
		} else {
			commit_inbuf(DISP_BUF, to_env_ptr);
		}
		exter_code_count = 0;
		DISP_BUF[exter_code_count] = 0;
	} else if (in_c == FULL_CTL_W) {
		/* Display the list of conversion condidates */
		if (exter_code_count == 0) {
			send_NOP(to_env_ptr);
			return;
		} else if (full_code_on == 0) {
			length_collision = 0;
			full_code_on = 1;
			if (create_dic_list(cms) == -1) {
				fullcode_switch_out(to_env_ptr, cms);
				return;
			}
		}
		S_state = 1;
		select_array = dict_find_all(
					     (CURRENT_FOCUS_PTR)->py_string,
					     &length_collision);
		euc_length = strlen((char *)(CURRENT_FOCUS_PTR)->py_string);
		euc_length = (int)(euc_length / 3) * 2;
		if (select_array == (e_char **) 0)	/* no */
			length_collision = 0;
		head_array = select_array;
		if (length_collision > 1) {
			S_ncandidate = 0;
			select_count = copy_select(
						select_array, /* From DIC */
						euc_collision, /* Send to ENV */
						euc_length,
						length_collision);
			send_interm_select(euc_collision,
					   select_count,
					   to_env_ptr, cms);
		} else {
			send_interm_reset_select(to_env_ptr, cms);
		}
	} else if ((in_c == FULL_CTL_F) || (in_c == FULL_CTL_B)) {
		/* Move focus forward and focus backward */
		if (full_code_on == 0) {
			send_NOP(to_env_ptr);
		} else {
		    if (in_c == FULL_CTL_F)
			cmscreen[cms]->focus_ptr =
					(char *)(CURRENT_FOCUS_PTR)->dtoc_next;
		    else
			cmscreen[cms]->focus_ptr =
					(char *)(CURRENT_FOCUS_PTR)->dtoc_prev;
		    send_interm(to_env_ptr, cms);
		}
		/* Change the focus area of the Intermediate Region  */
		/* Limit for a Chinese char  */
	} else if (in_c == FULL_CTL_U) {
		if (full_code_on == 0 || S_state) {
			send_NOP(to_env_ptr);
			return;
		}
		/* length of the external input string */
		euc_length = strlen((char *)(CURRENT_FOCUS_PTR)->py_string);
		if (((CURRENT_FOCUS_PTR)->conversion_on == 0) ||
		    				(euc_length <= 3)) {
			send_NOP(to_env_ptr);
		} else {
			if (shorter_focus(cms) == -1)
				send_NOP(to_env_ptr);
			else
				send_interm(to_env_ptr, cms);
		}
		/* Extend for a Chinese character */
	} else if (in_c == FULL_CTL_I) {
		if (full_code_on == 0 || S_state) {
			send_NOP(to_env_ptr);
			return;
		}

		euc_length = strlen(
			(char *)(CURRENT_FOCUS_PTR)->dtoc_next->py_string);
		if ( (euc_length < 3) ||
		    ((CURRENT_FOCUS_PTR)->conversion_on == 0) ||
		    ((CURRENT_FOCUS_PTR)->dtoc_next ==
					(struct dic_to_cm *)DTOC_HEAD)) {
			send_NOP(to_env_ptr);
		} else {
			longer_focus(cms);
			send_interm(to_env_ptr, cms);
		}

		/* Delete a character while input */
	} else if ((in_c == FULL_CTL_H) || (in_c == 0x7f)) {
		/* not Converted and have interm thing */
		if (exter_code_count && (full_code_on == 0)) {
			exter_code_count--;
			DISP_BUF[exter_code_count] = 0;
			DISP_ATTR[exter_code_count] = 0;
			to_env_ptr->ce_operation = ENV_INTERM;
			to_env_ptr->ce_cursor_type = -1;
			to_env_ptr->ce_cursor = strlen((char *)DISP_BUF);
			to_env_ptr->ce_text = DISP_BUF;
			to_env_ptr->ce_text_attr = DISP_ATTR;
			to_env_ptr->ce_v_pos = strlen((char *)DISP_BUF);
			to_env_ptr->ce_v_type = POS_END;
			to_env_ptr->ce_next = (struct cm_to_env *) NULL;
		} else if (exter_code_count == 0) {
			commit_string[0] = (in_c == FULL_CTL_H)?FULL_CTL_H:0x7f;
			commit_string[1] = 0;
			to_env_ptr->ce_operation = ENV_COMMIT;
			to_env_ptr->ce_string = commit_string;
			to_env_ptr->ce_size = 1;
			to_env_ptr->ce_next = (struct cm_to_env *) NULL;
		} else if (exter_code_count && full_code_on) {
			if (S_state) {
				send_NOP(to_env_ptr);
				return;
			}
			/* Committing , when have converted */
			send_commit(to_env_ptr, in_c, cms);
			reset_interm_select(to_env_ptr);
			full_code_on = 0;
			exter_code_count = 0;
		}
	} else {
		if (is_not_a_z(in_c) && S_state == 0) {
			commit_not_a_z(in_c, to_env_ptr, cms);
			/* Must reset below variables */
			full_code_on = 0;
			S_state = 0;
			exter_code_count = 0;
			DISP_BUF[exter_code_count] = 0;
			return;
		}
		if (full_code_on == 0) {
			full_code_on = 0;
			DISP_BUF[exter_code_count] = in_c;
			DISP_ATTR[exter_code_count++] = ATTR_REVERSE;
			DISP_BUF[exter_code_count] = 0;
			to_env_ptr->ce_operation = ENV_INTERM;
			to_env_ptr->ce_cursor_type = -1;
			to_env_ptr->ce_cursor = strlen((char *)DISP_BUF);
			to_env_ptr->ce_text = DISP_BUF;
			to_env_ptr->ce_text_attr = DISP_ATTR;
			to_env_ptr->ce_v_pos = strlen((char *)DISP_BUF);
			to_env_ptr->ce_v_type = POS_END;
			to_env_ptr->ce_next = (struct cm_to_env *) NULL;
		} else if ((S_state == 0) && (full_code_on)) {
			tp = send_commit(to_env_ptr, 0, cms);
			full_code_on = 0;
			S_state = 0;
			exter_code_count = 0;
			DISP_BUF[exter_code_count] = in_c;
			DISP_ATTR[exter_code_count++] = ATTR_REVERSE;
			DISP_BUF[exter_code_count] = 0;
			DISP_ATTR[exter_code_count] = 0;
			tp = alloc_env(tp);
			tp->ce_operation = ENV_INTERM;
			tp->ce_cursor_type = -1;
			tp->ce_cursor = 1;
			tp->ce_text = DISP_BUF;
			tp->ce_text_attr = DISP_ATTR;
			tp->ce_v_pos = 1;
			tp->ce_v_type = POS_END;
			tp->ce_next = (struct cm_to_env *) NULL;
		} else if (S_state) {
			if (process_S_state(in_c, cms)) {
				send_interm_reset_select(to_env_ptr, cms);
				S_state = 0;
/*
				free_select(S_candidate, &S_ncandidate);
*/
			} else {
				send_NOP(to_env_ptr);
			}
		}
	}
}

/*
 *	Create a dictionry list( dic_to_cm ) according to INBUf
 * 	input string. As the result, the double link list be created which
 *	entry is a dic_to_cm structure, and DTOC_HEAD pointer 
	points the head of the double link list. create_dic_list() call
 *	create_tail_list() to actually create the list.
 */
int
create_dic_list(cms)
Cm_session cms;
{

	/* Allocating the head structure of the double link list */
	cmscreen[cms]->dic_head = (char *)alloc_dic();
	if ( cmscreen[cms]->dic_head == NULL )
		return(-1);

	/* initial the head structure */
	(DTOC_HEAD)->py_string = DISP_BUF;
	(DTOC_HEAD)->buf_flag = -1;
	(DTOC_HEAD)->py_strlen = strlen((char *)DISP_BUF);
	(DTOC_HEAD)->EUC_code[0] = 0;
	(DTOC_HEAD)->cookie = -1;
	(DTOC_HEAD)->conversion_on = 0;	/* no conversion */

	/* linking double list */
	(DTOC_HEAD)->dtoc_next = (struct dic_to_cm *)DTOC_HEAD;
	(DTOC_HEAD)->dtoc_prev = (struct dic_to_cm *)DTOC_HEAD;
	cmscreen[cms]->focus_ptr  = (char *)DTOC_HEAD;

	/* main loop for created double link list */
	do {	
		if (create_tail_list(cms) == -1) 
			return(-1);
		cmscreen[cms]->focus_ptr = (char *)(CURRENT_FOCUS_PTR)->dtoc_next;
	} while ((CURRENT_FOCUS_PTR) != (struct dic_to_cm *)DTOC_HEAD);
	/* 
	 *  DTOC_HEAD and (CURRENT_FOCUS_PTR) all point to the head
	 *  structure of the double link list
	 */
	return(0);
}

/*
 *		It  convert a input pinyin string into EUC string and
 *	allocate a dic_to_cm structure, then it adjust the double link
 *	list pointer. The input pinyin string is a  component in the
 *	(CURRENT_FOCUS_PTR) pointer. 
 */
int
create_tail_list(cms)
Cm_session cms;
{
	int		cookie_tmp, len_tmp, length;
	e_char          *py_tmp;
	struct dic_to_cm *ptr_tmp;

	len_tmp = strlen((char *)(CURRENT_FOCUS_PTR)->py_string);
	if (len_tmp < 3) {
		(CURRENT_FOCUS_PTR)->conversion_on = CONVERT_MODE;
		(CURRENT_FOCUS_PTR)->cookie = -1;
		return 0;
	}

	py_tmp = (CURRENT_FOCUS_PTR)->py_string;

	cookie_tmp = dict_match_longest(py_tmp,
					&length, 
					(CURRENT_FOCUS_PTR)->EUC_code);
	if (cookie_tmp == -1)
		length = 3;

	(CURRENT_FOCUS_PTR)->py_string = (CURRENT_FOCUS_PTR)->key_code;
	strncpy((char *)(CURRENT_FOCUS_PTR)->py_string, (char *)py_tmp, length);
	(CURRENT_FOCUS_PTR)->py_string[length] = 0;
	(CURRENT_FOCUS_PTR)->py_strlen = length;

	len_tmp -= length;
	if (len_tmp == 0) {	/* just matching completely */
		(CURRENT_FOCUS_PTR)->conversion_on = CONVERT_MODE;
		(CURRENT_FOCUS_PTR)->cookie = cookie_tmp;
		return 0;
	}

	memccpy(py_tmp, py_tmp + length, 0, len_tmp);
	py_tmp[len_tmp] = 0;

	/* adjusting (CURRENT_FOCUS_PTR) structure value */
	(CURRENT_FOCUS_PTR)->conversion_on = CONVERT_MODE; 
	(CURRENT_FOCUS_PTR)->cookie = cookie_tmp;

	/* processing the rest string which not be converted */
	ptr_tmp = alloc_dic();
	if ( ptr_tmp == NULL )
		return(-1);

	ptr_tmp->py_string = py_tmp;
	ptr_tmp->EUC_code[0] = 0;
	ptr_tmp->conversion_on = 0;

	/* Adjusting link pointers */
	ptr_tmp->dtoc_prev = (struct dic_to_cm *)CURRENT_FOCUS_PTR;
	ptr_tmp->dtoc_next = (struct dic_to_cm *)(CURRENT_FOCUS_PTR)->dtoc_next;
	(CURRENT_FOCUS_PTR)->dtoc_next->dtoc_prev = ptr_tmp;
	(CURRENT_FOCUS_PTR)->dtoc_next = ptr_tmp;

	return 0;
}


/*
 *		composing a ENV_INTERM operation according the current
 *	dic_to_cm list, then send to ENV by CM.
 */
void
send_interm(to_env_ptr, cms)
struct cm_to_env *to_env_ptr;
Cm_session cms;
{
	u_char          attr, *euc_code;
	int             attr_offset, len_seg;
	struct dic_to_cm *ptr_tmp;

	ptr_tmp = (struct dic_to_cm *)DTOC_HEAD;
	commit_string[0] = 0;
	attr_offset = len_seg = 0;
	do {
		if (ptr_tmp->cookie == -1)
			euc_code = ptr_tmp->py_string;
		else
			euc_code = ptr_tmp->EUC_code;
		strcat((char *)commit_string, (char *)euc_code);
		len_seg = strlen((char *)euc_code);
		if (ptr_tmp == CURRENT_FOCUS_PTR)
			attr = ATTR_REVERSE;
		else
			attr = 0;	/* underline */
		while (len_seg--)
			DISP_ATTR[attr_offset++] = attr;
		ptr_tmp = ptr_tmp->dtoc_next;
	} while (ptr_tmp != (struct dic_to_cm *)DTOC_HEAD);

	to_env_ptr->ce_operation = ENV_INTERM;
	to_env_ptr->ce_cursor_type = -1;
	to_env_ptr->ce_cursor = strlen((char *)commit_string);
	to_env_ptr->ce_text = commit_string;
	to_env_ptr->ce_text_attr = DISP_ATTR;
	to_env_ptr->ce_v_pos = strlen((char *)commit_string);
	to_env_ptr->ce_v_type = POS_END;
	to_env_ptr->ce_next = (struct cm_to_env *) NULL;
}

/*
 *	composing a ENV_INTERM and ENV_SELECT operations according 
 *	the current dic_to_cm list, then send to ENV by CM.
 */
void
send_interm_select(array_ptr, len, to_env_ptr, cms)
e_char         *array_ptr[];
int             len;
struct cm_to_env *to_env_ptr;
Cm_session	cms;
{
	struct cm_to_env *tp;

	send_interm(to_env_ptr, cms);/* Just processing INTERM REGION */
	tp = alloc_env(to_env_ptr);
	S_state = 1;
	tp->ce_operation = ENV_SELECT;
	tp->ce_candidate = array_ptr;
	tp->ce_nextexist = NULL;
	tp->ce_prevexist = NULL;
	tp->ce_next = (struct cm_to_env *) NULL;
	tp->ce_ncandidate = len;
	S_candidate = array_ptr;
	S_ncandidate = tp->ce_ncandidate;
	return;
}

/*
 *	composing a ENV_INTERM and ENV_SELECT_RESET  operations 
 *	according the current dic_to_cm list, then send to ENV by CM.
 */
void
send_interm_reset_select(to_env_ptr, cms)
struct cm_to_env *to_env_ptr;
Cm_session cms;
{
	struct cm_to_env *tp;

	send_interm(to_env_ptr, cms);
	tp = alloc_env(to_env_ptr);
	S_state = 0;
	tp->ce_operation = ENV_SELECT_END;
	tp->ce_next = (struct cm_to_env *) NULL;
}

void
send_NOP(to_env_ptr)
	struct cm_to_env *to_env_ptr;
{
	to_env_ptr->ce_operation = ENV_NOP;
	to_env_ptr->ce_next = (struct cm_to_env *) NULL;
}

/*
 *		CM will send a string to ENV. As the result, The string
 *	will be sent to the AP by ENV.
 */
struct cm_to_env *
send_commit(to_env_ptr, del, cms)
	struct cm_to_env *to_env_ptr;
	int             del;	/* del =={0, 0x7f, others} */
	Cm_session	cms;
{
	int             leng;
	e_char         *euc_code;
	struct dic_to_cm *ptr_tmp;
	struct cm_to_env *tp;

	ptr_tmp = (struct dic_to_cm *)DTOC_HEAD;
	leng = 0;
	commit_string[0] = 0;
	do {
		if (ptr_tmp->cookie == -1)
			euc_code = ptr_tmp->py_string;
		else
			euc_code = ptr_tmp->EUC_code;
		strcat((char *)commit_string, (char *)euc_code);
		ptr_tmp = ptr_tmp->dtoc_next;
	} while (ptr_tmp != (struct dic_to_cm *)DTOC_HEAD);

	leng = strlen((char *)commit_string);
	if (del == 0x7f) {
		if (commit_string[leng - 1] & 0x80) {
			leng -= 2;
			commit_string[leng] = 0;
		} else {
			leng--;
			commit_string[leng] = 0;
		}
	} else if (del) {
		commit_string[leng++] = del;
		commit_string[leng] = 0;
	}

	to_env_ptr->ce_operation = ENV_INTERM_RESET;
	tp = alloc_env(to_env_ptr);

	if ( commit_string[leng - 1] == 0x0d ) {
		leng --;
		commit_string[leng] = 0;

		tp->ce_operation = ENV_COMMIT;
		tp->ce_string = commit_string;
		tp->ce_size = leng;
		tp = alloc_env(tp);

		second_commit[0] = 0x0d;
		tp->ce_operation = ENV_COMMIT; 
		tp->ce_string = second_commit;
		tp->ce_size = 1;
	} else {
		tp->ce_operation = ENV_COMMIT;
		tp->ce_string = commit_string;
		tp->ce_size = leng;
	}

	tp = alloc_env(tp);
	if ( S_state )
		tp->ce_operation = ENV_SELECT_END;
	else
		tp->ce_operation = ENV_NOP;
	tp->ce_next = (struct cm_to_env *) NULL;;

	full_code_on = exter_code_count = S_state = 0;
	return tp;
}

/*
 *	It is similar as send_commit, but CM will send the DISP_BUF string.
 */ 
struct cm_to_env *
commit_inbuf(str, env_ptr)
	e_char         *str;
	struct cm_to_env *env_ptr;
{
	int             leng;
	struct cm_to_env *tp;

	commit_string[0] = 0;
	strcpy((char *)commit_string, (char *)str);
	leng = strlen((char *)commit_string);

	env_ptr->ce_operation = ENV_INTERM_RESET;
	tp = alloc_env(env_ptr);

	if ( commit_string[leng - 1] == 0x0d ) {
		leng --;
		commit_string[leng] = 0;

		tp->ce_operation = ENV_COMMIT;
		tp->ce_string = commit_string;
		tp->ce_size = leng;

		tp = alloc_env(tp);
		second_commit[0] = 0x0d;
		tp->ce_operation = ENV_COMMIT; 
		tp->ce_string = second_commit;
		tp->ce_size = 1;
		tp->ce_next = (struct cm_to_env *) NULL;
	} else {
		tp->ce_operation = ENV_COMMIT;
		tp->ce_string = commit_string;
		tp->ce_size = leng;
		tp->ce_next = (struct cm_to_env *) NULL;
	}

	str[0] = 0;
	return tp;
}

/*
 *		Send a new string to ENV.		
 */
send_commit_return(env_ptr, in_c, cms)
	struct cm_to_env *env_ptr;
	int             in_c;
	Cm_session	cms;
{
	e_char          cc;
	int             leng;
	cc = (e_char) in_c;
	leng = 0;
	if (exter_code_count)
		leng = strlen((char *)DISP_BUF);
	DISP_BUF[leng++] = cc;
	DISP_BUF[leng] = 0;
	commit_inbuf(DISP_BUF, env_ptr);
}

/*
 *	Committing a string to ENV when CM receive a input strokekey
 *	which is not a full code input key.( NOT in [a-z,A-Z] )
 */
commit_not_a_z(in_char, env_ptr, cms)
	int             in_char;
	struct cm_to_env *env_ptr;
	Cm_session      cms;
{
	if (full_code_on && exter_code_count) {
		(void) send_commit(env_ptr, in_char, cms);
		free_dic(DTOC_HEAD);
	} else {
		send_commit_return(env_ptr, in_char, cms);
	}
}

is_not_a_z(ccc)
	e_char          ccc;
{
	if (((ccc >= 'A') && (ccc <= 'Z')) ||
	    ((ccc >= 'a') && (ccc <= 'z')) ||
	    (ccc == '[')) {
		return (0);
	} else {
		return (1);
	}
}

/*
 *	Processing candidate state.
 */
process_S_state(int_c, cms)
	int             int_c;
	Cm_session	cms;
{
	u_int           cookie_tmp, number;
	register struct dic_to_cm *ptr_tmp;

	ptr_tmp = (struct dic_to_cm *)CURRENT_FOCUS_PTR;

	int_c &= 0x7f;
	if ( luc_label_type == LUC_LABEL_NUMERIC ) {
		number = (int_c == 0x30) ? 9 : (int_c - 0x31);
	} else
		number = int_c - 0x41;	/* Upper case */

	if (is_select_rang(number, cms)) {
		strcpy((char *)ptr_tmp->EUC_code, (char *)S_candidate[number]);
		cookie_tmp = dict_get_cookie(ptr_tmp->py_string,
					     ptr_tmp->EUC_code);
		ptr_tmp->cookie = cookie_tmp;
		return (1);
	} else {
		return (0);
	}
}

/*
 * Input parameter:
 *		num is a number for candidate.
 * Output parameter:
 *		1 if true, else 0;
 */
is_select_rang(num, cms)
	int             num;
	Cm_session	cms;
{
	if ((num >= 0) && (num < S_ncandidate)) {
		return (1);
	} else {
		return (0);
	}
}



/*
 * alloc_dic:
 * 	Alollocating a dic_to_cm structure space.
 * Return:
 *	a pointer to dic_to_cm structure.
 */
struct dic_to_cm *
alloc_dic()
{
	struct dic_to_cm	*ptr;

	ptr = (struct dic_to_cm *)malloc(sizeof(struct dic_to_cm) + 1);
	if (ptr == NULL) {
		perror("Can not allocate memory for phrase dictionary.");
		return(NULL);
	}
	ptr->py_string = ptr->key_code;
	ptr->buf_flag = 0;
	ptr->EUC_code[0] = 0;
	return ((struct dic_to_cm *) ptr);
}

/*
 *	Deallocating a dic_to_cm structure.
 */
void
free_dic(ptr)
	struct dic_to_cm *ptr;
{
	register struct dic_to_cm *ptr_tmp;
	e_char         *str;

	ptr_tmp = ptr;
	do {
		if ( ptr_tmp->buf_flag > 0 )
			free(ptr_tmp->py_string);
		str = (e_char *) ptr_tmp;
		ptr_tmp = ptr_tmp->dtoc_next;
		free(str);
	} while (ptr_tmp != ptr);
	ptr = (struct dic_to_cm *) NULL;
}

/*
 *	Reset Interm_region and Select_region.
 */
void
reset_interm_select(prev_ptr)
	struct cm_to_env *prev_ptr;
{
	struct cm_to_env *tp;

	tp = alloc_env(prev_ptr);
	tp->ce_operation = ENV_INTERM_RESET;
	tp = alloc_env(tp);
	tp->ce_operation = ENV_SELECT_END;
	tp->ce_next = (struct cm_to_env *) NULL;
}

/*
 *	Copy candidate array str1 string which is  from dic_find_all() 
 *	to str2 which be used by CM.
 * Return :
 *	length is the copied candidate number .
 *	length <= Maximum_Cans.
 */
copy_select(str1, str2, leng1, leng2)
	e_char        **str1;	/* From dic_find_all */
	e_char        **str2;	/* to ENV */
	u_int           leng1;	/* length of EUC string */
	int             leng2;	/* length of collision */
{
	e_char         *euc_str;
	register int    length, length2;

/*
	free_select(S_candidate, &S_ncandidate);
*/

    /* new luc */
    if ( root_window ) {
	int	phr_max_cans = (Maximum_Cans * 2)/leng1;

	if (leng2 > phr_max_cans)
		length2 = phr_max_cans;
	else
		length2 = leng2;
    } else {
	if (leng2 > Maximum_Cans)
		length2 = Maximum_Cans;
	else
		length2 = leng2;
    }

	for (length = 0; length < length2; length++) {
		euc_str = (e_char *) my_malloc(leng1 + 1);
		strncpy((char *)euc_str, (char *)str1[length], leng1);
		euc_str[leng1] = NULL;
		str2[length] = euc_str;
	}
	return (length);
}

/*
 *	Shortens the focus area to the right by one Chinese character.
 */
int
shorter_focus(cms)
Cm_session	cms;
{
	struct dic_to_cm *ptr_tmp;
	u_int           py_length;

	ptr_tmp = alloc_dic();
	if (ptr_tmp == NULL)
		return(-1);

	py_length = strlen((char *)(CURRENT_FOCUS_PTR)->py_string);
	memccpy((char *)ptr_tmp->py_string,
		(char *)(CURRENT_FOCUS_PTR)->py_string + py_length - 3,
		0, 3);
	ptr_tmp->py_string[3] = 0;
	ptr_tmp->py_strlen = 3;

	ptr_tmp->cookie = dict_find_new(ptr_tmp->py_string, ptr_tmp->EUC_code);
	ptr_tmp->conversion_on = CONVERT_MODE;

	/* adjust link pointers */
	ptr_tmp->dtoc_next = (struct dic_to_cm *)(CURRENT_FOCUS_PTR)->dtoc_next;
	ptr_tmp->dtoc_prev = (struct dic_to_cm *)CURRENT_FOCUS_PTR;
	ptr_tmp->dtoc_next->dtoc_prev = ptr_tmp;
	(CURRENT_FOCUS_PTR)->dtoc_next = ptr_tmp;

	(CURRENT_FOCUS_PTR)->py_string[py_length - 3] = 0;
	(CURRENT_FOCUS_PTR)->py_strlen -= 3;

	(CURRENT_FOCUS_PTR)->cookie = dict_find_new(
		(CURRENT_FOCUS_PTR)->py_string, (CURRENT_FOCUS_PTR)->EUC_code);
	return(0);
}

/*
 *	Lengthens the focus area to right by one Chinese character.
 */
longer_focus(cms)
Cm_session cms;
{
	struct dic_to_cm *ptr_next;
	e_char         *str;
	u_int           current_py_len, next_py_len;

	ptr_next = (struct dic_to_cm *)(CURRENT_FOCUS_PTR)->dtoc_next;
	next_py_len = strlen((char *)ptr_next->py_string);
	current_py_len = strlen((char *)(CURRENT_FOCUS_PTR)->py_string);
	current_py_len += 3;

	/* Getting pinyin string */
	if ( current_py_len > MAX_KEY_LEN ) {
		str = (e_char *)my_malloc(current_py_len + 1);
		strcpy((char *)str, (char *)(CURRENT_FOCUS_PTR)->py_string);
		if ( (CURRENT_FOCUS_PTR)->buf_flag > MAX_KEY_LEN )
			free((CURRENT_FOCUS_PTR)->py_string);
		(CURRENT_FOCUS_PTR)->py_string = str;
		(CURRENT_FOCUS_PTR)->buf_flag = current_py_len + 1;
	} else {
		str = (CURRENT_FOCUS_PTR)->py_string;
	}

	strncat((char *)str, (char *)ptr_next->py_string, 3);
	str[current_py_len] = 0;
	(CURRENT_FOCUS_PTR)->py_strlen = current_py_len;

	/* Getting the EUC code string by the pinyin */
	(CURRENT_FOCUS_PTR)->EUC_code[0] = 0;
	(CURRENT_FOCUS_PTR)->cookie = dict_find_new(str,
						(CURRENT_FOCUS_PTR)->EUC_code);

	if (next_py_len == 3) {
		ptr_next->dtoc_next->dtoc_prev = CURRENT_FOCUS_PTR;
		(CURRENT_FOCUS_PTR)->dtoc_next = ptr_next->dtoc_next;
		if ( ptr_next->buf_flag > MAX_KEY_LEN )
			free(ptr_next->py_string);
		free(ptr_next);
	} else {
		memccpy(ptr_next->py_string, ptr_next->py_string + 3,
							0, next_py_len - 3);
		ptr_next->py_string[next_py_len - 3] = 0;
		ptr_next->py_strlen = next_py_len - 3;
		ptr_next->EUC_code[0] = 0;
		ptr_next->cookie = dict_find_new(ptr_next->py_string,
							ptr_next->EUC_code);
	}
}


/*
 *	Free selection area space.
 */
/*
void
free_select(select_str, select_count)
	e_char        **select_str;
	u_int          *select_count;
{
	register u_int  cc;
	cc = *select_count;
	while (cc--) {
		free(select_str[cc]);
	}
	select_count = 0;
}
*/

/*
 * Called when CM_RESET - commit preedit, clear status, and turn off conv.
 * CM_RESET is used in MOWN V3, in XmbResetIC().
 */
struct cm_to_env *
fullcode_CM_RESET(to_env_ptr, cms)
register struct cm_to_env *to_env_ptr;
Cm_session	cms;
{
	struct cm_to_env *tp;

	if (exter_code_count != 0) {
		if (full_code_on) {
			full_code_on = 0;
			tp = send_commit(to_env_ptr, 0, cms);
			free_dic(DTOC_HEAD);
		} else {
			tp = commit_inbuf(DISP_BUF, to_env_ptr);
		}
		tp = alloc_env(tp);

		exter_code_count = 0;
		DISP_BUF[exter_code_count] = 0;
	} else {
		tp = to_env_ptr;
	}

	tp->ce_operation = ENV_SET_SIMPLE_MODE;
	tp->ce_string = (e_char *) CMOFF_STRING;
	tp = alloc_env(tp);
	tp->ce_operation = ENV_CM_OFF;
	tp->ce_next = (struct cm_to_env *) NULL;
	return tp;
}

/*
 * Called when switch out - commit preedit, clear up.
 */
struct cm_to_env *
fullcode_switch_out(to_env_ptr, cms)
register struct cm_to_env *to_env_ptr;
Cm_session	cms;
{
	struct cm_to_env *tp;

        if (exter_code_count != 0) {
                if (full_code_on) {
                        full_code_on = 0;
                        tp = send_commit(to_env_ptr, 0, cms);
                        free_dic(DTOC_HEAD);
                } else {
                        tp = commit_inbuf(DISP_BUF, to_env_ptr);
                }
		tp = alloc_env(tp);

                exter_code_count = 0;
                DISP_BUF[exter_code_count] = 0;
        } else {
                to_env_ptr->ce_operation = ENV_NOP;
                tp = alloc_env(to_env_ptr);
        }

	return tp;
}
