/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
static char     sccsid[] = "@(#)dictionary.c	1.2 00/08/19";
#endif

/*
 * dictionary funcions for INTELLEGENT INPUT METHOD include map_dic(),
 * dict_find_new(), dict_find_next(), dict_find_pre(), dict_find_all(),
 * dict_find_longest() and dict_find_cookie()
 */

#include <stdio.h>
#include <sys/types.h>
#include "dictionary.h"
#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>

#define  	FILE_PATH_LEN	512
#define		PY_LEN		3	/* number of bytes in a pinyin */
#define		EUC_LEN		2
#define		PY_COUNT	6
#define         LEN_LIST        512
#define         EUC_STR_LEN     12
#define         PY_STR_LEN      18


static struct sub_header *header[6];
static struct s_dic   *s_dic;
static struct p2_dic  *p2_dic;
static struct p3_dic  *p3_dic;
static struct p4_dic  *p4_dic;
static struct p5_dic  *p5_dic;
static struct p6_dic  *p6_dic;
static struct s_dic_abbr *s_dic_abbr;
static struct p2_dic_abbr *p2_dic_abbr;
static struct p3_dic_abbr *p3_dic_abbr;
static struct p4_dic_abbr *p4_dic_abbr;
static struct p5_dic_abbr *p5_dic_abbr;
static struct p6_dic_abbr *p6_dic_abbr;

char           *mmap_addr;
extern u_char  *get_cle_path();

/*
 * hash function algorithm ???
 */
static int
hashf(str, length)
	char *str;
	int length;
{
	int len,val=0,i, hashv;
	char *p;

	p = str;
	if((len =length) <5)
		for ( i =0; i< len; i++) val = (val << 8) + *p++;
	else {
		for ( i =0; i<4; i++) val = (val << 8) + *p++;
		for ( i =5; i<len; i++) val += *p++<<i;	
	}
	hashv = HASH(val, PRIME_NUM);
	return(hashv);
}	

/*
 * map_dic(): maps the phrase dictionary file PHRASE_DIC into the memory. It
 * returns the char pointer which is returned by mmap() if call successes,
 * else returns NULL.
 */
char           *
map_dic(start_mmap)
	caddr_t         start_mmap;
{
	int             fp;
	caddr_t         p;
	register char  *addr;
	register int    len;
	struct stat     buf;
	off_t           flen;
	int            *ip, i;
	u_char         *dic_file = (u_char *) "/phrase_dic";
	u_char         *dic_path;
	u_char		path_name[FILE_PATH_LEN];

	dic_path = get_cle_path();	/* get environment variable CLE_PATH */
	strcpy(path_name, dic_path);
	strcat(path_name, dic_file);
	fp = open((char *)path_name, O_RDONLY);
	if (fp < 0) {
		printf("Can't open the file phrase_dic \n");
		return (NULL);
	}

	if (fstat(fp, &buf) < 0) {
		printf("Geting file length failed!\n");
		return (NULL);
	}
	flen = buf.st_size;
	if (flen <= 0) {
		printf("Zero length dictionay file.\n");
		return (NULL);
	}
	/* mmap the dictionary file */

	p = mmap(start_mmap, flen, PROT_READ, MAP_SHARED, fp, (off_t) 0);
	if ( (int)p == -1 ) {
		printf("mmap failed.\n");
		return (NULL);
	}
	mmap_addr = p;
	ip = (int *) p;
	for (i = 0; i < 6; i++)
		header[i] = (struct sub_header *) (p + ip[i]);
	len = sizeof(struct sub_header);

	/* first sub_header starting address */
	addr = (char *) header[0] + len;
	s_dic = (struct s_dic *) addr;
	addr += (header[0]->table_len) * sizeof(struct s_dic);
	s_dic_abbr = (struct s_dic_abbr *) addr;

	/* second sub_header starting address */
	addr = (char *) header[1] + len;
	p2_dic = (struct p2_dic *) addr;
	addr += (header[1]->table_len) * sizeof(struct p2_dic);
	p2_dic_abbr = (struct p2_dic_abbr *) addr;

	/* third sub_header starting address */
	addr = (char *) header[2] + len;
	p3_dic = (struct p3_dic *) addr;
	addr += (header[2]->table_len) * sizeof(struct p3_dic);
	p3_dic_abbr = (struct p3_dic_abbr *) addr;

	/* the fourth sub_header starting address */
	addr = (char *) header[3] + len;
	p4_dic = (struct p4_dic *) addr;
	addr += (header[3]->table_len) * sizeof(struct p4_dic);
	p4_dic_abbr = (struct p4_dic_abbr *) addr;

	/* the fifth sub_header starting address */
	addr = (char *) header[4] + len;
	p5_dic = (struct p5_dic *) addr;
	addr += (header[4]->table_len) * sizeof(struct p5_dic);
	p5_dic_abbr = (struct p5_dic_abbr *) addr;

	/* the sixth sub_header starting address */
	addr = (char *) header[5] + len;
	p6_dic = (struct p6_dic *) addr;
	addr += (header[5]->table_len) * sizeof(struct p6_dic);
	p6_dic_abbr = (struct p6_dic_abbr *) addr;

	return (mmap_addr);
}

/*
 * dict_find_new(): find a euc_code string matched by a pinyin string.
 * Returns cookie, the index of the euc_str in a array if successes,  else
 * returns -1. the higher word of the cookie is the position of the first euc
 * string which responds the given pinyin string (has the struct s_dic or
 * pi_dic where pi may be p1, p2, ..., p6i). And the lower word is for
 * current euc string (which has struct s_dic_abbr or pi_dic_abbr if
 * collisions are greater than 1, else it is the same as the higher word. In
 * the previous condition, the highest bit of the lower word is set.). Any
 * cookie in following functions has the same meaning.
 */
u_int
dict_find_new(py_str, euc_code)
	u_char         *py_str;
	u_char         *euc_code;
{
	int             i, j, euc_l;
	u_int           hashv, cookie;
	register u_int  index;
	register int    py_l;
	struct s_dic   *p1;
	struct p2_dic  *p2;
	struct p3_dic  *p3;
	struct p4_dic  *p4;
	struct p5_dic  *p5;
	struct p6_dic  *p6;
	struct s_dic_abbr *p1_abbr;
	struct p2_dic_abbr *p2_abbr;
	struct p3_dic_abbr *p3_abbr;
	struct p4_dic_abbr *p4_abbr;
	struct p5_dic_abbr *p5_abbr;
	struct p6_dic_abbr *p6_abbr;

	j = strlen(py_str) / PY_LEN;
	if (j <= 0)
		return (-1);
	else if (j > PY_COUNT)
		j = PY_COUNT;
	euc_l = j * EUC_LEN;
	py_l = j * PY_LEN;
	hashv = hashf(py_str, py_l);
	if (hashv >= HASH_TSIZE)
		hashv -= HASH_TSIZE;

	index = header[j - 1]->hash_e[hashv];
	if (index == NULL_FLG)
		return (-1);
	switch (j) {

	case 1:
		p1 = &s_dic[index];
		while (i = strncmp(py_str, p1->py_str, py_l))
			/* Pinyin not equal, find next hash chain entry */
			if (p1->flag) {
				/*
				 * flag != 0, next points to dic_abbr chain.
				 * Skip through dic_abbr chain.
				 * The last one in the dic_abbr chain has
				 * flag == 0, next points to dic[] or NULL.
				 */
				p1_abbr = &s_dic_abbr[p1->next];
				while (p1_abbr->flag)
					p1_abbr = &s_dic_abbr[p1_abbr->next];
				if (p1_abbr->next) {
					/* try the next pinyin in hash chain */
					p1 = &s_dic[index = p1_abbr->next];
					continue;
				} else
					break;
			} else 
				/*
				 * No entry in the dic_abbr chain, find
				 * next entry in the hash chain.
				 */
				if (p1->next)
					p1 = &s_dic[index = p1->next];
				else
					break;
		if (i)
			return (-1);
		else
			strncpy(euc_code, p1->euc_code, euc_l);
		break;

	case 2:
		p2 = &p2_dic[index];
		while (i = strncmp(py_str, p2->py_str, py_l)) {
			if (p2->flag) {
				p2_abbr = &p2_dic_abbr[p2->next];
				while (p2_abbr->flag)
					p2_abbr = &p2_dic_abbr[p2_abbr->next];
				if (p2_abbr->next) {
					p2 = &p2_dic[index = p2_abbr->next];
					continue;
				} else
					return (-1);
			}
			if (p2->next)
				p2 = &p2_dic[index = p2->next];
			else
				break;
		}
		if (i)
			return (-1);
		strncpy(euc_code, p2->euc_code, euc_l);
		break;

	case 3:
		p3 = &p3_dic[index];
		while (i = strncmp(py_str, p3->py_str, py_l)) {
			if (p3->flag) {
				p3_abbr = &p3_dic_abbr[p3->next];
				while (p3_abbr->flag)
					p3_abbr = &p3_dic_abbr[p3_abbr->next];
				if (p3_abbr->next) {
					p3 = &p3_dic[index = p3_abbr->next];
					continue;
				} else
					return (-1);
			}
			if (p3->next)
				p3 = &p3_dic[index = p3->next];

			else
				break;
		}
		if (i)
			return (-1);
		strncpy(euc_code, p3->euc_code, euc_l);
		break;

	case 4:
		p4 = &p4_dic[index];
		while (i = strncmp(py_str, p4->py_str, py_l)) {
			if (p4->flag) {
				p4_abbr = &p4_dic_abbr[p4->next];
				while (p4_abbr->flag)
					p4_abbr = &p4_dic_abbr[p4_abbr->next];
				if (p4_abbr->next) {
					p4 = &p4_dic[index = p4_abbr->next];
					continue;
				} else
					return (-1);
			}
			if (p4->next)
				p4 = &p4_dic[index = p4->next];
			else
				break;
		}
		if (i)
			return (-1);
		strncpy(euc_code, p4->euc_code, euc_l);
		break;

	case 5:
		p5 = &p5_dic[index];
		while (i = strncmp(py_str, p5->py_str, py_l)) {
			if (p5->flag) {
				p5_abbr = &p5_dic_abbr[p5->next];
				while (p5_abbr->flag)
					p5_abbr = &p5_dic_abbr[p5_abbr->next];
				if (p5_abbr->next) {
					p5 = &p5_dic[index = p5_abbr->next];
					continue;
				} else
					return (-1);
			}
			if (p5->next) 
				p5 = &p5_dic[index = p5->next];
			else
				break;
		}
		if (i)
			return (-1);
		strncpy(euc_code, p5->euc_code, euc_l);
		break;

	case 6:
		p6 = &p6_dic[index];
		while (i = strncmp(py_str, p6->py_str, py_l)) {
			if (p6->flag) {
				p6_abbr = &p6_dic_abbr[p6->next];
				while (p6_abbr->flag)
					p6_abbr = &p6_dic_abbr[p6_abbr->next];
				if (p6_abbr->next) {
					p6 = &p6_dic[index = p6_abbr->next];
					continue;
				} else
					return (-1);
			}
			if (p6->next) {
				p6 = &p6_dic[index = p6->next];
			} else
				break;
		}
		if (i)
			return (-1);
		strncpy(euc_code, p6->euc_code, euc_l);
		break;
	default:
		return (-1);
	}

	euc_code[euc_l] = NULL;
	index = index & 0x7fff;
	/* what is in the cookie ??? */
	cookie = (index << 16) | (index & 0xffff);
	return (cookie);
}

/*
 * dict_find_next(): finds next euc string responded by cookie and py_string.
 * It returns the index of the new euc string, else -1.
 */

u_int
dict_find_next(py_str, cookie, euc_code)
	u_char           *py_str;
	u_int           cookie;
	u_char         *euc_code;
{
	int             j, euc_l;
	u_int           cookie_new;
	register u_int  index;
	u_char         *euc_str;
	struct s_dic   *p1;
	struct p2_dic  *p2;
	struct p3_dic  *p3;
	struct p4_dic  *p4;
	struct p5_dic  *p5;
	struct p6_dic  *p6;
	struct s_dic_abbr *p1_abbr;
	struct p2_dic_abbr *p2_abbr;
	struct p3_dic_abbr *p3_abbr;
	struct p4_dic_abbr *p4_abbr;
	struct p5_dic_abbr *p5_abbr;
	struct p6_dic_abbr *p6_abbr;

	j = strlen(py_str) / PY_LEN;
	if (j > PY_COUNT)
		j = PY_COUNT;
	euc_l = j * EUC_LEN;
	if (j < 1)
		return (-1);
	index = cookie & 0xffff;

	switch (j) {
	case 1:
		if (!(index & 0x8000)) {
			/* bit 0x8000 is zero, index is to s_dic[] */
			p1 = &s_dic[index];
			if (p1->flag) {
				index = (p1->next) | 0x8000;
				euc_str = s_dic_abbr[p1->next].euc_code;
			} else
				/* dic_abbr not exist, index unchanged */
				euc_str = p1->euc_code;
		} else {
			/* bit 0x8000 is one, index is to dic_abbr[] */
			p1_abbr = &s_dic_abbr[index & 0x7fff];
			if (p1_abbr->flag) {
				index = (p1_abbr->next) | 0x8000;
				euc_str = s_dic_abbr[p1_abbr->next].euc_code;
			} else
				/* go back to the first candidate */
				euc_str = s_dic[index = cookie >> 16].euc_code;
		}
		/*
		 * Here, index will be the lower half-word of the new cookie,
		 * upper half-word is not changed for the new cookie.
		 */
		break;

	case 2:
		if (!(index & 0x8000)) {
			p2 = &p2_dic[index];
			if (p2->flag) {
				index = (p2->next) | 0x8000;
				euc_str = p2_dic_abbr[p2->next].euc_code;
			} else
				euc_str = p2->euc_code;
		} else {
			p2_abbr = &p2_dic_abbr[index & 0x7fff];
			if (p2_abbr->flag) {
				index = (p2_abbr->next) | 0x8000;
				euc_str = p2_dic_abbr[p2_abbr->next].euc_code;
			} else
				euc_str = p2_dic[index = cookie >> 16].euc_code;
		}
		break;
	case 3:
		if (!(index & 0x8000)) {
			p3 = &p3_dic[index];
			if (p3->flag) {
				index = (p3->next) | 0x8000;
				euc_str = p3_dic_abbr[p3->next].euc_code;
			} else
				euc_str = p3->euc_code;
		} else {
			p3_abbr = &p3_dic_abbr[index & 0x7fff];
			if (p3_abbr->flag) {
				index = (p3_abbr->next) | 0x8000;
				euc_str = p3_dic_abbr[p3_abbr->next].euc_code;
			} else
				euc_str = p3_dic[index = cookie >> 16].euc_code;
		}
		break;
	case 4:
		if (!(index & 0x8000)) {
			p4 = &p4_dic[index];
			if (p4->flag) {
				index = (p4->next) | 0x8000;
				euc_str = p4_dic_abbr[p4->next].euc_code;
			} else
				euc_str = p4->euc_code;
		} else {
			p4_abbr = &p4_dic_abbr[index & 0x7fff];
			if (p4_abbr->flag) {
				index = (p4_abbr->next) | 0x8000;
				euc_str = p4_dic_abbr[p4_abbr->next].euc_code;
			} else
				euc_str = p4_dic[index = cookie >> 16].euc_code;
		}
		break;
	case 5:
		if (!(index & 0x8000)) {
			p5 = &p5_dic[index];
			if (p5->flag) {
				index = (p5->next) | 0x8000;
				euc_str = p5_dic_abbr[p5->next].euc_code;
			} else
				euc_str = p5->euc_code;
		} else {
			p5_abbr = &p5_dic_abbr[index & 0x7fff];
			if (p5_abbr->flag) {
				index = (p5_abbr->next) | 0x8000;
				euc_str = p5_dic_abbr[p5_abbr->next].euc_code;
			} else
				euc_str = p5_dic[index = cookie >> 16].euc_code;
		}
		break;
	case 6:
		if (!(index & 0x8000)) {
			p6 = &p6_dic[index];
			if (p6->flag) {
				index = (p6->next) | 0x8000;
				euc_str = p6_dic_abbr[p6->next].euc_code;
			} else
				euc_str = p6->euc_code;
		} else {
			p6_abbr = &p6_dic_abbr[index & 0x7fff];
			if (p6_abbr->flag) {
				index = (p6_abbr->next) | 0x8000;
				euc_str = p6_dic_abbr[p6_abbr->next].euc_code;
			} else
				euc_str = p6_dic[index = cookie >> 16].euc_code;
		}
		break;
	default:
		return (-1);
	}
	cookie_new = (cookie & 0xffff0000) | (index & 0xffff);
	strncpy(euc_code, euc_str, euc_l);
	euc_code[euc_l] = NULL;
	return (cookie_new);
}

/*
 * dict_find_prev(): find the previous euc_str responding for cookie and
 * py_str. It returns new cookie.
 */

u_int
dict_find_prev(py_str, cookie, euc_code)
	u_char           *py_str;
	u_int           cookie;
	u_char         *euc_code;
{
	int             j, euc_l;
	register u_int  index,		/* to dic[] */
			index_abbr;	/* to dic_abbr[] */
	u_int           cookie_new;
	u_char         *euc_str;
	struct s_dic   *p1;
	struct p2_dic  *p2;
	struct p3_dic  *p3;
	struct p4_dic  *p4;
	struct p5_dic  *p5;
	struct p6_dic  *p6;
	struct s_dic_abbr *p1_abbr;
	struct p2_dic_abbr *p2_abbr;
	struct p3_dic_abbr *p3_abbr;
	struct p4_dic_abbr *p4_abbr;
	struct p5_dic_abbr *p5_abbr;
	struct p6_dic_abbr *p6_abbr;

	j = strlen(py_str) / PY_LEN;
	if (j > PY_COUNT)
		j = PY_COUNT;
	euc_l = j * EUC_LEN;

	index_abbr = cookie & 0xffff;
	index = cookie >> 16;

	switch (j) {
	case 1:
		p1 = &s_dic[index];
		if (!(index_abbr & 0x8000))
			/* 0x8000 is not set */
			index_abbr = -1;	/* 1 collision ??? */
		else
			index_abbr &= 0x7fff;
		if (p1->flag && (p1->next != index_abbr)) {
			/*
			 * More than one candidate and cookie does not
			 * point to the second one.
			 * Loop until found cookie or end of dic_abbr chain.
			 * index is used for the prev entry.
			 */
			p1_abbr = &s_dic_abbr[index = p1->next];
			while ((p1_abbr->next != index_abbr) &&
			       (p1_abbr->flag))
				p1_abbr = &s_dic_abbr[index = p1_abbr->next];
			/* p1_abbr->next == index_abbr or p1_abbr->flag == 0 */
			if (p1->flag) {
				/* p1_abbr->next == index_abbr */
				euc_str = p1_abbr->euc_code;
				index |= 0x8000;
				break;
			} else
				/* p1_abbr->flag == 0 */
				index = cookie >> 16;
		}
		euc_str = p1->euc_code;
		break;

	case 2:
		p2 = &p2_dic[index];
		if (!(index_abbr & 0x8000))
			index_abbr = -1;
		else
			index_abbr = index_abbr & 0x7fff;
		if ((p2->next != index_abbr) && p2->flag) {
			p2_abbr = &p2_dic_abbr[index = p2->next];
			while (!(p2_abbr->next == index_abbr) &&
			       (p2_abbr->flag))
				p2_abbr = &p2_dic_abbr[index = p2_abbr->next];
			if (p2->flag) {
				euc_str = p2_abbr->euc_code;
				index |= 0x8000;
				break;
			}
		}
		index = cookie >> 16;
		euc_str = p2->euc_code;
		break;

	case 3:
		p3 = &p3_dic[index];
		if (!(index_abbr & 0x8000))
			index_abbr = -1;
		else
			index_abbr = index_abbr & 0x7fff;
		if ((p3->next != index_abbr) && p3->flag) {
			p3_abbr = &p3_dic_abbr[index = p3->next];
			while (!(p3_abbr->next == index_abbr) &&
			       (p3_abbr->flag))
				p3_abbr = &p3_dic_abbr[index = p3_abbr->next];
			if (p3->flag) {
				euc_str = p3_abbr->euc_code;
				index |= 0x8000;
				break;
			}
		}
		index = cookie >> 16;
		euc_str = p3->euc_code;
		break;

	case 4:
		p4 = &p4_dic[index];
		if (!(index_abbr & 0x8000))
			index_abbr = -1;
		else
			index_abbr = index_abbr & 0x7fff;
		if ((p4->next != index_abbr) && p4->flag) {
			p4_abbr = &p4_dic_abbr[index = p4->next];
			while (!(p4_abbr->next == index_abbr) &&
			       (p4_abbr->flag))
				p4_abbr = &p4_dic_abbr[index = p4_abbr->next];
			if (p4->flag) {
				euc_str = p4_abbr->euc_code;
				index |= 0x8000;
				break;
			}
		}
		index = cookie >> 16;
		euc_str = p4->euc_code;
		break;

	case 5:
		p5 = &p5_dic[index];
		if (!(index_abbr & 0x8000))
			index_abbr = -1;
		else
			index_abbr = index_abbr & 0x7fff;
		if ((p5->next != index_abbr) && p5->flag) {
			p5_abbr = &p5_dic_abbr[index = p5->next];
			while (!(p5_abbr->next == index_abbr) &&
			       (p5_abbr->flag))
				p5_abbr = &p5_dic_abbr[index = p5_abbr->next];
			if (p5->flag) {
				euc_str = p5_abbr->euc_code;
				index |= 0x8000;
				break;
			}
		}
		index = cookie >> 16;
		euc_str = p5->euc_code;
		break;

	case 6:
		p6 = &p6_dic[index];
		if (!(index_abbr & 0x8000))
			index_abbr = -1;
		else
			index_abbr = index_abbr & 0x7fff;
		if ((p6->next != index_abbr) && p6->flag) {
			p6_abbr = &p6_dic_abbr[index = p6->next];
			while (!(p6_abbr->next == index_abbr) &&
			       (p6_abbr->flag))
				p6_abbr = &p6_dic_abbr[index = p6_abbr->next];
			if (p6->flag) {
				euc_str = p6_abbr->euc_code;
				index |= 0x8000;
				break;
			}
		}
		index = cookie >> 16;
		euc_str = p6->euc_code;
		break;

	}
	strncpy(euc_code, euc_str, euc_l);
	euc_code[euc_l] = NULL;
	cookie_new = (cookie & 0xffff0000) | (index & 0xffff);
	return (cookie_new);
}

/*
 * dict_find_all(): return a list of all euc_code strings responding to
 * py_str. The return parameter length contains the number of euc_strings
 */
static caddr_t  list[LEN_LIST];

u_char        **
dict_find_all(py_str, length)
	u_char           *py_str;
	int            *length;
{
	register int    i, j;
	register u_int  index, cookie;
	u_char          euc_str[EUC_STR_LEN + 1];
	struct s_dic   *p1;
	struct p2_dic  *p2;
	struct p3_dic  *p3;
	struct p4_dic  *p4;
	struct p5_dic  *p5;
	struct p6_dic  *p6;
	struct s_dic_abbr *p1_abbr;
	struct p2_dic_abbr *p2_abbr;
	struct p3_dic_abbr *p3_abbr;
	struct p4_dic_abbr *p4_abbr;
	struct p5_dic_abbr *p5_abbr;
	struct p6_dic_abbr *p6_abbr;

	j = strlen(py_str) / PY_LEN;
	if (j > PY_COUNT)
		j = PY_COUNT;
	if (j < 1)
		return (NULL);

	cookie = dict_find_new(py_str, euc_str);
	if (cookie == -1)
		return (NULL);

	index = cookie & 0xffff;
	i = 0;
	switch (j) {
	case 1:
		p1 = &s_dic[index];
		list[i++] = (char *) p1->euc_code;
		if (p1->flag) {
			p1_abbr = &s_dic_abbr[p1->next];
			while ((list[i++] = (char *) p1_abbr->euc_code) &&
			       p1_abbr->flag)
				p1_abbr = &s_dic_abbr[p1_abbr->next];
		}
		break;
	case 2:
		p2 = &p2_dic[index];
		list[i++] = (char *) p2->euc_code;
		if (p2->flag) {
			p2_abbr = &p2_dic_abbr[p2->next];
			while ((list[i++] = (char *) p2_abbr->euc_code) &&
			       p2_abbr->flag)
				p2_abbr = &p2_dic_abbr[p2_abbr->next];
		}
		break;
	case 3:
		p3 = &p3_dic[index];
		list[i++] = (char *) p3->euc_code;
		if (p3->flag) {
			p3_abbr = &p3_dic_abbr[p3->next];
			while ((list[i++] = (char *) p3_abbr->euc_code)
			       && p3_abbr->flag)
				p3_abbr = &p3_dic_abbr[p3_abbr->next];
		}
		break;

	case 4:
		p4 = &p4_dic[index];
		list[i++] = (char *) p4->euc_code;
		if (p4->flag) {
			p4_abbr = &p4_dic_abbr[p4->next];
			while ((list[i++] = (char *) p4_abbr->euc_code)
			       && p4_abbr->flag)
				p4_abbr = &p4_dic_abbr[p4_abbr->next];
		}
		break;

	case 5:
		p5 = &p5_dic[index];
		list[i++] = (char *) p5->euc_code;
		if (p5->flag) {
			p5_abbr = &p5_dic_abbr[p5->next];
			while ((list[i++] = (char *) p5_abbr->euc_code)
			       && p5_abbr->flag)
				p5_abbr = &p5_dic_abbr[p5_abbr->next];
		}
		break;
	case 6:
		p6 = &p6_dic[index];
		list[i++] = (char *) p6->euc_code;
		if (p6->flag) {
			p6_abbr = &p6_dic_abbr[p6->next];
			while ((list[i++] = (char *) p6_abbr->euc_code)
			       && p6_abbr->flag)
				p6_abbr = &p6_dic_abbr[p6_abbr->next];
		}
		break;
	}
	list[i] = (caddr_t)NULL;
	*length = i;
	return ((u_char **) list);
}

/*
 * dict_match_longest(): find the longest euc string that matchs py_str. It
 * returns cookie if some match exists, else -1.
 */
u_int
dict_match_longest(py_str, length, euc_code)
	u_char           *py_str;
	int            *length;
	u_char         *euc_code;
{
	int             py_l;
	u_int           cookie;
	u_char		py_str1[PY_STR_LEN + 1];

	py_l = strlen(py_str) / PY_LEN * PY_LEN;
	if (py_l > PY_STR_LEN)
		py_l = PY_STR_LEN;
	strncpy(py_str1, py_str, py_l);
	py_str1[py_l] = NULL;
	while ((cookie = dict_find_new(py_str1, euc_code)) == -1) {
		if (py_l > PY_LEN) {
			py_l -= PY_LEN;
			py_str1[py_l] = NULL;
		} else
			break;
	}

	if (cookie != -1)
		*length = py_l;

	return (cookie);
}


/*
 * dict_find_cookie(): find the cookie of an euc_code and returns it.
 * It returns -1 if euc_code is not a candidate of py_str.
 */
u_int
dict_get_cookie(py_str, euc_code)
	u_char           	*py_str;
	register u_char         *euc_code;
{
	register u_int		cookie, cookie1;
	int             	py_l;
	register int		not_equal = 1,	/* != 0 means not equal */
				euc_l;	/*  number of bytes in euc_code */
	u_char			euc_str[EUC_STR_LEN + 1];

	py_l = strlen(py_str) / PY_LEN;
	if (py_l > PY_COUNT)
		py_l = PY_COUNT;
	euc_l = py_l * EUC_LEN;

	if ((cookie = dict_find_new(py_str, euc_str)) != -1) {
		cookie1 = cookie;
		while (not_equal = strncmp(euc_code, euc_str, euc_l)) {
			cookie1 = dict_find_next(py_str, cookie1, euc_str);
			if (cookie1 == cookie)
				/* all candidates have been tried */
				break;
		}
	}

	return (not_equal ? -1 : cookie1);
}
