/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ident "@(#)cm_prc.h	1.2 00/08/19"

#include "input_method.h"

#define USER_IM_ST	10

#define MAX_CHOICE	1024
#define MAXLEN_CHOICE   16
#define MAXLEN_PREEDIT  32

#define	MAX_IM		20

enum	SYS_IM {QW_VALUE, PY_VALUE, SW_VALUE, JJ_VALUE, SUN_VALUE,
		SWITCH_MODE_VALUE, CS_VALUE, ASCII_VALUE, ON_VALUE, OFF_VALUE};

/*
 * Intermediate Region
 */
struct I_R {
	/* Chinese external code  region */
	e_char          inbuf[MAX_INTERM_TEXT + 1];	
	int		inbuf_len;
	e_char          disp_buf[MAX_INTERM_TEXT + 1];	/* display buffer */
	u_char          disp_attr[MAX_INTERM_TEXT + 1];
	int		disp_len;
	int             visible_type;
	int             visible_pos;
	int             cursor;
	int             state;
	int             pre_cursor;
};

/*
 * Selection  Region
 */
struct S_R {
	int             ncandidate;
	e_char        **candidate;
	e_char  	buf[MAX_CHOICE][MAXLEN_CHOICE + 1];
	e_char  	buf2[MAX_CHOICE][MAXLEN_CHOICE + 1];
	e_char  	*choices[MAX_CHOICE];
	int             prev_exist;	/* 1 means TRUE, */
	int             next_exist;	/* 1 means TRUE, */
	int             selecting;	/* Not used */
	int             state;		/* Not used */
	int		low, high;	/* range in data buffer */
};


enum	MODE {PRE_EDIT, LOOKUP_CHOICE};

/*
 * There are four cm's abstract  regions in cm_screen: the intermediate
 * region,the selection region, the mode region, and the misc region.
 */
struct CM_screen {
	int             cm_conv_on;	/* 1 means on */
	int             input_method; 	/* conv mode */
	int		im_mode;	/* PRE_EDIT, LOOKUP_CHOICE */
	struct I_R      cm_i_r;
	struct S_R      cm_s_r;
 					/* not used
	struct MODE_R   cm_mode_r;
	struct MISC_R   cm_misc_r;
					 */
	char *		dic_head;	/* used by Sun pinyin */
	char *		focus_ptr;
};

/* the IM specifies the Chinese input method under CM_ON. */
#define	IM		cmscreen[cms]->input_method

/*
 * INBUF is always terminated by a (e_char)NULL, INBUF is stored external
 * input code which is striked by user.
 */
#define	INBUF		(cmscreen[cms]->cm_i_r).inbuf
#define INBUF_LEN	(cmscreen[cms]->cm_i_r).inbuf_len
#define	DISP_BUF	(cmscreen[cms]->cm_i_r).disp_buf
#define	DISP_ATTR	(cmscreen[cms]->cm_i_r).disp_attr
#define DISP_LEN	(cmscreen[cms]->cm_i_r).disp_len

#define	MAX_STG_LEN	40

/*
 * For Selection Region ,.....
 */
#define	S_ncandidate	(cmscreen[cms]->cm_s_r).ncandidate
#define	r_cc		S_ncandidate	/* For comparable with CCSUNOS */
#define	S_candidate	(cmscreen[cms]->cm_s_r).candidate
#define	S_prev		(cmscreen[cms]->cm_s_r).prev_exist	/* Not Used */
#define	S_next		(cmscreen[cms]->cm_s_r).next_exist	/* Not Used */
#define	S_state		(cmscreen[cms]->cm_s_r).state

/*
 * Legal selection index key is  {A-Z} , for Jianjin coding
 */
#define	LEGAL_SELECTION(c)	((luc_label_type == LUC_LABEL_NUMERIC)? \
						((c>='0') && (c<='9')): \
						((c>='A') && (c<='Z')))
#define	ABORT_SELECTION(c)	( (c) == '\007' )	/* ^G */
#define	SELECTION_TO_INTEGER(c)	((luc_label_type == LUC_LABEL_NUMERIC)? \
					((c == '0') ? 9 : (c - '1')) : \
					(c - 'A'))

/*
 * Definition for Pinyin and stroke  input code. Note: PS is short hand of
 * pinyin and stroke
 */
#define	IS_DELETE(c)		( (c == 0x8) || (c == 0x7f) )
#define IS_NUMBER(c)		( (c >= '0') && (c <= '9') )
#define	IS_PAGE_F(c)		( (c == '.') || (c == '>') )
#define	IS_PAGE_B(c)		( (c == ',') || (c == '<') )
#define	PS_LEGAL_INPUT_KEY(c)	( ((c >= 'a') && (c <= 'z')) )
/* Chinese characters number = (3755 +3008)  at this time  */
#define	S_NUMBER	6763
/* The common define: */
#define	MAX_INPUT_CODE_LEN	4
#define	FIRST_CHINESE_EUC	0xa1a1
#define	FIRST_CHINESE_CODE	0xb0a1
#define	FIRST_CHINESE_CODE_1	FIRST_CHINESE_CODE
#define	LAST_CHINESE_CODE_1	0xd7f9
#define	FIRST_CHINESE_CODE_2	0xd8a1
#define	LAST_CHINESE_CODE_2	0xf4fe
#define	LAST_CHINESE_CODE	LAST_CHINESE_CODE_2
#define	LAST_CHINESE_EUC	0xfefe
#define	LEVEL1_COUNT	3755	/* The level 1 Chinese characters number */
#define	LEVEL2_COUNT	3008	/* The level 2 Chinese characters number */
#define	CHINESE_COUNT	(LEVEL1_COUNT + LEVEL2_COUNT)	/* S_NUMBER */
#define	GetHZ		0xff
#define	NullHZ		0
#define	MAX_RC		26	/* Maximum candidate */
#define	MIN_RC		10	/* Minimum candidate */

/*
	for new mode of Chinese symbols. -- roxon 
 */

#define PERIOD 0xa1a3		/* . */
#define COMMAM 0xa3ac		/* , */
#define EXCLMM 0xa3a1		/* ! */
#define COLONM 0xa3ba		/* : */
#define HYPHEN 0xa3ad		/* - */
#define CARETM 0xa3de		/* ^ */

#define LPARNT 0xa3a8		/* ( */
#define RPARNT 0xa3a9		/* ) */
#define LCUBRT 0xa3fb		/* { */
#define RCUBRT 0xa3fd		/* } */
#define LSQBRT 0xa3db		/* [ */
#define RSQBRT 0xa3dd		/* ] */

#define SNGQUO 0xa1e4		/* ' */
#define ACCENT 0xa3e0		/* ` */
#define DBLQUO 0xa1e5		/* " */

#define AMPERS 0xa3a6		/* & */
#define COMMAT 0xa3c0		/* @ */
#define SOLDUS 0xa3af		/* / */
#define SEMCLN 0xa3bb		/* ; */
#define QUESTM 0xa3bf		/* ? */
#define LESSTH 0xa3bc		/* < */
#define GREATH 0xa3be		/* > */
#define VERBAR 0xa3fc		/* | */
#define EQUALS 0xa3bd		/* = */

#define SGNNUM 0xa3a3		/* # */
#define DALLAR 0xa3a4		/* $ */
#define PERCNT 0xa3a5		/* % */
#define SGNSTR 0xa3aa		/* * */
#define UNDSCR 0xa3df		/* _ */
#define BCKSLH 0xa3dc		/* \ */
#define STILDE 0xa1ab		/* ~ */
#define SGNADD 0xa3ab		/* + */

#define DIGITS 0xa3b0		/* 0-9 */

#define UPPERS 0xa3c1		/* A-Z */

#define LOWERS 0xa3e1		/* a-z */
