/*
 * Copyright (c) 1990-1992 by Sun Microsystems, Inc.
 */

#ident  "@(#)cs.h 1.11 93/05/19 SMI"

#ifndef _MLE_CS_H
#define _MLE_CS_H

# include	<sys/types.h>

/*
 *	Region types 
 */
#define	CS_REGION_INTERM	1
#define	CS_REGION_MODE		2
#define	CS_REGION_SELECT	3
#define	CS_REGION_MISC		4
#define	CS_REGION_UNKNOWN	0

/*
 *	Result types 
 */
#define	CS_RESULT_CALLME	0
#define	CS_RESULT_INTERM	CS_REGION_INTERM
#define	CS_RESULT_MODE		CS_REGION_MODE
#define	CS_RESULT_SELECT	CS_REGION_SELECT
#define	CS_RESULT_MISC		CS_REGION_MISC	
#define	CS_RESULT_TEXT		(-1)
#define	CS_RESULT_KEYINFO	(-2)
#define	CS_RESULT_RESET		(-3)
#define	CS_RESULT_OFF		33
#define	CS_RESULT_REJECT	48

/*
 *	Region status 
 */
#define	CS_STATE_UNUSED		0x00	/* ( INTERM, SELECT, MISC) */
#define	CS_STATE_INIT		0x81	/* ( INTERM, SELECT ) */
#define	CS_STATE_EDIT		0x82	/* ( INTERM ) */
#define	CS_STATE_CONV		0x83	/* ( INTERM ) */
#define	CS_STATE_CHOICE		0x83	/* ( SELECT ) */
#define	CS_STATE_KAKUTEI	0x84	/* ( INTERM ,SELECT ) */
#define	CS_STATE_BUSY		0x80	/* ( INTERM ,SELECT, MISC ) */

/*
 *	Operations in select region
 */
#define	CS_SEL_INIT		0
#define	CS_SEL_UPDATE		1
#define	CS_SEL_UNFOCUS		2
#define	CS_SEL_FOCUS		3
#define	CS_SEL_END		4

/*
 *	Attribute in select infomation
 */
#define	CS_SI_DIMENSION		0x0000000f
#define	CS_SI_DIRECTION		0x000000f0
#define	CS_SI_LABEL		0x00000f00
#define	CS_SI_IWIDTH		0x0000f000
#define	CS_SI_CURSOR		0x000f0000
#define	CS_SI_TRANSFER		0x01000000
#define	CS_SI_INPUT		0x02000000
#define	CS_SI_FOCUS		0x04000000

/*
 *	Operations in misc region
 */
#define	CS_MISC_INIT		0
#define	CS_MISC_UPDATE		1
#define	CS_MISC_END		2

/*
 *	Field types in misc region
 */
#define	CS_FIELD_UNUSED		0
#define	CS_FIELD_INTERM		1
#define	CS_FIELD_DISPLAY	2
#define	CS_FIELD_SELECT		3

/*
 *	Control functions ( cs_ctl )
 */
#define	CS_RESET		0x0001
#define	CS_ACTIVE		0x000f
#define	CS_MODE_LIST		0x0010
#define	CS_MODE_SET		0x0011
#define	CS_MODE_GET		0x0012
#define	CS_CIOINFO_SET		0x0013
#define	CS_STATUS_GET		0x0020


/*
 *	e.t.c	definitions
 */
#define	CS_MBYTE_ENCODING	0
#define	CS_WCHAR_ENCODING	1

#define	CS_MODESTRSZ		32
#define	CS_MAXMBCHSZ		3

#define	CS_HOSTNAMESZ		32
#define	CS_USE_RPC		1
#define	CS_USE_IPC		2

#define	CS_PROTO_TCP		1
#define	CS_PROTO_UDP		2

#define	CS_USRNAMESZ		8
#define	CS_GRPNAMESZ		8
#define	CS_CSNAMESZ		8

#define	CS_MODNAMESZ		8
#define	CS_MAXMDINFO		64
#define	CS_STRINGSZ		128

#define	CS_CIOIS_WIN		0x0001
#define	CS_CIOIS_COLOR		0x0002
#define	CS_CIOIS_MDATT		0x0004

#define	CS_KCAT_SHIFTMASK	(1<<0)
#define	CS_KCAT_LOCKMASK	(1<<1)
#define	CS_KCAT_CTRLMASK	(1<<2)
#define	CS_KCAT_MOD1MASK	(1<<3)
#define	CS_KCAT_MOD2MASK	(1<<4)
#define	CS_KCAT_MOD3MASK	(1<<5)
#define	CS_KCAT_MOD4MASK	(1<<6)
#define	CS_KCAT_MOD5MASK	(1<<7)

#define	CS_CALLME_USECMD	0x01
#define	CS_CALLME_BYCI		0x80

#define	CS_MODTYPE_NUMBER	1
#define	CS_MODTYPE_STRING	2

#define	modestr_mb	modeatt._mb
#define	modestr_wc	modeatt._wc


typedef	int	Cs_cioinfo;

typedef	int	Cs_conn;

typedef	u_int	Cs_wchar;

typedef	u_short	Cs_text_attr;

typedef	struct _csinfo{
	int	level;
	char	csname[CS_CSNAMESZ];
	int	csversion;
	int	csrevision;
}	Cs_info;

typedef	struct	_cs_rpcdef {
	int	programno;
	int	versionno;
}	Cs_rpcdef;

typedef	struct	_cs_ipcdef {
	int	protocol;
	int	portno;
}	Cs_ipcdef;

typedef	struct	_cs_csdef {
	int	type;
	char	hostname[CS_HOSTNAMESZ];
	union	{
		Cs_rpcdef	rpcdef;
		Cs_ipcdef	ipcdef;
	}	param;
}	Cs_csdef;

typedef	struct	_cs_clntinfo {
	int	usrid;
	int	grpid;
	int	hstid;
	int	prcid;
	char	usrname[CS_USRNAMESZ];
	char	hstname[CS_HOSTNAMESZ];
}	Cs_clntinfo;


typedef	struct	_cs_csinfo {
	int	level;
	char	csname[CS_CSNAMESZ];
	int	csversion;
	int	csrevision;
}	Cs_csinfo;


typedef	struct	_cs_session {
	int	sesid;
	int	csstat;
	Cs_csdef	csdef;
	Cs_conn	csconn;
	Cs_csinfo	csinfo;
}	Cs_session;


typedef	struct	_cs_modelist {
	int	count;
	char	info[CS_MAXMDINFO][CS_MODNAMESZ];
}	Cs_modelist;

typedef	struct	_cs_modeinfo {
	char	name[CS_MODNAMESZ];
	int	type;
	union {
		char	*comment;
		int	number;
		char	string[CS_STRINGSZ];
	}	value;
	char	comment[CS_STRINGSZ];
}	Cs_modeinfo;

typedef	struct	_cs_keycode {
	u_short	code;
	u_short	attr;
}	Cs_keycode;


typedef	struct	_cs_keyinfo {
	int	func;
	int	count;
	Cs_keycode	*keycode;
	int	arg_is_wchar;
	union{
		char		*char_str;
		Cs_wchar	*wchar_str;
	}argum ;
}	Cs_keyinfo;

typedef	struct	_ci_selinfo {
	int	select_attr;
	int	total_items;
	int	page_items;
	int	line_items;
	int	max_iwidth;
	int	idx_top;
	int	idx_end;
	int	idx_focus;
}	Cs_selinfo;

typedef struct	_cs_control {
	int		opcode;
	caddr_t		operand;
	int		opdlen;
}	Cs_control;

typedef	union	_cs_text_data {
	char		*text_mb;
	Cs_wchar	*text_wc;
}	Cs_text_data;

typedef	struct	_cs_text {
	int	len;
	int	encoding;
	Cs_text_data	text;
	Cs_text_attr	*attr;
}	Cs_text;

typedef	struct	_cs_misc_label{
	Cs_text	text;
	int	ifwid;
}	Cs_misc_label;


typedef	struct	_cs_mode {
	int	len;
	int	encoding;
	union	{
		char		_mb[CS_MODESTRSZ*CS_MAXMBCHSZ];
		Cs_wchar	_wc[CS_MODESTRSZ];
	}	modestr;
	Cs_text_attr	modeatt[CS_MODESTRSZ];
}	Cs_mode;

typedef	struct	_cs_interm {
	int	regid;
	int	state;
	Cs_text	itext;
	int	caret;
	int	chgtop;
	int	chglen;
	Cs_misc_label	mlabel;
}	Cs_interm;


typedef	struct	_cs_select {
	int	regid;
	int	state;
	int	operation;
	int	choice;
	Cs_text_attr	focus_attr;
	Cs_text	prompt;
	Cs_selinfo	sel_info;
	int	count;
	Cs_text	items;
}	Cs_select;

typedef	struct	_cs_display {
	int	flags;
	int	width;
	int	height;
	int	spos_y;
	int	spos_x;
	Cs_text	text;
}	Cs_display;


typedef	struct	_cs_field {
	int	fnum;
	int	ftyp;
	union	{
		Cs_interm	interm;
		Cs_display	display;
		Cs_select	select;
	}	region;
}	Cs_field;

typedef	struct	_cs_misc {
	int	regid;
	int	operation;
	int	focus;
	int	count;
	Cs_field	*field;
}	Cs_misc;

typedef	struct	_cs_request {
	struct	_cs_request	*next;
	int	active_regtype;
	int	active_region;
	int	active_fldtype;
	int	active_field;
	Cs_keyinfo	keyinfo;
	Cs_selinfo	select_info;
	int	user_etcsize;	/* this is added 12/12/90 */
	caddr_t	user_etc;
	int	lead_of_sequence;
}	Cs_request;

typedef struct	_cs_callme {
	int	flags;
	union	{
		Cs_control	req_ctl;
		Cs_request	req_cmd;
	}	request;
}	Cs_callme;

typedef struct _cs_result {
	struct	_cs_result	*next;
	int	type;
	int		user_etcsize;	/* added 12/12/90 */
	caddr_t	user_etc;
	union {
		Cs_callme	callme;
		Cs_interm	interm;
		Cs_mode		mode;
		Cs_select	select;
		Cs_misc		misc;
		Cs_text		text;
		Cs_keyinfo	keyinfo;
	}	data;
}	Cs_result;


/*
 *	ERROR CODE OF C.S.
 */

#define	CS_OK			0x0000
#define	CS_ERR_EXIST		0x0001
#define	CS_ERR_CONNECT		0x0002
#define	CS_ERR_DISCONNECT	0x0003
#define	CS_ERR_LIMIT		0x0004
#define	CS_ERR_NOMEM		0x0005
#define	CS_ERR_INACTIVE		0x000f
#define	CS_ERR_UNDEFINED	0x0010
#define	CS_ERR_NOSUPPORT	0x0011
#define	CS_ERR_PARAM		0x0012
#define	CS_ERR_FORMAT		0x0013
#define	CS_ERR_MISSING		0x0020
#define	CS_ERR_NODICT		0x0021
#define	CS_ERR_ACCSES		0x0022
#define	CS_ERR_PERMIT		0x0023
#define	CS_ERR_ILLGAL		0x0024
#define	CS_ERR_STATUS		0x0025
#define	CS_ERR_ENCODING		0x0026
#define	CS_ERR_UNKNOWN		0x7fff

Cs_session	*csif_open();
int		csif_close();
int		csif_ctl();
int		csif_cmd();

# endif		/* !_MLE_CS_H */
