/*
 * Copyright (c) 1990-1992 by Sun Microsystems, Inc.
 */

#ident  "@(#)ci.h 1.7 93/05/19 SMI"

#ifndef _MLE_CI_H
#define _MLE_CI_H

/*
 *****************************************************************************
 *
 *  CIO/CI interface :  interface data definition (ci.h)
 *
 *****************************************************************************
 */

# include	<sys/types.h>
# include	<mle/cs.h>

/*
 *--------------------------------------------------------------------------
 *	**** Error Code Definition ****
 *--------------------------------------------------------------------------
 */
#define		CI_OK			0x0000
#define		CI_ERR_EXIST		0x0001
#define		CI_ERR_CONNECT		0x0002
#define		CI_ERR_DISCONNECT	0x0003
#define		CI_ERR_LIMIT		0x0004
#define		CI_ERR_NOMEM		0x0005
#define		CI_ERR_INACTIVE		0x000f
#define		CI_ERR_UNDEFINED	0x0010
#define		CI_ERR_NOSUPPORT	0x0011
#define		CI_ERR_PARAM		0x0012
#define		CI_ERR_FORMAT		0x0013
#define		CI_ERR_MISSING		0x0020
#define		CI_ERR_NODICT		0x0021
#define		CI_ERR_ACCESS		0x0022
#define		CI_ERR_PERMIT		0x0023
#define		CI_ERR_ILLGAL		0x0024
#define		CI_ERR_STATUS		0x0025
#define		CI_ERR_ENCODING		0x0026
#define		CI_ERR_UNKNOWN		0x7fff

/*
 *--------------------------------------------------------------------------
 *	**** Operand Code for control of CI_PUT ****
 *--------------------------------------------------------------------------
 */
#define		CI_CSLIST_GET		0x0100
#define		CI_KEYBIND_GET		0x0110
#define		CI_KEYBIND_SET		0x0111

/*
 *--------------------------------------------------------------------------
 *	**** for CI_OPEN ****
 *--------------------------------------------------------------------------
 */

/*
 *	key code information
 */
typedef	struct _ci_keycode {
	u_short		code;
	u_short		attr;

#define	CI_KCAT_SHIFTMASK	(1<<0)
#define	CI_KCAT_LOCKMASK	(1<<1)
#define	CI_KCAT_CTRLMASK	(1<<2)
#define	CI_KCAT_MOD1MASK	(1<<3)
#define	CI_KCAT_MOD2MASK	(1<<4)
#define	CI_KCAT_MOD3MASK	(1<<5)
#define	CI_KCAT_MOD4MASK	(1<<6)
#define	CI_KCAT_MOD5MASK	(1<<7)

} Ci_keycode;

/*
 *	convert session
 */
#define		CI_SESSION_MAX		64
typedef		int		Ci_session ;

/*
 *	convert server id number
 */
typedef		int		Ci_id ;

/*
 *	client information
 */
typedef struct _ci_clntinfo {
	caddr_t		*env_value ;		/* --UNUSED--	*/
	int 		uid ;			/* user id	*/
	char 		*user_name ;		/* user name	*/
	int 		gid ;			/* group id	*/
	char 		*grp_name ;		/* --UNUSED--	*/
	int 		hid ;			/* host id	*/
	char 		*host_name ;		/* host name	*/
} Ci_clntinfo ;

/*
 *	convert server information
 */
typedef struct _ci_csinfo {
	struct _ci_csinfo *next;		/* --UNUSED--	*/
	u_short 	action;
#define CIO_CIS_FAILED		0x0100
#define CIO_CIS_ESTABLISHED	0x0101
	u_short 	status;
	int 		csidno;
	Cs_csinfo	csinfo;
	int 		count_ci_onoff;
	Ci_keycode	**key_ci_onoff;
	int 		count_ci_on;
	Ci_keycode 	**key_ci_on;
	Ci_keycode 	*key_misc_top;
	Ci_keycode 	*key_misc_last;
	Ci_keycode 	*key_misc_next;
	Ci_keycode 	*key_misc_prev;
} Ci_csinfo;

/*
 *--------------------------------------------------------------------------
 *	**** for CI_PUT ****
 *--------------------------------------------------------------------------
 */

/*
 *	key data information
 */
typedef struct _ci_keyinfo {
	int 		func;
	int 		count;
	Ci_keycode	*keycode;
	int 		arg_is_wchar;
	union {
		char 		*char_str;
		Cs_wchar	*wchar_str;
	}		argum;
} Ci_keyinfo;

/*
 *	select information
 */
typedef		Cs_selinfo		Ci_selinfo;

/*
 *	control request
 */
typedef		Cs_control		Ci_control;

/*
 *	command request
 */
typedef struct _ci_command {
	struct _ci_command	*next;
	int 			active_regtype;
#define CI_REGION_UNKNOWN		CS_REGION_UNKNOWN
#define CI_REGION_INTERM		CS_REGION_INTERM
#define CI_REGION_MODE			CS_REGION_MODE
#define CI_REGION_SELECT 		CS_REGION_SELECT
#define CI_REGION_MISC			CS_REGION_MISC
	int 			active_region;
	int 			active_fldtype;
#define CI_FIELD_UNUSED			CS_FIELD_UNUSED
#define CI_FIELD_INTERM    		CS_FIELD_INTERM
#define CI_FIELD_DISPLAY		CS_FIELD_DISPLAY
#define CI_FIELD_SELECT 		CS_FIELD_SELECT
	int 			active_field;
	Ci_keyinfo		keyinfo;
	Ci_selinfo		select_info;
	int			user_etcsize;	/* UNUSED */
	caddr_t			user_etc;	/* UNUSED */
} Ci_command;

/*
 *	request table
 */
typedef struct _ci_request {
	struct _ci_request	*next;
	u_short			type;
#define CI_REQ_CONTROL			0x0200
#define CI_REQ_COMMAND			0x0201
	union {
		Ci_control		_ctl;
		Ci_command		_cmd;
	}			operation;
} Ci_request;

/*
 *	contorol result
 */
typedef struct _cio_control {
	caddr_t		result;
	int 		reslen;
} Cio_control;

/*
 *	convert server entry table
 */
typedef struct _ci_csentry {
	char	csname[CS_CSNAMESZ];
	int 	csidno;
} Ci_csentry;

/*
 *	convert server list table
 */
typedef struct _ci_cslist {
	int 		dflt;
	int 		count;
	Ci_csentry 	*list;
} Ci_cslist;

/*
 *	command result
 */
typedef		Cs_result		Cio_command;

/*
 *	result table
 */
typedef struct  _ci_result {
	struct _ci_result	*next;
	u_short			type;
#define CIO_RES_CONTROL			0x1200
#define CIO_RES_COMMAND			0x1201
	u_short			status;
	union {
		Cio_control		_ctl;
		Cio_command		_cmd;
	}			action;
} Ci_result;

/*
 *--------------------------------------------------------------------------
 *	Function Definition
 *--------------------------------------------------------------------------
 */
Ci_session	ci_open() ;
int		ci_close() ;
Ci_result	*ci_put() ;

#endif		/* !_MLE_CI_H */
