/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifdef  SCCS
static char SccsId[] = "@(#)ThCtl.h 1.3	00/09/14 SMI";
#endif

#ifndef _TH_CTL_H
#define _TH_CTL_H

typedef	enum {
	SHOW_CURR_CELL = 1,
	SHOW_NEXT_CELL,
	ILLEGAL_WTT_INP
} DisplayTypeClass;


#define	NullChr			'\0'
#define WCNullChr		L'\0'

#define	OneChrInCell		1
#define	TwoChrsInCell		2
#define	ThreeChrsInCell		3

#define	TIS620_2533		"tis620.2533"
#define	TIS620_2533_0		"tis620.2533-0"

#define	MAX_INT_BUF		4
#define	ChrType(InpChr)		_TACchclass[(unsigned char)(InpChr)]

#ifdef	notdef
#define IsArabicNumChr(Chr)	((((Chr) >= '0') && ((Chr) <= '9')) ? TRUE : FALSE)
#endif
#define	IsArabicNumChr(Chr)	isdigit(Chr)
#define	ToArabicNumChr(Chr)	((Chr) - 192)
#define	ToThaiNumChr(Chr)	((Chr) + 192)


/* 
 * Wtt2.0 definition for
 *  o Thai Character classification.
 *  o Thai Character Composing Table.
 *  o Thai Input Checking Table.
 */
extern	int			_TACchclass[256];
extern	char			_TAC_celltype_inputcheck[17][17];
extern	char			_TAC_cellShptype_inputcheck[28][28];

/* 
 * TIS620.2533-0's classification and composing.
 */
extern	int			_TIS_0class[384];

/*
 * EILSEQ Tables
 */
extern	int			_IsEILSEQChr[256];
extern  int                     _IsEILSEQShp[256];

/*
 * Conversion Tables
 */
extern  int                     _TIS_0ToBas[256];

/* Microsoft's Thai font glyph Tables */
extern	unsigned char		MSConsIndex[46];
extern	unsigned char		MSNikhahitTone[4];
extern 	unsigned char		MSCellStrtWthCons[3][68];
extern	unsigned char		MSCellStrtWthOutCons[30][30];

#endif	/* _TH_CTL_H */
