/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#ifndef lint
#ifdef sccs
static char     SccsId[] = "@(#)ThCtl.c 1.6	00/09/14 SMI";
#endif
#endif

/* 
 *   This module contains the functions for default th locale
 *   layout services implementation.
 */
#ifdef sun
#include <sys/isa_defs.h>
#endif
#include <stdio.h>
#include <errno.h> 
#include <malloc.h>
#ifdef sun
#include <widec.h>
#endif
#include <stdlib.h>
#include <langinfo.h>
#include <string.h>
#include "layout.h"
#include "layout_int.h"
#include "wtt.h"
#include "ThCtl.h"
#include "MSLayout.h"

#define	THAIZERO	240
#define	THAIONE		241
#define	THAITWO		242
#define	THAITHREE	243
#define	THAIFOUR	244
#define	THAIFIVE	245
#define	THAISIX		246
#define	THAISEVEN	247
#define	THAIEIGHT	248
#define	THAININE	249
#define	NIKHAHIT	237
#define	SARA_AA		210
#define	SARA_AM		211
#define	KOKAI		161
#define	YOYING		173
#define	THOTHAN		176
#define	MAIEK		232
#define	MAIHUNAKAT	209

static 	LayoutObject		_LSThCreate();
static 	int			_LSThDestroy();
static 	int			_LSThGetValues();
static 	int			_LSThSetValues();
static 	int			_LSThTransform();
static 	int			_LSThWCSTransform();

/* Methods for th locale support */
static LayoutMethodsRec _ThLayoutMethods = {
	_LSThCreate,
	_LSThDestroy,
	_LSThGetValues,
	_LSThSetValues,
	_LSThTransform,
	_LSThWCSTransform,
};

/* 
 *  Entry point of to create and initialize the default layout object.
 *
 */
LayoutObject
_LayoutObjectInit(locale_name)
    char		*locale_name;
{
    LayoutObj            layout_obj = (LayoutObj)malloc(sizeof(LayoutObjectRec));
 
    if (layout_obj) {
#ifdef	notdef
        layout_obj->methods = (&_ThLayoutMethods);

        layout_obj->core.locale_name = (char *) NULL;
        
        layout_obj->core.orientation = layout_obj->core.context = 
        layout_obj->core.type_of_text = layout_obj->core.implicit_alg = 
        layout_obj->core.swapping = layout_obj->core.numerals = 
        layout_obj->core.text_shaping = (LayoutTextDescriptor) NULL;
        
        layout_obj->core.shape_context_size = (LayoutEditSize) NULL;
#endif
	memset (layout_obj, 0, sizeof(LayoutObjectRec));       
        layout_obj->methods = (&_ThLayoutMethods);
        
        if(!(layout_obj->core.locale_name = (char *)strdup(locale_name))) {
            goto NoMemory;
        }

        layout_obj->core.orientation = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.orientation)
            goto NoMemory;
        layout_obj->core.orientation->inp = ORIENTATION_LTR;
        layout_obj->core.orientation->out = ORIENTATION_LTR;
        
        layout_obj->core.context = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.context)
            goto NoMemory;
        layout_obj->core.context->inp = CONTEXT_LTR;
        layout_obj->core.context->out = CONTEXT_LTR;
        
        layout_obj->core.type_of_text = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.type_of_text)
            goto NoMemory;            
        layout_obj->core.type_of_text->inp = TEXT_VISUAL;
        layout_obj->core.type_of_text->out = TEXT_VISUAL;
        
        layout_obj->core.implicit_alg = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.implicit_alg)
            goto NoMemory;                        
        layout_obj->core.implicit_alg->inp = ALGOR_IMPLICIT;
        layout_obj->core.implicit_alg->out = ALGOR_IMPLICIT;

        layout_obj->core.swapping = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.swapping)
            goto NoMemory;                                    
        layout_obj->core.swapping->inp = SWAPPING_NO;
        layout_obj->core.swapping->out = SWAPPING_NO;
        
        layout_obj->core.numerals = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.numerals)
            goto NoMemory;                                                
        layout_obj->core.numerals->inp = NUMERALS_NOMINAL;
        layout_obj->core.numerals->out = NUMERALS_NOMINAL;
        
        layout_obj->core.text_shaping = 
            (LayoutTextDescriptor)malloc(sizeof(LayoutTextDescriptorRec));
        if (!layout_obj->core.text_shaping)
            goto NoMemory;                                                            
        layout_obj->core.text_shaping->inp = TEXT_NOMINAL;
        layout_obj->core.text_shaping->out = TEXT_SHAPED;

        layout_obj->core.active_dir = FALSE;
        layout_obj->core.active_shape_editing = TRUE;
        layout_obj->core.shape_charset = (char *)strdup(TIS620_2533_0);
        layout_obj->core.shape_charset_size = 1;
        
        layout_obj->core.in_out_text_descr_mask = AllTextDescriptors;

        layout_obj->core.in_only_text_descr = 0;
        layout_obj->core.out_only_text_descr = 0;
        
        layout_obj->core.check_mode = MODE_STREAM;
        
        layout_obj->core.shape_context_size = 
            (LayoutEditSize)malloc(sizeof(LayoutEditSizeRec));
        if (!layout_obj->core.shape_context_size)
            goto NoMemory;   
        layout_obj->core.shape_context_size->front = 3;
        layout_obj->core.shape_context_size->back = 3;

	layout_obj->private_data = NULL;

    } else {
        goto NoMemory;
    }
 
    return ((LayoutObject)layout_obj);
    
NoMemory:
    errno = ENOMEM;
    
    if (layout_obj) {
        if(layout_obj->core.locale_name) {
            free(layout_obj->core.locale_name);
        }
        
        if(layout_obj->core.orientation) {
            free(layout_obj->core.orientation);
        }
        
        if(layout_obj->core.context) {
            free(layout_obj->core.context);
        }
        
        if(layout_obj->core.type_of_text) {
            free(layout_obj->core.type_of_text);
        }
        
        if(layout_obj->core.implicit_alg) {
            free(layout_obj->core.implicit_alg);
        }
        
        if(layout_obj->core.swapping) {
            free(layout_obj->core.swapping);
        }
        
        if(layout_obj->core.numerals) {
            free(layout_obj->core.numerals);
        }

        if(layout_obj->core.text_shaping) {
            free(layout_obj->core.text_shaping);
        }
        
        if(layout_obj->core.shape_context_size) {
            free(layout_obj->core.shape_context_size);
        }

        free(layout_obj);
    }
    return((LayoutObject)NULL);    
}


static LayoutObject
_LSThCreate(layout_obj, layout_values)
    LayoutObj		layout_obj;
    LayoutValues 	layout_values;
{
    int			result = -1;
    int			index_returned;
    LayoutValues	temp_ptr = layout_values;
    
    if (layout_values) {
        result = layout_obj->methods->setvalues(layout_obj, layout_values, &index_returned);
        
	while (temp_ptr->name) {
	     if ((temp_ptr->name == ShapeCharset) &&
		 (temp_ptr->value)) {
		 free(temp_ptr->value);
	     }
	     temp_ptr++;
	}

    }
    
    return(layout_obj);
}


static int
_LSThDestroy(layout_obj)
    LayoutObj		layout_obj;
{
    int			result = 0;
    
    if (layout_obj == NULL) {
	errno = EFAULT;
        result = -1;
	return (result);
    }

    if (layout_obj->core.orientation)
        free(layout_obj->core.orientation);
        
    if (layout_obj->core.context)
        free(layout_obj->core.context);
        
    if (layout_obj->core.type_of_text)
        free(layout_obj->core.type_of_text);
        
    if (layout_obj->core.implicit_alg)
        free(layout_obj->core.implicit_alg);
    
    if (layout_obj->core.swapping)
        free(layout_obj->core.swapping);
        
    if (layout_obj->core.numerals)
        free(layout_obj->core.numerals);
        
    if (layout_obj->core.text_shaping)
        free(layout_obj->core.text_shaping);
                
    if(layout_obj->core.shape_context_size) 
        free(layout_obj->core.shape_context_size);
        
    if(layout_obj->core.shape_charset) 
        free(layout_obj->core.shape_charset);
        
    if(layout_obj->core.locale_name) 
        free(layout_obj->core.locale_name);
    
    free(layout_obj);    
    
    return(result);
}

static int
_LSThGetValues(layout_obj, values, index_returned)
    LayoutObj		layout_obj;
    LayoutValues 	values;
    int 		*index_returned;
{
    int			result = 0;
    int			i = 0;
    unsigned long	descr_mask = 0;
    
    if (!values)
        return(result);
        
    while (values[i].name) {
    
        if (values[i].value == NULL)
             break; /* Error case */
        
        if ((values[i].name & AllTextDescriptors) &&
            (values[i].name & QueryValueSize)) {
            unsigned long		*dummy = values[i].value;
                
            *dummy = sizeof(LayoutTextDescriptorRec);

        } else if (values[i].name == AllTextDescriptors) {
            LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
            
            dummy->inp |= layout_obj->core.orientation->inp;
            dummy->out |= layout_obj->core.orientation->out;
            
            dummy->inp |= layout_obj->core.context->inp;
            dummy->out |= layout_obj->core.context->out;
            
            dummy->inp |= layout_obj->core.type_of_text->inp;
            dummy->out |= layout_obj->core.type_of_text->out;
            
            dummy->inp |= layout_obj->core.implicit_alg->inp;
            dummy->out |= layout_obj->core.implicit_alg->out;
            
            dummy->inp |= layout_obj->core.swapping->inp;
            dummy->out |= layout_obj->core.swapping->out;
            
            dummy->inp |= layout_obj->core.numerals->inp;
            dummy->out |= layout_obj->core.numerals->out;
            
            dummy->inp |= layout_obj->core.text_shaping->inp;
            dummy->out |= layout_obj->core.text_shaping->out;
            
        } else if (values[i].name & AllTextDescriptors) {
                        
            if (values[i].name & Orientation) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.orientation->inp;
                dummy->out = layout_obj->core.orientation->out;
            } else if  (values[i].name & Context) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.context->inp;
                dummy->out = layout_obj->core.context->out;
            } else if (values[i].name & TypeOfText) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.type_of_text->inp;
                dummy->out = layout_obj->core.type_of_text->out;
            } else if (values[i].name & ImplicitAlg) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.implicit_alg->inp;
                dummy->out = layout_obj->core.implicit_alg->out;
            } else if (values[i].name & Swapping) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.swapping->inp;
                dummy->out = layout_obj->core.swapping->out;
            } else if (values[i].name & Numerals) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.numerals->inp;
                dummy->out = layout_obj->core.numerals->out;

            } else if (values[i].name & TextShaping) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                dummy->inp = layout_obj->core.text_shaping->inp;
                dummy->out = layout_obj->core.text_shaping->out;
            }
        } else if (values[i].name & ActiveDirectional) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = sizeof(layout_obj->core.active_dir);
            } else {
                 BooleanValue		*dummy = values[i].value;

                *dummy = layout_obj->core.active_dir;
            }
        }  else if (values[i].name & ActiveShapeEditing) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = sizeof(layout_obj->core.active_shape_editing);
            } else {
                 BooleanValue		*dummy = values[i].value;

                *dummy = layout_obj->core.active_shape_editing;
            }
        } else if (values[i].name & ShapeCharset) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = strlen(layout_obj->core.shape_charset) + 1;
            } else {
                 char			**dummy = values[i].value;

                strcpy(*dummy, layout_obj->core.shape_charset);
            }
        }  else if (values[i].name & ShapeCharsetSize) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = sizeof(layout_obj->core.shape_charset_size);
            } else {
                 int		*dummy = values[i].value;

                *dummy = layout_obj->core.shape_charset_size;
            }
        } else if (values[i].name & InOutTextDescrMask) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = sizeof(layout_obj->core.in_out_text_descr_mask);
            } else {
                 unsigned long		*dummy = values[i].value;

                *dummy = layout_obj->core.in_out_text_descr_mask;
            }
        } else if (values[i].name & InOnlyTextDescr) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                 
                *dummy = sizeof(layout_obj->core.in_only_text_descr);
            } else {
                 unsigned long		*dummy = values[i].value;
                 
                 *dummy = 0;
                 
                 if (layout_obj->core.in_out_text_descr_mask & Orientation)
                     *dummy |= layout_obj->core.orientation->inp;
                 if (layout_obj->core.in_out_text_descr_mask & Context)
                     *dummy |= layout_obj->core.context->inp;
                 if (layout_obj->core.in_out_text_descr_mask & TypeOfText)
                     *dummy |= layout_obj->core.type_of_text->inp;
                 if (layout_obj->core.in_out_text_descr_mask & ImplicitAlg)
                     *dummy |= layout_obj->core.implicit_alg->inp;
                 if (layout_obj->core.in_out_text_descr_mask & Swapping)
                     *dummy |= layout_obj->core.swapping->inp;
                 if (layout_obj->core.in_out_text_descr_mask & Numerals)
                     *dummy |= layout_obj->core.numerals->inp;                     
                 if (layout_obj->core.in_out_text_descr_mask & TextShaping)
                     *dummy |= layout_obj->core.text_shaping->inp;
            }
        } else if (values[i].name & OutOnlyTextDescr) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                 
                *dummy = sizeof(layout_obj->core.out_only_text_descr);
            } else {
                 unsigned long		*dummy = values[i].value;
                 
                 *dummy = 0;
                 
                 if (layout_obj->core.in_out_text_descr_mask & Orientation)
                     *dummy |= layout_obj->core.orientation->out;
                 if (layout_obj->core.in_out_text_descr_mask & Context)
                     *dummy |= layout_obj->core.context->out;
                 if (layout_obj->core.in_out_text_descr_mask & TypeOfText)
                     *dummy |= layout_obj->core.type_of_text->out;
                 if (layout_obj->core.in_out_text_descr_mask & ImplicitAlg)
                     *dummy |= layout_obj->core.implicit_alg->out;
                 if (layout_obj->core.in_out_text_descr_mask & Swapping)
                     *dummy |= layout_obj->core.swapping->out;
                 if (layout_obj->core.in_out_text_descr_mask & Numerals)
                     *dummy |= layout_obj->core.numerals->out;                     
                 if (layout_obj->core.in_out_text_descr_mask & TextShaping)
                     *dummy |= layout_obj->core.text_shaping->out;
            }
        } else if (values[i].name & CheckMode) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = sizeof(layout_obj->core.check_mode);
            } else {
                 int			*dummy = values[i].value;

                *dummy = layout_obj->core.check_mode;
            }
        } else if (values[i].name & ShapeContextSize) {
            if (values[i].name & QueryValueSize) {
                 unsigned long		*dummy = values[i].value;
                
                *dummy = sizeof(LayoutEditSizeRec);
            } else {
                 LayoutEditSize		dummy = (LayoutEditSize)values[i].value;

                 dummy->front = layout_obj->core.shape_context_size->front;
                 dummy->back = layout_obj->core.shape_context_size->back;
            }

        } else
            break; /* Error condition */

        i++;
    
    }
    
    if (values[i].name) {
        result = -1;
        *index_returned = i;
        errno = EINVAL;
    }
    
    return(result);

}

static int
FoundIncorrectShpeChrset(ShpeChrset)
    char		*ShpeChrset;
{
    if (ShpeChrset)
	return ((strcmp(ShpeChrset, TIS620_2533) != 0) &&
		(strcmp(ShpeChrset, TIS620_2533_0) != 0));
    else
	return TRUE;
}

static int 
FoundInvalidValue(values, index_returned)
    LayoutValues	values;
    int 		*index_returned;
{
    int			i = 0;
    			
    while (values[i].name) {
             
        if (values[i].name & AllTextDescriptors) {
        
            if (values[i].value == NULL)
                break; /* Error case */
                        
            if (values[i].name & Orientation) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                if (dummy->inp & ~MaskOrientation)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskOrientation)
                    goto InvalidValue;
                                    
            } else if  (values[i].name & Context) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                if (dummy->inp & ~MaskContext)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskContext)
                    goto InvalidValue;
               
                                
            } else if (values[i].name & TypeOfText) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;

                if (dummy->inp & ~MaskTypeOfText)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskTypeOfText)
                    goto InvalidValue;
                
                
            } else if (values[i].name & ImplicitAlg) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;

                if (dummy->inp & ~MaskImplicitAlg)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskImplicitAlg)
                    goto InvalidValue;
                
            } else if (values[i].name & Swapping) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;

                if (dummy->inp & ~MaskSwapping)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskSwapping)
                    goto InvalidValue;
                                    
            } else if (values[i].name & Numerals) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;

                if (dummy->inp & ~MaskNumerals)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskNumerals)
                    goto InvalidValue;
                
                    
            } else if (values[i].name & TextShaping) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                if (dummy->inp & ~MaskTextShaping)
                    goto InvalidValue;
                    
                if (dummy->out & ~MaskTextShaping)
                    goto InvalidValue;
                                   
            }
        } else if (values[i].name & ShapeCharset) {
            char			*dummy = (char *)values[i].value;
            
            if ((dummy == NULL) || (strlen(dummy) <= 0) ||
		 FoundIncorrectShpeChrset(dummy))
                goto InvalidValue;
            
        } else if (values[i].name & InOutTextDescrMask) {
            unsigned long	dummy = (unsigned long)values[i].value;
            
            if (dummy & ~AllTextDescriptors)
                goto InvalidValue;
                
        } else if ((values[i].name & InOnlyTextDescr) ||
                   (values[i].name & OutOnlyTextDescr)) {
            unsigned long		dummy = (unsigned long)values[i].value;
                 
            if (dummy & ~MaskAllTextDescriptors)
                goto InvalidValue;
                
        } else if (values[i].name & CheckMode) {
            int				dummy = (int)values[i].value;
            if ((dummy != MODE_STREAM) && (dummy != MODE_EDIT))
                goto InvalidValue;

        } else
            goto InvalidValue; /* Error condition */

        i++;
    }
    
    return (FALSE);
    
InvalidValue:
    *index_returned = i;
    return (TRUE);

}	

static int
_LSThSetValues(layout_obj, values, index_returned)
    LayoutObj		layout_obj;
    LayoutValues 	values;
    int 		*index_returned;
{
    int			result = 0;
    int			i = 0;
    
    
    if (!values)
        return(0);
        
    /*
     *  ActiveDirectional, ActiveShapeEditing, ShapeCharsetSize and ShapeContextSize
     *  should not be set.
     */        
        
    if (FoundInvalidValue(values, index_returned))
        return(-1);
        
                
    while (values[i].name) {
        
        if (values[i].name == AllTextDescriptors) {
             LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                 
             layout_obj->core.orientation->inp = (dummy->inp & MaskOrientation);
	     layout_obj->core.context->inp = (dummy->inp & MaskContext);
	     layout_obj->core.type_of_text->inp = (dummy->inp & MaskTypeOfText);
	     layout_obj->core.implicit_alg->inp = (dummy->inp & MaskImplicitAlg);
	     layout_obj->core.swapping->inp = (dummy->inp & MaskSwapping);
	     layout_obj->core.numerals->inp = (dummy->inp & MaskNumerals);
	     layout_obj->core.text_shaping->inp = (dummy->inp & MaskTextShaping);
	     
	     layout_obj->core.orientation->out = (dummy->out & MaskOrientation);
	     layout_obj->core.context->out = (dummy->out & MaskContext);
	     layout_obj->core.type_of_text->out = (dummy->out & MaskTypeOfText);
	     layout_obj->core.implicit_alg->out = (dummy->out & MaskImplicitAlg);
	     layout_obj->core.swapping->out = (dummy->out & MaskSwapping);
	     layout_obj->core.numerals->out = (dummy->out & MaskNumerals);
	     layout_obj->core.text_shaping->out = (dummy->out & MaskTextShaping);
                 
        } else if (values[i].name & AllTextDescriptors) {
        
            if (values[i].value == NULL)
                break; /* Error case */
                        
            if (values[i].name & Orientation) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                    
                layout_obj->core.orientation->inp = dummy->inp;
                layout_obj->core.orientation->out = dummy->out;
                
            } else if  (values[i].name & Context) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                layout_obj->core.context->inp = dummy->inp;
                layout_obj->core.context->out = dummy->out;
                
            } else if (values[i].name & TypeOfText) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                layout_obj->core.type_of_text->inp = dummy->inp;
                layout_obj->core.type_of_text->out = dummy->out;
                
            } else if (values[i].name & ImplicitAlg) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                layout_obj->core.implicit_alg->inp = dummy->inp;
                layout_obj->core.implicit_alg->out = dummy->out;
                
            } else if (values[i].name & Swapping) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                layout_obj->core.swapping->inp = dummy->inp;
                layout_obj->core.swapping->out = dummy->out;
                    
            } else if (values[i].name & Numerals) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                layout_obj->core.numerals->inp = dummy->inp;
                layout_obj->core.numerals->out = dummy->out;
                    
            } else if (values[i].name & TextShaping) {
                LayoutTextDescriptor	dummy = (LayoutTextDescriptor)values[i].value;
                
                layout_obj->core.text_shaping->inp = dummy->inp;
                layout_obj->core.text_shaping->out = dummy->out;
                    
            }
        } else if (values[i].name & ShapeCharset) {
        
            if (layout_obj->core.shape_charset)
                 free(layout_obj->core.shape_charset);
            layout_obj->core.shape_charset = (char *)strdup((char *)values[i].value);
	    if (strcmp(layout_obj->core.shape_charset, TIS620_2533) == 0)
		layout_obj->core.shape_charset_size = 1;
	    else
		layout_obj->core.shape_charset_size = 2;
            
        } else if (values[i].name & InOutTextDescrMask) {
            layout_obj->core.in_out_text_descr_mask = (unsigned long)values[i].value;

        } else if (values[i].name & InOnlyTextDescr) {
             unsigned long		dummy = (unsigned long)values[i].value;
                 
             if (layout_obj->core.in_out_text_descr_mask & Orientation)
                 layout_obj->core.orientation->inp = (dummy & MaskOrientation);
             if (layout_obj->core.in_out_text_descr_mask & Context)
                 layout_obj->core.context->inp = (dummy & MaskContext);
             if (layout_obj->core.in_out_text_descr_mask & TypeOfText)
                 layout_obj->core.type_of_text->inp = (dummy & MaskTypeOfText);
             if (layout_obj->core.in_out_text_descr_mask & ImplicitAlg)
                 layout_obj->core.implicit_alg->inp = (dummy & MaskImplicitAlg);
             if (layout_obj->core.in_out_text_descr_mask & Swapping)
                 layout_obj->core.swapping->inp = (dummy & MaskSwapping);
             if (layout_obj->core.in_out_text_descr_mask & Numerals)
                 layout_obj->core.numerals->inp = (dummy & MaskNumerals);
             if (layout_obj->core.in_out_text_descr_mask & TextShaping)
                 layout_obj->core.text_shaping->inp = (dummy & MaskTextShaping);
                 
        } else if (values[i].name & OutOnlyTextDescr) {
             unsigned long		dummy = (unsigned long)values[i].value;
                 
             if (layout_obj->core.in_out_text_descr_mask & Orientation)
                 layout_obj->core.orientation->out = (dummy & MaskOrientation);
             if (layout_obj->core.in_out_text_descr_mask & Context)
                 layout_obj->core.context->out = (dummy & MaskContext);
             if (layout_obj->core.in_out_text_descr_mask & TypeOfText)
                 layout_obj->core.type_of_text->out = (dummy & MaskTypeOfText);
             if (layout_obj->core.in_out_text_descr_mask & ImplicitAlg)
                 layout_obj->core.implicit_alg->out = (dummy & MaskImplicitAlg);
             if (layout_obj->core.in_out_text_descr_mask & Swapping)
                 layout_obj->core.swapping->out = (dummy & MaskSwapping);
             if (layout_obj->core.in_out_text_descr_mask & Numerals)
                 layout_obj->core.numerals->out = (dummy & MaskNumerals);
             if (layout_obj->core.in_out_text_descr_mask & TextShaping)
                 layout_obj->core.text_shaping->out = (dummy & MaskTextShaping);

        } else if (values[i].name & CheckMode) {
             layout_obj->core.check_mode = (int) values[i].value;		
        } else
            break; /* Error condition */

        i++;
    
    }
    
    if (values[i].name) {
        result = -1;
        *index_returned = i;
        errno = EINVAL;
    }

    return(result);

}

static int
Thmblen(InpChr)
    unsigned char *InpChr;
{
    if (InpChr == NULL)
	return 0;

    if (*InpChr == '\0')
	return 0;
    else
	return 1;
}

static int
Thwcstombs(OutStr, InpStr, NumChrs)
    unsigned char *OutStr;
    wchar_t	  *InpStr;
    int		  NumChrs;
{
    int	i;

    if ((InpStr == NULL) || (OutStr == NULL))
	return 0;
    i = 0;
    while (*InpStr |= L'\0') {
	if (i < NumChrs)
	    *OutStr = *InpStr & 0x000000ff;
	OutStr++;
	InpStr++;
    }
    return ((i < NumChrs) ? i : NumChrs);
}

static int
IsDisplayTypeChr(PrevInpChr, FollInpChr)
    unsigned char		PrevInpChr;
    unsigned char		FollInpChr;
{
    switch (_TAC_celltype_inputcheck[ChrType(PrevInpChr)]
				    [ChrType(FollInpChr)])
    {
	case 'A':
	case 'S':
	case 'R':
	case 'X':
	  return SHOW_NEXT_CELL;

	case 'C':
	  return SHOW_CURR_CELL;
    }
}

static int
IsThaiNumChr(Chr)
    unsigned char	Chr;
{
    switch (Chr) {
      case THAIZERO:
      case THAIONE:
      case THAITWO:
      case THAITHREE:
      case THAIFOUR:
      case THAIFIVE:
      case THAISIX:
      case THAISEVEN:
      case THAIEIGHT:
      case THAININE:
	return TRUE;

      default:
	return FALSE;
    }
}

static int
IsArabicThaiNumChr(Chr)
    unsigned char	Chr;
{
    if (IsArabicNumChr(Chr) || IsThaiNumChr(Chr))
        return TRUE;
    else
    	return FALSE;
}

static int
IsBelowChr(InpChr)
    unsigned char	InpChr;
{
    switch (ChrType(InpChr))
    {
	case CTRL:
	case  NON:
	case CONS:
	case   LV:
	case  FV1:
	case  FV2:
	case  FV3:
	case  AV1:
	case  AV2:
	case  AV3:
	case TONE:
	case  AD1:
	case  AD2:
	case  AD3:
	  return FALSE;

	case  BV1:
	case  BV2:
	case   BD:
	  return TRUE;
    }
}


static int
IsEILSEQChr(InpChr)
    unsigned char	InpChr;
{
    return _IsEILSEQChr[InpChr];
}

static int
TACiswcons(InpWChr)
    wchar_t                     InpWChr;
{
    unsigned char       InpChr;

    InpChr = (unsigned char) (InpWChr & 0x000000ff);
    switch (ChrType(InpChr))
    {
        case CONS:
          return TRUE;

        case CTRL:
        case  NON:
        case   LV:
        case  FV1:
        case  FV2:
        case  FV3:
        case  BV1:
        case  BV2:
        case   BD:
        case TONE:
        case  AD1:
        case  AD2:
        case  AD3:
        case  AV1:
        case  AV2:
        case  AV3:
          return FALSE;
    }
}

static int
TACiswtone(InpWChr)
    wchar_t                     InpWChr;
{
    unsigned char       InpChr;

    InpChr = (unsigned char)(InpWChr & 0x000000ff);
    switch (ChrType(InpChr))
    {
        case TONE:
          return TRUE;

        case CTRL:
        case  NON:
        case CONS:
        case   LV:
        case  FV1:
        case  FV2:
        case  FV3:
        case  BV1:
        case  BV2:
        case   BD:
        case  AD1:
        case  AD2:
        case  AD3:
        case  AV1:
        case  AV2:
        case  AV3:
          return FALSE;
    }
}

static int
IsWDisplayType(PrevInpWChr, FollInpWChr)
    wchar_t             PrevInpWChr;
    wchar_t             FollInpWChr;
{
    unsigned char       PrevInpChr;
    unsigned char       FollInpChr;

    PrevInpChr = (unsigned char)(PrevInpWChr & 0x000000ff);
    FollInpChr = (unsigned char)(FollInpWChr & 0x000000ff);
    return (IsDisplayTypeChr(PrevInpChr, FollInpChr));
}



static int
IsDisplayTypeShp(PrevInpShp, FollInpShp, ShpSiz)
    unsigned char	*PrevInpShp;
    unsigned char	*FollInpShp;
    int			ShpSiz;
{
    switch (_TAC_cellShptype_inputcheck[ShpType(PrevInpShp, ShpSiz)]
				       [ShpType(FollInpShp, ShpSiz)])
    {
	case 'A':
	case 'S':
	case 'R':
	case 'X':
	  return SHOW_NEXT_CELL;

	case 'C':
	  return SHOW_CURR_CELL;
    }
}

static int
Strm2Int(InpStrm, ShpSiz)
    unsigned char		*InpStrm;
    int				ShpSiz;
{
    int	value = 0;

    while (ShpSiz) {
	value <<= 8;
	value += *InpStrm;
	InpStrm++;
	ShpSiz--;
    }
    return ((unsigned int) value);
}

static int
ShpType(InpStrm, ShpSiz)
    unsigned char		*InpStrm;
    int				ShpSiz;
{
    int	InpShp = Strm2Int(InpStrm, ShpSiz);

    if (InpShp < MAX_MS_GLYPHS) {
	if (InpShp == BadSeqIndicator) {
	    InpShp = Strm2Int(InpStrm + ShpSiz, ShpSiz);
	    switch (_TIS_0class[InpShp]) {
	      case  BV1:
	        return SBV1;
	        
	      case  BV2:
	        return SBV2;
	        
	      case   BD:
	        return SBD;
	        
	      case TONE:
	        return STON;
	        
	      case  AD1:
	        return SAD1;
	        
	      case  AD2:
	        return SAD2;
	        
	      case  AD3:
	        return SAD3;
	        
	      case  AV1:
	        return SAV1;
	        
	      case  AV2:
	        return SAV2;
	        
	      case  AV3:
	        return SAV3;
	    }
	} else
	    return (_TIS_0class[InpShp]);
    } else
	return NON;
}

static int
ShpStrlen(InpBuf, ShpSiz)
    unsigned char		*InpBuf;
    int				ShpSiz;
{
    int	nShps = 0;
    int ShpChrLen;

    while (ShpChrLen = ShpLen(InpBuf, ShpSiz)) {
	InpBuf += ShpChrLen;
	nShps++;
    }
    return (nShps);
}

static int
ShpLen(InpBuf, ShpSiz)
    unsigned char		*InpBuf;
    int				ShpSiz;
{
    int		InpShp = Strm2Int(InpBuf, ShpSiz);

    switch (InpShp) {
      case 0:
	return 0;
	
      case BadSeqIndicator:
        return (2*ShpSiz);
      
      default:
	return (ShpSiz);
    }
}

static int
IsFirstPartSaraAm(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    switch (Strm2Int(InpBuf, ShpSiz)) {
	case NIKHAHIT:
	case NIKHAHIT_LEFT_SHIFT:
	  return TRUE;

	default:
	  return FALSE;
    }
}

static int
IsSecondPartSaraAm(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    if (Strm2Int(InpBuf, ShpSiz) == SARA_AA)
	return TRUE;
    else
	return FALSE;
}

static int
IsArabicNumShp(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    return isdigit(Strm2Int(InpBuf, ShpSiz));
}

static int
IsThaiNumShp(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    switch (Strm2Int(InpBuf, ShpSiz)) {
      case THAIZERO:
      case THAIONE:
      case THAITWO:
      case THAITHREE:
      case THAIFOUR:
      case THAIFIVE:
      case THAISIX:
      case THAISEVEN:
      case THAIEIGHT:
      case THAININE:
	return TRUE;

      default:
	return FALSE;
    }
}

static int
IsArabicThaiNumShp(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    if (IsArabicNumShp(InpBuf, ShpSiz) ||
        IsThaiNumShp(InpBuf, ShpSiz))
        return TRUE;
    else
    	return FALSE;
}

static int
IsBelowShp(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    switch (ShpType(InpBuf, ShpSiz))
    {
	case CTRL:
	case  NON:
	case CONS:
	case   LV:
	case  FV1:
	case  FV2:
	case  FV3:
	case  AV1:
	case  AV2:
	case  AV3:
	case TONE:
	case  AD1:
	case  AD2:
	case  AD3:
	case SAV1:
	case SAV2:
	case SAV3:
	case STON:
	case SAD1:
	case SAD2:
	case SAD3:
	  return FALSE;

	case  BV1:
	case  BV2:
	case   BD:
	case SBV1:
	case SBV2:
	case  SBD:
	  return TRUE;
    }
}

static int
IsEILSEQShp(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    int	InpShp = Strm2Int(InpBuf, ShpSiz);
    
    if (InpShp >= MAX_MS_GLYPHS)
	return TRUE;
    if (InpShp == BadSeqIndicator) {
        InpShp = Strm2Int(InpBuf + ShpSiz, ShpSiz);
    	switch (_TIS_0class[InpShp]) {
    	  case  BV1:
    	  case  BV2:
    	  case   BD:
    	  case TONE:
    	  case  AD1:
    	  case  AD2:
    	  case  AD3:
    	  case  AV1:
    	  case  AV2:
    	  case  AV3:
    	    return FALSE;
    	    
    	  default:
    	    return TRUE;
	}
    }
    return _IsEILSEQShp[InpShp];
}

static int
TIS_0ToBas(InpBuf, ShpSiz)
    unsigned char	*InpBuf;
    int			ShpSiz;
{
    int		InpShp = Strm2Int(InpBuf, ShpSiz);

    if (InpShp == BadSeqIndicator)
        InpShp = Strm2Int(InpBuf + ShpSiz, ShpSiz);
    return (_TIS_0ToBas[InpShp]);
}


static int
BasToBas(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    num_bytes = (InpSize == 0) ?(strlen((char *)InpBuf) - TempInpBufIndex) : (InpSize);


    {

	int    MBChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    MBChrLen = Thmblen((char *)(InpBuf + IdxNextChr));
	    i += MBChrLen;
	    if (MBChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr++;
		i++;
	    } else if (IsEILSEQChr(InpBuf[IdxNextChr])) {
		num_bytes = i - MBChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += MBChrLen;
	    	TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }


    for (i=j=0; i < num_bytes ; ) {

	int		ii;
	unsigned char	dummy;
	int		TempIdxNextCell;
	int		IdxNextCell;
	int		nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += Thmblen((char *)(InpBuf + TempInpBufIndex));
	FirstNextChrIdx = IdxNextCell;

	/*
	 * ii is marked as a cell boundary.
	 */
	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeChr(InpBuf[TempIdxNextCell],
				 InpBuf[IdxNextCell]) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ?DISPLAYCELL_MASK : 0x00;
	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += Thmblen((char *) (InpBuf + IdxNextCell));
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ?DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {

	    case OneChrInCell:
	    
	      /*
	       * First Character in a Cell
	       */
	      dummy = InpBuf[TempInpBufIndex];
	      if ((NumeralsInp != NumeralsOut) &&
	          IsArabicThaiNumChr(InpBuf[TempInpBufIndex])) {
		  switch (NumeralsOut) {
		    case NUMERALS_NOMINAL:
		      if (IsThaiNumChr(InpBuf[TempInpBufIndex]))
		          dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
		      break;

		    case NUMERALS_NATIONAL:
		      if (IsArabicNumChr(InpBuf[TempInpBufIndex]))
			  dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
		      break;

		    case NUMERALS_CONTEXTUAL:
		      if (IsArabicNumChr(InpBuf[FirstPrevChrIdx]) &&
			  IsThaiNumChr(InpBuf[TempInpBufIndex]))
			  dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
		      else if (IsThaiNumChr(InpBuf[FirstPrevChrIdx]) &&
			       IsArabicNumChr(InpBuf[TempInpBufIndex]))
			  dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
		      break;
		  }
	      }
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = dummy;
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;
	      break;

	    case TwoChrsInCell:
	    
	      /*
	       * First Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[TempInpBufIndex];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;

	      /*
	       * Second Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[FirstNextChrIdx];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = SecondNextChrIdx - FirstNextChrIdx;ii;ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;
	      break;

	    case ThreeChrsInCell:
	    
	      /*
	       * First Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[TempInpBufIndex];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;

	      /*
	       * Second Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[FirstNextChrIdx];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = SecondNextChrIdx - FirstNextChrIdx;ii;ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;

	      /*
	       * Third Character in a Cell
	       */
	       
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[SecondNextChrIdx];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = ThirdNextChrIdx - SecondNextChrIdx ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = SecondNextChrIdx;
	      j++;
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}

    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
BasToSFTIS(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ? *InpBufIndex : 0;
    int				TempOutSize = OutSize ? *OutSize : 0;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    num_bytes = (InpSize == 0) ?(strlen((char *)InpBuf) - TempInpBufIndex) : (InpSize);

    {

	int    MBChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    MBChrLen = Thmblen((char *)(InpBuf + IdxNextChr));
	    i += MBChrLen;
	    if (MBChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr++;
		i++;
	    } else if (IsEILSEQChr(InpBuf[IdxNextChr])) {
		num_bytes = i - MBChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += MBChrLen;
		/*
		 * Due to "ShapeCharSet" is set to "TIS620.2533"
		 * instead of "TIS620.2533-0"
		 */
		if (IsDisplayTypeChr(InpBuf[TempIdxNextChr], 
				     InpBuf[IdxNextChr]) == SHOW_NEXT_CELL) {
		    if ((ChrType(InpBuf[IdxNextChr]) != CTRL) &&
			(ChrType(InpBuf[IdxNextChr]) != NON) &&
			(ChrType(InpBuf[IdxNextChr]) != CONS) &&
			(ChrType(InpBuf[IdxNextChr]) != LV) &&
			(ChrType(InpBuf[IdxNextChr]) != FV1) &&
			(ChrType(InpBuf[IdxNextChr]) != FV2) &&
			(ChrType(InpBuf[IdxNextChr]) != FV3)) {
			num_bytes = i;
			errno = EILSEQ;
			result = -1;
			break;
		    }
		}
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }


    for (i=j=0; i < num_bytes ; ) {

	int		ii;
	unsigned char	dummy;
	int		TempIdxNextCell;
	int		IdxNextCell;
	int		nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += Thmblen((char *)(InpBuf + TempInpBufIndex));
	FirstNextChrIdx = IdxNextCell;

	ii = 0;
	/*
	 * ii is marked as the cell boundary.
	 */
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeChr(InpBuf[TempIdxNextCell],
	       			 InpBuf[IdxNextCell]) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ?DISPLAYCELL_MASK : 0x00;
	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += Thmblen((char *) (InpBuf + IdxNextCell));
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ?DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {

	    case OneChrInCell:
	      /*
	       * First Character in a Cell
	       */
	      dummy = InpBuf[TempInpBufIndex];
	      if ((NumeralsInp != NumeralsOut) &&
	          IsArabicThaiNumChr(InpBuf[TempInpBufIndex])) {
		  switch (NumeralsOut) {
		    case NUMERALS_NOMINAL:
		      if (IsThaiNumChr(InpBuf[TempInpBufIndex]))
		          dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
		      break;

		    case NUMERALS_NATIONAL:
		      if (IsArabicNumChr(InpBuf[TempInpBufIndex]))
			  dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
		      break;

		    case NUMERALS_CONTEXTUAL:
		      if (IsArabicNumChr(InpBuf[FirstPrevChrIdx]) &&
			  IsThaiNumChr(InpBuf[TempInpBufIndex]))
			  dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
		      else if (IsThaiNumChr(InpBuf[FirstPrevChrIdx]) &&
			       IsArabicNumChr(InpBuf[TempInpBufIndex]))
			  dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
		      break;
		  }
	      }
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = dummy;
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;
	      break;

	    case TwoChrsInCell:
	      /*
	       * First Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[TempInpBufIndex];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;

	      /*
	       * Second Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[FirstNextChrIdx];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = SecondNextChrIdx - FirstNextChrIdx;ii;ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;
	      break;

	    case ThreeChrsInCell:
	      /*
	       * First Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[TempInpBufIndex];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;

	      /*
	       * Second Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[FirstNextChrIdx];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = SecondNextChrIdx - FirstNextChrIdx;ii;ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;

	      /*
	       * Third Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = InpBuf[SecondNextChrIdx];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = ThirdNextChrIdx - SecondNextChrIdx ;ii; ii--,i++)
		  if (InpToOut)
		      InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = SecondNextChrIdx;
	      j++;
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}

    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}


static int
BasToSFTIS_0(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    num_bytes = (InpSize == 0) ?(strlen((char *)InpBuf) - TempInpBufIndex) : (InpSize);

    {

	int    MBChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    MBChrLen = Thmblen((char *)(InpBuf + IdxNextChr));
	    i += MBChrLen;
	    if (MBChrLen == 0) {
		num_bytes = i;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (IsEILSEQChr(InpBuf[IdxNextChr])) {
		num_bytes = i - MBChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += MBChrLen;
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i < num_bytes ;) {

	int		ii;
	int		TempIdxNextCell;
	int		IdxNextCell;
	int		nChrsInCell = OneChrInCell;
	unsigned char	dummy;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += Thmblen((char *) (InpBuf + TempInpBufIndex));
	FirstNextChrIdx = IdxNextCell;

	ii = 0;
	/*
	 * ii is marked here as a cell boundary.
	 */
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeChr(InpBuf[TempIdxNextCell],
	       			 InpBuf[IdxNextCell]) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ?DISPLAYCELL_MASK : 0x00;
	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += Thmblen((char *) (InpBuf + IdxNextCell));
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ?DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {

	    case OneChrInCell:
	    
	      /*
	       * First Character in a Cell
	       */
	      if ((FirstPrevChrIdx >= 0) &&
		  (ChrType(InpBuf[FirstPrevChrIdx]) == CONS)
		  && (InpBuf[TempInpBufIndex] == SARA_AM)) {
		  if (Property)
		      for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
			    Property[i + ii] = 0x00;
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] =
			     MSCellStrtWthCons[MSConsIndex[InpBuf[FirstPrevChrIdx]- KOKAI]]
			     		      [0x1c];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = SARA_AA; 
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	          if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
	      } else if ((SecondPrevChrIdx >= 0) &&
			(ChrType(InpBuf[SecondPrevChrIdx])== CONS) &&
			(ChrType(InpBuf[FirstPrevChrIdx])== TONE) &&
			(InpBuf[TempInpBufIndex] == SARA_AM)) {
		  if (Property)
		      for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
			    Property[i + ii] = 0x00;

		  j--;

		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] =
			    MSCellStrtWthCons[MSConsIndex[InpBuf[SecondPrevChrIdx]- KOKAI]]
					[MSNikhahitTone[InpBuf[FirstPrevChrIdx]- MAIEK]];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  j++;

		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] =
			     MSCellStrtWthCons[MSConsIndex[InpBuf[SecondPrevChrIdx]- KOKAI]]
			     		      [0x1c];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;

		  if (j < TempOutSize) {
		      if (OutBuf)
		          OutBuf[j] = SARA_AA; 
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
	      } else {
		  dummy = InpBuf[TempInpBufIndex];
		  switch (ChrType(InpBuf[TempInpBufIndex])) {

		    case  NON:
		      if ((NumeralsInp != NumeralsOut) &&
		          IsArabicThaiNumChr(InpBuf[TempInpBufIndex])) {
			  switch (NumeralsOut) {
			    case NUMERALS_NOMINAL:
			      if (IsThaiNumChr(InpBuf[TempInpBufIndex]))
				  dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
			      break;

			    case NUMERALS_NATIONAL:
			      if (IsArabicNumChr(InpBuf[TempInpBufIndex]))
				  dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
			      break;

			    case NUMERALS_CONTEXTUAL:
			      if (IsArabicNumChr(InpBuf[FirstPrevChrIdx]) &&
			          IsThaiNumChr(InpBuf[TempInpBufIndex]))
			          dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
			      else if (IsThaiNumChr(InpBuf[FirstPrevChrIdx]) &&
			      	       IsArabicNumChr(InpBuf[TempInpBufIndex]))
			      	  dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
			      break;
			  }
		      }

		    case CONS:
		    case CTRL:
		    case   LV:
		    case  FV1:
		    case  FV2:
		    case  FV3:
		      if (j < TempOutSize) {
			  if (OutBuf)
			      OutBuf[j] = dummy;
		      } else
			  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		      for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			   if (InpToOut)
			       InpToOut[i] = j;
		      if (OutToInp && (j < TempOutSize))
			  OutToInp[j] = TempInpBufIndex;
		      j++;
		      break;

		    case  BV1:
		    case  BV2:
		    case   BD:
		    case TONE:
		    case  AD1:
		    case  AD2:
		    case  AD3:
		    case  AV1:
		    case  AV2:
		    case  AV3:
		      if (j < TempOutSize) {
			  if (OutBuf)
			      OutBuf[j] = BadSeqIndicator;
		      } else
			  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		      if (OutToInp && (j < TempOutSize))
			  OutToInp[j] = TempInpBufIndex;
		      j++;
		      if (j < TempOutSize) {
			  if (OutBuf)
			      OutBuf[j] = InpBuf[TempInpBufIndex];
		      } else
			  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		      for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			   if (InpToOut)
			       InpToOut[i] = j;
		      if (OutToInp && (j < TempOutSize))
			  OutToInp[j] = TempInpBufIndex;
		      j++;
		      break;
		  }
		  /*
		   * Check E2BIG for CONS + SARA_AM
		   */
		  if (TempOutSize && (j >= TempOutSize) &&
		      (ChrType(InpBuf[TempInpBufIndex]) == CONS) &&
		      (InpBuf[IdxNextCell] == SARA_AM))
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      }
	      break;

	    case TwoChrsInCell:
	      if (ChrType(InpBuf[TempInpBufIndex]) == CONS) {

		  /*
		   * First Character in a Cell
		   */
	          if (j < TempOutSize) {
		      if ((InpBuf[TempInpBufIndex] == YOYING) &&
			   IsBelowChr(InpBuf[FirstNextChrIdx])) {
			    if (OutBuf)
				OutBuf[j] = YOYING_NOTAIL;	      
		      } else if ((InpBuf[TempInpBufIndex] == THOTHAN) &&
		  		  IsBelowChr(InpBuf[FirstNextChrIdx])) {
				    if (OutBuf)
					OutBuf[j] = THOTHAN_NOTAIL;
		      } else {
			  if (OutBuf)
			      OutBuf[j] = InpBuf[TempInpBufIndex];
		      }
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;

		  /*
		   * Second Character in a Cell
		   */
		  dummy =
		    MSCellStrtWthCons[MSConsIndex[InpBuf[TempInpBufIndex]- KOKAI]]
						 [InpBuf[FirstNextChrIdx] - MAIHUNAKAT];
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = dummy;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
		       if (InpToOut)
			   InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;

		  /*
		   * Check E2BIG for CONS + TONE + SARA_AM
		   */
		  if (TempOutSize && (j >= TempOutSize) &&
		      (ChrType(InpBuf[TempInpBufIndex]) == CONS) &&
		      (InpBuf[IdxNextCell] == SARA_AM))
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		      
	      } else {
	      
		  /*
		   * First Character in a Cell
		   */
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = BadSeqIndicator;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[TempInpBufIndex];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;


		  /*
		   * Second Character in a Cell
		   */
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[FirstNextChrIdx];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;
	      }
	      break;

	    case ThreeChrsInCell:
	    
	      /*
	       * First Character in a Cell
	       */
	      if (j < TempOutSize) {
		  if ((InpBuf[TempInpBufIndex] == YOYING) &&
		       IsBelowChr(InpBuf[FirstNextChrIdx])) {
		      if (OutBuf)
			  OutBuf[j] = YOYING_NOTAIL;	      
		  } else if ((InpBuf[TempInpBufIndex] == THOTHAN) &&
		  	      IsBelowChr(InpBuf[FirstNextChrIdx])) {
		      if (OutBuf)
			  OutBuf[j] = THOTHAN_NOTAIL;
		  } else {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[TempInpBufIndex];
		  }
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;

	      dummy =
		MSCellStrtWthCons[MSConsIndex[InpBuf[TempInpBufIndex]- KOKAI]]
				 [InpBuf[FirstNextChrIdx] - MAIHUNAKAT];
	      if (j < TempOutSize) {
		  if (OutBuf)
			  OutBuf[j] = dummy;
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = SecondNextChrIdx - FirstNextChrIdx; ii ; ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;

	      dummy =
		MSCellStrtWthOutCons[InpBuf[SecondNextChrIdx] - MAIHUNAKAT]
				    [InpBuf[FirstNextChrIdx] - MAIHUNAKAT];
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] =
			 MSCellStrtWthCons[MSConsIndex[InpBuf[TempInpBufIndex]- KOKAI]]
			 		  [dummy];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = ThirdNextChrIdx - SecondNextChrIdx; ii ; ii--,i++)
			if (InpToOut)
			    InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = SecondNextChrIdx;
	      j++;
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}


static int
BasToSF1TIS(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int                         TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    num_bytes = (InpSize == 0) ?
			(strlen((char *)InpBuf) - TempInpBufIndex) : (InpSize);

    {

	int    MBChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    MBChrLen = Thmblen((char *)(InpBuf + IdxNextChr));
	    i += MBChrLen;
	    if (MBChrLen == 0) {
		num_bytes = i;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (IsEILSEQChr(InpBuf[IdxNextChr])) {
		num_bytes = i - MBChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += MBChrLen;
		/*
		 * Due to "ShapeCharSet" is set to "TIS620.2533"
		 * instead of "TIS620.2533-0"
		 */
		if (IsDisplayTypeChr(InpBuf[TempIdxNextChr], 
				     InpBuf[IdxNextChr]) == SHOW_NEXT_CELL) {
		    if ((ChrType(InpBuf[IdxNextChr]) != CTRL) &&
			(ChrType(InpBuf[IdxNextChr]) != NON) &&
			(ChrType(InpBuf[IdxNextChr]) != CONS) &&
			(ChrType(InpBuf[IdxNextChr]) != LV) &&
			(ChrType(InpBuf[IdxNextChr]) != FV1) &&
			(ChrType(InpBuf[IdxNextChr]) != FV2) &&
			(ChrType(InpBuf[IdxNextChr]) != FV3)) {
			num_bytes = i;
			errno = EILSEQ;
			result = -1;
			break;
		    }
		}
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ; ) {

	int		ii;
	int		TempIdxNextCell;
	int		IdxNextCell;
	int		nChrsInCell = OneChrInCell;
	unsigned char	dummy;
	
	
	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += Thmblen((char *) (InpBuf + TempInpBufIndex));
	FirstNextChrIdx = IdxNextCell;

	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeChr(InpBuf[TempIdxNextCell],
	       			 InpBuf[IdxNextCell]) == SHOW_CURR_CELL)) {
	    if (Property)
		for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;
	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += Thmblen((char *) (InpBuf + IdxNextCell));
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {
	  case OneChrInCell:
	    dummy = InpBuf[TempInpBufIndex];
	    switch (ChrType(InpBuf[TempInpBufIndex])) {

	      case  NON:
		if ((NumeralsInp != NumeralsOut) &&
		     IsArabicThaiNumChr(InpBuf[TempInpBufIndex])) {
		     switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumChr(InpBuf[FirstPrevChrIdx]) &&
			      IsThaiNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
			  else if (IsThaiNumChr(InpBuf[FirstPrevChrIdx]) &&
			      	   IsArabicNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
			  break;
		      }
		 }
		 
	      case CTRL:
	      case CONS:
	      case   LV:
	      case  FV1:
	      case  FV2:
	      case  FV3:
		 if (j < TempOutSize) {
		     if (OutBuf)
			 OutBuf[j] = dummy;
		 } else
		     IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		 for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--, i++)
		      if (InpToOut)
			  InpToOut[i] = j;
		 if (OutToInp && (j < TempOutSize))
		     OutToInp[j] = TempInpBufIndex;
		 j++;
		 break;

	     case  BV1:
	     case  BV2:
	     case   BD:
	     case TONE:
	     case  AD1:
	     case  AD2:
	     case  AD3:
	     case  AV1:
	     case  AV2:
	     case  AV3:
	       if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = BadSeqIndicator;
	       } else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	       if (OutToInp && (j < TempOutSize))
		   OutToInp[j] = TempInpBufIndex;
	       j++;
	       dummy = InpBuf[TempInpBufIndex];
	       break;	      
	    }
	    break;
	    

	  /*
	   * These two cases shouldn't be happended.
	   */
	  case TwoChrsInCell:
	  case ThreeChrsInCell:
	    fprintf(stderr, "\nLeak in the algorithism [BasToSF1TIS]\n");
	    break;

	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}


static int
BasToSF1TIS_0(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int                         TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    num_bytes = (InpSize == 0) ?(strlen((char *)InpBuf) - TempInpBufIndex) : (InpSize);

    {

	int    MBChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    MBChrLen = Thmblen((char *)(InpBuf + IdxNextChr));
	    i += MBChrLen;
	    if (MBChrLen == 0) {
		num_bytes = i;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (IsEILSEQChr(InpBuf[IdxNextChr])) {
		num_bytes = i - MBChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += MBChrLen;
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ; ) {

	int		ii;
	int		TempIdxNextCell;
	int		IdxNextCell;
	int		nChrsInCell = OneChrInCell;
	unsigned char	dummy;
	
	
	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += Thmblen((char *) (InpBuf + TempInpBufIndex));
	FirstNextChrIdx = IdxNextCell;

	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeChr(InpBuf[TempIdxNextCell],
	       			 InpBuf[IdxNextCell]) == SHOW_CURR_CELL)) {
	    if (Property)
		for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0 ) ? DISPLAYCELL_MASK : 0x00;
	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += Thmblen((char *) (InpBuf + IdxNextCell));
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		    Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {
	  case OneChrInCell:
	    dummy = InpBuf[TempInpBufIndex];
	    switch (ChrType(InpBuf[TempInpBufIndex])) {

	      case  NON:
		if ((NumeralsInp != NumeralsOut) &&
		     IsArabicThaiNumChr(InpBuf[TempInpBufIndex])) {
		     switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumChr(InpBuf[FirstPrevChrIdx]) &&
			      IsThaiNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToArabicNumChr(InpBuf[TempInpBufIndex]);
			  else if (IsThaiNumChr(InpBuf[FirstPrevChrIdx]) &&
			      	   IsArabicNumChr(InpBuf[TempInpBufIndex]))
			      dummy = ToThaiNumChr(InpBuf[TempInpBufIndex]);
			  break;
		     }
		}
		 
	      case CTRL:
	      case CONS:
	      case   LV:
	      case  FV1:
	      case  FV2:
	      case  FV3:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = dummy;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = TempInpBufIndex;
		j++;
		break;

	      case  BV1:
	      case  BV2:
	      case   BD:
	      case TONE:
	      case  AD1:
	      case  AD2:
	      case  AD3:
	      case  AV1:
	      case  AV2:
	      case  AV3:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = BadSeqIndicator;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = TempInpBufIndex;
		j++;
		dummy = InpBuf[TempInpBufIndex];
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = dummy;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = TempInpBufIndex;
		j++;
		break;	      
	    }
	    break;
	    
	  case TwoChrsInCell:
	    /*
	     * First Char in a Cell
	     */
	    switch (ChrType(InpBuf[TempInpBufIndex])) {
	      case  BV1:
	      case  BV2:
	      case   BD:
	      case TONE:
	      case  AD1:
	      case  AD2:
	      case  AD3:
	      case  AV1:
	      case  AV2:
	      case  AV3:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = BadSeqIndicator;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = TempInpBufIndex;
		j++;
		
	        default:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = InpBuf[TempInpBufIndex];
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = TempInpBufIndex;
		j++;
		break;
	    }

	    /*
	     * Second Char in a Cell
	     */
	    switch (ChrType(InpBuf[FirstNextChrIdx])) {
	      case  BV1:
	      case  BV2:
	      case   BD:
	      case TONE:
	      case  AD1:
	      case  AD2:
	      case  AD3:
	      case  AV1:
	      case  AV2:
	      case  AV3:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = BadSeqIndicator;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = FirstNextChrIdx;
		j++;
		
	        default:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = InpBuf[FirstNextChrIdx];
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = SecondNextChrIdx - FirstNextChrIdx; ii ; ii--, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = FirstNextChrIdx;
		j++;
		break;
	    }
	    break;

	  case ThreeChrsInCell:
	    /*
	     * First Char in a Cell
	     */
	    switch (ChrType(InpBuf[TempInpBufIndex])) {
	    
	      /*
	       * Should not happend.
	       */
	      case  BV1:
	      case  BV2:
	      case   BD:
	      case TONE:
	      case  AD1:
	      case  AD2:
	      case  AD3:
	      case  AV1:
	      case  AV2:
	      case  AV3:
		fprintf(stderr, "\nLeak in the algorithism [BasToSF1TIS_0]\n");
		
	        default:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = InpBuf[TempInpBufIndex];
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = TempInpBufIndex;
		j++;
		break;
	    }

	    /*
	     * Second Char in a Cell
	     */
	    switch (ChrType(InpBuf[FirstNextChrIdx])) {
	      case  BV1:
	      case  BV2:
	      case   BD:
	      case TONE:
	      case  AD1:
	      case  AD2:
	      case  AD3:
	      case  AV1:
	      case  AV2:
	      case  AV3:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = BadSeqIndicator;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = FirstNextChrIdx;
		j++;
		
		default:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = InpBuf[TempInpBufIndex];
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = SecondNextChrIdx - FirstNextChrIdx; ii ; ii--, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = FirstNextChrIdx;
		j++;
		break;
	    }
	    
	    /*
	     * Third Char in a Cell
	     */
	    switch (ChrType(InpBuf[SecondNextChrIdx])) {
	      case  BV1:
	      case  BV2:
	      case   BD:
	      case TONE:
	      case  AD1:
	      case  AD2:
	      case  AD3:
	      case  AV1:
	      case  AV2:
	      case  AV3:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = BadSeqIndicator;
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = SecondNextChrIdx;
		j++;
		
		default:
		if (j < TempOutSize) {
		    if (OutBuf)
			OutBuf[j] = InpBuf[TempInpBufIndex];
		} else
		    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		for (ii = ThirdNextChrIdx - SecondNextChrIdx; ii ; ii--, i++)
		     if (InpToOut)
			 InpToOut[i] = j;
		if (OutToInp && (j < TempOutSize))
		    OutToInp[j] = SecondNextChrIdx;
		j++;
		break;
	    }
	    break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);

}

static int
SFTIS_0ToBas(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;
	
    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;
    if (layout_obj->core.text_shaping->inp == TEXT_NOMINAL)
	ShpSiz = 1;

    num_bytes = (InpSize == 0) ?
		(ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    /* find out the num_bytes */
    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ; ) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);
	FirstNextChrIdx = IdxNextCell;

	/*
	 * ii is marked as the boundary cell.
	 */
	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
	       	&InpBuf[IdxNextCell],ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {
	    case OneChrInCell:
	      /*
	       * First Shape in a Cell
	       */
	      if ((FirstPrevChrIdx >= 0) &&
		  IsFirstPartSaraAm(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
		  IsSecondPartSaraAm(&InpBuf[TempInpBufIndex], ShpSiz)) {

		    int	nikhahit_idx;

		    j--;
		    if (j < TempOutSize) {
			if (OutBuf)
			    OutBuf[j] = SARA_AM;
		    } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		    for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		    if (OutToInp && (j < TempOutSize))
			OutToInp[j] = TempInpBufIndex;
		    j++;
		    /*
		     *	Need to set Property[NIKHAHIT] to 0
		     */
		    nikhahit_idx = i - (IdxNextCell - FirstPrevChrIdx);
		    for (ii = 0;FirstPrevChrIdx + ii < TempInpBufIndex ; ii++)
			if (Property)
			    Property[nikhahit_idx + ii] = 0x00;
	      } else {
	      	    switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
	      	      case  NON:
			dummy =  TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz);
			if ((NumeralsInp != NumeralsOut) &&
			    IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
			    switch (NumeralsOut) {
			      case NUMERALS_NOMINAL:
				if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				    dummy = ToArabicNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
				break;

			      case NUMERALS_NATIONAL:
				if (IsArabicNumShp(&InpBuf[TempInpBufIndex],ShpSiz))
				    dummy = ToThaiNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
				break;

			      case NUMERALS_CONTEXTUAL:
				if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				    IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				    dummy = ToArabicNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
				else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
					 IsArabicNumShp(InpBuf[TempInpBufIndex], ShpSiz))
				    dummy = ToThaiNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
				break;
			    }
			}
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[i] = dummy;
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
			break;
			      	      
		      case CONS:
		      case CTRL:
		      case   LV:
		      case  FV1:
		      case  FV2:
		      case  FV3:
		      case  BV1:
		      case  BV2:
		      case   BD:
		      case TONE:
		      case  AD1:
		      case  AD2:
		      case  AD3:
		      case  AV1:
		      case  AV2:
		      case  AV3:
		      case SBV1:
		      case SBV2:
		      case  SBD:
		      case STON:
		      case SAD1:
		      case SAD2:
		      case SAD3:
		      case SAV1:
		      case SAV2:
		      case SAV3:
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz);
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);

			for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			    if (InpToOut)
				InpToOut[i] = j;
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = TempInpBufIndex;
			j++;
			break;
		    }
	      }
	      break;

	    case TwoChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[TempInpBufIndex], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;
	      
	      /*
	       * Second Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;
	      break;
	    
	    case ThreeChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[TempInpBufIndex], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;
	      
	      /*
	       * Second Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;
	      
	      /*
	       * Third Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[SecondNextChrIdx], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = SecondNextChrIdx; ii < ThirdNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = SecondNextChrIdx;
	      j++;
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SF1TIS_0ToBas(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;
    if (layout_obj->core.text_shaping->inp == TEXT_NOMINAL)
	ShpSiz = 1;

    num_bytes = (InpSize == 0) ?(ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		/*
		 * Due to InpBuf is set to "TEXT_SHAPE1"
		 * which means that InpBuf should contain only spacing shapes.
		 */
		if (IsDisplayTypeShp(&InpBuf[TempIdxNextChr], 
				     &InpBuf[IdxNextChr], ShpSiz) == SHOW_CURR_CELL) {
		    num_bytes = i;
		    errno = EILSEQ;
		    result = -1;
		    break;
		}
		TempIdxNextChr = IdxNextChr;
	    } else
	        IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ; ) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);
	FirstNextChrIdx = IdxNextCell;

	/*
	 * ii is marked as the boundary cell.
	 */
	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
		&InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {
	    case OneChrInCell:
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
		case  NON:
		  dummy =  TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz);
		  if ((NumeralsInp != NumeralsOut) &&
			IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
			switch (NumeralsOut) {
			  case NUMERALS_NOMINAL:
			    if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				dummy = ToArabicNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
			    break;

			  case NUMERALS_NATIONAL:
			    if (IsArabicNumShp(&InpBuf[TempInpBufIndex],ShpSiz))
				dummy = ToThaiNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
			    break;

			  case NUMERALS_CONTEXTUAL:
			    if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				dummy = ToArabicNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
			    else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				     IsArabicNumShp(InpBuf[TempInpBufIndex], ShpSiz))
				dummy = ToThaiNumChr(TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz));
			    break;
			}
		  }
		  if (j < TempOutSize) {
			if (OutBuf)
			    OutBuf[i] = dummy;
		  } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  break;
			      	      
		case CONS:
		case CTRL:
		case   LV:
		case  FV1:
		case  FV2:
		case  FV3:
		case SBV1:
		case SBV2:
		case  SBD:
		case STON:
		case SAD1:
		case SAD2:
		case SAD3:
		case SAV1:
		case SAV2:
		case SAV3:
		  if (j < TempOutSize) {
			if (OutBuf)
			    OutBuf[j] = TIS_0ToBas(&InpBuf[TempInpBufIndex],ShpSiz);
		  } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);

		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  break;
			
		case  BV1:
		case  BV2:
		case   BD:
		case TONE:
		case  AD1:
		case  AD2:
		case  AD3:
		case  AV1:
		case  AV2:
		case  AV3:
		  fprintf(stderr, "\nLeak in the algorithism [SF1TIS_0ToBas]\n");
		  break;
	      }
	      break;

	    case TwoChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[TempInpBufIndex], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;
	      
	      /*
	       * Second Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;
	      break;
	    
	    case ThreeChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[TempInpBufIndex], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;
	      
	      /*
	       * Second Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;
	      
	      /*
	       * Third Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] = TIS_0ToBas(&InpBuf[SecondNextChrIdx], ShpSiz);
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  
	      for (ii = SecondNextChrIdx; ii < ThirdNextChrIdx; ii++, i++)
		  if (InpToOut)
		      InpToOut[i] = j;

	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = SecondNextChrIdx;
	      j++;
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SFToSFTIS(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;
	
    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ?(ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		/*
		 * "ShapeCharSet" is set to "TIS620.2533" and
		 * InpBuf is set to "TEXT_SHAPE". So InpBuf should not
		 * have spacing non-spacing glyphs.
		 */
		if (IsDisplayTypeShp(&InpBuf[TempIdxNextChr],
				     &InpBuf[IdxNextChr], ShpSiz) == SHOW_NEXT_CELL) {
		    if ((ShpType(&InpBuf[IdxNextChr], ShpSiz) != CTRL) &&
			(ShpType(&InpBuf[IdxNextChr], ShpSiz) != NON) &&
			(ShpType(&InpBuf[IdxNextChr], ShpSiz) != CONS) &&
			(ShpType(&InpBuf[IdxNextChr], ShpSiz) != LV) &&
			(ShpType(&InpBuf[IdxNextChr], ShpSiz) != FV1) &&
			(ShpType(&InpBuf[IdxNextChr], ShpSiz) != FV2) &&
			(ShpType(&InpBuf[IdxNextChr], ShpSiz) != FV3)) {
			num_bytes = i;
			errno = EILSEQ;
			result = -1;
			break;
		    }
		}
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ;) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);

	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
		&InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;


	switch (nChrsInCell) {
	    case OneChrInCell:
	    
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
		case  NON:
		  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		  if ((NumeralsInp != NumeralsOut) &&
		      IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
		      switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
			      IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				   IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;
		      }
		  }
		  for (ii = ShpSiz; ii ; ii--, i++, j++) {
		       if (j < TempOutSize) {
			   if (OutBuf)
			       OutBuf[j] = (dummy >> ((ii - 1) * 8));
		       } else
			   IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		       if (InpToOut)
			   InpToOut[i] = j;
		       if (OutToInp && (j < TempOutSize))
			   OutToInp[j] = ii;
		  }
		  break;
	      
		  default:
		    for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++, j++) {
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
			if (InpToOut)
			    InpToOut[i] = j;
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		    }
		    break;
	      }
	    
	    case TwoChrsInCell:
	    case ThreeChrsInCell:
	      /*
	       * First, Second, [Third] Shape in a Cell
	       */
	      for (ii = TempInpBufIndex; ii < IdxNextCell; ii++, i++, j++) {
		   if (j < TempOutSize) {
		       if (OutBuf)
			   OutBuf[j] = InpBuf[ii];
		   } else
		       IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		   if (InpToOut)
		       InpToOut[i] = j;
		   if (OutToInp && (j < TempOutSize))
		       OutToInp[j] = ii;
	      }
	      break;
	}


	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SFToSFTIS_0(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;


    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ?(ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ;) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);

	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
		&InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;


	switch (nChrsInCell) {
	    case OneChrInCell:
	    
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
		case  NON:
		  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		  if ((NumeralsInp != NumeralsOut) &&
		      IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
		      switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
			      IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				   IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;
		      }
		  }
		  for (ii = ShpSiz; ii ; ii--, i++, j++) {
		       if (j < TempOutSize) {
			   if (OutBuf)
			       OutBuf[j] = (dummy >> ((ii - 1) * 8));
		       } else
			   IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		       if (InpToOut)
			   InpToOut[i] = j;
		       if (OutToInp && (j < TempOutSize))
			   OutToInp[j] = ii;
		  }
		  break;
	      
		  default:
		    for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++, j++) {
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
			if (InpToOut)
			    InpToOut[i] = j;
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		    }
		    break;
	      }
	    
	    case TwoChrsInCell:
	    case ThreeChrsInCell:
	      for (ii = TempInpBufIndex; ii < IdxNextCell; ii++, i++, j++) {
		   if (j < TempOutSize) {
		       if (OutBuf)
			   OutBuf[j] = InpBuf[ii];
		   } else
		       IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		   if (InpToOut)
		       InpToOut[i] = j;
		   if (OutToInp && (j < TempOutSize))
		       OutToInp[j] = ii;
	      }
	      break;
	}


	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SFToSF1TIS(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ? *InpBufIndex : 0;
    int				TempOutSize = OutSize ? *OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;
	
    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ? (ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		switch (ShpType(&InpBuf[IdxNextChr], ShpSiz)) {
		  case  BV1:
		  case  BV2:
		  case   BD:
		  case TONE:
		  case  AD1:
		  case  AD2:
		  case  AD3:
		  case  AV1:
		  case  AV2:
		  case  AV3:
		    num_bytes = i;
		    errno = EILSEQ;
		    result = -1;
		    break;
		}		
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ;) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;


	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);

	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
	        &InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {
	    case OneChrInCell:
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
		case  NON:
		  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		  if ((NumeralsInp != NumeralsOut) &&
		      IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
		      switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
			      IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				   IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;
		      }
		  }
		  for (ii = ShpSiz; ii ; ii--, i++, j++) {
		       if (j < TempOutSize) {
			   if (OutBuf)
			       OutBuf[j] = (dummy >> ((ii - 1) * 8));
		       } else
			   IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		       if (InpToOut)
			   InpToOut[i] = j;
		       if (OutToInp && (j < TempOutSize))
			   OutToInp[j] = ii;
		  }
		  break;
	      
		  default:
		    for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++, j++) {
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
			if (InpToOut)
			    InpToOut[i] = j;
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		    }
		    break;
	      }
	      break;
	    
	    case TwoChrsInCell:
	    case ThreeChrsInCell:
	      fprintf(stderr, "\nLeak in the algorithism [SFToSF1TIS]\n");
	      break;
	}


	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SFToSF1TIS_0(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ? *InpBufIndex : 0;
    int				TempOutSize = OutSize ? *OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;
	
    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ? (ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ;) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;


	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);

	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
	        &InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {
	    case OneChrInCell:
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
		case  NON:
		  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		  if ((NumeralsInp != NumeralsOut) &&
		      IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
		      switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
			      IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				   IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;
		      }
		  }
		  for (ii = ShpSiz; ii ; ii--, i++, j++) {
		       if (j < TempOutSize) {
			   if (OutBuf)
			       OutBuf[j] = (dummy >> ((ii - 1) * 8));
		       } else
			   IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		       if (InpToOut)
			   InpToOut[i] = j;
		       if (OutToInp && (j < TempOutSize))
			   OutToInp[j] = ii;
		  }
		  break;
	      
		  default:
		    for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++, j++) {
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
			if (InpToOut)
			    InpToOut[i] = j;
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		    }
		    break;
	      }
	      break;
	    
	    case TwoChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      
		case  NON:
		  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		  if (dummy == YOYING_NOTAIL)
		      dummy = YOYING;
		  else if (dummy == THOTHAN_NOTAIL)
		      dummy = THOTHAN;
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = dummy;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;		  
		  break;
		  
		case  BV1:
		case  BV2:
		case   BD:
		case TONE:
		case  AD1:
		case  AD2:
		case  AD3:
		case  AV1:
		case  AV2:
		case  AV3:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = BadSeqIndicator;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		
		  default:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[TempInpBufIndex];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  break;
	      }

	      /*
	       * Second Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[FirstNextChrIdx], ShpSiz)) {
		  
		case  BV1:
		case  BV2:
		case   BD:
		case TONE:
		case  AD1:
		case  AD2:
		case  AD3:
		case  AV1:
		case  AV2:
		case  AV3:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = BadSeqIndicator;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;
		
		  default:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[FirstNextChrIdx];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = FirstNextChrIdx; ii < SecondNextChrIdx ; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;
		  break;
	      }
	      break;

	    case ThreeChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
		  
		case  BV1:
		case  BV2:
		case   BD:
		case TONE:
		case  AD1:
		case  AD2:
		case  AD3:
		case  AV1:
		case  AV2:
		case  AV3:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = BadSeqIndicator;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		
		  default:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[TempInpBufIndex];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  break;
	      }

	      /*
	       * Second Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[FirstNextChrIdx], ShpSiz)) {
		  
		case  BV1:
		case  BV2:
		case   BD:
		case TONE:
		case  AD1:
		case  AD2:
		case  AD3:
		case  AV1:
		case  AV2:
		case  AV3:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = BadSeqIndicator;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;
		
		  default:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[FirstNextChrIdx];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = FirstNextChrIdx; ii < SecondNextChrIdx ; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;
		  break;
	      }

	      /*
	       * Third Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[SecondNextChrIdx], ShpSiz)) {
		  
		case  BV1:
		case  BV2:
		case   BD:
		case TONE:
		case  AD1:
		case  AD2:
		case  AD3:
		case  AV1:
		case  AV2:
		case  AV3:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = BadSeqIndicator;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = SecondNextChrIdx;
		  j++;
		
		  default:
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[SecondNextChrIdx];
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = SecondNextChrIdx; ii < IdxNextCell ; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = SecondNextChrIdx;
		  j++;
		  break;
	      }
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SF1ToSFTIS(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ?(ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
                num_bytes = i - ShpChrLen;
                errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		switch (ShpType(&InpBuf[IdxNextChr], ShpSiz)) {
		  case  BV1:
		  case  BV2:
		  case   BD:
		  case TONE:
		  case  AD1:
		  case  AD2:
		  case  AD3:
		  case  AV1:
		  case  AV2:
		  case  AV3:
		    num_bytes = i;
		    errno = EILSEQ;
		    result = -1;
		    break;
		}
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i < num_bytes ;) {

	int	ii;
	int	dummy;
	int	TempIdxNextCell;
	int	IdxNextCell;
	int	nChrsInCell = OneChrInCell;
	int	ShpChrLen;


	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	ShpChrLen = ShpLen(InpBuf + TempInpBufIndex, ShpSiz);
	IdxNextCell += ShpChrLen;
	FirstNextChrIdx = IdxNextCell;

	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	      (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
	       &InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {

	    if (Property)
                for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		     Property[i + ii] =(ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
            IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
                for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		     Property[i + ii] =(ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {

	    case OneChrInCell:
	      if ((FirstPrevChrIdx >= 0) &&
                  (ShpType(&InpBuf[FirstPrevChrIdx], ShpSiz) == CONS)
		  && (Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz) == SARA_AM)) {
		  ii = 0;
		  if (Property)
                      for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
			   Property[i + ii] = 0x00;
		  if (j < TempOutSize) {
		      if (OutBuf)
                          OutBuf[j] = MSCellStrtWthCons[MSConsIndex[
					Strm2Int(&InpBuf[FirstPrevChrIdx], ShpSiz)
                                        - KOKAI]][0x1c];
		  } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
                  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
                       if (InpToOut)
                           InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  if (j < TempOutSize) {
		      if (OutBuf)
                          OutBuf[j] = SARA_AA; 
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	          if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
	      } else {
                  switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {

		    case SBV1:
		    case SBV2:
		    case  SBD:
		    case STON:
		    case SAD1:
		    case SAD2:
		    case SAD3:
		    case SAV1:
		    case SAV2:
		    case SAV3:
		      fprintf(stderr, "\nLeak in the algorithism [SF1ToSFTIS]\n");
		      break;

		    case  NON:
		      dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		      if ((NumeralsInp != NumeralsOut) &&
			  IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {

			  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
			  switch (NumeralsOut) {
			    case NUMERALS_NOMINAL:
			      if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      break;

			    case NUMERALS_NATIONAL:
			      if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      break;

			    case NUMERALS_CONTEXTUAL:
			      if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				  IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				       IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      break;
			  }
			  for (ii = ShpSiz; ii ; ii--, i++, j++) {
				if (InpToOut)
				    InpToOut[i] = j;
				if (j < TempOutSize) {
				    if (OutBuf)
					OutBuf[j] = (dummy >> ((ii - 1) * 8));
				} else
				    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);	      
				if (OutToInp && (j < TempOutSize))
				    OutToInp[j] = ii;
			  }
			  break;
		      }

		    case CTRL:
		    case CONS:
		    case   LV:
		    case  FV1:
		    case  FV2:
		    case  FV3:
		      for (ii = TempInpBufIndex; ii < IdxNextCell; ii++, i++, j++) {
			    if (InpToOut)
				InpToOut[i] = j;
			    if (j < TempOutSize) {
				if (OutBuf)
				    OutBuf[j] = InpBuf[ii];
			    } else
				IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);	      
			    if (OutToInp && (j < TempOutSize))
				OutToInp[j] = ii;
		      }
		      break;
		  }
	      }
	      break;

	    case TwoChrsInCell:
	    case ThreeChrsInCell:
	      fprintf(stderr, "\nLeak in the algorithism [SF1ToSFTIS]\n");
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SF1ToSFTIS_0(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ?*InpBufIndex : 0;
    int				TempOutSize = OutSize ?*OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ?(ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
                num_bytes = i - ShpChrLen;
                errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i < num_bytes ;) {

	int	ii;
	int	dummy;
	int	TempIdxNextCell;
	int	IdxNextCell;
	int	nChrsInCell = OneChrInCell;
	int	ShpChrLen;


	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	ShpChrLen = ShpLen(InpBuf + TempInpBufIndex, ShpSiz);
	IdxNextCell += ShpChrLen;
	FirstNextChrIdx = IdxNextCell;

	ii = 0;
	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
	        &InpBuf[IdxNextCell], ShpSiz) == SHOW_CURR_CELL)) {

	    if (Property)
                for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		     Property[i + ii] =(ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
            IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
                for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		     Property[i + ii] =(ii == 0) ? DISPLAYCELL_MASK : 0x00;

	switch (nChrsInCell) {

	    case OneChrInCell:
	      if ((FirstPrevChrIdx >= 0) &&
                  (ShpType(&InpBuf[FirstPrevChrIdx], ShpSiz) == CONS)
		  && (Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz) == SARA_AM)) {
		  ii = 0;
		  if (Property)
                      for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
			   Property[i + ii] = 0x00;
		  if (j < TempOutSize) {
		      if (OutBuf)
                          OutBuf[j] = MSCellStrtWthCons[MSConsIndex[
					Strm2Int(&InpBuf[FirstPrevChrIdx], ShpSiz)
                                        - KOKAI]][0x1c];
		  } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
                  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
                       if (InpToOut)
                           InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  if (j < TempOutSize) {
		      if (OutBuf)
                          OutBuf[j] = SARA_AA; 
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	          if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
	      } else if ((SecondPrevChrIdx >= 0) &&
                        (ShpType(&InpBuf[SecondPrevChrIdx], ShpSiz)== CONS) &&
                        (ShpType(&InpBuf[FirstPrevChrIdx], ShpSiz)== STON) &&
			(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz)== SARA_AM)) {
		  if (Property)
                      for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
			   Property[i + ii] = 0x00;
		  j--;

		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] =
                                MSCellStrtWthCons[MSConsIndex[
				   Strm2Int(&InpBuf[SecondPrevChrIdx], ShpSiz)
				   - KOKAI]]
                                  [MSNikhahitTone[TIS_0ToBas(&InpBuf[FirstPrevChrIdx], ShpSiz)
                                   - MAIEK]];
		  } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  j++;
		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] =
                                MSCellStrtWthCons[MSConsIndex[
				   Strm2Int(&InpBuf[SecondPrevChrIdx], ShpSiz)
                                   - KOKAI]][0x1c];
		  } else
			IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
                  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
                            InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
		  if (j < TempOutSize) {
		      if (OutBuf)
                          OutBuf[j] = SARA_AA; 
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;
	      } else {
                  switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {

		    case  NON:
		      dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		      if ((NumeralsInp != NumeralsOut) &&
			  IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {

			  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
			  switch (NumeralsOut) {
			    case NUMERALS_NOMINAL:
			      if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      break;

			    case NUMERALS_NATIONAL:
			      if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      break;

			    case NUMERALS_CONTEXTUAL:
			      if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				  IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				       IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
				  dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			      break;
			  }
			  for (ii = ShpSiz; ii ; ii--, i++, j++) {
				if (InpToOut)
				    InpToOut[i] = j;
				if (j < TempOutSize) {
				    if (OutBuf)
					OutBuf[j] = (dummy >> ((ii - 1) * 8));
				} else
				    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);	      
				if (OutToInp && (j < TempOutSize))
				    OutToInp[j] = ii;
			  }
			  break;
		      }

		    case CTRL:
		    case CONS:
		    case   LV:
		    case  FV1:
		    case  FV2:
		    case  FV3:
		    case SBV1:
		    case SBV2:
		    case  SBD:
		    case STON:
		    case SAD1:
		    case SAD2:
		    case SAD3:
		    case SAV1:
		    case SAV2:
		    case SAV3:
		      for (ii = TempInpBufIndex; ii < IdxNextCell; ii++, i++, j++) {
			    if (InpToOut)
				InpToOut[i] = j;
			    if (j < TempOutSize) {
				if (OutBuf)
				    OutBuf[j] = InpBuf[ii];
			    } else
				IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);	      
			    if (OutToInp && (j < TempOutSize))
				OutToInp[j] = ii;
		      }
		      break;
		  }
	      }
	      break;

	    case TwoChrsInCell:
	      if (ShpType(&InpBuf[TempInpBufIndex], ShpSiz) == CONS) {
	      
	          if (j < TempOutSize) {
	              if ((ShpType(&InpBuf[TempInpBufIndex], ShpSiz) == YOYING) &&
			  (IsBelowShp(&InpBuf[FirstNextChrIdx], ShpSiz))) {
			    if (OutBuf)
				OutBuf[j] = YOYING_NOTAIL;
	              } else if ((ShpType(&InpBuf[TempInpBufIndex], ShpSiz) == THOTHAN) &&
				 (IsBelowShp(&InpBuf[FirstNextChrIdx], ShpSiz))) {
				 OutBuf[j] = THOTHAN_NOTAIL;
	              } else {
			  if (OutBuf)
			      OutBuf[j] = InpBuf[TempInpBufIndex];
		      }
	          } else
	              IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = TempInpBufIndex;
		  j++;

		  dummy =
		    MSCellStrtWthCons[MSConsIndex[
			       Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz)
			       - KOKAI]]
			      [TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz)
			       - MAIHUNAKAT];

		  if (j < TempOutSize) {
		      if (OutBuf)
			  OutBuf[j] = dummy;
		  } else
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		  for (ii = FirstNextChrIdx; ii < SecondNextChrIdx; ii++, i++)
		       if (InpToOut)
			   InpToOut[i] = j;
		  if (OutToInp && (j < TempOutSize))
		      OutToInp[j] = FirstNextChrIdx;
		  j++;

		  /*
		   * Check E2BIG for CONS + TONE + SARA_AM
		   */
		  if (TempOutSize && (j >= TempOutSize) &&
		      (ShpType(&InpBuf[TempInpBufIndex], ShpSiz) == CONS) &&
		      (Strm2Int(&InpBuf[IdxNextCell], ShpSiz) == SARA_AM))
		      IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);

	      } else {

		  /*
		   * First Shape in a Cell
		   */
		  for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++, j++) {
			if (InpToOut)
			    InpToOut[i] = j;
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);	      
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		  }

		  /*
		   * Second Shape in a Cell
		   */
		  for (ii = ShpSiz; ii ; ii--, i++)
			if (InpToOut)
			    InpToOut[i] = j;
		  for (ii = FirstNextChrIdx + ShpSiz; ii < IdxNextCell; ii++, i++, j++) {
			if (InpToOut)
			    InpToOut[i] = j;
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);	      
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		  }
	      }
	      break;

	    case ThreeChrsInCell:
	      /*
	       * First Shape in a Cell
	       */
	      if (j < TempOutSize) {
		  if ((Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz) == YOYING) &&
		      (IsBelowShp(&InpBuf[FirstNextChrIdx], ShpSiz))) {
		      if (OutBuf)
			  OutBuf[j] = YOYING_NOTAIL;	      
		  } else if ((Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz) == THOTHAN) &&
		  	     (IsBelowShp(&InpBuf[FirstNextChrIdx], ShpSiz))) {
		      if (OutBuf)
			  OutBuf[j] = THOTHAN_NOTAIL;
		  } else {
		      if (OutBuf)
			  OutBuf[j] = InpBuf[TempInpBufIndex];
		  }
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = FirstNextChrIdx - TempInpBufIndex; ii ; ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = TempInpBufIndex;
	      j++;

	      /*
	       * Second Shape in a Cell
	       */
	      dummy =
		MSCellStrtWthCons[MSConsIndex[
			   Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz)
			   - KOKAI]]
			  [TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz)
			   - MAIHUNAKAT];

	      if (j < TempOutSize) {
		  if (OutBuf)
			  OutBuf[j] = dummy;
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = SecondNextChrIdx - FirstNextChrIdx; ii ; ii--,i++)
		   if (InpToOut)
		       InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = FirstNextChrIdx;
	      j++;

	      /*
	       * Third Shape in a Cell
	       */
	      dummy =
		MSCellStrtWthOutCons[TIS_0ToBas(&InpBuf[SecondNextChrIdx], ShpSiz)
			   - MAIHUNAKAT]
			  [TIS_0ToBas(&InpBuf[FirstNextChrIdx], ShpSiz)
			   - MAIHUNAKAT];
	      if (j < TempOutSize) {
		  if (OutBuf)
		      OutBuf[j] =
			 MSCellStrtWthCons[MSConsIndex[
			 	       Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz)
				       - KOKAI]][dummy];
	      } else
		  IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
	      for (ii = ThirdNextChrIdx - SecondNextChrIdx; ii ; ii--,i++)
			if (InpToOut)
			    InpToOut[i] = j;
	      if (OutToInp && (j < TempOutSize))
		  OutToInp[j] = SecondNextChrIdx;
	      j++;
	      break;
	}

	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    SecondPrevChrIdx = FirstPrevChrIdx;
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    SecondPrevChrIdx = TempInpBufIndex;
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    SecondPrevChrIdx = FirstNextChrIdx;
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static int
SF1ToSF1(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    unsigned char		*InpBuf;
    size_t			InpSize;
    unsigned char		*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				result = 0;
    int				i, j;
    int				num_bytes;
    int				TempInpBufIndex = InpBufIndex ? *InpBufIndex : 0;
    int				TempOutSize = OutSize ? *OutSize : 0;
    int				ShpSiz;
    LayoutDesc			NumeralsInp = layout_obj->core.numerals->inp;
    LayoutDesc			NumeralsOut = layout_obj->core.numerals->out;
    int				nByteCompTranStr = 0;
    int				InpBufIndexCompStr = TempInpBufIndex;
    int				IsOutBufNotEnough = FALSE;
    int				FirstPrevChrIdx = -1;
    int				SecondPrevChrIdx = -1;
    int				FirstNextChrIdx = 0;
    int				SecondNextChrIdx = 0;
    int				ThirdNextChrIdx = 0;

    errno = 0;
    ShpSiz = layout_obj->core.shape_charset_size;

    num_bytes = (InpSize == 0) ? (ShpStrlen(InpBuf, ShpSiz) - TempInpBufIndex) : (InpSize);

    {

	int    ShpChrLen = 0;
	int    TempIdxNextChr = TempInpBufIndex;
	int    IdxNextChr = TempInpBufIndex;

	i = 0;
	while (i < num_bytes) {
	    ShpChrLen = ShpLen(InpBuf + IdxNextChr, ShpSiz);
	    i += ShpChrLen;
	    if (ShpChrLen == 0) {
		TempIdxNextChr = IdxNextChr;
		IdxNextChr += ShpSiz;
		i += ShpSiz;
	    } else if (IsEILSEQShp(&InpBuf[IdxNextChr], ShpSiz)) {
		num_bytes = i - ShpChrLen;
		errno = EILSEQ;
		result = -1;
		IdxNextChr = TempIdxNextChr;
		break;
	    } else if (i < num_bytes) {
		IdxNextChr += ShpChrLen;
		switch (ShpType(&InpBuf[IdxNextChr], ShpSiz)) {
		  case  BV1:
		  case  BV2:
		  case   BD:
		  case TONE:
		  case  AD1:
		  case  AD2:
		  case  AD3:
		  case  AV1:
		  case  AV2:
		  case  AV3:
		    num_bytes = i;
		    errno = EILSEQ;
		    result = -1;
		    break;
		}
		TempIdxNextChr = IdxNextChr;
	    } else
		IdxNextChr = TempIdxNextChr;
	}
    }

    for (i=j=0; i<num_bytes ;) {

	int	ii;
	int	dummy;
	int	IdxNextCell;
	int	TempIdxNextCell;
	int	nChrsInCell = OneChrInCell;

	TempIdxNextCell = IdxNextCell = TempInpBufIndex;
	IdxNextCell += ShpLen(InpBuf + TempInpBufIndex, ShpSiz);

	while ((i + IdxNextCell - TempInpBufIndex < num_bytes) &&
	       (IsDisplayTypeShp(&InpBuf[TempIdxNextCell],
	        &InpBuf[IdxNextCell],ShpSiz) == SHOW_CURR_CELL)) {
	    if (Property)
		for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;

	    TempIdxNextCell = IdxNextCell;
	    IdxNextCell += ShpLen(InpBuf + IdxNextCell, ShpSiz);
	    nChrsInCell++;
	    switch (nChrsInCell) {
	      case TwoChrsInCell:
		SecondNextChrIdx = IdxNextCell;
		break;

	      case ThreeChrsInCell:
		ThirdNextChrIdx = IdxNextCell;
		break;
	    }
	}
	if (nChrsInCell == OneChrInCell)
	    if (Property)
	        for (ii=0; TempIdxNextCell + ii < IdxNextCell ; ii++)
		   Property[i + ii] = (ii == 0) ? DISPLAYCELL_MASK : 0x00;


	switch (nChrsInCell) {
	    case OneChrInCell:
	      /*
	       * First Shape in a Cell
	       */
	      switch (ShpType(&InpBuf[TempInpBufIndex], ShpSiz)) {
	      	    
		case  NON:
		  dummy = Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz);
		  if ((NumeralsInp != NumeralsOut) &&
		      IsArabicThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz)) {
		      switch (NumeralsOut) {
			case NUMERALS_NOMINAL:
			  if (IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_NATIONAL:
			  if (IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;

			case NUMERALS_CONTEXTUAL:
			  if (IsArabicNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
			      IsThaiNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToArabicNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  else if (IsThaiNumShp(&InpBuf[FirstPrevChrIdx], ShpSiz) &&
				   IsArabicNumShp(&InpBuf[TempInpBufIndex], ShpSiz))
			      dummy = ToThaiNumChr(Strm2Int(&InpBuf[TempInpBufIndex], ShpSiz));
			  break;
		      }
		  }
		  for (ii = ShpSiz; ii ; ii--, i++, j++) {
		       if (j < TempOutSize) {
			   if (OutBuf)
			       OutBuf[j] = (dummy >> ((ii - 1) * 8));
		       } else
			   IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		       if (InpToOut)
			   InpToOut[i] = j;
		       if (OutToInp && (j < TempOutSize))
			   OutToInp[j] = ii;
		  }
		  break;
	      
		  default:
		    for (ii = TempInpBufIndex; ii < FirstNextChrIdx; ii++, i++, j++) {
			if (j < TempOutSize) {
			    if (OutBuf)
				OutBuf[j] = InpBuf[ii];
			} else
			    IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
			if (InpToOut)
			    InpToOut[i] = j;
			if (OutToInp && (j < TempOutSize))
			    OutToInp[j] = ii;
		    }
		    break;
	      }
	      break;
	    
	    case TwoChrsInCell:
	    case ThreeChrsInCell:
	      for (ii = TempInpBufIndex; ii < IdxNextCell; ii++, i++, j++) {
		   if (j < TempOutSize) {
		       if (OutBuf)
			   OutBuf[j] = InpBuf[ii];
		   } else
		       IsOutBufNotEnough = (TempOutSize ? TRUE : FALSE);
		   if (InpToOut)
		       InpToOut[i] = j;
		   if (OutToInp && (j < TempOutSize))
		       OutToInp[j] = ii;
	      }
	      break;
	}


	/*
	 * Find the proper *InpBufIndex and *OutSize for E2BIG
	 */
	if ((j <= TempOutSize) && (i < num_bytes)) {
	    nByteCompTranStr = j;
	    InpBufIndexCompStr = IdxNextCell;
	}

	switch (nChrsInCell) {
	  case OneChrInCell:
	    FirstPrevChrIdx = TempInpBufIndex;
	    TempInpBufIndex = IdxNextCell;
	    break;

	  case TwoChrsInCell:
	    FirstPrevChrIdx = FirstNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	    
	  case ThreeChrsInCell:
	    FirstPrevChrIdx = SecondNextChrIdx;
	    TempInpBufIndex = IdxNextCell;
	    break;
	}
    }

    if (IsOutBufNotEnough && (OutBuf != NULL)) {
	errno = E2BIG;
	result = -1;
    }

    if (InpBufIndex)
	*InpBufIndex =
		(IsOutBufNotEnough ? InpBufIndexCompStr : TempInpBufIndex);

    if (OutSize)
	*OutSize = (IsOutBufNotEnough ? nByteCompTranStr : j);

    return (result);
}

static void *
GetTransformFunc(InpShapeForm, OutShapeForm, ShpeChrset)
    LayoutDesc			InpShapeForm;
    LayoutDesc			OutShapeForm;
    char			*ShpeChrset;
{
    int				(*transform_func)() = (int(*) ()) NULL;

    switch (InpShapeForm)
    {
	case TEXT_NOMINAL:
	  switch (OutShapeForm) {
	    case TEXT_NOMINAL:
	      transform_func = BasToBas;
	      break;

	    case TEXT_SHAPED:
	      if (strcmp(ShpeChrset, TIS620_2533) == 0)
		  transform_func = BasToSFTIS;
	      else
		  transform_func = BasToSFTIS_0;
	      break;

	    case TEXT_SHFORM1:
	      if (strcmp(ShpeChrset, TIS620_2533) == 0)
		  transform_func = BasToSF1TIS;
	      else
		  transform_func = BasToSF1TIS_0;
	      break;
	  }
	  break;

	case TEXT_SHAPED:
	  switch (OutShapeForm) {
	    case TEXT_NOMINAL:
	      transform_func = SFTIS_0ToBas;
	      break;

	    case TEXT_SHAPED:
	      if (strcmp(ShpeChrset, TIS620_2533) == 0)
		  transform_func = SFToSFTIS;
	      else
		  transform_func = SFToSFTIS_0;
	      break;

	    case TEXT_SHFORM1:
	      if (strcmp(ShpeChrset, TIS620_2533) == 0)
		  transform_func = SFToSF1TIS;
	      else
		  transform_func = SFToSF1TIS_0;
	      break;
	  }
	  break;

	case TEXT_SHFORM1:
	  switch (OutShapeForm) {
	    case TEXT_NOMINAL:
	      transform_func = SF1TIS_0ToBas;
	      break;

	    case TEXT_SHAPED:
	      if (strcmp(ShpeChrset, TIS620_2533) == 0)
		  transform_func = SF1ToSFTIS;
	      else
		  transform_func = SF1ToSFTIS_0;
	      break;

	    case TEXT_SHFORM1:
	      transform_func = SF1ToSF1;
	      break;
	  }
	  break;
    }

    return ((void *)transform_func);
}

static int
_LSThTransform(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		   InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObj			layout_obj;
    char			*InpBuf;
    size_t			InpSize;
    void			*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t   			*InpBufIndex;
{
    int				(*transform_func)() = (int(*)()) NULL;


    if (InpBuf == NULL) {
        /* Reset bidi nest level state */
	errno = 0;
	return 0;
    }
    
    if (transform_func == NULL)
	transform_func =
	    (int(*) ())GetTransformFunc(layout_obj->core.text_shaping->inp,
			layout_obj->core.text_shaping->out,
			layout_obj->core.shape_charset);

    return ((*transform_func)(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
				InpToOut, OutToInp, Property, InpBufIndex));
}

static int
_LSThWCSTransform(layout_obj, InpBuf, InpSize, OutBuf, OutSize,
		   InpToOut, OutToInp, Property, InpBufIndex)
    LayoutObject		layout_obj;
    wchar_t			*InpBuf;
    size_t			InpSize;
    wchar_t			*OutBuf;
    size_t			*OutSize;
    size_t			*InpToOut;
    size_t			*OutToInp;
    unsigned char		*Property;
    size_t			*InpBufIndex;		   
{
    int				result = 0;
    int				TmpInpBufIndex =
					InpBufIndex ? (*InpBufIndex) : 0;
    int				num_wchars =
				   (InpSize == 0) ? 
				   wslen(InpBuf) - TmpInpBufIndex : (InpSize);
    unsigned char		TmpInpBuf[MAX_INT_BUF];
    unsigned char		*TmpOutBuf =
					OutBuf ? (unsigned char *) OutBuf : NULL;
    unsigned char		*TmpProperty =
					Property ? Property : NULL;
    int				TmpOutSize =
					OutSize ? *OutSize : 0;
    int				ToTalOutSize = 0;
    size_t			*TmpInpToOut =
					InpToOut ? InpToOut : NULL;
    size_t			*TmpOutToInp =
					OutToInp ? OutToInp : NULL;
    size_t			BaseInpToOut = 0;
    size_t			BaseOutToInp = 0;


    errno = 0;

    if (InpBuf == NULL) {
        /* Reset bidi nest level state */
	return (result);
    }

    while (num_wchars) {

	int		nwChrs;
	int		dummy;
	int		tmp_input_buf_index = 0;
	int		*tmp_out_size = OutSize ? &dummy : NULL;
	wchar_t		NullWChr;

	 /*
	  * Find the point which should be splited
	  */
	if (num_wchars < MAX_INT_BUF - 1)
	        nwChrs = num_wchars;
	else {

	  nwChrs = MAX_INT_BUF - 1;

	  while ((nwChrs - 2 >= 0) &&
		 (IsWDisplayType(InpBuf[TmpInpBufIndex + nwChrs - 2],
				 InpBuf[TmpInpBufIndex + nwChrs - 1]) == SHOW_CURR_CELL))
		nwChrs--;

	  /*
	   * Check for CONS + TONEMARK + SARA_AM
	   * Don't split between these two cells
	   */
	  if ((nwChrs - 2 >= 0) &&
	      TACiswcons(InpBuf[TmpInpBufIndex + nwChrs - 2]) &&
	      (InpBuf[TmpInpBufIndex + nwChrs - 1] == WC_SARA_AM))
		nwChrs--;
	  else if ((nwChrs - 3 >= 0) &&
		 TACiswcons(InpBuf[TmpInpBufIndex + nwChrs - 3]) &&
		 TACiswtone(InpBuf[TmpInpBufIndex + nwChrs - 2]) &&
		 (InpBuf[TmpInpBufIndex + nwChrs - 1] == WC_SARA_AM))
		nwChrs -= 2;

	  NullWChr = InpBuf[TmpInpBufIndex + nwChrs];
	  InpBuf[TmpInpBufIndex + nwChrs] = WCNullChr;
	  nwChrs = Thwcstombs((char *) TmpInpBuf, &InpBuf[TmpInpBufIndex],
				nwChrs + 1);
	  if (nwChrs == (size_t) -1) {
	      nwChrs = 0;
	      if (errno)
		  errno = EILSEQ;
	      InpBuf[TmpInpBufIndex + nwChrs] = NullWChr;
	      result = -1;
	      break;
	  }
	  InpBuf[TmpInpBufIndex + nwChrs] = NullWChr;

	}
	    
	/*
	 * Transform some small pieces of input buffer
	 */
	if (tmp_out_size)
	   *tmp_out_size = TmpOutSize;


	result = _LSThTransform(layout_obj, TmpInpBuf, nwChrs,
				TmpOutBuf, tmp_out_size, TmpInpToOut,
				TmpOutToInp, TmpProperty,
				&tmp_input_buf_index);


	TmpInpBufIndex += tmp_input_buf_index;
	if (TmpProperty)
	    TmpProperty += tmp_input_buf_index;
	    
	if (TmpOutBuf && tmp_out_size) {
	    TmpOutBuf += (*tmp_out_size);
	}
	if (tmp_out_size) {
	    if (TmpOutSize)
		TmpOutSize -= (*tmp_out_size);
	}

	if (TmpInpToOut) {
	    int		i;

	    for (i = 0; i < tmp_input_buf_index ; i++, TmpInpToOut++)
		(*TmpInpToOut) += BaseOutToInp;
	}
	if (TmpOutToInp && tmp_out_size) {
	    int		i;

	    for (i = 0; i < (*tmp_out_size) ; i++, TmpOutToInp++)
		(*TmpOutToInp) += BaseInpToOut;
	}
	ToTalOutSize += (tmp_out_size ? (*tmp_out_size) : 0);
	BaseInpToOut += tmp_input_buf_index;
	BaseOutToInp += (tmp_out_size ? (*tmp_out_size) : 0);
	num_wchars -= tmp_input_buf_index;

	if (errno == E2BIG)
	    break;
		
    }

    if (InpBufIndex)
	*InpBufIndex = TmpInpBufIndex;
    if (OutSize)
	*OutSize = ToTalOutSize;

    return(result);
}
