/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef lint
#ifdef sccs
static char     sccsid[] = "@(#)layout_int.h 1.2 94/12/14";
#endif
#endif

/*
 *      (c) Copyright 1994 Sun Microsystems, Inc. Sun design patents
 *      pending in the U.S. and foreign countries. See LEGAL NOTICE
 *      file for terms of the license.
 */
 
/*
 *  This is the private header file for layout services.
 */
#ifndef _LAYOUT_INT_H_
#define _LAYOUT_INT_H_

/* In case if TRUE or FALSE are defined */
#if     !defined(TRUE) || ((TRUE) != 1)
#define TRUE    1
#endif   
#if     !defined(FALSE) || ((FALSE) != 0)
#define FALSE   0
#endif   


typedef struct _LayoutObject *LayoutObj;		/* Private name */



typedef struct {
    LayoutObject (*create)(
#if NeedFunctionPrototypes
        LayoutObj, LayoutValues
#endif
        );

    int (*destroy)(
#if NeedFunctionPrototypes
        LayoutObj
#endif
        );
        
    int (*getvalues)(
#if NeedFunctionPrototypes
        LayoutObj, LayoutValues, int *
#endif
        );
        
    int (*setvalues)(
#if NeedFunctionPrototypes
        LayoutObj, LayoutValues, int *
#endif
        );
        
    int (*transform)(
#if NeedFunctionPrototypes
        LayoutObj, const char *, size_t , void *,
        size_t *, size_t *, size_t *, unsigned char *, size_t *
#endif
        );
        
    int (*wcstransform)(
#if NeedFunctionPrototypes
        LayoutObj, const wchar_t *, size_t , void *,
        size_t *, size_t *, size_t *, unsigned char *, size_t *
#endif
        );
        
} LayoutMethodsRec, *LayoutMethods;


typedef struct {
    char			*locale_name;
    
    LayoutTextDescriptor	orientation;
    LayoutTextDescriptor	context;
    LayoutTextDescriptor	type_of_text;
    LayoutTextDescriptor	implicit_alg;
    LayoutTextDescriptor	swapping;
    LayoutTextDescriptor	numerals;
    LayoutTextDescriptor	text_shaping;
    BooleanValue		active_dir;
    BooleanValue		active_shape_editing;
    char			*shape_charset;
    int				shape_charset_size;
    unsigned long		in_out_text_descr_mask;
    unsigned long		in_only_text_descr;
    unsigned long		out_only_text_descr;
    int				check_mode;
    LayoutEditSize		shape_context_size;
} LayoutCoreRec, *LayoutCore;

typedef struct _LayoutObject {
    LayoutMethods         methods;         /* methods of this CTL Object */
    LayoutCoreRec         core;                   /* data of this CTL Object */
    void		  *private_data;   /* Private data of locale-dependent object */

} LayoutObjectRec;


#endif /* _LAYOUT_INT_H_ */
