/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
/*
 * Copyright (c) 1998, by Sun Microsystems, Inc.
 * All rights reserved.
 */
#pragma ident "@(#)LOtypes.cc	1.2     00/09/12  SMI%"

#include "LOtypes.H"
#include CUR_LANG_LOTYPES

const int LOtypes::binSearch(int val, int start, int end, const int* array)const
{
	while(start <= end){
	    int mid = start + ((end - start) >> 1);
	    if(val == array[mid])
	       return mid;
	    if(val < array[mid])
		end = mid - 1;
	    else
		start = mid + 1;
	}
	return -1;
    }

const LOtypes::lotype_t &
LOtypes::charmapGet(const val_t &c) const 
{
  static lotype_t defaultVal=0; /* dummy value to
				      * return if c not found in map
				      */
  int key = c; 
  int idx;
  if (key < 0x20){
    defaultVal=(lotype_t) (_CTRL);
    return (defaultVal);
  }
  else if (key >=0x20 &&key <=0x7f ) //latin range
    idx= key-0x20;
  else if (key >=0xa0 && key <=0xff) //iso range
    idx= (key-0x40);
  else if (key >= 0x80 &&key <=0x9f ) //latin range
    idx= -1;
  else if (key >=0x064b && key <=0x0652) //unicode
    idx= (key-0x064b)+191; // was 192 
  else if (key >=0xfc5e && key <=0xfc62) //unicode
    idx= (key-0xfc5e)+199; // was 200
  else if (key >=0xfef5 && key <=0xfefb) //unicode
    idx= (key-0xfef5)+204; // was 205

  else  //other unicode values 
    idx = binSearch( key, 0 ,(sizeof(charDataIndex)/sizeof(charDataIndex[0]))-1 , charDataIndex);
  if (idx != -1 && idx <=(sizeof(charData)/sizeof(charData[0]))-1 ) 
    return ((lotype_t)charData[idx]);
  return defaultVal;
}

const LOtypes::val_t &
LOtypes::swapmapGet(const val_t &c) const 
{
  int key = c; 
  int idx = binSearch( key, 0, sizeof (swapDataIndex)/sizeof(swapDataIndex[0]-1) , swapDataIndex);
  if (idx != -1) 
      return ((val_t)swapData[idx]);
  return c;
}
const LOtypes::val_t &
LOtypes::nummapGet(const val_t &c) const 
{
  int key = c;
  if(key >=0x30 && key <=0x39 && (sizeof(numData)/sizeof(numData[0])) >=9 )
    return ((val_t)numData[key-0x30]);
  return c;
}
LOtypes::shapeData_t LOtypes::shapemapGet(const val_t &c) const
{
  int key = c; 
  int idx;
  static shapeData_t defaultVal; /* dummy value to
				  * return if c not found in map
				  */
  defaultVal.begin = defaultVal.end = 
    defaultVal.middle = defaultVal.isolated = c; // initialize all to c
  if (key >=0xa0 &&key <=0xf2 ) //Arabic Iso range
    idx= key-0xa0;
  else if (key >=0xfef5 && key <=0xfefb) //unicode
     idx=(key-0xfef5)+83;
  else  //other unicode values 
    idx = binSearch(key, 0, sizeof(shapeDataIndex)/sizeof(shapeDataIndex[0]-1), shapeDataIndex);
  if (idx != -1) 
    return  ((shapeData_t)shapeData[idx]);
  return defaultVal;
}
const  LOtypes::val_t &
LOtypes::combomapGet(const val_t &base, const val_t &next) const
{
  static const  val_t defaultVal=0;  /* dummy value to
				      * return if combo not found in map
				      */
  // create the search key from the base and next combined values
  const unsigned long key = ((unsigned int)base << 16) | next;
  int idx =  binSearch( key, 0,  sizeof(comboDataIndex)/sizeof(comboDataIndex[0]-1) , comboDataIndex); 
  if (idx != -1) 
    return  ((val_t)comboData[idx]);
  return defaultVal;
}







