/*
Copyright 1985, 1986, 1987, 1991, 1998  The Open Group

Portions Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#ifndef CTLFUNCTIONS_H
#define CTLFUNCTIONS_H

#include <stdlib.h>
#include "layout.h"
#include "layout_int.h"

#ifdef ARABIC_TARGET
#define LOcontrolClass LOarControl
#else 
#define LOcontrolClass LOheControl
#endif

/** Functions directly interfaced with liblayout.
    These functions are wrappers with C linking - the
    real job is delegated to pear routines in the LOcontrol
    object attached to the private_data of the layout object 
    parameter
    @name PLS library interface functions
    @see LOcontrol
*/
extern "C" {
//@{
  /** initialize the layout object.
      @param locale_name name of current locale - e.g. "ar"
  */
  LayoutObject _LayoutObjectInit(char *locale_name);
  /** m_create_layout interface.
      @param layout_obj current LayoutObject
      @param layout_values LayoutValues to override default engine's layout settings
  */
  static LayoutObject CTL_createLayout(LayoutObj layout_obj, LayoutValues layout_values);
  /// 
  static int CTL_destroyLayout(LayoutObj layout_obj);
  /// return values of requested fields
  static int CTL_getValuesLayout(LayoutObj layout_obj, LayoutValues values, int *index_returned);
  /// set values of requested fields in layout object 
  static int CTL_setValuesLayout(LayoutObj layout_obj, LayoutValues values, int *index_returned);
  /** transform text for char or short input type.
      the InpBuf type, even though declared as char pointer, will
      be treated as short array If the shape_charset_size of current
      locale is 2 bytes  - i e use 16bit fonts
  */
  static int CTL_transformLayout(LayoutObj layout_obj, 
				 const char *InpBuf, size_t InpSize, 
				 void *OutBuf, 
				 size_t *OutSize, 
				 size_t *InpToOut, 
				 size_t *OutToInp, 
				 unsigned char *Property, 
				 size_t *InpBufIndex);
  /// transform text - input and output of type wchar_t*
  static int CTL_wtransformLayout(LayoutObject layout_obj, 
				   const wchar_t *InpBuf, 
				   size_t InpSize, 
				   void *OutBuf, 
				   size_t *OutSize, 
				   size_t *InpToOut, 
				   size_t *OutToInp, 
				   unsigned char *Property, 
				   size_t *InpBufIndex);
//@}
}

#endif // CTLFUNCTIONS_H
