.TH XTIC 1 "X11" "Mattias Jonsson, KTH"
.SH NAME
xtic \- X version of a simple but tricky board game
.PP

.SH RULES
The board is made up of 4x4 squares and 16 pieces. The pieces
carry 4 properties each, namely:

.HP 3
o Black or brown
.HP 3
o Horizontal or vertical
.HP 3
o Solid or hollow
.HP 3
o Round or square
.PP

This makes a total of 16 possible pieces and there are exactly
one piece of each type (so each piece can be represented by
a binary number of length 4).

Initially, the board is empty and it is successively filled with
pieces. The game is over when a row, a column or a diagonal
has four pieces carrying a common property in it, e.g. four
black pieces. The player who places the fatal piece loses.

The game is a two-player game, although in the current release,
only the human-computer combination is supported.
Player 1 (the human by default) chooses one of the 16 pieces. Player 2
(the computer by default) places this piece on one of the 16 
squares of the board and chooses a piece out of the remaining 
15 pieces which he gives to player 1, who places this
piece on one of the remaining 15 squares on the board, etc.

As mentioned above, the game is over when a player places a 
piece in such a way that a row, a column or a diagonal 
(but see below) contains four pieces carrying a common property.
The player who places this piece loses. If there is no empty square
left, we have a draw (yes, this can happen).

.SH MENU COMMANDS
There are two menus, the Actions Menu and the Options Menu.

.SH Actions Menu
.TP 8
.B New game - You start
Starts a new game of 
.IR xtic,
ending the previous one abruptly and letting the human start.
.TP 8
.B New game - I start
Identical to "New game - You start" except that the computer will
begin the next game.
.TP 8
.B Quit
Exist from 
.IR xtic.

.SH Options Menu
.TP 8
.B Level trivial
The easiest level. The computer only tries to place the selected
piece in a way that it does not lose immediately, and chooses any
free piece to give away, i.e. it thinks only one move ahead.
.TP 8
.B Level easy
The computer thinks two moves ahead.
.TP 8
.B Level medium
The computer thinks three moves ahead.
.TP 8
.B Level hard
The computer thinks four moves ahead.
.TP 8
.B Level very hard
The computer thinks five moves ahead.
.TP 8
.B Level don't try
The computer thinks six moves ahead. This can be quite slow (and hard).
.TP 8
.B Game Type: normal
In addition to the rows and columns, the two main diagonals are
dangerous (can make the game end).
.TP 8
.B Game Type: nodiags
Only the rows and columns are dangerous.
.TP 8
.B Game Type: torus
.IR All
8 "diagonals" are dangerous. This corresponds to playing on 
a torus.


.SH BUGS
Probably plenty. Report any you find to mjo@math.kth.se

.SH AUTHOR
Mattias Jonsson,
Dept of Mathematics,
Royal Institute of Technology,
S-100 44 Stockholm,
Sweden.

email: mjo@math.kth.se,
URL: http://www.math.kth.se/~mjo
