#include "endgame.h"
/* returns a 1 in each winning position:
   the rows occupy positions 0              to BOARDLENGTH-1
       cols                  BOARDLENGTH    to 2*BOARDLENGTH-1
       diags                 2*BOARDLENGTH  to 4*BOARDLENGTH-1
   if game is not over, then fuction returns 0 */
long endgame()
{
  unsigned int win1=~0, win2=~0, win3=~0, win4=~0;
  long eg=0;
  int i,j;
  for (i=0; i<BOARDLENGTH; i++) { /* check all rows and all cols*/
    win1=win2=win3=win4=~0;
    for (j=0; j<BOARDLENGTH; j++) {
      win1&=board[i*BOARDLENGTH+j];
      win2&=(~board[i*BOARDLENGTH+j]^1);
      win3&=board[j*BOARDLENGTH+i];
      win4&=(~board[j*BOARDLENGTH+i]^1);
    }
    win2=win2%(1<<(NPROPERTIES+1));
    win4=win4%(1<<(NPROPERTIES+1));
    if ((win1!=1 && win1&1==1) || (win2!=1 && win2&1==1)) 
      eg|=(1<<i);
    if ((win3!=1 && win3&1==1) || (win4!=1 && win4&1==1))
      eg|=(1<<(BOARDLENGTH+i));
  }
  switch (gametype) {
  case NORMAL:
    win1=win2=win3=win4=~0;
    for (i=0; i<BOARDLENGTH; i++) { /* check the diags */
      win1&=board[i*(BOARDLENGTH+1)];
      win2&=(~board[i*(BOARDLENGTH+1)]^1);
      win3&=board[(i+1)*(BOARDLENGTH-1)];
      win4&=(~board[(i+1)*(BOARDLENGTH-1)]^1);
    }
    win2=win2%(1<<(NPROPERTIES+1));
    win4=win4%(1<<(NPROPERTIES+1));
    if ((win1!=1 && win1&1==1) || (win2!=1 && win2&1==1))
      eg|=(1<<2*BOARDLENGTH);
    if ((win3!=1 && win3&1==1) || (win4!=1 && win4&1==1))
      eg|=(1<<(4*BOARDLENGTH-1));
    break;
  case NODIAGS:
    break;
  case TORUS:
    for (i=0; i<BOARDLENGTH; i++) { /* check all diags (on the torus) */
      win1=win2=win3=win4=~0;
      for (j=0; j<BOARDLENGTH; j++) {
	win1&=board[j*BOARDLENGTH+((i+j)%BOARDLENGTH)];
	win2&=(~board[j*BOARDLENGTH+((i+j)%BOARDLENGTH)]^1);
	win3&=board[j*BOARDLENGTH+((BOARDLENGTH+i-j)%BOARDLENGTH)];
	win4&=(~board[j*BOARDLENGTH+((BOARDLENGTH+i-j)%BOARDLENGTH)]^1);
      }
      win2=win2%(1<<(NPROPERTIES+1));
      win4=win4%(1<<(NPROPERTIES+1));
      if ((win1!=1 && win1&1==1) || (win2!=1 && win2&1==1)) 
      eg|=(1<<(2*BOARDLENGTH+2*i));
      if ((win3!=1 && win3&1==1) || (win4!=1 && win4&1==1)) 
      eg|=(1<<(2*BOARDLENGTH+2*i+1));
    }
  }
  return eg;
}
