/* *************************************************************************
 *
 *	xpm.c	Pixmap Reading Functions
 *	--------------------------------
 *	Functions:
 *
 *      Pixmap readpixmapfile(char *xpmfilename)
 *      Pixmap readbitmapfile(char *xbmfilename)
 *      Pixmap readpixmapdata(char **xpmdata)
 *
 *	---
 *
 *	readpixmapfile() is a convience function to read
 *	a pixmap from a .xpm file.
 *
 *      readbitmapfile() is a convience function to read
 *      a bitmap from a .xbm file.
 *
 *	readpixmapdata() is a convience function to read
 *	a pixmap from a character array.
 *
 */

#include "xjscal.h"




Pixmap readpixmapfile(char *xpmfilename)
{
        Pixmap pixmap;          /* Will contain read xpm. */
        Pixmap pixmapmask;      /* Will contain mask of read xpm. */
        XpmAttributes xpmattr;  /* struct for xpm attributes. */
        XpmInfo xpminfo;        /* struct for xpm info. */
        XpmImage xpmimg;        /* struct for xpm image. */

/* Color closeness. */
#ifndef COLORCLOSENESS
#define COLORCLOSENESS 40000
#endif

	/* Check if file exists. */
	if(access(xpmfilename,F_OK) != 0)
	{
	   fprintf(stderr,
		"Error: Unable to find XPM file: %s\n",
		xpmfilename
	   );
	   return(pixmap);
	}

	/* Set XPM attributes. */
        xpmattr.closeness = COLORCLOSENESS;
        xpmattr.valuemask = XpmSize | XpmCloseness;
 
	/* Attempt to read the pixmap data from file. */
        if((XpmReadFileToPixmap(display, DefaultRootWindow(display),
                xpmfilename, &pixmap, &pixmapmask, &xpmattr)) == XpmSuccess)
        {
                return(pixmap);
        }
        else
        {
                fprintf(stderr,"Can't open xpm file %s.\n",xpmfilename);
                return(pixmap);
        }
}



Pixmap readpixmapdata(char **xpmdata)
{
        /* Local variables. */
        Pixmap pixmap;          /* Will contain read xpm. */
        Pixmap pixmapmask;      /* Will contain mask of read xpm. */
        XpmAttributes xpmattr;  /* struct for xpm attributes. */
        XpmInfo xpminfo;        /* struct for xpm info. */
        XpmImage xpmimg;        /* struct for xpm image. */


	/* Set color closeness. */
#ifndef COLORCLOSENESS
#define COLORCLOSENESS 40000
#endif

        /* Set XPM attributes. */
        xpmattr.closeness = COLORCLOSENESS;
        xpmattr.valuemask = XpmSize | XpmCloseness;
  
        /* Attempt to read the pixmap data from file. */
        if((XpmCreatePixmapFromData(display, DefaultRootWindow(display),
                xpmdata, &pixmap, &pixmapmask, &xpmattr)) == XpmSuccess)
        {
                return(pixmap);
        }
        else
        {
                fprintf(stderr,"Can't load pixmap from data.\n");
                return(pixmap);
        }
}



Pixmap readbitmapfile(char *xbmfilename)
{
	/* Local variables. */
	int status;
	unsigned int width_rtn, height_rtn;
	int x_hot, y_hot;
	static unsigned char *xbm_data_rtn;
	struct stat statbuf;
	Pixmap pixmap_rtn;


        /* Check if file exists. */
        if(access(xbmfilename,F_OK) != 0)
        {
           fprintf(stderr,
                "Error: Unable to find XBM file: %s\n",
                xbmfilename 
           );
           return(pixmap_rtn); 
        }


	/* Read the .xbm file's data. */
	status = XReadBitmapFileData(
			xbmfilename,
			&width_rtn, &height_rtn,
			&xbm_data_rtn,
			&x_hot, &y_hot			
	);


	/* Read data into pixmap. */
	pixmap_rtn = XCreateBitmapFromData(display,
			toplevel,
			xbm_data_rtn,
			width_rtn, height_rtn
	);


	/* Check for errors. */
	switch(status)
	{
	   case BitmapOpenFailed:
		fprintf(stderr, "Error: Unable to open file: %s\n", xbmfilename);
		break;

	   case BitmapFileInvalid:
		fprintf(stderr,
                       "Error: Unable to read bitmap data in file: %s\n",
		       xbmfilename
		);
		break;

	   case BitmapNoMemory:
		fprintf(stderr,
			"Error: Insufficent memory to read file: %s\n",
			xbmfilename
		);
		break;

	   default:
		break;
	}


	return(pixmap_rtn);
}
