/* ******************************************************************************
 *
 *	rcfile.c
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <strings.h>
#include <sys/stat.h>
#include <malloc.h>




/*
 *   Keymapping Structure:
 *
 *      For user defined key mapping in xkey form.
 */
typedef struct
{ 
    unsigned int help;
    unsigned int display_arrow;  
    unsigned int display_labels;
    unsigned int display_events;
 
    unsigned int net_connect;
    unsigned int net_disconnect;
    unsigned int net_refresh;
 
    unsigned int net_exec;
    unsigned int local_exec;

    unsigned int scanner_toggle;
    unsigned int scanner_zin;
    unsigned int scanner_zout; 
    unsigned int scanner_max;

    unsigned int joystick_mode;
    unsigned int reverse_thrust;  
     
    unsigned int shields_toggle;
    unsigned int dmgctl_toggle;
    unsigned int cloak_toggle;
 
    unsigned int select_weapon1;
    unsigned int select_weapon2;
    unsigned int select_weapon3;
    unsigned int select_weapon4;
    unsigned int select_weapon5;        /* Weapon 5 and greater not supported. */
    unsigned int select_weapon6;
    unsigned int select_weapon7;
    unsigned int select_weapon8;
    unsigned int select_weapon9;
    unsigned int select_weapon10;
 
    unsigned int weapons_lock;
    unsigned int weapons_unlock;
  
    unsigned int set_intercept;
    unsigned int set_shield_freq;
    
    unsigned int send_message;  
 
} xsw_keymap_struct;
xsw_keymap_struct xsw_keymap;   
    


char swservaddress[1024];
int swservport;

int minimum_images_bool;



int RCLoadFromFile(char *filename)
{
	/* Local varables. */
        FILE *fp;
        char *filebuf;
        off_t filesize;
        struct stat statbuf;

        char stringa[256];
        char stringb[256];
        char *strptr;

        long lines_read = 0;
	long parameters_read = 0;


	/* Check if filename exists. */
	if(access(filename, F_OK) == -1)
	{
	    fprintf(stderr, "%s: No such file.\n", filename);
	    return(-1);
	}

        /* Open filename. */
        fp = fopen(filename, "r");
        if(fp == NULL)
        {
            fprintf(stderr, "%s: Unable to open file.\n", filename);
            return(-1);
        }

        /* Get statistics and stuff about the file. */
        fstat(fileno(fp), &statbuf);    /* Get stats on file. */
        filesize = statbuf.st_size;     /* Get size of file. */
        
        /* Allocate memory. */
        filebuf = malloc(filesize * sizeof(char) + 1);


	/* ******************************************************** */
	/* ***            Begin Reading Configurations          *** */
        while( fgets(filebuf,256,fp) != NULL )
        {
            lines_read++;

            /* Skip comments. */
            if(strstr(filebuf,"#") != NULL)
                continue;
 
            /* Skip short lines. */
            if(strlen(filebuf) < 4)
                continue;

            /* Remove newline characters from filebuf. */
            while( (strptr = strchr(filebuf, '\n')) != NULL )
            {    
                *strptr='\0';
            }


            /*
             *   Parsing format:
             *
             *       <parameter>[ = <value>]
             */
            
            /* Fetch parameter and put it into stringa. */
            strncpy(stringa, filebuf, 256);
            stringa[255] = '\0';   
            if( (strptr = strchr(stringa, '=')) != NULL)
            {
                *strptr = '\0';
            }


            /* DefaultServerAddress */
            if( strstr(stringa, "DefaultServerAddress") != NULL )
            {
		strptr = strchr(filebuf, '=');
		strptr += 2;
		strncpy(swservaddress, strptr, 1024);

                parameters_read++;
                continue;
            }
            /* DefaultServerPort */
            else if( strstr(stringa, "DefaultServerPort") != NULL )
            {
                sscanf(filebuf, "%s %s %i",
                    &stringb,
                    &stringb,
                    &swservport
                );

                parameters_read++;
                continue;
            }
            /* DefaultLoginName */
            else if( strstr(stringa, "DefaultLoginName") != NULL )
            {
                strptr = strchr(filebuf, '=');
                strptr += 2;
                strncpy(loginname, strptr, MAX_NAME_LENGTH);
                loginname[MAX_NAME_LENGTH - 1] = '\0';

                parameters_read++;
                continue;
            }
            /* DefaultLoginPassword */
            else if( strstr(stringa, "DefaultLoginPassword") != NULL )
            {
                strptr = strchr(filebuf, '=');
                strptr += 2;
                strncpy(loginpassword, strptr, MAX_PASSWORD_LENGTH);
                loginpassword[MAX_PASSWORD_LENGTH - 1] = '\0';
                
                parameters_read++;
                continue;
            }
	    /* MinimumImages */
	    else if( strstr(stringa, "MinimumImages") != NULL )
	    {
                sscanf(filebuf, "%s %s %i",
                    &stringb,
                    &stringb,
                    &stringc
                );

		if( (strstr(stringc, "y") != NULL) ||
		    (strstr(stringc, "Y") != NULL)
		)
		{
		    minimum_images_bool = True;
		}
		else
		{
		    minimum_images_bool = False;
		}

                parameters_read++;
                continue;
            }

            /* **************************************************** */
            /* ***                   KeyMapping                 *** */
            else if(strstr(filebuf,"BeginKeyMap") != NULL)
            {
                while((fgets(filebuf,256,fp)) != NULL)
                {
                    lines_read++;
         
                    /* Skip comments. */
                    if(strstr(filebuf,"#") != NULL)
                        continue;
                           
                    /* Skip short lines. */
                    if(strlen(filebuf) < 4)
                        continue;

                    /* Remove newline characters from filebuf. */
                    while( (strptr = strchr(filebuf, '\n')) != NULL )
                    {
                        *strptr='\0';
                    }

                    /*          
                     *   Parsing format:
                     *
                     *       <parameter>[ = <value>]
                     */
             
                    /* Fetch parameter and put it into stringa. */
                    strncpy(stringa, filebuf, 256);
                    stringa[255] = '\0';
                    if( (strptr = strchr(stringa, '=')) != NULL)
                    {
                        *strptr = '\0';
                    }


                    /* Help */
                    if( strstr(stringa, "Help") != NULL )
                    {
			sscanf(filebuf, "%s %s %i",
                            &stringb,
			    &stringb,
                            &xsw_keymap.help
			);
			parameters_read++;
                        continue;
                    }
                    /* DisplayArrow */
                    else if( strstr(stringa, "DisplayArrow") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.display_arrow
                        );
                        parameters_read++;
                        continue;
                    }
                    /* DisplayLabels */
                    else if( strstr(stringa, "DisplayLabels") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.display_labels
                        );
                        parameters_read++;
                        continue;
                    }
                    /* DisplayEvents */
                    else if( strstr(stringa, "DisplayEvents") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.display_events
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetConnect */
                    else if( strstr(stringa, "NetConnect") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_connect
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetDisconnect */
                    else if( strstr(stringa, "NetDisconnect") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_disconnect
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetRefresh */
                    else if( strstr(stringa, "NetRefresh") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_refresh
                        );
                        parameters_read++;
                        continue;
                    }
                    /* NetExec */
                    else if( strstr(stringa, "NetExec") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.net_exec
                        );
                        parameters_read++;
                        continue;
                    }
                    /* LocalExec */
                    else if( strstr(stringa, "LocalExec") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.local_exec
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerToggle */
                    else if( strstr(stringa, "ScannerToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerZoomIn */
                    else if( strstr(stringa, "ScannerZoomIn") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_zin
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerZoomOut */
                    else if( strstr(stringa, "ScannerZoomOut") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_zout
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ScannerZoomMax */
                    else if( strstr(stringa, "ScannerZoomMax") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.scanner_max
                        );
                        parameters_read++;
                        continue;
                    }
                    /* JoystickMode */
                    else if( strstr(stringa, "JoystickMode") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.joystick_mode
                        );
                        parameters_read++;
                        continue;
                    }
                    /* JoystickMode */
                    else if( strstr(stringa, "JoystickMode") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.joystick_mode
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ReverseThrust */
                    else if( strstr(stringa, "ReverseThrust") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.reverse_thrust
                        );
                        parameters_read++;
                        continue;
                    }
                    /* ShieldsToggle */
                    else if( strstr(stringa, "ShieldsToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.shields_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* DmgCtlToggle */
                    else if( strstr(stringa, "DmgCtlToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.dmgctl_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* CloakToggle */
                    else if( strstr(stringa, "CloakToggle") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.cloak_toggle
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon1 */
                    else if( strstr(stringa, "SelectWeapon1") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon1
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon2 */
                    else if( strstr(stringa, "SelectWeapon2") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon2
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon3 */
                    else if( strstr(stringa, "SelectWeapon3") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon3
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon4 */
                    else if( strstr(stringa, "SelectWeapon4") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon4
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon5 */
                    else if( strstr(stringa, "SelectWeapon5") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon5
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon6 */
                    else if( strstr(stringa, "SelectWeapon6") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon6
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon7 */
                    else if( strstr(stringa, "SelectWeapon7") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon7
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon8 */
                    else if( strstr(stringa, "SelectWeapon8") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon8
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SelectWeapon9 */
                    else if( strstr(stringa, "SelectWeapon9") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.select_weapon9
                        );
                        parameters_read++;
                        continue;
                    }
                    /* WeaponsLock */
                    else if( strstr(stringa, "WeaponsLock") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.weapons_lock
                        );
                        parameters_read++;
                        continue;
                    }
                    /* WeaponsUnlock */
                    else if( strstr(stringa, "WeaponsUnlock") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.weapons_unlock
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SetIntercept */
                    else if( strstr(stringa, "SetIntercept") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.set_intercept
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SetShieldFreq */
                    else if( strstr(stringa, "SetShieldFreq") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.set_shield_freq
                        );
                        parameters_read++;
                        continue;
                    }
                    /* SendMessage */
                    else if( strstr(stringa, "SendMessage") != NULL )
                    {
                        sscanf(filebuf, "%s %s %i",
                            &stringb,
                            &stringb,
                            &xsw_keymap.send_message
                        );
                        parameters_read++;
                        continue;
                    }


                    /* EndKeyMap */
                    else if( strstr(stringa, "EndKeyMap") != NULL )
                    {
                        break;
                    }
                    /* Unknown parameter. */
                    else
                    {
                        fprintf(stderr,
                            "%s: Line %i: Unknown parameter: `%s'\n",
                            filename,
                            lines_read,
                            filebuf
                        );
                        continue;
                    }
		}
		continue;
	    }
            /* Unknown parameter. */
            else
            {
                fprintf(stderr, "%s: Line %i: Unknown parameter: `%s'\n",
                    filename,
                    lines_read,
                    filebuf
                );
                continue;
            }
	}



	/* Free filebuf and close fp. */
	free(filebuf);
	fclose(fp);

	return(0);
}



int main(int argc, char *argv[])
{





	RCLoadFromFile("/root/xsw/client/xswrc");


	printf("swservaddress = %s\n", swservaddress);
	printf("xsw_keymap.display_arrow = %i\n", xsw_keymap.display_arrow);


	return(0);
}
