/* *************************************************************************
 *
 *	Dynamic array example, by Taura LearFox.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>



/* Create a normal structure for the objects, like we always do.
 */
struct xsw_object_struct
{
	char name[256];
	int type;
	struct xsw_object_struct *next;
} *xsw_object_first=0, *xsw_object_last=0;

/* See the 2 alias pointers above?  They will be pointers to the first and
 * last XSW Objects allocated in memory.
 */



/* We need to keep track of the total objects we have.
 * total_objects is relative to 1.   1 means 1 object.
 */
long total_objects;



/* ***************************************************************************
 *
 *	Convience function to allocate memory for XSW Objects.
 *
 */
int DBCreateObject(long *count)
{
	/* Local variables. */
	struct xsw_object_struct *new;


	/* Allocate the memory needed for 1 XSW Object. */
	new = calloc(1, sizeof(struct xsw_object_struct));
	if(new != 0)
	{
	    if(xsw_object_first == 0)
	    {
	        xsw_object_first = new;
            }
	    else
            {
		xsw_object_last->next = new;
            }

	    xsw_object_last = new;

	    ++ *count;

	    return(0);
	}
	else
	{
	    fprintf(stderr, "Object memory allocation error.\n");

	    return(-1);
	}
}



int main(int argc, char *argv[])
{
	/* Local variables. */
	int x, y, z;
	char stringa[128];


	/* Set total objects to 0. */
	total_objects = 0;


	/* Allocate 5 objects. */
	for(x=0; x<5; x++)
	{
	    DBCreateObject(&total_objects);
	}

	/* Print results. */
	printf("Allocated %i XSW Objects.\n", total_objects);


	/* We should be using free() to free the memory before
	 * exiting.
	 */



	return(0);
}
