/* ***************************************************************************
 *
 *	xsw.h	XShipWars Global Definations
 *	------------------------------------
 *
 *
 */


#ifndef __XSW_H__
#define __XSW_H__


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <errno.h>
#include <ctype.h>
#include <signal.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>
#include <netdb.h>
#include <waitflags.h>
#include <fcntl.h>

#include <sys/time.h>
#include <sys/signal.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <net/if.h>
#include <arpa/inet.h>

#ifdef LINUX			/* Linux specific stuff. */
   #include <linux/ppp.h>
   #include <linux/in.h>
   #include <linux/socket.h>
   #include <linux/if.h>
   #include <linux/if_ppp.h>
   #include <linux/ipx.h>
   #include <linux/joystick.h>  /* Joystick. */
#endif				/* Linux specific stuff. */


#include <netinet/ip.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

#include <net/ppp_defs.h>


/* Xlib */
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>

/* Xpm */
#include <X11/xpm.h>

/* Xext (X Extensions) */
#include <X11/extensions/shape.h>


/* Local header files. */
#include "objects.h"
#include "netcodes.h"
#include "xutils.h"
#include "reality.h"



/* ****************************************************************************
 *
 *                        USER EDITABLE DEFINATIONS
 *
 *   You may edit these definations, read the comments carefully, so you know
 *   which settings you must edit and which to leave alone.
 */

/*
 *   Color reduction for XPM (pixmap) images:
 *
 *	0     = 0% Reduction allowed (not recommended).
 *	40000 = (Default).
 *	60000 = 100% Reduction allowed.
 */
#define COLORCLOSENESS 40000


/*
 *   XShipWars Directories:
 *
 *	These are directories used by XShipWars, make sure that they actually
 *	exist on your computer.
 */
#define XSW_DIR "/usr/games/xshipwars"
#define XSW_IMAGES_DIR "/usr/games/xshipwars/images"
#define XSW_ETC_DIR "/usr/games/xshipwars/etc"
#define ETC_DIR "/etc"


/*
 *   Various Configuration Files:
 *
 *	These are configuration files used by XShipWars.   Some are local
 *	configuration files do not need a complete directory path name.
 *	Below is a list on which files need to have a full path name.
 *
 *	XSW_RCFILE is local.
 *	JS_CALIBRATION_FILE is local.
 */
#define XSW_RCFILE              ".xshipwarsrc"
#define XSW_RCFILE_GLOBAL       "xshipwarsrc"
#define JS_CALIBRATION_FILE     ".joystick"
#define DEV_JOYSTICK		"/dev/js0"



/*
 *   Default Data to Server:
 *
 */
#define DEFAULT_SWSERV_ADDRESS   "taura.ccinet.com"
#define DEFAULT_SWSERV_PORT      1701



/*
 *   Color Specifications:
 *
 *	These need to be in "rgbi:" format.
 */
#define NORMAL_TEXT_COLOR_SPEC  "rgbi:1.00/0.70/0.92"
#define BOLD_TEXT_COLOR_SPEC    "rgbi:1.00/0.97/0.99"
#define LIGHT_GREY_COLOR_SPEC   "rgbi:0.80/0.80/0.80"
#define DARK_GREY_COLOR_SPEC    "rgbi:0.15/0.15/0.15"

#define STATUS_TEXT_COLOR_SPEC          "rgbi:1.00/0.75/0.95"
#define HULL_BAR_COLOR_SPEC             "rgbi:0.62/0.37/0.62"
#define POWER_BAR_COLOR_SPEC            "rgbi:1.00/0.81/0.38"
#define SHIELDS_BAR_COLOR_SPEC          "rgbi:0.94/0.62/0.21"
#define WEAPONS_LOCK_COLOR_SPEC         "rgbi:1.00/0.82/0.39"
#define SELECTED_WEAPON_COLOR_SPEC      "rgbi:1.00/0.75/0.95"
#define UNSELECTED_WEAPON_COLOR_SPEC    "rgbi:0.62/0.28/0.56"
#define VISIBILITY_BAR_COLOR_SPEC       "rgbi:0.37/0.62/0.81"
#define INTERCEPT_COLOR_SPEC            "rgbi:0.62/0.37/0.62"
#define THROTTLE_BAR_COLOR_SPEC         "rgbi:0.95/0.65/0.23"
#define VELOCITY_BAR_COLOR_SPEC         "rgbi:1.00/0.81/0.38"
#define ANTIMATTER_BAR_COLOR_SPEC       "rgbi:1.00/0.75/0.95"
#define DMGCTL_BAR_COLOR_SPEC           "rgbi:0.72/0.47/0.72"

#define STAR1_COLOR_SPEC        "rgbi:1.00/1.00/1.00"
#define STAR2_COLOR_SPEC        "rgbi:1.00/0.92/0.98"
#define STAR3_COLOR_SPEC        "rgbi:0.96/0.94/0.97"

#define STAR4_COLOR_SPEC        "rgbi:0.60/0.60/0.61"
#define STAR5_COLOR_SPEC        "rgbi:0.65/0.63/0.67"
#define STAR6_COLOR_SPEC        "rgbi:0.65/0.69/0.66"

#define STAR7_COLOR_SPEC        "rgbi:0.40/0.40/0.42"
#define STAR8_COLOR_SPEC        "rgbi:0.40/0.38/0.42"
#define STAR9_COLOR_SPEC        "rgbi:0.47/0.48/0.46"



/*      
 *   Server Object Update Send Interval:
 *
 *      In milliseconds. These are the minimum and maximum object updates
 *      intervals that we can request of the server to send us object
 *	updates.   The server code's minimum and maximum update intervals
 *	settings will override these minimum and maximum settings.
 *
 *	* These settings should match the server's default settings! *
 */
#define MIN_SERVER_UPDATE_INTERVAL 50
#define MAX_SERVER_UPDATE_INTERVAL 5000
#define DEFAULT_UPDATE_INTERVAL 1000


/*
 *   Object Assume Outdated Duration:
 *
 *	Objects that have not been updated by the server or client for
 *	this many milliseconds will not be drawn.  However the object
 *	will not be recycled.
 */
#define OBJECT_OUTDATED_INTERVAL 6000



/*
 * *********************************************************************
 * *********************************************************************
 * ***      THERE IS NO NEED FOR USER EDITING BELOW THIS LINE        ***
 * *********************************************************************
 * *********************************************************************
 */

/*
 *   Master name and version strings:
 */
#define XSW_NAME "XShipWars"
#define XSW_VERSION "0.54"


/*
 *   Copyright information:
 */
#define XSW_COPYRIGHT \
"Copyright (C) 1997, 1998 Taura (learfox@hotmail.com)\n\
This is a developer's edition and is not publically distributed.\n\
Permission is NOT granted to distribute, use, modify, or copy this\n\
program.\n"



/*
 *   Main Loop Interval:
 *
 *	In microseconds (1000000 microseconds = 1 second).
 *
 *	WARNING: Changing MAIN_LOOP_INTERVAL value will change results from
 *	velocity, acceleration, and other such calculations.
 *	Default is 1000.
 *
 *	MAIN_LOOP_CATCHUP is the interval to sleep whenever a loop cycle took
 *	longer than MAIN_LOOP_INTERVAL microseconds to complete.
 */
#define MAIN_LOOP_INTERVAL 16000
#define MAIN_LOOP_CATCHUP  14000

/*
 *   Timming Intervals:
 *
 *	In milliseconds (1000 milliseconds = 1 second).
 */
#define MEMORY_CLEAN_INTERVAL      10000
#define SCANNER_REFRESH_INTERVAL   200
#define STATS_REFRESH_INTERVAL     1500


/*
 *   Maximum Local Execution Argument Length:
 *
 *	In bytes.
 */
#define MAX_LEXEC_ARG_LEN 1024


/*
 *   Maximum Values:
 *
 *	These are general maximum values.
 */
#define MESSAGE_WIN_TOTAL_MESSAGES 100
#define MAX_SWSERV_ADDRESS_ENTRIES 100
#ifndef MAXBUFLEN
   #define MAXBUFLEN 32767
#endif


/*
 *   History Buffers:
 *
 *	Various definations for history buffers.
 */
#define MAX_HISTORY_ITEMSIZE 1024	/* In bytes. */
#define MAX_HISTORY_ITEMS 50
#define MAX_HISTORY_BUFFERS 4	/* Must be greater than highest */
				/* buffer type!                 */
#define HISTORY_TYPE_LEXEC 0
#define HISTORY_TYPE_EXEC 1
#define HISTORY_TYPE_CONNECT 2
#define HISTORY_TYPE_INTERCEPT 3


/*
 *   Window Attributes Mask:
 */
#define WIN_ATTR_MASK CWBackPixel|CWBorderPixel|   \
                      CWBackPixmap|CWBorderPixmap| \
                      CWBitGravity|CWWinGravity|   \
                      CWColormap|CWBackingStore|CWCursor

/*
 *   Window XEvent Mask:
 *
 *	Mask of events to watch for.
 */
#define toplevel_eventmask ExposureMask| \
                           KeyPressMask|KeyReleaseMask| \
                           ButtonPressMask|ButtonReleaseMask

#define button_eventmask ExposureMask| \
                         ButtonPressMask|ButtonReleaseMask| \
                         KeyPressMask|KeyReleaseMask

#define XSW_OBJ_WIN_EVENTMASK ButtonPressMask




/* **********************************************************************
 *
 *                         GLOBAL VARIABLES
 *
 */

/*
 *   Process handling:
 *
 *	Note the rootpid is the PID of the main xpppcon process,
 *	the process that started it all.   childpid can change
 *	during execution, it will contain and child processes'
 *      PID.
 */
pid_t rootpid;
pid_t childpid;
int child_procs;


/*
 *   Current MilliTime:
 *
 *	Contains the number of milliseconds since midnight.
 *	The contents of this variable are updated in main() with
 *	a call to MilliTime().
 */
long cur_millitime;


/*
 *   FPS Counter:
 *
 */
typedef struct
{
    long fcount;	/* Frames drawn counter. */
    long lfcount;       /* Last time frames drawn record. */
    long lastud;        /* In milliseconds. */
    long interval;	/* Should always be 1000. */
} fps_counter_struct;
fps_counter_struct fps_counter;


/*
 *   General Animation Timmer
 *
 */
typedef struct
{
    long count;		/* 0 to count_max - 1. */
    long count_max;
    long lastud;        /* In milliseconds. */
    long interval;
} genanim_timmer_struct;
genanim_timmer_struct genanim_timmer[1];


/*
 *   Verbose:
 *   
 *      Prints various action/event messages if True.
 *      This feature may be elimited after the beta testing is over.
 */
Bool verbose_bool;
Bool print_event_bool;


/*
 *   XLib Resources:
 */
Display                 *display;	/* Default display. */
int                     scr_num;	/* Default screen number. */
Screen                  *scr_ptr;	/* Default screen pointer. */
Visual                  *visual;	/* Default visual. */
int                     depth;		/* Depth. */
XSetWindowAttributes    attributes;		/* Set window attributes. */
XWindowAttributes	winattributes;		/* Return Window attributes. */
unsigned long           black_pix, white_pix;	/* Default pixels. */
GC                      the_GC;		/* Graphics context. */
XGCValues		GCvalues;	/* Graphics context values. */
Colormap                colormap;	/* Default colormap. */
XColor                  xcolor;		/* Default xcolor. */
XSizeHints		sizehints;	/* X size hints. */
XWMHints		wmhints;	/* Window manager size hints. */

/* XEvents. */
XEvent buttonpress_xevent,
       buttonrelease_xevent,
       keypress_xevent,
       keyrelease_xevent,
       expose_xevent,
       destroy_xevent;

/* XFontinfos. */
XFontStruct *normal_xfont,
            *bold_xfont;

/* XFontnames. */
char *normal_fontname;
char *bold_fontname;

/* XColors. */
XColor normal_text_xcolor,
       bold_text_xcolor,
       light_grey_xcolor,
       dark_grey_xcolor,

       status_text_xcolor,
       hull_bar_xcolor,
       power_bar_xcolor,
       shields_bar_xcolor,
       weapons_lock_xcolor,
       selected_weapon_xcolor,
       unselected_weapon_xcolor,
       visibility_bar_xcolor,
       intercept_xcolor,
       throttle_bar_xcolor,
       velocity_bar_xcolor,
       antimatter_bar_xcolor,
       dmgctl_bar_xcolor,

       star1_xcolor,
       star2_xcolor,
       star3_xcolor,
       star4_xcolor,
       star5_xcolor,
       star6_xcolor,
       star7_xcolor,
       star8_xcolor,
       star9_xcolor;


/* Pixels numbers. */
unsigned long normal_text_pixel,
              bold_text_pixel,
              light_grey_pixel,
              dark_grey_pixel,

              status_text_pixel,
              hull_bar_pixel,
              power_bar_pixel,
              shields_bar_pixel,
              weapons_lock_pixel,
              selected_weapon_pixel,
              unselected_weapon_pixel,
              visibility_bar_pixel,
              intercept_pixel,
              throttle_bar_pixel,
              velocity_bar_pixel,
              antimatter_bar_pixel,
	      dmgctl_bar_pixel,

              star1_pixel,
              star2_pixel,
              star3_pixel,
              star4_pixel,
              star5_pixel,
              star6_pixel,
              star7_pixel, 
              star8_pixel,
              star9_pixel;


/*
 *   Windows:
 */
Window toplevel,
       game_win,		/* Where all the action is. */
       player_stats_win,	/* Long vertical window on the left. */
       sensor_win,		/* Sensor map window on the upper right. */
       sensor_readout_win,	/* Sensor verbose info on the lower right. */
       message_win;             /* Message window, center bottom. */

Window loadstatus_win,          /* Startup status window. */
       loadstatus_pbar_win;     /* Message window on status window.



/*
 *   Pixmaps:
 *
 *	These pixmaps are used on the primary windows, toplevel, etc.
 *	Each XSW Object will have an associated imageset, the imageset structure
 *	is declared farther below.
 */
Pixmap startup_bkg_pixmap,      /* Startup (loading status) window background. */
       xsw_icon_pixmap,         /* XSW's Icon. */
       xsw_title_sm_pixmap,     /* Small XSW title. */
       bridge_pixmap,           /* Bridge surroundings (big image). */
       bridge_mask_pixmap;

/*
 *   Key Input Prompt Modes:
 *
 *	These are used in inhandler.c's key input handling functions.
 *	When one of these are true, all key inputs will be considered
 *	additional input to a function in question that has been activated.
 *
 *	For example; if the "i" key was pressed, then intercept_prompt will
 *	be set to True and the next key inputs will be considered an object
 *	number, untill the enter key has been pressed.
 */
Bool message_prompt,
     intercept_prompt,
     connect_prompt,
     shield_frequency_prompt,
     lexec_prompt,
     exec_prompt,
     exit_prompt;

Bool shift_key_state;

char message_prompt_buffer[1024],
     intercept_prompt_buffer[1024],
     connect_prompt_buffer[1024],
     shield_frequency_prompt_buffer[1024],
     lexec_prompt_buffer[MAX_LEXEC_ARG_LEN],
     exec_prompt_buffer[MAX_NET_CMD_SIZE];


/*
 *   Command history buffers
 *
 *	These are command history buffers for local executed commands
 *	and remote executed commands.
 */
typedef struct
{
    char item[MAX_HISTORY_ITEMSIZE];
} buffer_item_struct;

typedef struct
{
    long current_item;
    buffer_item_struct items[MAX_HISTORY_ITEMS];
} history_buffer_struct;

history_buffer_struct history_buffer[MAX_HISTORY_BUFFERS];


/*
 *   Redraw Counters:
 */
int button_draw_count;



/*
 *   Keymapping Structure:
 *
 *	For user defined key mapping in xkey form.
 */
typedef struct
{
    unsigned int help;
    unsigned int display_arrow;
    unsigned int display_labels;
    unsigned int display_events;

    unsigned int net_interval_dec;
    unsigned int net_interval_inc;

    unsigned int mesg_win_scroll_up;
    unsigned int mesg_win_scroll_down;

    unsigned int net_connect;
    unsigned int net_disconnect;
    unsigned int net_refresh;

    unsigned int net_exec;
    unsigned int local_exec;

    unsigned int scanner_toggle;
    unsigned int scanner_zin;
    unsigned int scanner_zout;
    unsigned int scanner_max;

    unsigned int joystick_mode;
    unsigned int reverse_thrust;

    unsigned int shields_toggle;
    unsigned int dmgctl_toggle;
    unsigned int cloak_toggle;

    unsigned int select_weapon1;
    unsigned int select_weapon2;
    unsigned int select_weapon3;
    unsigned int select_weapon4;
    unsigned int select_weapon5;	/* Weapon 5 and greater not supported. */
    unsigned int select_weapon6;
    unsigned int select_weapon7;
    unsigned int select_weapon8;
    unsigned int select_weapon9;

    unsigned int weapons_lock;
    unsigned int weapons_unlock;

    unsigned int set_intercept;
    unsigned int set_shield_freq;

    unsigned int send_message;

    unsigned int exit;

} xsw_keymap_struct;
xsw_keymap_struct xsw_keymap;



/*
 *   Full Pathnames to Files:
 */
char js_calibration_file_fullname[1024];
char xsw_rcfile_fullname[1024];


/*
 *   message_win Message Structure
 */
typedef struct
{
	char message[256];
	unsigned long pixel;	/* Pixel for the color. */
} message_win_struct;

message_win_struct message_win_message[MESSAGE_WIN_TOTAL_MESSAGES];
long message_win_curline;	/* Current, bottom-most line, */
				/* can be 0 to                */
				/* MESSAGE_WIN_TOTAL_MESSAGES */


/*
 *   Local Player Object Number:
 *
 *	Contains the number for the local player object.
 *	All local redraws and inputs are relative to this object.
 */
long lplayer_object;



/*
 *   Joystick Configuration Structure:
 */
typedef struct
{  
	int x_min;	   /* Min and max stick values. */
	int x_max;
	int y_min;
	int y_max;
	int x;		   /* Current raw x and y stick values. */
	int y;
	int nullzone;      /* Total width of nullzone. */
	int button1_state; /* 0 = unarmed, 1 = armed, -1 = not exist */
	int button2_state;
	int button3_state;
	int button4_state;
} joystick_data_struct;

joystick_data_struct joystick_data;



/*
 *   Joystick File Descriptor:
 */
#ifdef LINUX
   int joystick_fd;
#endif

int js_throttle_mode;


/*
 *   Show Idetifiers:
 *
 *	Indicates if certain identifiers on the game_win should be drawn
 *	(ie heading arrow and object names).
 *	1 = Show, 0 = Not Show
 */
int show_heading_arrow;
int show_object_names;
double scanner_zoom_scale;	/* For the scanner window. */



/*
 *   Site `Address Book':
 *
 *	This structure contains a list of site addresses and ports
 *	for easy connecting.  Each address is associated with an `alias'.
 */
typedef struct
{
	char url[1024];
	char alias[256];
} swserv_addr_ent_struct;
swserv_addr_ent_struct swserv_addr_ent[MAX_SWSERV_ADDRESS_ENTRIES];
long total_address_entries;


/*
 *   Network Variables:
 */
int connection_state;		/* 0 = not connected. */
				/* 1 = connected, logging in. */
				/* 2 = connected. */

int swserv_socket;		/* Socket number to the server. */
				/* -1 means unconnected.        */
char loginname[MAX_NAME_LENGTH];
char loginpassword[MAX_PASSWORD_LENGTH];
int swserv_address_set;		/* 1 = Address to server set at */
				/* command line, 0 = not.       */

char swservaddress[1024];
int swservport;

long net_server_update_interval;    /* In milliseconds. */

int disconnect_send_count;	    /* Times the disconnect key */
				    /* was pressed.  Reset to 0 */
				    /* on connects.             */


/* *******************************************************************
 *
 *                        GLOBAL FUNCTIONS
 */

/* In db.c. */
extern void DBClearObjectsFromMemory();
extern long DBCleanMemory();
extern long DBCreateObject(Window parent_win, long imageset);
extern int DBCreateExplicitObject(long object_num, long imageset, Window parent_win);
extern long DBCreateExplosion1(double loc_x, double loc_y);
extern long DBCreateExplosion2(double loc_x, double loc_y);
extern void DBRecycleObject(long object_num);
extern long DBGetTopObjectNumber();
extern double DBGetObjectVisibility(long object_num);


/* In devices.c */
extern int JSInitialize(char *jsdevicenode, char *jscalfile);
extern double JSGetThrottle(int jsfd, int throttle_mode);
extern double JSGetTurn(int jsfd);
extern int JSGetButtonState(int jsfd, int button_number);


/* In draw.c */
extern int DrawSensor(
        long object_num,
        Window w,
        double win_x, double win_y,
        double height, double width,
        double scan_scale
);
extern int DrawLockCursor(Window w, double x_rel, double y_rel,
        double cur_size);
extern int DrawObjectAnimated(long object_num);
extern int DrawStreamWeapon(long object_num, double x_rel, double y_rel);
extern int DrawObjectImageset(long object_num);
extern int DrawHeadingArrow(Window w, double arrow_heading,
        unsigned int x_center, unsigned int y_center);
extern int DrawStarfield(Window w,
        double x_rel, double y_rel, int width, int height);
extern int DrawGameWin();
extern int DrawStats(Window w);
extern int DrawSensorReadout(Window w);
extern int DrawToplevel();


/* In history.c */
extern void HistoryClear(long history);
extern int HistoryAddItem(long history, char *item);


/* In images.c */
extern int IMGLoadBasic();
extern void IMGFreeAllImages();
extern int IMGLoadSpecified(long imageset_code, long frames);


/* In inhandler.c */ 
extern int EventHandleJSButton1Input();
extern int EventHandleJSButton2Input();
extern int EventHandleKeyInput(unsigned int in_keycode);
extern int EventHandleKeyReleaseInput(unsigned int in_keycode);
extern int EventHandleButton1PressInput(Window w, int x, int y);
extern int EventHandleButton3PressInput(Window w, int x, int y);
extern int EventHandleButtonReleaseInput(Window w, int x, int y);
extern int EventHandleWeaponFire(long object_num);


/* In keychart.c */
extern unsigned char xkeytoa(unsigned int in_xkey);


/* In lexec.c */
extern int LExecHandleInput(char *input);


/* In loadstatus.c */
extern int LSWinInit();
extern int LSWinDrawProgressBar(long items, long max_items, char *message);
extern void LSWinDestroy();


/* In match.c */
extern long MatchObjectWithWindow(Window w);
extern long MatchWeaponsLock(long ref_object, long start_object, double range);
extern long MatchInterceptByNumber(long ref_object, long target_object);


/* In math.c */
extern double MuPolarRotX(double input_angle, double input_radius);
extern double MuPolarRotY(double input_angle, double input_radius);
extern double MuLocationtoHeading(double delta_x, double delta_y);
extern double Mu3DDistance(double delta_x, double delta_y, double delta_z);
extern int Mu3DInContact(long object_num1, long object_num2);
extern int Mu3DInVectorContact(long object_num1, long object_num2, double
	heading, double heading_variance, double range);
extern int Mu3DInRange(long object_num1, long object_num2, double distance);


/* In messagewin.c */
extern int MesgWinAddMessage(char *new_mesg, unsigned long mesg_color); 
extern int DrawMessageWin();
extern int MesgWinReplaceMessage(char *new_mesg,
        unsigned long mesg_color, long mesg_num);


/* In net.c */ 
extern int NetSendData(char *outbounddata);
extern int NetOpenConnection(char *new_hostname, int new_portnum); 
extern int NetHandleLogin();
extern int NetSendGlobalMessage(char *message);
extern int NetSendDisconnect();
extern int NetSendSetInterval();
extern int NetSendExec(char *arg);
extern int NetSendLocalObjectPosition();
extern long NetHandleWhoAmI(char *arg);
extern int NetHandleRecycleObject(char *arg);
extern int NetHandleSetObjApp(char *arg);
extern int NetHandleSetObjectValues(char *arg);
extern int NetHandleSetObjectMaximums(char *arg);
extern int NetSendSetWeapon(int selected_weapon);
extern int NetSendSetShields(int shield_state, double shield_frequency);
extern int NetSendSetDmgCtl();
extern int NetSendSetCloak();
extern int NetSendWeaponsLock();
extern int NetSendWeaponsUnlock();
extern int NetSendIntercept();
extern int NetSendFireWeapon();
extern int NetHandleSetName(char *arg);
extern int NetHandleRecv();


/* In prochandle.c */
extern void fork_system(char *command_string);
extern void zombiekiller();


/* In rcfile.c */
extern int RCLoadFromFile(char *filename);


/* In strings.c */
extern char *StringStripSpaces(char *string);
extern char *StringParseAddress(char *input_str);
extern int StringParsePort(char *input_str);
extern int StringGetNetCommand(char *input_str);
extern char *StringGetNetArgument(char *input_str);


/* In timming.c */
extern long MilliTime();
extern long UTime();


/* In update.c */
extern int UpdateObject(long object_num);


/* In weapons.c */
extern int WepCreate(
        long weapon_type,
        long owner,       /* Must not be garbage or error. */
        double birth_x,
        double birth_y,
        double birth_heading,
        double power,
        double range      /* Disgarded for projectile weapons */
);


/* In xpm.c */
extern Pixmap readpixmapfile(char *xpmfilename);
extern Pixmap readbitmapfile(char *xbmfilename);
extern Pixmap readpixmapdata(char **xpmdata);  


/* In xsw.c */
extern void xsw_exit_CB();




#endif
