/* ********************************************************************
 *
 *	strings.c	String Parsers
 *	------------------------------
 *	Functions:
 *
 *	char *StringStripSpaces(char *string)
 *	char *StringParseAddress(char *input_str)
 *	int StringParsePort(char *input_str)
 *	int StringGetNetCommand(char *input_str)
 *	char *StringGetNetArgument(char *input_str)
 *
 *	---
 *
 *	StringStripSpaces() returns a pointer to a string identical
 *	to input string string with leading and tailing white space
 *	characters removed.
 *
 *	StringParseAddress() takes the address out of standard URL
 *	formatted string input_str.   Returns pointer to string
 *	containing address of the site or NULL on error.
 *
 *	StringParsePort() takes the port number out of standard URL
 *	formatted string input_str.   Returns the port number or
 *	-1 on error.
 *
 *	StringGetNetCommand() returns the net command (see netcodes.h)
 *	extracted from input_str.   Returns -1 on error.
 *
 *	StringGetNetArgument() returns pointer to argument string
 *	extracted from input_str.   Returns "" on error or no argument
 *	found.
 *
 *
 */

#include "../include/xsw.h"



char *StringStripSpaces(char *string)
{
        /* Local variables. */
        int x, y, z;
        char work_str[16384];
        static char rtn_str[16384];


        /* string must be atleast 1 character long. */
        if(strlen(string) < 1)
                return("");


        strncpy(work_str, string, 16384);
        work_str[16384 - 1] = '\0';


        /* Get x as starting character position on work_str for rtn_str. */
        for(x = 0; x < 16384; x++)
        {
            if(work_str[x] != ' ')
                break;
        }

        /* Start copying work_str to rtn_str, skipping leading spaces */
        /* on work_str.                                               */
        for(y = 0; y < 16384; y++, x++)
        {        
            if(work_str[x] == '\0')
            {
                rtn_str[y] = '\0';
                break;
            }
            rtn_str[y] = work_str[x];
        }
        rtn_str[16384 - 1] = '\0';


        /* Get highest non space character on rtn_str as y. */
        for(x = 0, y = 0; x < (16384 - 1); x++)
        {
            if(rtn_str[x] == '\0')
                break;

            if(rtn_str[x] != ' ')
                y = x;
        }
        rtn_str[y + 1] = '\0';


        return(rtn_str);
}



char *StringParseAddress(char *input_str)
{
	/* Local variables. */
	static char return_str[1024];
	static char temp_str[1024];
	char *strptr;

	/* input_str must be atleast 1 character long. */
	if(strlen(input_str) <= 0)
		return(NULL);


	/* Copy input_str to return_str. */
	strcpy(return_str, input_str);


	/* See if return_str is prefixed with "proto://" */
        strcpy(temp_str, return_str);
	if( (strptr = strstr(temp_str, "//")) != NULL)
	{
		strcpy(return_str, strptr + 2);
	}


	/* See if return_str is postfixed with ":1234" */
	strcpy(temp_str, return_str);
	if( (strptr = strstr(temp_str, ":")) != NULL)
	{
		*strptr = '\0';
		strcpy(return_str, temp_str);
	}


	return(return_str);
}



int StringParsePort(char *input_str)
{
        /* Local variables. */
        int return_port;
        char stringa[1024];
        char stringb[1024];
        char *strptr;
         
         
        /* input_str must be atleast 1 character long. */
        if(strlen(input_str) <= 0)
                return(-1);
         
 
        return_port = -1;
        strcpy(stringa, input_str);
        
            
        /* Search for "://" in stringa. */
        if( (strptr = strstr(stringa, "://")) != NULL)
        {
                strcpy(stringb, strptr + 3);
                strcpy(stringa, stringb);
        }

         
        /* Search for ":" in stringa. */
        if( (strptr = strstr(stringa, ":")) != NULL)
        {
                strcpy(stringb, strptr + 1);
                return_port = atoi(stringb);
        }
        else
        {
                return(-1);
        }
        
        
        return(return_port);
}



int StringGetNetCommand(char *input_str)
{
	/* Local variables. */
	int command_rtn;
	char stringa[MAX_NET_CMD_SIZE];
	char *strptr;


	/* input_str must be atleast 1 character long. */
	if(strlen(input_str) < 1)
		return(-1);

	/* Copy input_str to stringa for working. */
	strcpy(stringa, input_str);

	/* See if there is a space. */
	if( (strptr = strchr(stringa, ' ')) != NULL )
	{
	    *strptr = '\0';
	}

	command_rtn = atoi(stringa);

	return(command_rtn);
}



char *StringGetNetArgument(char *input_str)
{
        /* Local variables. */
        static char arg_rtn[MAX_NET_CMD_SIZE];
        char stringa[MAX_NET_CMD_SIZE];
        char *strptr;
 

        /* input_str must be atleast 1 character long. */
        if(strlen(input_str) < 1)
                return("");
 

        /* Copy input_str to stringa for working. */
        strcpy(stringa, input_str);


        /* See if there is a space. */
        if( (strptr = strchr(stringa, ' ')) != NULL )
        {   
            strptr += 1;
	    strncpy(arg_rtn, strptr, MAX_NET_CMD_SIZE);
	    arg_rtn[MAX_NET_CMD_SIZE - 1] = '\0';
        }
	else
	{
	    return("");
	}


        return(arg_rtn);
}
