/* ****************************************************************************
 *   
 *	inhandler.c	Input Event Handler
 * 	-----------------------------------
 *	Functions:
 *
 *      int EventHandleJSButton1Input()
 *      int EventHandleJSButton2Input()
 *      int EventHandleKeyInput(unsigned int in_keycode)
 *	int EventHandleKeyReleaseInput(unsigned int in_keycode)
 *      int EventHandleButton1PressInput(Window w, int x, int y)
 *      int EventHandleButton3PressInput(Window w, int x, int y)
 *      int EventHandleButtonReleaseInput(Window w, int x, int y)
 *      int EventHandleWeaponFire(long object_num)
 *
 *	---
 *
 *	Handles XSW and X input events.
 * 
 *
 */

#include "../include/xsw.h"  



/* ****************************************************************************
 *   
 *   int EventHandleJSButton1Input()
 *
 *	Handles input mapping for joystick button 1.
 *	Button state will be checked within.
 */
int EventHandleJSButton1Input()
{
	/* Local variables. */


	/* swserv_socket must be connected, connection_state must be
	 * set to 2, and lplayer_object must be valid.
	 */
	if( (swserv_socket < 0) ||
	    (connection_state != 2) ||
	    (lplayer_object < 0) ||
	    (lplayer_object >= MAX_OBJECTS)
	)
		return(0);


#ifdef LINUX
	/* Handle button state. */
        if(JSGetButtonState(joystick_fd, 1) > 0)
        {
		EventHandleWeaponFire(lplayer_object);
        }
#endif


	return(0);
}



/* ****************************************************************************
 *
 *   int EventHandleJSButton2Input()
 *
 *      Handles input mapping for joystick button 2.
 *      Button state will be checked within.    
 *
 */

int EventHandleJSButton2Input()
{
        /* swserv_socket must be connected, connection_state must be
         * set to 2, and lplayer_object must be valid.
         */
        if( (swserv_socket < 0) ||
            (connection_state != 2) ||
            (lplayer_object < 0) ||
	    (lplayer_object >= MAX_OBJECTS)
        )
                return(0);

   
	/* If we are in js_throttle_mode (bi directional scope),
	 * then don't do thrust reversing.
	 */
	if(js_throttle_mode == 1)
		return(0);


#ifdef LINUX
	/* Handle button state. */
	if(JSGetButtonState(joystick_fd, 2) > 0)
        {
           if(joystick_data.button2_state == 0)
           {
		joystick_data.button2_state = 1;
                xsw_object[lplayer_object].thrust_dir = 0;
                xsw_object[lplayer_object].thrust_rev_state = 1;
		if(print_event_bool)
		{
                   MesgWinAddMessage(
                      "Engines: Reverse (Momentary).", light_grey_pixel);
		}

		/* Redraw player_stats_win. */
		DrawStats(player_stats_win);
            }
        }
	else
        {
            if(joystick_data.button2_state == 1)
            {
                joystick_data.button2_state = 0;
                xsw_object[lplayer_object].thrust_dir = 3.1415927;
                xsw_object[lplayer_object].thrust_rev_state = 0;

                /* Redraw player_stats_win. */
                DrawStats(player_stats_win);
            }  
        }
#endif
	

	return(0);
}



/* ****************************************************************************
 *
 *   int EventHandleKeyInput(unsigned int in_keycode)
 *
 *      Handles a local input KeyPress XEvent.
 *
 */

int EventHandleKeyInput(unsigned int in_keycode)
{
	/* Local Variables. */
	char stringa[256];
	char stringb[256];
	long x;


        /* Shift key (code 50 or 62). */
        if((in_keycode == 50) || (in_keycode == 62))
        {
                shift_key_state = True;
		return(0);
        }


	/* ******************************************************** */
	/* ***           Message Prompt Input Handling          *** */
	if(message_prompt)
	{
	    /* Enter key (code 36) */
	    if(in_keycode == 36)
	    {
	      if(strlen(message_prompt_buffer) > 0)
	      {
		if(swserv_socket < 0)
		{
		    MesgWinAddMessage("Not connected.", normal_text_pixel);
		}
		else
		{
		    sprintf(stringa, "Message: %s", message_prompt_buffer);
		    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);
		    NetSendGlobalMessage(message_prompt_buffer);
		}
              }
              message_prompt_buffer[0] = '\0';
              message_prompt = False;
	    }
            /* Backspace key (code 22) */
            else if(in_keycode == 22)
            {
                x = strlen(message_prompt_buffer);
                if(x > 0)
                        x--;
                message_prompt_buffer[x]='\0';
                sprintf(stringa, "Message: %s_", message_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
	    else
	    {
		if(strlen(message_prompt_buffer) < 127)
		{
                    sprintf(message_prompt_buffer, "%s%c",
                        message_prompt_buffer, xkeytoa(in_keycode));
                    sprintf(stringa, "Message: %s_", message_prompt_buffer);
	        }
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
	    }

	    /* Return, do not continue. */
	    return(0);
	}


        /* ******************************************************** */
        /* ***         Intercept Prompt Input Handling          *** */
        if(intercept_prompt)
        {
            /* Enter key (code 36) */
            if(in_keycode == 36)
            {
		if(strlen(intercept_prompt_buffer) > 0)
		{
		    NetSendIntercept(intercept_prompt_buffer);
		    sprintf(stringa, "Intercept: %s", intercept_prompt_buffer);
                    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);
		}
                else
                {
                    NetSendIntercept("#off");
                    strncpy(stringa, "Intercept: #off", 256);
                    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);
		}

		intercept_prompt_buffer[0] = '\0';
		intercept_prompt = False;
            }
            /* Backspace key (code 22) */
            else if(in_keycode == 22)
            {
		x = strlen(intercept_prompt_buffer);
		if(x > 0)
			x--;
		intercept_prompt_buffer[x]='\0';
		sprintf(stringa, "Intercept: %s_", intercept_prompt_buffer);
		MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
	    else
	    {
                sprintf(intercept_prompt_buffer, "%s%c",
                    intercept_prompt_buffer, xkeytoa(in_keycode));
                sprintf(stringa, "Intercept: %s_", intercept_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
	    }


            /* Return, do not continue. */
            return(0);
        }


        /* ******************************************************* */
        /* ***            Connect to Server Prompt             *** */

	if(connect_prompt)
	{
            /* Enter key (code 36) */
            if(in_keycode == 36)
            {
              if(strlen(connect_prompt_buffer) > 0)
              {
                  sprintf(stringa, "Connect to: %s",
                        connect_prompt_buffer
                  );
                  MesgWinReplaceMessage(stringa, normal_text_pixel, 0);

		  if(strchr(connect_prompt_buffer, ':') == NULL)
		  {
                    swservport = -1;
                    for(x = 0; x < total_address_entries; x++)
                    {
                       if(strcmp(connect_prompt_buffer, swserv_addr_ent[x].alias) == 0)
                       {
                          strcpy(swservaddress,
                             StringParseAddress(swserv_addr_ent[x].url));
                          swservport = StringParsePort(swserv_addr_ent[x].url);
                          break;
                       }
                    }
                    /* Did we find an alias match? */
                    if(swservport < 0)
                    {
                       sprintf(stringa, "%s: No such alias.", connect_prompt_buffer);
                       MesgWinAddMessage(stringa, normal_text_pixel);
		       connect_prompt_buffer[0] = '\0';
		       connect_prompt = False;
                       return(-1);
                    }
		  }
		  else
		  {
		    if(StringParseAddress(connect_prompt_buffer) == NULL)
		    {
		       MesgWinAddMessage("Cannot parse address.",
			 normal_text_pixel);
		       connect_prompt_buffer[0] = '\0';
		       connect_prompt = False;
		       return(-1);
		    }
		    strcpy(swservaddress, StringParseAddress(connect_prompt_buffer));
		    swservport = StringParsePort(connect_prompt_buffer);
		  }

		  /* Open connection. */
		  swserv_socket = NetOpenConnection(swservaddress, swservport);

		  if(swserv_socket < 0)
		  {
		     sprintf(stringa, "Unable to connect to: %s  port: %i",
			swservaddress, swservport);
                     MesgWinAddMessage(stringa, normal_text_pixel);
		  }
	          /* We're connected, set up some default connect values. */
		  else
		  {
		     MesgWinAddMessage("Connected!", normal_text_pixel);
		     /* Set default update interval. */
		     net_server_update_interval = DEFAULT_UPDATE_INTERVAL;
		     /* Set connection_state to 1. */
		     connection_state = 1;
		  }

                  /* Record this in history buffer. */
                  HistoryAddItem(HISTORY_TYPE_CONNECT, connect_prompt_buffer);
                  history_buffer[HISTORY_TYPE_CONNECT].current_item = -1;
              }
	      else
	      {
		  /* Print book marked server addresses. */
		  for(x = 0; x < total_address_entries; x++)
		  {
		      sprintf(stringa, "%s: %s",
			swserv_addr_ent[x].alias,
			swserv_addr_ent[x].url
		      );
                      MesgWinAddMessage(stringa, normal_text_pixel);
		  }
	      }
	      DBClearObjectsFromMemory();
	      XUnmapSubwindows(display, game_win);
              connect_prompt_buffer[0] = '\0';
              connect_prompt = False;
            }
            /* Up cursor (code 128) */
            else if(in_keycode == 128)
            {
                history_buffer[HISTORY_TYPE_CONNECT].current_item++;
                if(history_buffer[HISTORY_TYPE_CONNECT].current_item >=   
                    MAX_HISTORY_ITEMS)
                {   
                    history_buffer[HISTORY_TYPE_CONNECT].current_item =
                        MAX_HISTORY_ITEMS - 1;
                }

                strncpy(connect_prompt_buffer,
                    history_buffer[HISTORY_TYPE_CONNECT].items[
                        history_buffer[HISTORY_TYPE_CONNECT].current_item
                    ].item, 1024);

                sprintf(stringa, "Connect to: %s_", connect_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            /* Down cursor (code 93) */
            else if(in_keycode == 93)
            {
                history_buffer[HISTORY_TYPE_CONNECT].current_item--;
                if(history_buffer[HISTORY_TYPE_CONNECT].current_item < 0)
                {
                    history_buffer[HISTORY_TYPE_CONNECT].current_item = 0;
                }

                strncpy(connect_prompt_buffer,
                    history_buffer[HISTORY_TYPE_CONNECT].items[
                        history_buffer[HISTORY_TYPE_CONNECT].current_item
                    ].item, 1024);

                sprintf(stringa, "Connect to: %s_", connect_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            /* Backspace key (code 22) */ 
            else if(in_keycode == 22)
            {
                x = strlen(connect_prompt_buffer);
                if(x > 0)
                        x--;
                connect_prompt_buffer[x]='\0';
                sprintf(stringa, "Connect to: %s_", connect_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            else
            {
		if(strlen(connect_prompt_buffer) < 127)
		{
                    sprintf(connect_prompt_buffer, "%s%c", 
                        connect_prompt_buffer, xkeytoa(in_keycode));
                    sprintf(stringa, "Connect to: %s_", connect_prompt_buffer);
		}
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }

            /* Return, do not continue. */
            return(0);
	}


        /* ******************************************************* */
        /* ***             Shield Frequency Prompt             *** */
	if(shield_frequency_prompt)
	{
            /* Enter key (code 36) */
            if(in_keycode == 36)
            {
                if(strlen(shield_frequency_prompt_buffer) > 0)
                { 
		    sscanf(shield_frequency_prompt_buffer, "%lf",
			&xsw_object[lplayer_object].shield_frequency);
		    NetSendSetShields(
			xsw_object[lplayer_object].shield_state,		
			xsw_object[lplayer_object].shield_frequency
		    );
                    sprintf(stringa, "Shield frequency: %s",
                        shield_frequency_prompt_buffer);
                    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);
                }
	        shield_frequency_prompt_buffer[0] = '\0';
                shield_frequency_prompt = False;
            }
            /* Backspace key (code 22) */
            else if(in_keycode == 22)
            {
                x = strlen(shield_frequency_prompt_buffer);
                if(x > 0)
                        x--;
                shield_frequency_prompt_buffer[x]='\0';
                sprintf(stringa, "Shield frequency: %s_",
		    shield_frequency_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            else 
            {  
                sprintf(shield_frequency_prompt_buffer, "%s%c",
                    shield_frequency_prompt_buffer, xkeytoa(in_keycode));
                sprintf(stringa, "Shield frequency: %s_",
		    shield_frequency_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }

            /* Return, do not continue. */
            return(0);
	}


	/* ******************************************************** */
	/* ***         Local Execution Prompt Handling          *** */
	if(lexec_prompt)
	{
            /* Enter key (code 36) */
            if(in_keycode == 36)
            {
                if(strlen(lexec_prompt_buffer) > 0)
                {
		    lexec_prompt_buffer[MAX_LEXEC_ARG_LEN - 1] = '\0';

		    sprintf(stringa, "Local command: %s",
			lexec_prompt_buffer);
		    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);

		    LExecHandleInput(lexec_prompt_buffer);

                    /* Record this in history buffer. */
                    HistoryAddItem(HISTORY_TYPE_LEXEC, lexec_prompt_buffer);
                    history_buffer[HISTORY_TYPE_LEXEC].current_item = -1;
                }
		else
		{
                    strncpy(stringa, "Local command: *Canceled*", 256);
                    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);
		}
                lexec_prompt_buffer[0] = '\0';
                lexec_prompt = False;
            }
            /* Up cursor (code 128) */
            else if(in_keycode == 128)
            {    
                history_buffer[HISTORY_TYPE_LEXEC].current_item++;
                if(history_buffer[HISTORY_TYPE_LEXEC].current_item >=
                    MAX_HISTORY_ITEMS)
                {   
                    history_buffer[HISTORY_TYPE_LEXEC].current_item =
                        MAX_HISTORY_ITEMS - 1;
                }

                strncpy(lexec_prompt_buffer,
                    history_buffer[HISTORY_TYPE_LEXEC].items[
                        history_buffer[HISTORY_TYPE_LEXEC].current_item
                    ].item, MAX_LEXEC_ARG_LEN);

                sprintf(stringa, "Local command: %s_", lexec_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            /* Down cursor (code 93) */
            else if(in_keycode == 93)
            {
                history_buffer[HISTORY_TYPE_LEXEC].current_item--;
                if(history_buffer[HISTORY_TYPE_LEXEC].current_item < 0)
                {
                    history_buffer[HISTORY_TYPE_LEXEC].current_item = 0;
                }

                strncpy(lexec_prompt_buffer,
                    history_buffer[HISTORY_TYPE_LEXEC].items[
                        history_buffer[HISTORY_TYPE_LEXEC].current_item
                    ].item, MAX_LEXEC_ARG_LEN);

                sprintf(stringa, "Local command: %s_", lexec_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            /* Backspace key (code 22) */
            else if(in_keycode == 22)
            {
                x = strlen(lexec_prompt_buffer);
                if(x > 0)
                        x--;
                lexec_prompt_buffer[x]='\0';
                sprintf(stringa, "Local command: %s_",
                    lexec_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            else
            {
                if(strlen(lexec_prompt_buffer) < MAX_LEXEC_ARG_LEN)
                {
                    sprintf(lexec_prompt_buffer, "%s%c",
                        lexec_prompt_buffer, xkeytoa(in_keycode));
                    sprintf(stringa, "Local command: %s_",
                        lexec_prompt_buffer);
                    MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
		}
            }


            /* Return, do not continue. */
            return(0);
	}



        /* ******************************************************** */
        /* ***         Server Execution Prompt Handling         *** */
        if(exec_prompt)
        {
            /* Enter key (code 36) */
            if(in_keycode == 36)
            {
                if(strlen(exec_prompt_buffer) > 0)   
                {
                    exec_prompt_buffer[MAX_NET_CMD_SIZE - 1] = '\0';
             
                    sprintf(stringa, "Remote command: %s",
                        exec_prompt_buffer);
                    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);

                    NetSendExec(exec_prompt_buffer);

		    /* Record this in history buffer. */
		    HistoryAddItem(HISTORY_TYPE_EXEC, exec_prompt_buffer);
		    history_buffer[HISTORY_TYPE_EXEC].current_item = -1;
                }
		else
		{
                    strncpy(stringa, "Remote command: *Canceled*", 256);
                    MesgWinReplaceMessage(stringa, normal_text_pixel, 0);
		}
                exec_prompt_buffer[0] = '\0';
                exec_prompt = False;
            }
	    /* Up cursor (code 128) */
            else if(in_keycode == 128)
            {
		history_buffer[HISTORY_TYPE_EXEC].current_item++;
		if(history_buffer[HISTORY_TYPE_EXEC].current_item >=
		    MAX_HISTORY_ITEMS)
		{
		    history_buffer[HISTORY_TYPE_EXEC].current_item =
			MAX_HISTORY_ITEMS - 1;
		}

		strncpy(exec_prompt_buffer,
		    history_buffer[HISTORY_TYPE_EXEC].items[
                        history_buffer[HISTORY_TYPE_EXEC].current_item
		    ].item, MAX_NET_CMD_SIZE);

		sprintf(stringa, "Remote command: %s_", exec_prompt_buffer);
		MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
	    }
            /* Down cursor (code 93) */
            else if(in_keycode == 93)
            {
                history_buffer[HISTORY_TYPE_EXEC].current_item--;
                if(history_buffer[HISTORY_TYPE_EXEC].current_item < 0)
                {
                    history_buffer[HISTORY_TYPE_EXEC].current_item = 0;
                }
             
                strncpy(exec_prompt_buffer,
                    history_buffer[HISTORY_TYPE_EXEC].items[
                        history_buffer[HISTORY_TYPE_EXEC].current_item
                    ].item, MAX_NET_CMD_SIZE);
             
                sprintf(stringa, "Remote command: %s_", exec_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            /* Backspace key (code 22) */
            else if(in_keycode == 22)
            {
                x = strlen(exec_prompt_buffer);
                if(x > 0)
                        x--;
                exec_prompt_buffer[x]='\0';
                sprintf(stringa, "Remote command: %s_",
                    exec_prompt_buffer);
                MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
            }
            else
            {
                if(strlen(exec_prompt_buffer) < MAX_LEXEC_ARG_LEN)
                {
                    sprintf(exec_prompt_buffer, "%s%c",
                        exec_prompt_buffer, xkeytoa(in_keycode));
                    sprintf(stringa, "Remote command: %s_",
                        exec_prompt_buffer);
                    MesgWinReplaceMessage(stringa, bold_text_pixel, 0);
                }
            }
                
             
            /* Return, do not continue. */
            return(0);
        }




	/* ******************************************************* */
	/* ***             Normal Key Input Checking           *** */

        /* Print help. */
        if(in_keycode == xsw_keymap.help)
        {
                message_win_print_help();
        }

        /* Display heading arrow. */
        else if(in_keycode == xsw_keymap.display_arrow)
        {
           if(show_heading_arrow == 0)
                show_heading_arrow = 1;
           else
                show_heading_arrow = 0;
        }

        /* Display labels. */
        else if(in_keycode == xsw_keymap.display_labels)
        {
           if(show_object_names == 0)
                show_object_names = 1;
           else
                show_object_names = 0;
        }

        /* Display events. */
        else if(in_keycode == xsw_keymap.display_events)
        {
           if(print_event_bool)
           {
                MesgWinAddMessage(
                   "Event Messages: OFF",
                   normal_text_pixel
                );
                print_event_bool = False;
           } 
           else
           {
                MesgWinAddMessage(
                   "Event Messages: ON",
                   normal_text_pixel    
                );
                print_event_bool = True;
           } 
        }    

        /* Net update interval decrease. */
        else if(in_keycode == xsw_keymap.net_interval_dec)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
                /* Decrease interval by 25 milliseconds.*/
                net_server_update_interval = net_server_update_interval - 25;
                if(net_server_update_interval < MIN_SERVER_UPDATE_INTERVAL)
                        net_server_update_interval = MIN_SERVER_UPDATE_INTERVAL;
                NetSendSetInterval();
            }
        }
                
        /* Net update interval increase. */
        else if(in_keycode == xsw_keymap.net_interval_inc)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
                net_server_update_interval = net_server_update_interval + 25;
                if(net_server_update_interval > MAX_SERVER_UPDATE_INTERVAL)
                        net_server_update_interval = MAX_SERVER_UPDATE_INTERVAL;
                NetSendSetInterval();
            }
        }

        /* Message window scroll up. */
        else if(in_keycode == xsw_keymap.mesg_win_scroll_up)
        {
           message_win_curline += 1;
           if(message_win_curline >= MESSAGE_WIN_TOTAL_MESSAGES)
              message_win_curline = MESSAGE_WIN_TOTAL_MESSAGES - 1;
           DrawMessageWin();
        }

        /* Message window scroll down. */
        else if(in_keycode == xsw_keymap.mesg_win_scroll_down)
        {
           message_win_curline -= 1;
           if(message_win_curline < 0)
              message_win_curline = 0;
           DrawMessageWin();
        }

        /* Net connect. */
        else if(in_keycode == xsw_keymap.net_connect)
        {
           if(swserv_socket < 0)
           {
                sprintf(connect_prompt_buffer,
                        "swserv://%s:%i",
                        swservaddress,
                        swservport
                );
                sprintf(stringa, "Connect to: %s_", connect_prompt_buffer);
                MesgWinAddMessage(stringa, bold_text_pixel);
                connect_prompt = True;  
           }
           else
           { 
                MesgWinAddMessage("You are already connected.",
                        normal_text_pixel);
           }
        }

        /* Net disconnect. */
        else if(in_keycode == xsw_keymap.net_disconnect)
        {
           if(swserv_socket >= 0)
           {
                MesgWinAddMessage(
                        "Disconnecting...", bold_text_pixel);
                NetSendDisconnect();
                disconnect_send_count++;
                /* Force disconnect after 3rd press. */
                if(disconnect_send_count > 2)
                {
                    swserv_socket = -1;
                    lplayer_object = -1;
                    connection_state = 0;
                    MesgWinAddMessage("Disconnected.", normal_text_pixel);
                    disconnect_send_count = 0;
                }
           }
           else
           {   
                MesgWinAddMessage("Not connected.",
                        normal_text_pixel);
           }
        }   

        /* Net refresh. */
        else if(in_keycode == xsw_keymap.net_refresh)
        {
           if(swserv_socket >= 0)
           {
                MesgWinAddMessage("Refresh request sent.", normal_text_pixel);
                sprintf(stringa, "%i\n%c", NET_CMD_REFRESH, '\0');
                NetSendData(stringa);
           }
           else
           {   
                MesgWinAddMessage("Not connected.",
                        normal_text_pixel);
           }
        }   

	/* Net Execute Server Command. */
	else if(in_keycode == xsw_keymap.net_exec)
	{
	    if(swserv_socket > -1)
	    {
		MesgWinAddMessage("Remote command: _", bold_text_pixel);
		exec_prompt = True;
	    }
	}

        /* Execute Local Client Command. */
        else if(in_keycode == xsw_keymap.local_exec)
        {
            MesgWinAddMessage("Local command: _", bold_text_pixel);
	    lexec_prompt = True;
	}

        /* Scanner Toggle. */
        else if(in_keycode == xsw_keymap.scanner_toggle)
        {




        }

        /* Scanner zoom in. */
        else if(in_keycode == xsw_keymap.scanner_zin)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
                scanner_zoom_scale += 1.8;
                if(scanner_zoom_scale > 1000)
                {
                    scanner_zoom_scale = 76 /
                    xsw_object[lplayer_object].scanner_range;
                }
                XClearWindow(display, sensor_win);
                DrawSensor(lplayer_object, sensor_win, 0, 0, 152, 152,
                    scanner_zoom_scale);
            }
        }

        /* Scanner zoom out. */
        else if(in_keycode == xsw_keymap.scanner_zout)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )                   
            {
               scanner_zoom_scale -= 1.8;
               if((scanner_zoom_scale * xsw_object[lplayer_object].scanner_range)
                < (76 / xsw_object[lplayer_object].scanner_range))
               {
                   scanner_zoom_scale = 76 /
                   xsw_object[lplayer_object].scanner_range;
               }
               XClearWindow(display, sensor_win);
               DrawSensor(lplayer_object, sensor_win, 0, 0, 152, 152,
                   scanner_zoom_scale);
            }
        }                         

        /* Scanner zoom max. */
        else if(in_keycode == xsw_keymap.scanner_max)
	{




	}

        /* Joystick throttle scope mode. */
        else if(in_keycode == xsw_keymap.joystick_mode)
        {           
            js_throttle_mode++;
            if(js_throttle_mode > 1)
                js_throttle_mode = 0;
         
            switch(js_throttle_mode)
            {
                case 1:
                    strcpy(stringa, "Throttle mode: Bi-directional scope.");
                    break;
            
                default:
                    strcpy(stringa, "Throttle mode: Normal scope.");
                    break;
            }
            MesgWinAddMessage(stringa, normal_text_pixel);
        }

        /* Reverse thrust. */
        else if(in_keycode == xsw_keymap.reverse_thrust)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (js_throttle_mode == 0)
            )
            {
                if(xsw_object[lplayer_object].thrust_rev_state == 0)
                {
                    xsw_object[lplayer_object].thrust_dir = 0;
                    xsw_object[lplayer_object].thrust_rev_state = 1;
                    MesgWinAddMessage("Engines: Reverse.", light_grey_pixel);
                }
                else
                {
                    xsw_object[lplayer_object].thrust_dir = 3.1415927;
                    xsw_object[lplayer_object].thrust_rev_state = 0;
                    MesgWinAddMessage("Engines: Forward.", light_grey_pixel);
                }
            }
            DrawStats(player_stats_win);
        }
 
        /* Shields toggle. */
        else if(in_keycode == xsw_keymap.shields_toggle)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
	        switch(xsw_object[lplayer_object].shield_state)
		{
	            case 1:
			NetSendSetShields(
				0,
				xsw_object[lplayer_object].shield_frequency
			);
			break;

                    case 0:
                        NetSendSetShields(  
                                1,
                                xsw_object[lplayer_object].shield_frequency
                        );
                        break;
		}
	    }
        }

        /* Dmgctl toggle. */ 
        else if(in_keycode == xsw_keymap.dmgctl_toggle)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
	    {
                NetSendSetDmgCtl();
	    }
        }

        /* Cloak toggle. */ 
        else if(in_keycode == xsw_keymap.cloak_toggle)
        {
            if( (lplayer_object > -1) &&  
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
	    {
                NetSendSetCloak();
	    }
        }

        /* Select weapon 1. */
        else if(in_keycode == xsw_keymap.select_weapon1)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (0 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 0;
                NetSendSetWeapon(0);
            }  
        }   
                
        /* Select weapon 2. */
        else if(in_keycode == xsw_keymap.select_weapon2)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (1 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 1;
                NetSendSetWeapon(1);
            }
        }

        /* Select weapon 3. */
        else if(in_keycode == xsw_keymap.select_weapon3)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) && 
                (connection_state == 2) &&
                (2 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 2;
                NetSendSetWeapon(2);
            }
        }
         
        /* Select weapon 4. */
        else if(in_keycode == xsw_keymap.select_weapon4)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) && 
                (connection_state == 2) &&
                (3 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 3;
                NetSendSetWeapon(3);
            }
        }

        /* Weapons lock. */
        else if(in_keycode == xsw_keymap.weapons_lock)
        {
            NetSendWeaponsLock();
        }
         
        /* Weapons unlock. */
        else if(in_keycode == xsw_keymap.weapons_unlock)
        {
            NetSendWeaponsUnlock();
        }
 
        /* Set intercept. */
        else if(in_keycode == xsw_keymap.set_intercept)
        {   
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {   
                intercept_prompt = True;
                sprintf(stringa, "Intercept: _");
                MesgWinAddMessage(stringa, bold_text_pixel);
            }   
        }

        /* Set shield frequency. */
        else if(in_keycode == xsw_keymap.set_shield_freq)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) && 
                (connection_state == 2) 
            )
            {
                shield_frequency_prompt = True;
                sprintf(shield_frequency_prompt_buffer, "%lf",
                        xsw_object[lplayer_object].shield_frequency);
                sprintf(stringa, "Shield frequency: %s_",
                        shield_frequency_prompt_buffer); 
                MesgWinAddMessage(stringa, bold_text_pixel);
            }
        }

        /* Send message. */
        else if(in_keycode == xsw_keymap.send_message)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )   
            {
                message_prompt = True;
		sprintf(stringa, "Message: _");
                MesgWinAddMessage(stringa, bold_text_pixel);
	    }
        }

        /* Exit. */
        else if(in_keycode == xsw_keymap.exit)
        {
		exit_prompt = True;
                MesgWinAddMessage(
		    "Are you sure you want to exit? (y/n): _", bold_text_pixel);
        }

        /* Unknown Command. */
        else
        {
           MesgWinAddMessage(
              "Unknown Command, Press \"F1\" for help.",
              normal_text_pixel
           );
        }


        /* Set button_draw_count to 0 so buttons will get drawn. */
        button_draw_count = 0;


	return(0);
}



/* ****************************************************************************
 *
 *   int EventHandleKeyReleaseInput(unsigned int in_keycode)
 *
 *	Handles local KeyRelease XEvent.
 *
 *
 */

int EventHandleKeyReleaseInput(unsigned int in_keycode)
{
        /* Shift key (code 50 or 62). */
        if((in_keycode == 50) || (in_keycode == 62))
        {
                shift_key_state = False;
		return(0);
        }








	return(0);
}



/* ****************************************************************************
 *
 *   int EventHandleButton1PressInput(Window w, int x, int y)
 *
 *	Handles a local input ButtonPress XEvent for Button1.
 *
 */

int EventHandleButton1PressInput(Window w, int x, int y)
{
	/* Local variables. */
	char stringa[256];



	/* ************************************************** */
	/* ***             player_stats_win               *** */

	/* Shield toggle. */
	if( (w == player_stats_win) &&
	    (x >= 15) &&
	    (x <= 137) &&
            (y >= 116) &&
            (y <= 131)
	)
	{
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
                switch(xsw_object[lplayer_object].shield_state)
                {
                    case 1:   
                        NetSendSetShields(
                                0,
                                xsw_object[lplayer_object].shield_frequency
                        );
                        break;
                
                    case 0:
                        NetSendSetShields(
                                1,
                                xsw_object[lplayer_object].shield_frequency
                        );
                        break;
                }
            }
	}

        /* Select weapon 1. */
        if( (w == player_stats_win) &&
            (x >= 3) &&
            (x <= 150) &&
            (y >= 182) &&
            (y <= 202)
        )
	{
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (0 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 0;
                NetSendSetWeapon(0);
            }
	}

        /* Select weapon 2. */
        if( (w == player_stats_win) &&
            (x >= 3) &&
            (x <= 150) &&
            (y >= 215) &&
            (y <= 235)
        )
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (1 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 1;
                NetSendSetWeapon(1);
            }
        }

        /* Select weapon 3. */
        if( (w == player_stats_win) &&
            (x >= 3) &&
            (x <= 150) &&
            (y >= 248) &&
            (y <= 268)    
        )
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (2 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 2;
                NetSendSetWeapon(2);
            }
        }

        /* Select weapon 4. */
        if( (w == player_stats_win) &&
            (x >= 3) &&
            (x <= 150) &&
            (y >= 281) &&
            (y <= 301) 
        )
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) &&
                (3 < xsw_object[lplayer_object].total_weapons)
            )
            {
                xsw_object[lplayer_object].selected_weapon = 3;
                NetSendSetWeapon(3);
            }
        }

        /* Cloak toggle. */
        if( (w == player_stats_win) &&
            (x >= 15) &&
            (x <= 137) &&
            (y >= 331) &&
            (y <= 346)
        )
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2) 
            )
            {
                NetSendSetCloak();
            }
        }


        /* Dmgctl toggle. */
        if( (w == player_stats_win) &&
            (x >= 15) &&
            (x <= 137) &&
            (y >= 545) &&
            (y <= 560)
        )
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
                NetSendSetDmgCtl();
            }   
        }


        /* ************************************************** */
        /* ***                sensor_win                  *** */
 
        /* Scanner zoom in. */
        if(w == sensor_win)
        {
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {
                scanner_zoom_scale += 1.8;
                if(scanner_zoom_scale > 1000)
                {
                    scanner_zoom_scale = 76 /
                    xsw_object[lplayer_object].scanner_range;
                }
                XClearWindow(display, sensor_win);
                DrawSensor(lplayer_object, sensor_win, 0, 0, 152, 152,
                    scanner_zoom_scale);
            }
        }           



        /* ************************************************** */
        /* ***            sensor_readout_win              *** */

        /* Weapons lock. */
        if(w == sensor_readout_win)
        {
            NetSendWeaponsLock();
        }









        /* Set button_draw_count to 0 so buttons will get drawn. */
	button_draw_count = 0;


	return(0);
}



/* ****************************************************************************
 *
 *   int EventHandleButton3PressInput(Window w)
 *
 *      Handles a local input ButtonPress XEvent for Button1.
 *
 */

int EventHandleButton3PressInput(Window w, int x, int y)
{
	/* Local variables. */
	char stringa[256];
	long object_count;









        /* ************************************************** */
        /* ***                sensor_win                  *** */

        /* Scanner zoom out. */
        if(w == sensor_win)
        {       
            if( (lplayer_object > -1) &&
                (swserv_socket > -1) &&
                (connection_state == 2)
            )
            {    
               scanner_zoom_scale -= 1.8;  
               if((scanner_zoom_scale * xsw_object[lplayer_object].scanner_range)
                < (76 / xsw_object[lplayer_object].scanner_range))
               {
                   scanner_zoom_scale = 76 /
                   xsw_object[lplayer_object].scanner_range;
               }
               XClearWindow(display, sensor_win);
               DrawSensor(lplayer_object, sensor_win, 0, 0, 152, 152,
                   scanner_zoom_scale);
            }
        }


        /* ************************************************** */
        /* ***            sensor_readout_win              *** */

        /* Weapons unlock. */
        if(w == sensor_readout_win)
        {
            NetSendWeaponsUnlock();
        }









        /* Search for an object. */
        object_count = MatchObjectWithWindow(w);
        if(object_count > -1)
        {
              sprintf(stringa,
                   "Scan results: %s(#%i)",
                   xsw_object[object_count].name,
                   object_count
              );
              MesgWinAddMessage(stringa, normal_text_pixel);
        }



        /* Set button_draw_count to 0 so buttons will get drawn. */
        button_draw_count = 0;


        return(0);
} 



/* ****************************************************************************
 *       
 *   int EventHandleButtonReleaseInput(Window w)
 *
 *      Handles a local input ButtonRelease.
 *
 */

int EventHandleButtonReleaseInput(Window w, int x, int y)
{







        /* Set button_draw_count to 0 so buttons will get drawn. */
        button_draw_count = 0;


	return(0);
}



/* ****************************************************************************
 *
 *   int EventHandleWeaponFire(long object_num)
 *
 *      Handles a weapons fire from XSW Object object_num.
 *
 */

int EventHandleWeaponFire(long object_num)
{
        /* Local variables. */
        int selected_weapon = 0;
        int objects_created = 0;


	/* Make sure object_num is valid. */
	if( (object_num < 0) || (object_num >= MAX_OBJECTS) )
		return(-1);
        /* object_num cannot be error or garbage. */
        if(xsw_object[object_num].type <= XSW_OBJ_TYPE_GARBAGE)
                return(-1);

        /* Get object_num's selected weapon. */
        selected_weapon = xsw_object[object_num].selected_weapon;

        /* Check if selected_weapon is valid. */
        if( (selected_weapon < 0) || (selected_weapon >= MAX_WEAPONS) )
                return(-1);
        if( selected_weapon >= xsw_object[object_num].total_weapons )
                return(-1);


	/* Check if we've waited the weapon's delay period. */
	if( (xsw_object[object_num].weapons[selected_weapon].last_used +
	    xsw_object[object_num].weapons[selected_weapon].delay) >=
	    cur_millitime
	)
	{
		return(0);
	}


	/* Send the fire weapon command to server. */
	if(NetSendFireWeapon() != 0)
		return(-1);


        /*
	 *   Mark last millitime this weapon was used.
	 *   The last used time sent by the server is ignored and the client
	 *   keeps track of the last used time.  Since the firing times and
	 *   weapon delay times are synced (or atleast reasonably synced)
	 *   there shouldn't be any problem.
	 */
        xsw_object[object_num].weapons[selected_weapon].last_used = cur_millitime;

	return(0);
}
