/* **********************************************************************
 *
 *	database.c	Database Handling
 *	---------------------------------
 *	Functions:
 *
 *	void DBClearObjectsFromMemory()
 *	long DBCleanMemory()
 *	long DBCreateObject(Window parent_win, long imageset)
 *	int DBCreateExplicitObject(long object_num, long imageset, Window
 *	    parent_win)
 *	long DBCreateExplosion1(double loc_x, double loc_y)
 *      long DBCreateExplosion2(double loc_x, double loc_y)
 *	void DBRecycleObject(long object_num)
 *      void DBEmergancySave()
 *	long DBGetTopObjectNumber()
 *      double DBGetObjectVisibility(long object_num)
 *
 *	---
 *
 *	Database IO is handled by these functions, including reading
 *	and writing database files, creating and removing database
 *	entries, and database management.   The XSW database is made up
 *	up of xsw_object[] entries.
 *
 *	DBClearObjectsFromMemory() removes any DB objects from memory,
 *	setting all of their types to XSW_OBJ_TYPE_GARBAGE.
 *
 *	DBCleanMemory() cleans memory, returns topmost object number
 *	relative to 0.   total_objects + 1 should be assigned this
 *	return value.
 *
 *	DBCreateObject() allocates a new space in memory for a new
 *	xsw object and creates a simple XLib window for it of width
 *	width and height height.   The window's coordinates will be
 *	set to x, y coordinates 0, 0 and the window itself will NOT
 *	be mapped, you must map it using XMapWindow().   The new xsw
 *	object will be initally set to be of type XSW_OBJ_TYPE_STATIC
 *	and have an imageset of IMAGESET_CODE_GENERIC.  Return value
 *	is the number for the newly created xsw object relative to 0.
 *
 *	DBCreateExplicitObject() similar to DBCreateObject(), with the
 *	exception that it creates an object with the number givin as
 *	object_num.   If object_num already exists, it will be recycled.
 *	Returns non-zero on error.
 *
 *	DBRecycleObject() removes xsw object object_num from memory
 *	and frees (recycles) its number for future reuse.   If the
 *	object_num was that of an invalid xsw object, then no action
 *	will be taken.   No return.
 *
 *	DBGetTopObjectNumber() returns the number for the topmost xsw
 *	object loaded in memory.   Return is the number for the topmost
 *	xsw object loaded
 *	memory.
 *
 */

#include "../include/xsw.h"



void DBClearObjectsFromMemory()
{
	/* Local variables. */
	long object_num;

	for(object_num = 0; object_num < MAX_OBJECTS; object_num++)
	{
	    DBRecycleObject(object_num);
	}

	return;
}



long DBCleanMemory()
{
	/* Local variables. */
	long topmostobj;


	/* Do cleaning... not coded right now, but insert code later
	 * when needed..
	 */


	/* Get topmost object. */
	topmostobj = DBGetTopObjectNumber();

	return(topmostobj);
}



long DBCreateObject(Window parent_win, long imageset)
{
	/* Local variables. */
	char stringa[1024];
	long created_object_num;


	/* imageset must be valid. */
	if( (imageset < 0) || (imageset >= MAX_IMAGESETS) )
		return(-1);

        /* Make sure imageset is loaded. */
        if(xsw_imageset[imageset].load_state == 0)
            IMGLoadSpecified(imageset, 1);


	/* Find garbage to create space from. */
	for(created_object_num = 0; created_object_num < MAX_OBJECTS;
	    created_object_num++)
	{
	    /* Is this xsw_object[] free? */
	    if(xsw_object[created_object_num].type != XSW_OBJ_TYPE_GARBAGE)
		continue;

	    break;
	}

        /* Did we find any available space for new objects? */
        if(created_object_num >= MAX_OBJECTS)
                return(-1);


	/* Increment global variable total_objects if created_object_num */
	/* tops it.                                                      */
	if(created_object_num >= total_objects)
	{
		total_objects = created_object_num + 1;
	}
	if(total_objects > MAX_OBJECTS)
		total_objects = MAX_OBJECTS;


	/* Got free object space, now begin creating new object. */
	sprintf(stringa, "Object %i", created_object_num);
	strncpy(xsw_object[created_object_num].name, stringa, MAX_NAME_LENGTH);
	strncpy(xsw_object[created_object_num].empire, "NONE",
            MAX_EMPIRE_LENGTH);
        strncpy(xsw_object[created_object_num].password, "",
            MAX_PASSWORD_LENGTH);
	xsw_object[created_object_num].last_updated = cur_millitime;
        xsw_object[created_object_num].type = XSW_OBJ_TYPE_STATIC;
        xsw_object[created_object_num].imageset = IMAGESET_CODE_UNKNOWN;
        xsw_object[created_object_num].owner = created_object_num;
        xsw_object[created_object_num].size = 1;
	xsw_object[created_object_num].locked_on = -1;
        xsw_object[created_object_num].intercepting_object = -1;
        xsw_object[created_object_num].window =
             XCreateSimpleWindow(display, parent_win,
                 0, 0,
                 xsw_imageset[imageset].fwidth,
		 xsw_imageset[imageset].fheight,
                 0,
                 white_pix, black_pix
             );
        XSelectInput(display,
            xsw_object[created_object_num].window,
            XSW_OBJ_WIN_EVENTMASK
        );
        xsw_object[created_object_num].scanner_range = 8.0;
        xsw_object[created_object_num].x = 0;
        xsw_object[created_object_num].y = 0;
        xsw_object[created_object_num].z = 0;
        xsw_object[created_object_num].heading = 0;
        xsw_object[created_object_num].pitch = 0;
        xsw_object[created_object_num].velocity = 0;
        xsw_object[created_object_num].velocity_max = 0;
        xsw_object[created_object_num].velocity_heading = 0;
        xsw_object[created_object_num].thrust_rev_state = 0;
        xsw_object[created_object_num].thrust_dir = 3.1415927;
        xsw_object[created_object_num].thrust = 0;
        xsw_object[created_object_num].thrust_power = 0;
        xsw_object[created_object_num].throttle = 0;
        xsw_object[created_object_num].turnrate = 0.003;
        xsw_object[created_object_num].brakes_state = 0;
	xsw_object[created_object_num].brakes_power = 0;
        xsw_object[created_object_num].hp = 1;
        xsw_object[created_object_num].hp_max = 1;
        xsw_object[created_object_num].power = 0;
        xsw_object[created_object_num].power_max = 0;
        xsw_object[created_object_num].power_purity = 0;
        xsw_object[created_object_num].core_efficency = 0;
        xsw_object[created_object_num].antimatter = 0;
        xsw_object[created_object_num].antimatter_max = 0;
        xsw_object[created_object_num].shield_state = 0;
        xsw_object[created_object_num].shield_frequency = 180.25;
        xsw_object[created_object_num].selected_weapon = 0;
        xsw_object[created_object_num].total_weapons = 0;
        xsw_object[created_object_num].birth_time = cur_millitime;
        xsw_object[created_object_num].age = 0;
        xsw_object[created_object_num].lifespan = -1;
        xsw_object[created_object_num].cloak_state = -1;
        xsw_object[created_object_num].cloak_strength = 1.0;
        xsw_object[created_object_num].shield_visibility = 0.0;
        xsw_object[created_object_num].visibility = 1.0;
        xsw_object[created_object_num].damage_control = 0;

        xsw_object[created_object_num].score.gpl = 0;
        xsw_object[created_object_num].score.rmu = 0;
        xsw_object[created_object_num].score.rmu_max = 1000; 
        xsw_object[created_object_num].score.damage_givin = 0;
        xsw_object[created_object_num].score.damage_recieved = 0;
        xsw_object[created_object_num].score.kills = 0;
        
        xsw_object[created_object_num].permission.uid = DEFAULT_UID;
        xsw_object[created_object_num].permission.gid = DEFAULT_GID;

        xsw_object[created_object_num].animation.interval = 500;
        xsw_object[created_object_num].animation.last_interval = cur_millitime;
        xsw_object[created_object_num].animation.current_frame = 0;
        xsw_object[created_object_num].animation.total_frames = 1;
        xsw_object[created_object_num].animation.cycle_count = 0; 
        xsw_object[created_object_num].animation.cycle_times = 1; 


	return(created_object_num);
}



int DBCreateExplicitObject(long object_num, long imageset, Window parent_win)
{
	/* Local variables. */
	long created_object_num;


        /* imageset must be valid. */
        if( (imageset < 0) || (imageset >= MAX_IMAGESETS) )
                return(-1);
        
        /* Make sure imageset is loaded. */
        if(xsw_imageset[imageset].load_state == 0)
            IMGLoadSpecified(imageset, 1);


	/* Is object_num valid? */
	if((object_num < 0) || (object_num >= MAX_OBJECTS))
		return(-1);


	/* If object_num already exists, recycle it. */
	if(xsw_object[object_num].type > XSW_OBJ_TYPE_GARBAGE)
	{
		DBRecycleObject(object_num);
	}

	/* Created explicitly. */
        created_object_num = object_num;


        /* Increment global variable total_objects if created_object_num */
        /* tops it.                                                      */
        if(created_object_num >= total_objects)
        {       
                 total_objects = created_object_num + 1;
        }
        if(total_objects > MAX_OBJECTS)
                total_objects = MAX_OBJECTS;


        /* Got free object space, now begin creating new object. */
        sprintf(xsw_object[created_object_num].name, "Object %i",
            created_object_num);
        sprintf(xsw_object[created_object_num].empire, "NONE");
        xsw_object[created_object_num].last_updated = cur_millitime;
        xsw_object[created_object_num].type = XSW_OBJ_TYPE_STATIC;
        xsw_object[created_object_num].imageset = IMAGESET_CODE_UNKNOWN;
        xsw_object[created_object_num].owner = created_object_num;
        xsw_object[created_object_num].size = 1;
        xsw_object[created_object_num].locked_on = -1;  
        xsw_object[created_object_num].intercepting_object = -1;
        xsw_object[created_object_num].window =
             XCreateSimpleWindow(display, parent_win,
                 0, 0,
                 xsw_imageset[imageset].fwidth, 
                 xsw_imageset[imageset].fheight,
                 0,
                 white_pix, black_pix
             );
        XSelectInput(display,
            xsw_object[created_object_num].window,
            XSW_OBJ_WIN_EVENTMASK
        );
        xsw_object[created_object_num].scanner_range = 8.0;
        xsw_object[created_object_num].x = 0;
        xsw_object[created_object_num].y = 0;
        xsw_object[created_object_num].z = 0;
        xsw_object[created_object_num].heading = 0;
        xsw_object[created_object_num].pitch = 0;
        xsw_object[created_object_num].velocity = 0;
        xsw_object[created_object_num].velocity_max = 0;
        xsw_object[created_object_num].velocity_heading = 0;
        xsw_object[created_object_num].thrust_rev_state = 0;
        xsw_object[created_object_num].thrust_dir = 3.1415927;
        xsw_object[created_object_num].thrust = 0;
        xsw_object[created_object_num].thrust_power = 0;
        xsw_object[created_object_num].throttle = 0;
        xsw_object[created_object_num].turnrate = 0.003;
        xsw_object[created_object_num].brakes_state = 0;
        xsw_object[created_object_num].brakes_power = 0;      
        xsw_object[created_object_num].hp = 1;
        xsw_object[created_object_num].hp_max = 1;
        xsw_object[created_object_num].power = 0;
        xsw_object[created_object_num].power_max = 0;  
        xsw_object[created_object_num].power_purity = 0;
        xsw_object[created_object_num].core_efficency = 0;
        xsw_object[created_object_num].antimatter = 0;
        xsw_object[created_object_num].antimatter_max = 0;
        xsw_object[created_object_num].shield_state = 0;
        xsw_object[created_object_num].shield_frequency = 180.25;
        xsw_object[created_object_num].selected_weapon = 0;
        xsw_object[created_object_num].total_weapons = 0;
        xsw_object[created_object_num].birth_time = cur_millitime;
        xsw_object[created_object_num].age = 0;
        xsw_object[created_object_num].lifespan = -1;
        xsw_object[created_object_num].cloak_state = -1;
        xsw_object[created_object_num].cloak_strength = 1.0;
        xsw_object[created_object_num].shield_visibility = 0.0;  
        xsw_object[created_object_num].visibility = 1.0;
        xsw_object[created_object_num].damage_control = 0;

        xsw_object[created_object_num].score.gpl = 0;
        xsw_object[created_object_num].score.rmu = 0;
        xsw_object[created_object_num].score.rmu_max = 1000; 
        xsw_object[created_object_num].score.damage_givin = 0;
        xsw_object[created_object_num].score.damage_recieved = 0;
        xsw_object[created_object_num].score.kills = 0;
        
        xsw_object[created_object_num].permission.uid = DEFAULT_UID;
        xsw_object[created_object_num].permission.gid = DEFAULT_GID;
            
        xsw_object[created_object_num].animation.interval = 500;
        xsw_object[created_object_num].animation.last_interval = cur_millitime;
        xsw_object[created_object_num].animation.current_frame = 0;
        xsw_object[created_object_num].animation.total_frames = 1;
        xsw_object[created_object_num].animation.cycle_count = 0;
        xsw_object[created_object_num].animation.cycle_times = 1;

        
	return(0);
}



/* *****************************************************************************
 *
 *   long DBCreateExplosion1(double loc_x, double loc_y)
 *
 *      Creates an explosion 1 (large explosion) object at location
 *      loc_x and loc_y.
 * 
 *      Returns the number of the object created, or -1 if an object
 *      cannot be created.
 */

long DBCreateExplosion1(double loc_x, double loc_y)
{
	long created_object_num;

	created_object_num = DBCreateObject(game_win, IMAGESET_CODE_EXPLOSION1);
	if(created_object_num < 0)
		return(-1);


	sprintf(xsw_object[created_object_num].name,"");
        sprintf(xsw_object[created_object_num].empire,"");
        xsw_object[created_object_num].type = XSW_OBJ_TYPE_ANIMATED;
        xsw_object[created_object_num].imageset = IMAGESET_CODE_EXPLOSION1;

	xsw_object[created_object_num].size = 75;
	xsw_object[created_object_num].x = loc_x;
	xsw_object[created_object_num].y = loc_y;
	xsw_object[created_object_num].animation.interval = 200;
        xsw_object[created_object_num].animation.current_frame = 0;
        xsw_object[created_object_num].animation.total_frames = 4;
        xsw_object[created_object_num].animation.cycle_count = 0;
        xsw_object[created_object_num].animation.cycle_times = 1;

	return(created_object_num);
}



/* *****************************************************************************
 *
 *   long DBCreateExplosion2(double loc_x, double loc_y)
 *
 *	Creates an explosion 2 (small explosion) object at location
 *	loc_x and loc_y.
 *
 *	Returns the number of the object created, or -1 if an object
 *	cannot be created.
 */

long DBCreateExplosion2(double loc_x, double loc_y)
{
        long created_object_num;

        created_object_num = DBCreateObject(game_win, IMAGESET_CODE_EXPLOSION1);
        if(created_object_num < 0)
                return(-1);

  
        sprintf(xsw_object[created_object_num].name,"");
        sprintf(xsw_object[created_object_num].empire,"");
        xsw_object[created_object_num].type = XSW_OBJ_TYPE_ANIMATED;
        xsw_object[created_object_num].imageset = IMAGESET_CODE_EXPLOSION2;

        xsw_object[created_object_num].size = 6;
        xsw_object[created_object_num].x = loc_x;
        xsw_object[created_object_num].y = loc_y;
        xsw_object[created_object_num].animation.interval = 200;
        xsw_object[created_object_num].animation.current_frame = 0;
        xsw_object[created_object_num].animation.total_frames = 1;
        xsw_object[created_object_num].animation.cycle_count = 0;
        xsw_object[created_object_num].animation.cycle_times = 1;
        
        return(created_object_num);
}       



void DBRecycleObject(long object_num)
{
	/* Is it already recycled? */
	if(xsw_object[object_num].type <= XSW_OBJ_TYPE_GARBAGE)
		return;

	/* Begin recycling... */
	sprintf(xsw_object[object_num].name, "");
	sprintf(xsw_object[object_num].empire, "");
	xsw_object[object_num].owner = -1;

	xsw_object[object_num].type = XSW_OBJ_TYPE_GARBAGE;
	xsw_object[object_num].imageset = IMAGESET_CODE_UNKNOWN;


	/* Destroy its associated window ID. */
	XDestroyWindow(display, xsw_object[object_num].window);


	return;
}



long DBGetTopObjectNumber()
{
	/* Local variables. */
	long last_valid_object = -1;
	long current_object = 0;


	/* Get last valid object. */
	for(current_object = 0; current_object < MAX_OBJECTS;
	   current_object++)
	{
	   if(xsw_object[current_object].type <= XSW_OBJ_TYPE_GARBAGE)
		continue;

	   last_valid_object = current_object;
	}


	return(last_valid_object);
}



double DBGetObjectVisibility(long object_num)
{
        /* Local variables. */
	double visibility_rtn;


	/* Garbages and errors have no visibility. */
	if(xsw_object[object_num].type <= XSW_OBJ_TYPE_GARBAGE)
		return(0);


	/* Get objects visibility. */
	visibility_rtn = xsw_object[object_num].visibility;

	/* See if object is cloaked. */
	if(xsw_object[object_num].cloak_state >= 1)
		visibility_rtn -= xsw_object[object_num].cloak_strength;

	/* Visibility should not be negative. */
	if(visibility_rtn < 0)
		visibility_rtn = 0;

	return(visibility_rtn);
}
