/* params.hh 1.21 95/12/28 23:24:14 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// this file contains most of the adjustable parameters used in the program
// for controlling speeds, lengths, locations, etc.

#ifndef _PARAMS_
#define _PARAMS_

// NOTE: parameters for controlling speeds of jovian attacks and jovian
// movement are defined in c_jovian_ai.hh


#define RANDMAX 32767L		// max value for rand(). probably most
				// generators go higher than this.
				// This value is used for generating
				// random numbers in [0,1].

// millisec interval between jovian actions
#define JOVINT (unsigned long)app_data.jovian_action_speed

// millisec interval for endever movement
#define MOVEINT (unsigned long)app_data.endever_thrust_speed

// millisec interval for ship re-energizing
#define ERGINT (unsigned long)app_data.ship_energize_speed

#define PAUSEINT 500UL		// When game is paused, all the timeout
				// routines will simply reset the timer
				// with this value and keep passing the
				// same client_data back every time.
#define FLASHINT 1000UL		// millisec to flash "base under attack" mesg
#define UNFLASHINT 500UL	// millisec to unflash "base under attack" mesg
#define SEEDINT 60000UL		// change the rand() seed after some random
#define SEEDINTRANGE 6000UL	// time ranging from SEEDINT - SEEDINTRANGE
				// to SEEDINT + SEEDINTRANGE millisecs.
				// time() provides the seed.
#define MINSKILL 1		// lowest skill level
#define MAXSKILL 10		// highest skill level

// default faser/torpedo trajectory
#define DEFANGLE (double)app_data.default_firing_angle

// endever code to self-destruct
#define SDESTRUCTCODE app_data.self_destruct_code

// max number jovians in a sector
#define MAXJOVSECT app_data.max_jovians_per_sector

// max number stars in a sector
#define MAXSTARSECT app_data.max_stars_per_sector

// starting number of torpedoes
#define MAXTORPEDOES app_data.max_torpedoes

// max energy possible for shields, thrust, warp or fasers

#define ENDMAXERG 100		// for endever
#define JOVMAXERG 100		// for jovians
#define BASEMAXERG 500		// for bases (all energy devoted to shields)

// endever min energy needed for faser to work
#define ENDMINFASERG app_data.endever_min_faser_energy

// endever min energy needed for warp to work
#define ENDMINWARPERG app_data.endever_min_warp_energy

// endever min energy needed for thrust to work
#define ENDMINTHRUSTERG app_data.endever_min_thrust_energy

// jovian min energy needed for faser to work
#define JOVMINFASERG app_data.jovian_min_faser_energy

// jovian min energy needed for warp to work
#define JOVMINWARPERG app_data.jovian_min_warp_energy

// jovian min energy needed for thrust to work
#define JOVMINTHRUSTERG app_data.jovian_min_thrust_energy

#define ENDMINERGRATE 1		// endever min rate of re-energizing (mean)
#define ENDMAXERGRATE 4		// endever max rate of re-energizing (mean)
#define ENDMINERGRATEDOCK 6	// endv min rate of re-erging when docked (mean)
#define ENDMAXERGRATEDOCK 12	// endv max rate of re-erging when docked (mean)
#define JOVMINERGRATE 1		// jovian min rate of re-energizing (mean)
#define JOVMAXERGRATE 4		// jovian max rate of re-energizing (mean)
#define BASEMINERGRATE 30	// min rate of re-energizing for bases (mean)
#define BASEMAXERGRATE 60	// max rate of re-energizing for bases (mean)
#define ENDERGVAR 3		// when re-energizing endever, this is the +/-
				// amount of rand variation in the re-erg rate.
#define ENDERGVARDOCK 6		// endever re-erg rate variation when docked
#define JOVERGVAR 3		// when re-erging jov, this is the +/- amount
				// of random variation in the re-erg rate.
#define BASEERGVAR 30		// when re-erging a base, this is the +/- amount
				// of random variation in the re-erg rate.

// energy and parameters used in damage model

// effect of faser intensity on damage (make larger for more damage)
// (use a value like 2.0 if fasers are represented as bursts)
#define INTENPARAM (double)6.0

// effect of shield level on damage (make larger for more damage)
// this parameter is very sensitive to small changes.
#define SHIELDPARAM (double)0.04

// probab a sector has a mask (percent)
#define PROBMASK  app_data.mask_probability

// faser parameters

//#define FASERLEN 30		// length of faser burst (pixels)
#define FASERLEN 15 // value to use when faser is a continuous line
#define FASERWTH app_data.faser_width	// width of faser burst (pixels)
#define FASERRVWTH  (FASERWTH+2) // width of reverse video faser burst (erasing)
				 // wider to remove stray pixels.
#define FASERSPD 15		// distance burst moves between time intervals

// millisecs between faser movements (when faser represented as a burst)
//#define FASERINT 40UL
// millisecs between faser movements (when faser represented as continuous line)
#define FASERINT (unsigned long)app_data.faser_speed
#define FASERMAXDASH 50		// max number chars in faser dash pattern

// torpedo parameters

#define TORPLEN app_data.torpedo_length 	// length of torpedo (pixels)
#define TORPWTH app_data.torpedo_width		// width of torpedo (pixels)
#define TORPRVWTH (TORPWTH+2)   // width of reverse video torpedo (erasing)
#define TORPSPD 15		// distance burst moves between time intervals

// millisecs between torpedo movements
#define TORPINT (unsigned long)app_data.torpedo_speed

// surround the inside of the border of the sector with a margin and
// do not allow fasers or torpedoes to enter within this margin. This
// keeps fasers and torpedoes from eating away the sector border when
// fired at oblique angles.

#define FASERMARGIN  FASERRVWTH/2  // use reverse video width to determine
#define TORPMARGIN   TORPRVWTH/2   // margins because it is wider.


#define RADIUS 17	// radius from icon center to begin faser/torpedo

// these are the dimensions of a rectangle redrawn at the
// leading end of a faser after the faser shot over. this cleans
// up stray pixels and also redraws the shot target in case it
// got erased when the faser got erased (this sometimes happens
// if the target ship moves into the faser as the faser is being
// erased).

#define CLEANUPW 54		// width
#define CLEANUPH 30		// height

// explosion related parameters

// explosion radius for fasers/torpedo hits
#define EXPLODERAD app_data.explosion_radius_small
// explosion radius for self-destruction
#define SDESTRUCTRAD  app_data.explosion_radius_big

// timeout interval between expand() calls
#define EXPANDINT (unsigned long)app_data.explosion_speed
#define EXPANDRATE 5	// amount explosion radius increases between expansions
#define FRAGW  3	// width of an explosion fragment
#define FRAGH  5	// height of an explosion fragment
#define FRAGDENSITY 40		// number fragments per disk of current radius

// When the endever leaps into a new sector, it gets placed at a
// random location inside that sector. The euclidean distance
// (in pixels) from this location to the jovians inside the
// sector is at least MINJOVDIST.

#define MINJOVDIST app_data.min_jovian_distance

// Number of rows/cols of Sectors in the universe matrix

#define UROWS 9
#define UCOLS 9

/**************** GRAPHICS DIMENSIONS ***************/

// The game window is divided into rows/cols of 9x15 blocks.  In
// the style of the C/C++ convention, the first row/column is
// numbered 0.

// number of rows/cols in a sector. make sure these dimensions
// are large enough to contain the scanner and summary displays 
// specified below. SECTROWS & SECTCOLS should be the only 
// parameters that need to be changed to resize the game window.

#define SECTROWS app_data.rows
#define SECTCOLS app_data.columns

// row/col position of sector display wrt game window.

#define SECTROW 1
#define SECTCOL 1

// max & min pixel dimensions of sector display

#define SECTMAXX (9*(SECTCOL + SECTCOLS) - 1)
#define SECTMINX (9*SECTCOL)
#define SECTMAXY (15*(SECTROW + SECTROWS) - 1)
#define SECTMINY (15*SECTROW)

// Sector display width and height in pixels

#define SECTW (SECTMAXX-SECTMINX+1)
#define SECTH (SECTMAXY-SECTMINY+1)

// Square of length of main diagonal of the sector display

#define SECTDIAGSQ ((long)SECTW*(long)SECTW + (long)SECTH*(long)SECTH)

// Dimensions of the game window measured in 9x15 blocks.

#define GAMEROWS (SECTROWS+3)
#define GAMECOLS (SECTCOLS+2)

// Dimensions of the game window in pixels:

#define GAMEW (9*GAMECOLS)
#define GAMEH (15*GAMEROWS)

// number of rows/cols in scanner display

#define SCANROWS 20
#define SCANCOLS 47

// row/col position of scanner display wrt game window

#define SCANROW (GAMEROWS/2 - SCANROWS/2)
#define SCANCOL (GAMECOLS/2 - SCANCOLS/2)

// dimensions of the summary display are set at runtime in
// draw_summary.cc: set_summary_size()

// row/col position of the echo area

#define ECHOROW (GAMEROWS-1)
#define ECHOCOL 1






#endif				// _PARAMS_

// end
