/* orientation.hh 1.9 95/12/28 23:24:14 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// ------------------ INTERNATIONALIZATION ------------------
//
// For persons wanting to translate xspacewarp into a different language,
// messages.hh and orientation.hh contain all the text used in xspacewarp.


// orientation.hh: text for the xspacewarp orientation.


#ifndef _ORIENTATION_
#define _ORIENTATION_


typedef char* Line;
typedef Line* Page;


// The string to put at the top of every orientation page.

static const char orientation_header[] =
"XSPACEWARP ORIENTATION";


// When changing the pages below, be sure to NULL terminate every page
// with a (Line)0

// The story behind the game.

static Line page_1[] =	// (Line)0 terminated list of strings
{
  "Page 1 of 3",
  " ",
  "You are in command of the Federation starship \"Endever\".",
  "Your ship looks like this: >-0",
  "The Federation is at war with the evil Jovian Empire.",
  "Its ships look like this: <*>",
  "Your objective is to destroy all Jovian ships",
  "before they destroy the Federation bases",
  "which look like this: +0+",
  " ",
  "The Endever is the Federation\'s last hope.",
  "To survive, the Endever must not hit a star (dot) or a",
  "blackhole (invisible) or be hit by a Jovian faser when",
  "shields are critically low. To stay fully operational,",
  "the Endever must dock with Federation bases to",
  "re-energize and repair battle damage.",
  (Line)0
};

static Line page_2[] =	// (Line)0 terminated list of strings
{
  "Page 2 of 3",
  " ",
  "The Endever is equipped with a scanner to show",
  "locations of Jovians (numbers), bases (\"B\"),",
  "blackholes (\"?\"), and the Endever itself (\"E\")",
  "within the universe. The Jovians have a cloaking",
  "device which can mask the number of Jovians within",
  "a sector of the universe. Such sectors appear with an",
  "\"M\" under the scanner. The Endever has warpdrive",
  "for traveling to different sectors and has ion thrusters",
  "for traveling within them. The Endever has a limited",
  "number of photon torpedoes which are sure-kills and",
  "the Jovians lack. Both the Endever and the Jovians have",
  "fasers which have strength decreasing with distance",
  "but increasing with energy level. You may gamble and",
  "lower the Endever shield levels to boost the faser",
  "strength with the increased risk of a fatal encounter.",
  (Line)0
};

static Line page_3[] =	// (Line)0 terminated list of strings
{
  "Page 3 of 3",
  " ",
  "The Endever control panel is as follows:",
  " ",
  "1 = Scanner             6 = Photon Torpedoes",
  "2 = Status Report       7 = Self-Destruct (Code 123)",
  "3 = Warpdrive           arrows = Ion Thrusters",
  "4 = Shield Setting",
  "5 = Fasers              p = Pause",
  " ",
  " ",
  " ",
  "Good Luck!",
  (Line)0
};


// If there is any change in the number of pages of text, then
// the initializer for orientation_text[] will need to be changed
// into {page_1, page_2, ... page_n} where "n" is the number of pages.

static const Page orientation_text[] = {page_1, page_2, page_3};


// Instructions for operating the orientation. The actual
// keybindings can be changed in the user X resources or
// app-defaults. See the resource *widget.translations and its
// components orientation(next), orientation(prev), and
// orientation(quit).

static const char orientation_controls[] =
"(N) Next Page, (P) Previous Page, (Q) Quit Orientation";


#endif				// _ORIENTATION_

// end
