/* draw_summary.cc 1.10 95/12/23 03:11:39 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// draw the endever energy stats, jov population, and base population


#include <stdio.h>		// sprintf()
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"
#include "params.hh"
#include "c_block.hh"
#include "c_endever.hh"		// access energy stats
#include "c_base.hh"		// access number of bases
#include "c_jovian.hh"		// access jovian population
#include "globals.hh"		// access toplevel, endever
#include "messages.hh"

extern void connect_blocks(Drawable, GC, Block&, Block&);

static void draw_frame(void);
static void draw_names(void);
void draw_summary_numbers(Drawable);

// row/col position of summary display wrt game window

static int summrows;		// set in set_summary_size()
static int summcols;		// set in set_summary_size()

// number of rows/cols in summary display

static int summrow;		// set in set_summary_size()
static int summcol;		// set in set_summary_size()


// display the energy summary and jovian population.
// all drawing done on pixmap then copied to window.

void draw_summary(void)
{
  // clear previous stuff

  XFillRectangle(DISPLAY, pixmap, defrv_GC, 0, 0, GAMEW, GAMEH);

  // draw scanner on pixmap

  draw_frame();
  draw_names();
  draw_summary_numbers(pixmap);

  // copy pixmap to window

  XCopyArea(DISPLAY, pixmap, XtWindow(widget),
	    def_GC, 0, 0, GAMEW, GAMEH, 0, 0);
}


// routine for drawing the graphic rectangular frame for the info

static void draw_frame(void)
{
  Block block1, block2;

  // draw top line

  block1.setrow(summrow);
  block1.setcol(summcol);
  block2.setrow(summrow);
  block2.setcol(summcol+summcols-1);
  connect_blocks(pixmap, def_GC, block1, block2);
 
  // draw middle line

  block1.setrow(summrow+summrows-5);
  block2.setrow(summrow+summrows-5);
  connect_blocks(pixmap, def_GC, block1, block2);

  // draw bottom line

  block1.setrow(summrow+summrows-1);
  block2.setrow(summrow+summrows-1);
  connect_blocks(pixmap, def_GC, block1, block2);

  // draw left line

  block2.setrow(summrow);
  block2.setcol(summcol);
  connect_blocks(pixmap, def_GC, block1, block2);

  // draw right line

  block1.setcol(summcol+summcols-1);
  block2.setcol(summcol+summcols-1);
  connect_blocks(pixmap, def_GC, block1, block2);
}


// routine for drawing the words in the energy/jovian summary

static void draw_names(void)
{
  Block block;
  Point origin;
  int len;

  // draw ion thruster string

  block.setrow(summrow+1);
  block.setcol(summcol+1);
  origin = block.origin();
  len = XtNumber(summary_ion_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_ion_str, len);

  // draw warp drive string

  block.setrow(summrow+3);
  origin = block.origin();
  len = XtNumber(summary_warp_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_warp_str, len);

  // draw faser string

  block.setrow(summrow+5);
  origin = block.origin();
  len = XtNumber(summary_faser_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_faser_str, len);

  // draw shield string

  block.setrow(summrow+7);
  origin = block.origin();
  len = XtNumber(summary_shield_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_shield_str, len);

  // draw torpedo string

  block.setrow(summrow+9);
  origin = block.origin();
  len = XtNumber(summary_torpedo_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_torpedo_str, len);

  // draw base string

  block.setrow(summrow+11);
  origin = block.origin();
  len = XtNumber(summary_base_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_base_str, len);

  // draw jovian string

  block.setrow(summrow+13);
  origin = block.origin();
  len = XtNumber(summary_jovian_str) - 1;
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      summary_jovian_str, len);
}


// Routine for drawing percentages of energy levels

void draw_summary_numbers(Drawable drawable)
{
  Block block;
  Point origin;
  int len;
  char status[5];

  // set space requirements for percentage stats

  block.setcol(summcol+summcols-5);
  len = 4;

  // percent thrusters

  block.setrow(summrow+1);
  origin = block.origin();
  (void) sprintf(status, "%*u%%", len-1, endever.getthrusters());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);

  // percent warp drive

  block.setrow(summrow+3);
  origin = block.origin();
  (void) sprintf(status, "%*u%%", len-1, endever.getwarpdrive());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);

  // percent fasers

  block.setrow(summrow+5);
  origin = block.origin();
  (void) sprintf(status, "%*u%%", len-1, endever.getfasers());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);

  // percent shields

  block.setrow(summrow+7);
  origin = block.origin();
  (void) sprintf(status, "%*u%%", len-1, endever.getshields());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);

  // torpedo, base and jovian stats do not require as much space

  block.setcol(summcol+summcols-4);
  len = 3;

  // torpedoes remaining

  block.setrow(summrow+9);
  origin = block.origin();
  (void) sprintf(status, "%*u", len, endever.gettorpedoes());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);


  // number of bases remaining

  block.setrow(summrow+11);
  origin = block.origin();
  (void) sprintf(status, "%*u", len, Base::getpop());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);

  // number of jovians remaining

  block.setrow(summrow+13);
  origin = block.origin();
  (void) sprintf(status, "%*u", len, Jovian::getpop());
  XDrawString(DISPLAY, drawable, def_GC, origin.x, origin.y, status, len);
}


// routine for erasing the numbers shown in the summary display

void erase_summary_numbers(Drawable drawable)
{
  Block block;
  Point corner;
  int width;

  // set space requirements for percentage stats

  block.setcol(summcol+summcols-5);
  width = 4*BLOCKW;

  // percent thrusters

  block.setrow(summrow+1);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);

  // percent warp drive

  block.setrow(summrow+3);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);

  // percent fasers

  block.setrow(summrow+5);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);

  // percent shields

  block.setrow(summrow+7);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);

  // torpedo, base and jovian stats do not require as much space

  block.setcol(summcol+summcols-4);
  width = 3*BLOCKW;

  // torpedoes remaining

  block.setrow(summrow+9);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);


  // number of bases remaining

  block.setrow(summrow+11);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);

  // number of jovians remaining

  block.setrow(summrow+13);
  corner = block.northwest();
  XFillRectangle(DISPLAY, drawable, defrv_GC,
		 corner.x, corner.y, width, BLOCKH);
}


// an internationalization routine.  call this once after the
// app_data is loaded to initialize the summary display
// dimensions: summrow, summrows, summcol, and summcols.

void set_summary_size(void)
{
  summrows = 15;
  summrow = (GAMEROWS/2 - summrows/2);

  summcols = XtNumber(summary_ion_str)-1;
  summcols = max(summcols, XtNumber(summary_warp_str)-1);
  summcols = max(summcols, XtNumber(summary_faser_str)-1);
  summcols = max(summcols, XtNumber(summary_shield_str)-1);
  summcols = max(summcols, XtNumber(summary_torpedo_str)-1);
  summcols = max(summcols, XtNumber(summary_base_str)-1);
  summcols = max(summcols, XtNumber(summary_jovian_str)-1);
  summcols += 7;

  summcol = GAMECOLS/2 - summcols/2;
}

// end
