/* draw_orientation.cc 1.5 95/12/23 03:11:40 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// draw a page of the xspacewarp orientation


#include "orientation.hh"	// text for the orientation
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <iostream.h>
#include <string.h>		// strlen()
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// access toplevel
#include "c_block.hh"


static void draw_page(int pagenum);


// number of pages in the orientation

static const int NPAGES = XtNumber(orientation_text);


// input can be any integer. draw_orientation() uses mod NPAGES arithmetic
// to select a page in the range 1...NPAGES. If the input, i, is increased
// monotonically, then the page number shown will cycle every NPAGES. Ie,
// i=1 shows page 1, ..., i=NPAGES shows page NPAGES, i=NPAGES+1 shows page 1.

void draw_orientation(int i)
{
  int len, pagenum;		// array length and page number
  Block block;
  Point origin;

  // clear previous stuff

  XFillRectangle(DISPLAY, pixmap, defrv_GC, 0, 0, GAMEW, GAMEH);

  // draw header string

  len = XtNumber(orientation_header) - 1;
  block.setrow(0);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      orientation_header, len);

  // use modular arithmetic (mod NPAGES) to map an int to a page number
  // in the range 1...NPAGES so that pages will rotate in a cycle as read.

  pagenum = (i > 0)? (((i-1) % NPAGES) + 1) : (i + NPAGES*(1 + (-i/NPAGES)));
  draw_page(pagenum);

  // draw command string

  len = XtNumber(orientation_controls) - 1;
  block.setrow(GAMEROWS - 1);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      orientation_controls, len);

  // copy to window

  XCopyArea(DISPLAY, pixmap, XtWindow(widget),
	    def_GC, 0, 0, GAMEW, GAMEH, 0, 0);
}


// draw a page of text from orientation_text. see orientation.hh

static void draw_page(int pagenum)
{
  Block block(1, 1);
  Point origin;
  int i = 0;
  Line line;
  Page page;

  if (pagenum < 1 || pagenum > NPAGES)
  {
    cerr << "xspacewarp: bad orientation page number." << endl;
    exit(1);
  }

  page = orientation_text[pagenum-1];
  while (line = page[i])
  {
    block.setrow(i+1);
    origin = block.origin();
    XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
		line, strlen(line));
    i++;
  }
}

// end
