/* draw_mission.cc 1.3 95/12/23 03:11:39 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// make display showing mission for the endever.

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>		// sprintf()
#include "common.hh"
#include "params.hh"
#include "globals.hh"		// access toplevel
#include "c_block.hh"
#include "c_base.hh"		// access number of bases
#include "c_jovian.hh"		// access number of jovians
#include "messages.hh"

static const int LENGTH1 (XtNumber(mission_statement_1) - 1);
static const int LENGTH2 (XtNumber(mission_statement_2) - 1);
static const int LENGTH3 (XtNumber(mission_statement_3) - 1);
static const int LENGTH4 (XtNumber(mission_statement_4) - 1);


void draw_mission(void)
{
  Block block;
  Point origin;
  int len;
  char mission_str1[LENGTH1 + LENGTH2 + 4];
  char mission_str2[LENGTH3 + LENGTH4 + 4];

  // clear previous stuff

  XFillRectangle(DISPLAY, pixmap, defrv_GC, 0, 0, GAMEW, GAMEH);

  // draw header string

  len = XtNumber(mission_header_str) - 1;
  block.setrow(GAMEROWS/2 - 3);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      mission_header_str, len);

  // draw first half of mission string

  (void) sprintf(mission_str1, "%s%3u%s", mission_statement_1,
		 Jovian::getpop(), mission_statement_2);
  len = XtNumber(mission_str1) - 1;
  block.setrow(GAMEROWS/2 - 1);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y, mission_str1, len);
  
  // draw second half of mission string

  (void) sprintf(mission_str2, "%s%3u%s", mission_statement_3,
		 Base::getpop(), mission_statement_4);
  len = XtNumber(mission_str2) - 1;
  block.setrow(GAMEROWS/2);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y, mission_str2, len);

  // draw start string

  len = XtNumber(mission_start_str) - 1;
  block.setrow(GAMEROWS-1);
  block.setcol(GAMECOLS/2 - len/2);
  origin = block.origin();
  XDrawString(DISPLAY, pixmap, def_GC, origin.x, origin.y,
	      mission_start_str, len);

  // copy to window

  XCopyArea(DISPLAY, pixmap, XtWindow(widget),
	    def_GC, 0, 0, GAMEW, GAMEH, 0, 0);
}

// end
