/* c_combatant.hh 1.16 95/12/23 03:11:30 */


// xspacewarp by Greg Walker (gow@math.orst.edu)

// This is free software. Non-profit redistribution and/or modification
// is allowed and welcome.


// class for connecting jovians and endever. controls shooting graphics.

#ifndef _COMBATANT_
#define _COMBATANT_

#include "c_ship.hh"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "common.hh"
#include "space_objects.hh"

extern void faser_to(XtPointer client_data, XtIntervalId *id);

class Combatant: public Ship
{
public:
  Combatant(): Ship() {}
  virtual int getmaxerg() const = 0;
  int getthrusters() const;
  int getwarpdrive() const;
  int getfasers() const;
  int getshields() const;
  void moveshot(int length, int margin,
		unsigned long interval, GC gc, GC gc_rv,
		XtTimerCallbackProc proc);
protected:
  Shot shot;
  bool mustmove;	// A flag for jovian use.
			// set to true if faser hits a star or a move
			// is blocked by a star or a ship
			// (but not by blackholes).
			// If set true, it indicates the next jovian action
			// must be a movement.
  void initshot(int length, int margin, unsigned long interval,
		GC gc, GC gc_rv, XtTimerCallbackProc proc);
private:
  bool snip(int margin);
  void cleanup(GC gc_rv);
};




#endif _COMBATANT_

// end
